/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.metadata;

import java.io.File;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.collection.CollectionTreeNode;
import org.greenstone.gatherer.metadata.DocXMLFileManager;
import org.greenstone.gatherer.metadata.MetadataElement;
import org.greenstone.gatherer.metadata.MetadataSetManager;
import org.greenstone.gatherer.metadata.MetadataValue;
import org.greenstone.gatherer.metadata.MetadataValueTreeNode;
import org.greenstone.gatherer.metadata.MetadataXMLFileManager;

public class MetadataAuditTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 0L;
    private CollectionTreeNode[] file_nodes = null;
    private ArrayList metadata_elements = new ArrayList();
    private ArrayList metadata_audit_table_entries = new ArrayList();

    @Override
    public int getColumnCount() {
        return 1 + this.metadata_elements.size();
    }

    @Override
    public String getColumnName(int n) {
        if (n == 0) {
            return Dictionary.get("AuditTable.File");
        }
        int n2 = n - 1;
        return this.metadata_elements.get(n2).toString();
    }

    public ArrayList getColumnValues(int n) {
        if (n == 0) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < this.metadata_audit_table_entries.size(); ++i) {
                MetadataAuditTableEntry metadataAuditTableEntry = (MetadataAuditTableEntry)this.metadata_audit_table_entries.get(i);
                arrayList.add(metadataAuditTableEntry.getFilename());
            }
            return arrayList;
        }
        int n2 = n - 1;
        if (n2 < 0 || n2 >= this.metadata_elements.size()) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.metadata_audit_table_entries.size(); ++i) {
            MetadataAuditTableEntry metadataAuditTableEntry = (MetadataAuditTableEntry)this.metadata_audit_table_entries.get(i);
            MetadataValueTreeNode[] metadataValueTreeNodeArray = metadataAuditTableEntry.getMetadataValueTreeNodes(n2);
            if (metadataValueTreeNodeArray == null) continue;
            for (int j = 0; j < metadataValueTreeNodeArray.length; ++j) {
                arrayList.add(metadataValueTreeNodeArray[j].toString());
            }
        }
        return arrayList;
    }

    @Override
    public int getRowCount() {
        return this.metadata_audit_table_entries.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n < 0 || n >= this.metadata_audit_table_entries.size()) {
            return null;
        }
        if (n2 == 0) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(((MetadataAuditTableEntry)this.metadata_audit_table_entries.get(n)).getFilename());
            return arrayList;
        }
        int n3 = n2 - 1;
        if (n3 < 0 || n3 >= this.metadata_elements.size()) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        MetadataAuditTableEntry metadataAuditTableEntry = (MetadataAuditTableEntry)this.metadata_audit_table_entries.get(n);
        MetadataValueTreeNode[] metadataValueTreeNodeArray = metadataAuditTableEntry.getMetadataValueTreeNodes(n3);
        if (metadataValueTreeNodeArray != null) {
            for (int i = 0; i < metadataValueTreeNodeArray.length; ++i) {
                arrayList.add(metadataValueTreeNodeArray[i].toString());
            }
        }
        return arrayList;
    }

    public void rebuild(CollectionTreeNode[] collectionTreeNodeArray) {
        this.metadata_elements = MetadataSetManager.getEveryMetadataSetElement();
        this.metadata_audit_table_entries.clear();
        this.file_nodes = collectionTreeNodeArray;
        if (collectionTreeNodeArray != null && collectionTreeNodeArray.length > 0) {
            MetadataAuditTableModelBuilder metadataAuditTableModelBuilder = new MetadataAuditTableModelBuilder();
            metadataAuditTableModelBuilder.run();
        }
    }

    private class MetadataAuditTableEntry {
        private File file = null;
        private ArrayList[] metadata_values = null;

        public MetadataAuditTableEntry(File file, ArrayList arrayList) {
            int n;
            this.file = file;
            this.metadata_values = new ArrayList[MetadataAuditTableModel.this.metadata_elements.size()];
            for (n = 0; n < this.metadata_values.length; ++n) {
                this.metadata_values[n] = new ArrayList();
            }
            block1: for (n = 0; n < arrayList.size(); ++n) {
                MetadataValue metadataValue = (MetadataValue)arrayList.get(n);
                MetadataElement metadataElement = metadataValue.getMetadataElement();
                for (int i = 0; i < MetadataAuditTableModel.this.metadata_elements.size(); ++i) {
                    if (!metadataElement.equals(MetadataAuditTableModel.this.metadata_elements.get(i))) continue;
                    this.metadata_values[i].add(metadataValue);
                    continue block1;
                }
            }
        }

        public String getFilename() {
            return this.file.getName();
        }

        public MetadataValueTreeNode[] getMetadataValueTreeNodes(int n) {
            ArrayList arrayList = this.metadata_values[n];
            if (arrayList == null) {
                return null;
            }
            MetadataValueTreeNode[] metadataValueTreeNodeArray = new MetadataValueTreeNode[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                metadataValueTreeNodeArray[i] = ((MetadataValue)arrayList.get(i)).getMetadataValueTreeNode();
            }
            return metadataValueTreeNodeArray;
        }
    }

    private class MetadataAuditTableModelBuilder {
        private MetadataAuditTableModelBuilder() {
        }

        public void run() {
            for (int i = 0; i < MetadataAuditTableModel.this.file_nodes.length; ++i) {
                File file = MetadataAuditTableModel.this.file_nodes[i].getFile();
                ArrayList arrayList = MetadataXMLFileManager.getMetadataAssignedToFile(file);
                if (Configuration.get("general.view_extracted_metadata", true)) {
                    arrayList.addAll(DocXMLFileManager.getMetadataExtractedFromFile(file));
                }
                MetadataAuditTableEntry metadataAuditTableEntry = new MetadataAuditTableEntry(file, arrayList);
                MetadataAuditTableModel.this.metadata_audit_table_entries.add(metadataAuditTableEntry);
            }
        }
    }
}

