/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.regex.PatternSyntaxException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.fife.ui.rtextarea.SearchContext;
import org.fife.ui.rtextarea.SearchEngine;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.gui.GLIButton;
import org.greenstone.gatherer.gui.ModalDialog;
import org.greenstone.gatherer.gui.NumberedJTextArea;
import org.greenstone.gatherer.util.Utility;

public class TextFileEditor
extends ModalDialog
implements ActionListener,
DocumentListener {
    public final File config_file;
    protected String syntax_type = null;
    protected GLIButton cancel_button = null;
    protected GLIButton save_button = null;
    protected NumberedJTextArea editor = null;
    protected JPanel toolbars_panel;
    protected JPanel content_pane;
    protected final JTextField searchField;
    protected JCheckBox regexCB;
    protected JCheckBox matchCaseCB;
    protected JButton nextButton;
    protected JButton prevButton;
    protected static final Dimension SIZE = new Dimension(850, 550);

    public TextFileEditor(File file) {
        this(file, null);
    }

    public TextFileEditor(File file, String string) {
        super((Frame)Gatherer.g_man, true);
        this.setModal(true);
        this.setSize(SIZE);
        this.config_file = file;
        this.syntax_type = string;
        if (this.syntax_type == null) {
            this.syntax_type = this.getSyntaxType(this.config_file);
        }
        JToolBar jToolBar = new JToolBar();
        this.searchField = new JTextField(30);
        jToolBar.add(this.searchField);
        this.nextButton = new JButton("Find Next");
        this.nextButton.setActionCommand("FindNext");
        this.nextButton.addActionListener(this);
        jToolBar.add(this.nextButton);
        this.searchField.addActionListener(this);
        this.prevButton = new JButton("Find Previous");
        this.prevButton.setActionCommand("FindPrev");
        this.prevButton.addActionListener(this);
        jToolBar.add(this.prevButton);
        this.regexCB = new JCheckBox("Regex");
        jToolBar.add(this.regexCB);
        this.matchCaseCB = new JCheckBox("Match Case");
        jToolBar.add(this.matchCaseCB);
        this.editor = new NumberedJTextArea("", "", string);
        this.editor.getDocument().addDocumentListener(this);
        this.editor.addKeyListener(new TextFileEditorKeyListener());
        this.save_button = new GLIButton(Dictionary.get("General.Save"), Dictionary.get("XMLFileEditor.Save_Tooltip"));
        this.cancel_button = new GLIButton(Dictionary.get("General.Cancel"), Dictionary.get("XMLFileEditor.Cancel_Tooltip"));
        this.cancel_button.addActionListener(this);
        this.save_button.addActionListener(this);
        JPanel jPanel = new JPanel(new FlowLayout());
        jPanel.setComponentOrientation(Dictionary.getOrientation());
        jPanel.add(this.editor.undoButton);
        jPanel.add(this.editor.redoButton);
        jPanel.add(this.cancel_button);
        jPanel.add(this.save_button);
        this.toolbars_panel = new JPanel(new BorderLayout());
        this.toolbars_panel.add((Component)jToolBar, "North");
        this.toolbars_panel.add((Component)jPanel, "South");
        this.content_pane = (JPanel)this.getContentPane();
        this.content_pane.setComponentOrientation(Dictionary.getOrientation());
        this.content_pane.setLayout(new BorderLayout());
        this.content_pane.add((Component)new JScrollPane(this.editor), "Center");
        this.content_pane.add((Component)this.toolbars_panel, "South");
        this.setFileTextInEditor();
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                super.windowClosed(windowEvent);
                Gatherer.g_man.doRegainFocus();
                Gatherer.g_man.updateUI();
            }
        });
        this.getRootPane().setDefaultButton(this.save_button);
        Dimension dimension = Configuration.screen_size;
        this.setLocation((dimension.width - TextFileEditor.SIZE.width) / 2, (dimension.height - TextFileEditor.SIZE.height) / 2);
        this.editor.setCaretPosition(0);
        this.editor.requestFocusInWindow();
    }

    protected String getSyntaxType(File file) {
        String string = file.getName();
        String string2 = string.substring(string.lastIndexOf(".") + 1);
        if (string2.matches("xml|xsl|mds|col")) {
            return "text/xml";
        }
        if (string2.equals("js")) {
            return "text/javascript";
        }
        if (string2.equals("css")) {
            return "text/css";
        }
        if (string2.equals("dtd")) {
            return "text/dtd";
        }
        if (string2.matches("htm|html")) {
            return "text/html";
        }
        if (string2.equals("pm") || string2.equals("pl")) {
            return "text/perl";
        }
        if (string2.equals("properties")) {
            return "text/properties";
        }
        return "text/plain";
    }

    protected void setFileTextInEditor() {
        String string = Utility.readUTF8File(this.config_file);
        this.editor.setText(string);
    }

    protected void saveFile() {
        String string = this.editor.getText();
        Utility.writeUTF8File(this.config_file, string);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.cancel_button) {
            this.dispose();
        } else if (actionEvent.getSource() == this.save_button) {
            this.saveFile();
            this.dispose();
            this.customActionOnSave();
        } else if (actionEvent.getSource() == this.searchField) {
            this.nextButton.doClick(0);
        } else if (actionEvent.getSource() == this.nextButton || actionEvent.getSource() == this.prevButton) {
            String string = actionEvent.getActionCommand();
            boolean bl = "FindNext".equals(string);
            SearchContext searchContext = new SearchContext();
            String string2 = this.searchField.getText();
            if (string2.length() == 0) {
                return;
            }
            searchContext.setSearchFor(string2);
            searchContext.setMatchCase(this.matchCaseCB.isSelected());
            searchContext.setRegularExpression(this.regexCB.isSelected());
            searchContext.setSearchForward(bl);
            searchContext.setWholeWord(false);
            boolean bl2 = false;
            try {
                bl2 = SearchEngine.find(this.editor, searchContext);
                this.searchField.setBackground(Color.white);
                if (!bl2) {
                    JOptionPane.showMessageDialog(this, "Text not found");
                }
            }
            catch (PatternSyntaxException patternSyntaxException) {
                this.searchField.setBackground(Color.red);
                JOptionPane.showMessageDialog(this, "Invalid regex");
            }
        }
    }

    protected void customActionOnSave() {
    }

    public String getProcessingInstruction(String string) {
        int n;
        String string2 = "";
        if ((string = string.trim()).startsWith("<?xml") && (n = string.indexOf("?>")) != -1) {
            string2 = string.substring(0, n += 2);
        }
        return string2;
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.update();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.update();
        this.updateUndo("insert");
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.update();
        this.updateUndo("remove");
    }

    protected void updateUndo(String string) {
        this.editor.undoButton.setEnabled(true);
    }

    public void update() {
    }

    protected class TextFileEditorKeyListener
    extends KeyAdapter {
        protected TextFileEditorKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getModifiers() == Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() && keyEvent.getKeyCode() == 70) {
                TextFileEditor.this.searchField.requestFocusInWindow();
            }
        }
    }
}

