/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.gui;

import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.greenstone.gatherer.Dictionary;

public class GProgressBar
extends JProgressBar {
    private long cur_value = 0L;
    private long max_value = 0L;
    private int previous = -1;

    public GProgressBar() {
        super(0, 100);
        this.setComponentOrientation(Dictionary.getOrientation());
    }

    public void addMaximum(long l) {
        if (l > 0L) {
            this.max_value += l;
            this.update();
        }
    }

    public void addValue(long l) {
        if (l > 0L) {
            this.cur_value += l;
            this.update();
        }
    }

    public void clear() {
        this.previous = -1;
        this.update();
    }

    public void reset() {
        this.cur_value = 0L;
        this.max_value = 0L;
        this.previous = -1;
        this.update();
    }

    @Override
    public void setIndeterminate(boolean bl) {
        SwingUtilities.invokeLater(new SafeSetIndeterminateTask(bl));
    }

    @Override
    public void setString(String string) {
        SwingUtilities.invokeLater(new SafeSetStringTask(string));
    }

    @Override
    public void setMaximum(int n) {
        this.max_value = n;
        this.update();
    }

    @Override
    public void setValue(int n) {
        this.cur_value = n;
        this.update();
    }

    private void update() {
        int n = -1;
        if (this.cur_value == 0L || this.max_value == 0L) {
            n = 0;
        } else {
            long l = this.cur_value * 100L / this.max_value;
            n = (int)l;
            if (n > 100) {
                n = 100;
            }
        }
        if (n != this.previous) {
            this.previous = n;
            this.setString(n + "%");
            SwingUtilities.invokeLater(new SafeSetValueTask(n));
        }
    }

    private void unsafeSetIndeterminate(boolean bl) {
        super.setIndeterminate(bl);
    }

    private void unsafeSetString(String string) {
        super.setString(string);
    }

    private void unsafeSetValue(int n) {
        super.setValue(n);
    }

    private class SafeSetValueTask
    implements Runnable {
        private int value;

        public SafeSetValueTask(int n) {
            this.value = n;
        }

        @Override
        public void run() {
            GProgressBar.this.unsafeSetValue(this.value);
        }
    }

    private class SafeSetStringTask
    implements Runnable {
        private String label;

        public SafeSetStringTask(String string) {
            this.label = string;
        }

        @Override
        public void run() {
            GProgressBar.this.unsafeSetString(this.label);
        }
    }

    private class SafeSetIndeterminateTask
    implements Runnable {
        private boolean indeterminate;

        public SafeSetIndeterminateTask(boolean bl) {
            this.indeterminate = bl;
        }

        @Override
        public void run() {
            GProgressBar.this.unsafeSetIndeterminate(this.indeterminate);
        }
    }
}

