/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.greenstone;

import java.io.StringReader;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.DebugStream;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.cdm.Argument;
import org.greenstone.gatherer.cdm.ArgumentContainer;
import org.greenstone.gatherer.cdm.Classifier;
import org.greenstone.gatherer.greenstone.LocalGreenstone;
import org.greenstone.gatherer.util.SafeProcess;
import org.greenstone.gatherer.util.XMLTools;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Classifiers {
    private static ArrayList core_greenstone_classifiers_list = null;
    private static String collection_name = null;
    private static ArrayList collection_specific_classifiers_list = new ArrayList();

    public static Classifier getClassifier(String string, boolean bl) {
        Classifier classifier;
        int n;
        ArgumentContainer argumentContainer = null;
        boolean bl2 = false;
        for (n = 0; n < collection_specific_classifiers_list.size(); ++n) {
            classifier = (Classifier)collection_specific_classifiers_list.get(n);
            if (!classifier.getName().equals(string)) continue;
            argumentContainer = classifier;
            bl2 = true;
            break;
        }
        if (argumentContainer == null) {
            for (n = 0; n < core_greenstone_classifiers_list.size(); ++n) {
                classifier = (Classifier)core_greenstone_classifiers_list.get(n);
                if (!classifier.getName().equals(string)) continue;
                argumentContainer = classifier;
                break;
            }
        }
        if (argumentContainer != null && bl) {
            if (argumentContainer.getArguments().size() == 0 && !((Classifier)argumentContainer).didLoadingOptionsFail()) {
                Classifiers.loadClassifierInfo((Classifier)argumentContainer, bl2);
            } else {
                DebugStream.println("Already loaded arguments for " + string + "!");
            }
        }
        return argumentContainer;
    }

    public static ArrayList getClassifiersList() {
        ArrayList<Classifier> arrayList = new ArrayList<Classifier>();
        arrayList.addAll(collection_specific_classifiers_list);
        for (int i = 0; i < core_greenstone_classifiers_list.size(); ++i) {
            Classifier classifier = (Classifier)core_greenstone_classifiers_list.get(i);
            boolean bl = false;
            for (int j = 0; j < collection_specific_classifiers_list.size(); ++j) {
                Classifier classifier2 = (Classifier)collection_specific_classifiers_list.get(j);
                if (!classifier.getName().equals(classifier2.getName())) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            arrayList.add(classifier);
        }
        return arrayList;
    }

    private static void loadClassifierInfo(Classifier classifier, boolean bl) {
        DebugStream.println("Loading arguments for " + classifier.getName() + "...");
        try {
            String string = null;
            if (Gatherer.isGsdlRemote) {
                String string2 = "&classifier=" + classifier;
                if (bl) {
                    string2 = string2 + "&collection=" + collection_name;
                }
                string = Gatherer.remoteGreenstoneServer.getScriptOptions("classinfo.pl", string2);
            } else {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(Configuration.perl_path);
                arrayList.add("-S");
                arrayList.add(LocalGreenstone.getBinScriptDirectoryPath() + "classinfo.pl");
                if (bl) {
                    arrayList.add("-collection");
                    arrayList.add(collection_name);
                }
                arrayList.add("-xml");
                arrayList.add("-language");
                arrayList.add(Configuration.getLanguage());
                arrayList.add(classifier.getName());
                SafeProcess safeProcess = new SafeProcess(arrayList.toArray(new String[0]));
                int n = safeProcess.runProcess();
                if (n != 0) {
                    throw new Exception("*** Error running classinfo.pl loadClassifierInfo, (" + arrayList.toString() + ") process exited with: " + n);
                }
                string = safeProcess.getStdError();
            }
            if (string == null || string.length() == 0) {
                classifier.setLoadingOptionsFailed();
                JOptionPane.showMessageDialog(Gatherer.g_man, Dictionary.get("CDM.ClassifierManager.Classifier_XML_Parse_Failed", classifier.getName()), Dictionary.get("General.Error"), 0);
                return;
            }
            Classifiers.parseClassifierInfoXML(classifier, string);
        }
        catch (Exception exception) {
            DebugStream.printStackTrace(exception);
        }
    }

    public static void loadClassifiersList(String string) {
        DebugStream.println("In loadClassifiersList()...");
        if (string != null) {
            collection_name = string;
            collection_specific_classifiers_list = new ArrayList();
        }
        try {
            StringBuffer stringBuffer = null;
            if (Gatherer.isGsdlRemote) {
                String string2 = "&listall";
                if (collection_name != null) {
                    string2 = string2 + "&collection=" + collection_name;
                }
                String string3 = Gatherer.remoteGreenstoneServer.getScriptOptions("classinfo.pl", string2);
                stringBuffer = new StringBuffer(string3);
            } else {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(Configuration.perl_path);
                arrayList.add("-S");
                arrayList.add(LocalGreenstone.getBinScriptDirectoryPath() + "classinfo.pl");
                if (collection_name != null) {
                    arrayList.add("-collection");
                    arrayList.add(collection_name);
                }
                arrayList.add("-listall");
                arrayList.add("-xml");
                SafeProcess safeProcess = new SafeProcess(arrayList.toArray(new String[0]));
                int n = safeProcess.runProcess();
                if (n != 0) {
                    throw new Exception("*** Error running classinfo.pl loadClassifiersList (" + arrayList.toString() + "), process exited with: " + n);
                }
                stringBuffer = new StringBuffer(safeProcess.getStdError());
            }
            if (stringBuffer == null || stringBuffer.length() == 0) {
                JOptionPane.showMessageDialog(Gatherer.g_man, Dictionary.get("CDM.ClassifierManager.Classifier_List_XML_Parse_Failed"), Dictionary.get("General.Error"), 0);
                return;
            }
            if (collection_name != null) {
                collection_specific_classifiers_list = Classifiers.parseClassifiersListXML(stringBuffer.toString());
            } else {
                core_greenstone_classifiers_list = Classifiers.parseClassifiersListXML(stringBuffer.toString());
            }
        }
        catch (Exception exception) {
            DebugStream.printStackTrace(exception);
        }
    }

    private static void parseClassifierInfoXML(Classifier classifier, String string) {
        Document document = XMLTools.parseXML(new StringReader(string));
        if (document == null) {
            classifier.setLoadingOptionsFailed();
            JOptionPane.showMessageDialog(Gatherer.g_man, Dictionary.get("CDM.ClassifierManager.Classifier_XML_Parse_Failed", classifier.getName()), Dictionary.get("General.Error"), 0);
            return;
        }
        Classifiers.parseClassifierInfoXMLNode(classifier, document.getDocumentElement());
    }

    private static void parseClassifierInfoXMLNode(Classifier classifier, Node node) {
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            Object object;
            String string = node2.getNodeName();
            if (string.equalsIgnoreCase("Name")) {
                classifier.setName(XMLTools.getValue(node2));
                continue;
            }
            if (string.equals("Desc")) {
                classifier.setDescription(XMLTools.getValue(node2));
                continue;
            }
            if (string.equals("Abstract")) {
                classifier.setIsAbstract(XMLTools.getValue(node2).equalsIgnoreCase("yes"));
                continue;
            }
            if (string.equalsIgnoreCase("Arguments")) {
                for (object = node2.getFirstChild(); object != null; object = object.getNextSibling()) {
                    if (!object.getNodeName().equalsIgnoreCase("Option")) continue;
                    Argument argument = new Argument();
                    argument.parseXML((Element)object);
                    classifier.addArgument(argument);
                }
                continue;
            }
            if (!string.equalsIgnoreCase("ClassInfo")) continue;
            object = new Classifier();
            Classifiers.parseClassifierInfoXMLNode((Classifier)object, node2);
            classifier.setSuper((ArgumentContainer)object);
        }
    }

    private static ArrayList parseClassifiersListXML(String string) {
        ArrayList<Classifier> arrayList = new ArrayList<Classifier>();
        Document document = XMLTools.parseXML(new StringReader(string));
        Element element = document.getDocumentElement();
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            String string2 = node.getNodeName();
            if (!string2.equals("ClassInfo")) continue;
            Classifier classifier = new Classifier();
            Classifiers.parseClassifierInfoXMLNode(classifier, node);
            arrayList.add(classifier);
        }
        return arrayList;
    }
}

