/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.gems;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.text.JTextComponent;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.DebugStream;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.GetOpt;
import org.greenstone.gatherer.gems.AttributeTable;
import org.greenstone.gatherer.gems.DeleteMetadataSetPrompt;
import org.greenstone.gatherer.gems.GEMSConstants;
import org.greenstone.gatherer.gems.GEMSListener;
import org.greenstone.gatherer.gems.MetadataElementModel;
import org.greenstone.gatherer.gems.MetadataSetInfo;
import org.greenstone.gatherer.gems.MetadataSetManager;
import org.greenstone.gatherer.gems.MetadataSetModel;
import org.greenstone.gatherer.gems.MetadataSetTree;
import org.greenstone.gatherer.gems.NewMetadataSetPrompt;
import org.greenstone.gatherer.gems.OpenMetadataSetPrompt;
import org.greenstone.gatherer.gui.GLIButton;
import org.greenstone.gatherer.gui.TestingPreparation;
import org.greenstone.gatherer.util.JarTools;
import org.greenstone.gatherer.util.Utility;

public class GEMS
extends JFrame
implements WindowFocusListener {
    private static final Dimension SIZE = new Dimension(800, 550);
    private CardLayout card_layout = null;
    private JPanel card_pane = null;
    private String SET_LOADED_CARD = "";
    private String NO_SET_LOADED_CARD = "No set loaded";
    private GEMS self = this;
    private OpenMetadataSetPrompt open_prompt;
    private DeleteMetadataSetPrompt delete_prompt;
    private NewMetadataSetPrompt new_prompt;
    private JSplitPane metadata_set_details_split_pane = null;
    private JSplitPane attribute_tables_split_pane = null;
    private Dimension screen_size = null;
    private MetadataSetManager msm;
    private AttributeTable attribute_table;
    private AttributeTable language_dependent_attribute_table;
    private MetadataSetTree meta_set_tree;
    private MetadataSetModel metadata_set_model;
    private boolean stand_alone = true;
    private ArrayList listeners;

    public static void main(String[] stringArray) {
        final GetOpt getOpt = new GetOpt(stringArray);
        if (getOpt.debug) {
            DebugStream.enableDebugging();
            Calendar calendar = Calendar.getInstance();
            String string = "debug" + calendar.get(5) + "-" + calendar.get(2) + "-" + calendar.get(1) + ".txt";
            DebugStream.println("Debug file path: " + string);
            DebugStream.setDebugFile(string);
        }
        if (getOpt.testing_mode) {
            TestingPreparation.TEST_MODE = true;
        }
        Gatherer.invokeInEDT_replacesProceedInCurrThread("GEMS.main()", true, new Runnable(){

            @Override
            public void run() {
                new GEMS(getOpt.gsdl_path, getOpt.gsdl3_web_path, getOpt.gsdl3_writableweb_path, getOpt.metadata_path, true, getOpt.new_set);
            }
        });
    }

    public GEMS(String string, String string2, String string3, String string4, boolean bl, boolean bl2) {
        JarTools.initialise(this);
        String string5 = System.getProperty("user.home") + File.separator;
        string5 = Utility.isWindows() ? string5 + "Application Data" + File.separator + "Greenstone" + File.separator + "GLI" + File.separator : string5 + ".gli" + File.separator;
        new Configuration(string5, string, string2, string3, null, null, null, null, null);
        new Dictionary(Configuration.getLocale("general.locale", true), Configuration.getFont("general.font", true));
        this.init(string4, bl, bl2);
    }

    public GEMS(String string, boolean bl) {
        JarTools.initialise(this);
        this.init(string, false, bl);
    }

    private void init(String string, boolean bl, boolean bl2) {
        this.screen_size = Configuration.screen_size;
        this.msm = new MetadataSetManager();
        this.stand_alone = bl;
        this.listeners = new ArrayList();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                GEMS.this.metadata_set_model.save(true);
                if (GEMS.this.stand_alone) {
                    System.exit(0);
                } else {
                    GEMS.this.notifyListeners();
                    GEMS.this.setVisible(false);
                }
            }
        });
        this.setSize(SIZE);
        this.setTitle(Dictionary.get("GEMS.Title"));
        this.setJMenuBar(new GEMSMenuBar());
        this.addWindowFocusListener(this);
        this.card_layout = new CardLayout();
        this.card_pane = new JPanel();
        this.metadata_set_model = new MetadataSetModel(this.msm);
        this.msm.setMetadataSetModel(this.metadata_set_model);
        this.meta_set_tree = new MetadataSetTree(this.self);
        this.metadata_set_model.addObserver(this.meta_set_tree);
        this.attribute_table = new AttributeTable(false);
        MetadataElementModel metadataElementModel = new MetadataElementModel();
        metadataElementModel.addMetadataElementListener(this.attribute_table);
        this.attribute_table.addAttributeListener(this.metadata_set_model);
        this.language_dependent_attribute_table = new AttributeTable(true);
        metadataElementModel.addMetadataElementListener(this.language_dependent_attribute_table);
        this.language_dependent_attribute_table.addAttributeListener(this.metadata_set_model);
        MetadataSetInfo metadataSetInfo = new MetadataSetInfo();
        metadataSetInfo.addMetadataSetListener(this.attribute_table);
        metadataSetInfo.addMetadataSetListener(this.language_dependent_attribute_table);
        metadataSetInfo.setMetadataSetModel(this.metadata_set_model);
        this.open_prompt = new OpenMetadataSetPrompt((Frame)this.self, this.msm);
        this.open_prompt.addMetadataSetListener(this.metadata_set_model);
        this.open_prompt.addMetadataSetListener(this.attribute_table);
        this.open_prompt.addMetadataSetListener(this.language_dependent_attribute_table);
        this.delete_prompt = new DeleteMetadataSetPrompt((Frame)this.self, this.msm);
        this.delete_prompt.addMetadataSetListener(this.metadata_set_model);
        this.delete_prompt.addMetadataSetListener(this.attribute_table);
        this.delete_prompt.addMetadataSetListener(this.language_dependent_attribute_table);
        this.new_prompt = new NewMetadataSetPrompt((Frame)this.self, this.msm);
        this.new_prompt.addMetadataSetListener(this.metadata_set_model);
        this.new_prompt.addMetadataSetListener(this.attribute_table);
        this.new_prompt.addMetadataSetListener(this.language_dependent_attribute_table);
        if (string != null && !string.equals("")) {
            this.open_prompt.openMetadataSet(string);
        } else if (bl2) {
            this.new_prompt.display();
        }
        JScrollPane jScrollPane = new JScrollPane(this.meta_set_tree);
        JScrollPane jScrollPane2 = new JScrollPane(this.attribute_table);
        JScrollPane jScrollPane3 = new JScrollPane(this.language_dependent_attribute_table);
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.lightGray);
        JLabel jLabel = new JLabel(Dictionary.get("GEMS.No_Set_Loaded"));
        jLabel.setHorizontalAlignment(0);
        jLabel.setVerticalAlignment(0);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jLabel, "Center");
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2));
        GLIButton gLIButton = new GLIButton(Dictionary.get("GEMS.Move_Up"));
        gLIButton.setIcon(JarTools.getImage("arrow-up.gif"));
        GLIButton gLIButton2 = new GLIButton(Dictionary.get("GEMS.Move_Down"));
        gLIButton2.setIcon(JarTools.getImage("arrow-down.gif"));
        gLIButton.setActionCommand(GEMSConstants.MOVE_UP);
        gLIButton.addActionListener(this.meta_set_tree);
        gLIButton2.addActionListener(this.meta_set_tree);
        gLIButton2.setActionCommand(GEMSConstants.MOVE_DOWN);
        jPanel2.add(gLIButton);
        jPanel2.add(gLIButton2);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)jScrollPane, "Center");
        jPanel3.add((Component)jPanel2, "South");
        JLabel jLabel2 = new JLabel(Dictionary.get("GEMS.SelectedLanguage"));
        jLabel2.setOpaque(true);
        Vector<String> vector = new Vector<String>(this.msm.getLanguageList());
        vector.add(0, Dictionary.get("GEMS.Language"));
        JComboBox jComboBox = new JComboBox(vector);
        jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                String string = (String)jComboBox.getSelectedItem();
                if (!string.equals(Dictionary.get("GEMS.Language"))) {
                    String string2 = string.split("\\s")[0];
                    GEMS.this.language_dependent_attribute_table.addNewLanguage(string2);
                }
            }
        });
        JLabel jLabel3 = new JLabel(Dictionary.get("GEMS.LanguageDependent"));
        jLabel3.setOpaque(true);
        JPanel jPanel4 = new JPanel(new BorderLayout(5, 5));
        jPanel4.add((Component)jLabel2, "West");
        jPanel4.add(jComboBox, "Center");
        JPanel jPanel5 = new JPanel(new BorderLayout(5, 5));
        jPanel5.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel5.add((Component)jLabel3, "North");
        jPanel5.add((Component)jPanel4, "Center");
        JPanel jPanel6 = new JPanel(new BorderLayout());
        jPanel6.add((Component)jPanel5, "North");
        jPanel6.add((Component)jScrollPane3, "Center");
        JLabel jLabel4 = new JLabel(Dictionary.get("GEMS.Attribute_Table"));
        jLabel4.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel jPanel7 = new JPanel(new BorderLayout());
        jPanel7.add((Component)jLabel4, "North");
        jPanel7.add((Component)jScrollPane2, "Center");
        this.attribute_tables_split_pane = new JSplitPane(0, jPanel7, jPanel6);
        this.metadata_set_details_split_pane = new JSplitPane(1, jPanel3, this.attribute_tables_split_pane);
        this.card_pane.setLayout(this.card_layout);
        this.card_pane.add((Component)jPanel, this.NO_SET_LOADED_CARD);
        this.card_pane.add((Component)this.metadata_set_details_split_pane, this.SET_LOADED_CARD);
        this.getContentPane().add((Component)this.card_pane, "Center");
        this.setLocation((this.screen_size.width - GEMS.SIZE.width) / 2, (this.screen_size.height - GEMS.SIZE.height) / 2);
        if (this.stand_alone) {
            this.setVisible(true);
        }
        TestingPreparation.setNamesRecursively(this);
        if (TestingPreparation.TEST_MODE) {
            this.setDefaultCloseOperation(2);
            this.setName("GEMS");
        }
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.attribute_tables_split_pane.setDividerLocation(0.3);
        }
    }

    public void displayMetadataSet(String string) {
        this.open_prompt.openMetadataSet(string);
        this.updateCardLayout(true);
        this.setVisible(true);
    }

    public void newMetadataSet() {
        this.new_prompt.display();
        if (!this.new_prompt.isCancelled()) {
            this.updateCardLayout(true);
            this.setVisible(true);
        }
    }

    public void addGEMSListener(GEMSListener gEMSListener) {
        this.listeners.add(gEMSListener);
    }

    public void removeGEMSListener(GEMSListener gEMSListener) {
        this.listeners.remove(gEMSListener);
    }

    public void notifyListeners() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            GEMSListener gEMSListener = (GEMSListener)this.listeners.get(i);
            gEMSListener.gemsIsClosed();
        }
    }

    public void exit() {
        this.cleanUpListeners();
    }

    protected void cleanUpListeners() {
        MetadataSetInfo metadataSetInfo = new MetadataSetInfo();
        metadataSetInfo.removeAllMetadataSetListeners();
        MetadataElementModel metadataElementModel = new MetadataElementModel();
        metadataElementModel.removeAllMetadataElementListeners();
    }

    @Override
    public void windowGainedFocus(WindowEvent windowEvent) {
    }

    @Override
    public void windowLostFocus(WindowEvent windowEvent) {
    }

    protected void updateCardLayout(boolean bl) {
        if (bl) {
            this.card_layout.show(this.card_pane, this.SET_LOADED_CARD);
        } else {
            this.card_layout.show(this.card_pane, this.NO_SET_LOADED_CARD);
        }
    }

    private class GEMSMenuBar
    extends JMenuBar
    implements ActionListener {
        private JMenu file = new JMenu();
        private JMenu edit = null;
        public JMenuItem file_exit = null;
        public JMenuItem file_new = null;
        public JMenuItem file_open = null;
        public JMenuItem file_close = null;
        public JMenuItem file_save = null;
        public JMenuItem edit_copy = null;
        public JMenuItem edit_cut = null;
        public JMenuItem edit_paste = null;
        public JMenuItem help_help = null;
        public JMenuItem file_delete = null;

        public GEMSMenuBar() {
            this.file.setText(Dictionary.get("Menu.File"));
            this.file_exit = new JMenuItem(Dictionary.get("Menu.File_Exit"));
            this.file_exit.addActionListener(this);
            this.file_new = new JMenuItem(Dictionary.get("Menu.File_New"));
            this.file_new.addActionListener(this);
            this.file_open = new JMenuItem(Dictionary.get("Menu.File_Open"));
            this.file_open.addActionListener(this);
            this.file_close = new JMenuItem(Dictionary.get("Menu.File_Close"));
            this.file_close.addActionListener(this);
            this.file_save = new JMenuItem(Dictionary.get("Menu.File_Save"));
            this.file_save.addActionListener(this);
            this.file_delete = new JMenuItem(Dictionary.get("Menu.File_Delete"));
            this.file_delete.addActionListener(this);
            if (!GEMS.this.stand_alone) {
                this.file_new.setEnabled(false);
                this.file_open.setEnabled(false);
                this.file_close.setEnabled(false);
                this.file_delete.setEnabled(false);
            }
            this.file.add(this.file_new);
            this.file.add(this.file_open);
            this.file.add(this.file_close);
            this.file.add(this.file_save);
            this.file.add(this.file_delete);
            this.file.add(new JSeparator());
            this.file.add(this.file_exit);
            this.edit = new JMenu();
            this.edit.setText(Dictionary.get("Menu.Edit"));
            String string = "ctrl";
            if (Utility.isMac()) {
                String string2;
                char c = '\u2318';
                string = string2 = String.valueOf(c);
            }
            this.edit_cut = new JMenuItem(Dictionary.get("Menu.Edit_Cut", string));
            this.edit_cut.addActionListener(this);
            this.edit_copy = new JMenuItem(Dictionary.get("Menu.Edit_Copy", string));
            this.edit_copy.addActionListener(this);
            this.edit_paste = new JMenuItem(Dictionary.get("Menu.Edit_Paste", string));
            this.edit_paste.addActionListener(this);
            this.edit.add(this.edit_cut);
            this.edit.add(this.edit_copy);
            this.edit.add(this.edit_paste);
            this.add(this.file);
            this.add(Box.createHorizontalStrut(15));
            this.add(this.edit);
            this.add(Box.createHorizontalGlue());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.file_new) {
                GEMS.this.new_prompt.display();
                if (!GEMS.this.new_prompt.isCancelled()) {
                    GEMS.this.updateCardLayout(true);
                }
                return;
            }
            if (object == this.file_open) {
                GEMS.this.open_prompt.display();
                if (!GEMS.this.open_prompt.isCancelled()) {
                    GEMS.this.updateCardLayout(true);
                }
                return;
            }
            if (object == this.file_close) {
                GEMS.this.metadata_set_model.save(true);
                GEMS.this.updateCardLayout(false);
                return;
            }
            if (object == this.file_delete) {
                GEMS.this.delete_prompt.display();
                return;
            }
            if (object == this.file_save) {
                GEMS.this.metadata_set_model.save(false);
                return;
            }
            if (object == this.file_exit) {
                GEMS.this.metadata_set_model.save(true);
                if (GEMS.this.stand_alone) {
                    if (TestingPreparation.TEST_MODE) {
                        GEMS.this.setVisible(false);
                        GEMS.this.dispose();
                    } else {
                        System.exit(0);
                    }
                } else {
                    GEMS.this.self.notifyListeners();
                    GEMS.this.self.setVisible(false);
                    return;
                }
            }
            if (object == this.edit_cut) {
                try {
                    KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                    JTextComponent jTextComponent = (JTextComponent)keyboardFocusManager.getPermanentFocusOwner();
                    jTextComponent.cut();
                }
                catch (ClassCastException classCastException) {
                    DebugStream.println(classCastException.toString());
                }
                return;
            }
            if (object == this.edit_copy) {
                try {
                    KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                    JTextComponent jTextComponent = (JTextComponent)keyboardFocusManager.getPermanentFocusOwner();
                    jTextComponent.copy();
                }
                catch (Exception exception) {
                    DebugStream.println(exception.toString());
                }
                return;
            }
            if (object == this.edit_paste) {
                try {
                    KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                    JTextComponent jTextComponent = (JTextComponent)keyboardFocusManager.getPermanentFocusOwner();
                    jTextComponent.paste();
                }
                catch (ClassCastException classCastException) {
                    DebugStream.println(classCastException.toString());
                }
                return;
            }
        }
    }
}

