/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.file;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.greenstone.gatherer.DebugStream;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.file.FileFilter;
import org.greenstone.gatherer.file.FileNode;
import org.greenstone.gatherer.gui.tree.DragTree;

public class FileSystemModel
extends DefaultTreeModel
implements TreeExpansionListener,
TreeWillExpandListener {
    private DragTree tree = null;
    private FileFilter current_filter = null;
    private FileFilter[] filters = null;
    private FileFilter[] default_filters = new FileFilter[]{new FileFilter("\\..*", true), new FileFilter("metadata\\.xml", true)};

    public FileSystemModel(FileNode fileNode) {
        super(fileNode);
        fileNode.setModel(this);
        fileNode.refresh();
    }

    @Override
    public int getChildCount(Object object) {
        return ((TreeNode)object).getChildCount();
    }

    public FileFilter[] getFilters() {
        if (this.filters == null) {
            if (this.current_filter != null) {
                this.filters = new FileFilter[this.default_filters.length + 1];
                this.filters[this.default_filters.length] = this.current_filter;
            } else {
                this.filters = new FileFilter[this.default_filters.length];
            }
            System.arraycopy(this.default_filters, 0, this.filters, 0, this.default_filters.length);
        }
        return this.filters;
    }

    public FileNode getNode(TreePath treePath) {
        FileNode fileNode = (FileNode)treePath.getLastPathComponent();
        DebugStream.println("Last Path Component = " + fileNode);
        return fileNode;
    }

    @Override
    public void insertNodeInto(MutableTreeNode mutableTreeNode, MutableTreeNode mutableTreeNode2, int n) {
        super.insertNodeInto(mutableTreeNode, mutableTreeNode2, n);
    }

    public void refresh(final TreePath treePath) {
        Gatherer.invokeInEDT_replacesProceedInCurrThread("FileSystemModel.refresh()", true, new Runnable(){

            @Override
            public void run() {
                Enumeration<TreePath> enumeration;
                if (FileSystemModel.this.tree == null) {
                    return;
                }
                TreePath treePath4 = treePath;
                if (treePath4 == null) {
                    treePath4 = new TreePath(((FileNode)FileSystemModel.this.root).getPath());
                    FileSystemModel.this.tree.expandPath(treePath4);
                }
                if ((enumeration = FileSystemModel.this.tree.getExpandedDescendants(treePath4)) == null) {
                    return;
                }
                FileNode fileNode = (FileNode)treePath4.getLastPathComponent();
                fileNode.refresh();
                FileSystemModel.this.nodeStructureChanged(fileNode);
                ArrayList<TreePath> arrayList = Collections.list(enumeration);
                Collections.sort(arrayList, new TreePathComparator());
                for (int i = 0; i < arrayList.size(); ++i) {
                    TreePath treePath2 = arrayList.get(i);
                    TreePath treePath3 = new TreePath(treePath4.getPath());
                    FileNode fileNode2 = fileNode;
                    while (!treePath3.toString().equals(treePath2.toString())) {
                        FileNode fileNode3 = (FileNode)treePath2.getPathComponent(treePath3.getPathCount());
                        boolean bl = false;
                        for (int j = 0; j < fileNode2.getChildCount(); ++j) {
                            FileNode fileNode4 = (FileNode)fileNode2.getChildAt(j);
                            if (!fileNode4.equals(fileNode3)) continue;
                            treePath3 = treePath3.pathByAddingChild(fileNode4);
                            fileNode2 = fileNode4;
                            bl = true;
                            break;
                        }
                        if (bl) continue;
                        break;
                    }
                    if (!treePath3.toString().equals(treePath2.toString())) continue;
                    FileSystemModel.this.tree.expandPath(treePath3);
                }
            }
        });
    }

    @Override
    public void removeNodeFromParent(MutableTreeNode mutableTreeNode) {
        TreeNode treeNode = ((FileNode)mutableTreeNode).getParent();
        if (treeNode != null && treeNode.getIndex((FileNode)mutableTreeNode) != -1) {
            super.removeNodeFromParent(mutableTreeNode);
        }
    }

    public void removeNodeFromRoot(MutableTreeNode mutableTreeNode, MutableTreeNode mutableTreeNode2) {
        for (int i = 0; i < mutableTreeNode2.getChildCount(); ++i) {
            MutableTreeNode mutableTreeNode3 = (MutableTreeNode)mutableTreeNode2.getChildAt(i);
            if (!mutableTreeNode3.toString().equals(mutableTreeNode.toString())) continue;
            super.removeNodeFromParent(mutableTreeNode3);
            break;
        }
    }

    public void setFilter(String string) {
        this.current_filter = string != null ? new FileFilter(string, false) : null;
        this.filters = null;
    }

    public void setTree(DragTree dragTree) {
        this.tree = dragTree;
    }

    public String toString() {
        if (this.tree != null) {
            return this.tree.toString();
        }
        return "FileSystemModel";
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        TreePath treePath = treeExpansionEvent.getPath();
        FileNode fileNode = (FileNode)treePath.getLastPathComponent();
        fileNode.unmap();
        this.nodeStructureChanged(fileNode);
    }

    @Override
    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
        TreePath treePath = treeExpansionEvent.getPath();
        if (treePath.getPathCount() == 1) {
            throw new ExpandVetoException(treeExpansionEvent, "Cannot collapse root node!");
        }
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
        Gatherer.g_man.wait(true);
        TreePath treePath = treeExpansionEvent.getPath();
        FileNode fileNode = (FileNode)treePath.getLastPathComponent();
        fileNode.refresh();
        this.nodeStructureChanged(fileNode);
        Gatherer.g_man.wait(false);
    }

    private class TreePathComparator
    implements Comparator {
        private TreePathComparator() {
        }

        public int compare(Object object, Object object2) {
            return ((TreePath)object).getPathCount() - ((TreePath)object2).getPathCount();
        }
    }
}

