/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.feedback;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import org.greenstone.gatherer.feedback.SaveToXML;

public class UserComponent
implements Serializable {
    private String type = null;
    private String title = null;
    private ArrayList content = new ArrayList();
    private String selected = null;
    private String visible = null;
    private String image = null;
    private String img = null;
    private String imgFile = null;
    private int index;
    private String height;
    private String width;
    private String tooltip;

    public String getWidth() {
        return this.width;
    }

    public String getHeight() {
        return this.height;
    }

    public String getType() {
        return this.type;
    }

    public String getToolTip() {
        return this.tooltip;
    }

    public String getTitle() {
        return this.title;
    }

    public ArrayList getContent() {
        return this.content;
    }

    public String getSelected() {
        return this.selected;
    }

    public String getVisible() {
        return this.visible;
    }

    public String getImage() {
        return this.image;
    }

    public String getImageFileName() {
        return this.img;
    }

    public String getImageFile() {
        return this.imgFile;
    }

    public void startContent(int n) {
        this.index = n;
    }

    public void saveContent(UserComponent userComponent) {
        this.content.add(userComponent);
    }

    public void saveContent(String string) {
        if (string == null) {
            string = " ";
        }
        switch (this.index) {
            case 1: {
                this.type = string;
                break;
            }
            case 2: {
                this.title = string;
                break;
            }
            case 3: {
                this.content.add(string);
                break;
            }
            case 4: {
                this.selected = string;
                break;
            }
            case 5: {
                this.visible = string;
                break;
            }
            case 6: {
                this.image = string;
                break;
            }
            case 7: {
                this.tooltip = string;
            }
        }
    }

    public void saveImage(ImageIcon imageIcon, String string) {
    }

    public void saveImage(Icon icon, String string) {
        if (icon == null) {
            System.out.println("null image??");
        } else if (icon instanceof ImageIcon) {
            this.saveImage((ImageIcon)icon, string);
        } else {
            System.out.println("Its a icon");
        }
    }

    private void saveIcon(Icon icon, String string) {
        JFrame jFrame = new JFrame();
        jFrame.setVisible(false);
        BufferedImage bufferedImage = this.iconToImage(icon, jFrame);
        ImageIcon imageIcon = new ImageIcon(bufferedImage);
        jFrame.dispose();
        jFrame = null;
        this.saveImage(imageIcon, string);
    }

    public void sendingXML(SaveToXML saveToXML) {
        if (this.type != null) {
            saveToXML.startContent(1);
            saveToXML.saveContent(this.type);
            saveToXML.closeContent(1);
        }
        if (this.title != null) {
            saveToXML.startContent(2);
            saveToXML.saveContent(this.title);
            saveToXML.closeContent(2);
        }
        if (this.content != null) {
            saveToXML.startContent(3);
            for (int i = 0; i < this.content.size(); ++i) {
                if (this.content.get(i) instanceof String) {
                    saveToXML.saveContent((String)this.content.get(i));
                    continue;
                }
                saveToXML.startContent(0);
                UserComponent userComponent = (UserComponent)this.content.get(i);
                userComponent.sendingXML(saveToXML);
                saveToXML.closeContent(0);
            }
            saveToXML.closeContent(3);
        }
        if (this.selected != null) {
            saveToXML.startContent(4);
            saveToXML.saveContent(this.selected);
            saveToXML.closeContent(4);
        }
        if (this.visible != null) {
            saveToXML.startContent(5);
            saveToXML.saveContent(this.visible);
            saveToXML.closeContent(5);
        }
        if (this.img != null) {
            saveToXML.startContent(6);
            saveToXML.saveImage(this.imgFile, this.img, this.width, this.height);
            saveToXML.closeContent(6);
        } else if (this.image != null) {
            saveToXML.startContent(11);
            saveToXML.saveContent(this.image);
            saveToXML.closeContent(11);
        }
        if (this.tooltip != null) {
            saveToXML.startContent(12);
            saveToXML.saveContent(this.tooltip);
            saveToXML.closeContent(12);
        }
    }

    public BufferedImage iconToImage(Icon icon, Component component) {
        int n = icon.getIconWidth();
        int n2 = icon.getIconHeight();
        GraphicsConfiguration graphicsConfiguration = component.getGraphicsConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n2, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        icon.paintIcon(component, graphics2D, 0, 0);
        graphics2D.dispose();
        return bufferedImage;
    }
}

