/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.cdm;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.DebugStream;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.cdm.CollectionConfiguration;
import org.greenstone.gatherer.cdm.CollectionDesignManager;
import org.greenstone.gatherer.cdm.Control;
import org.greenstone.gatherer.cdm.DOMProxyListModel;
import org.greenstone.gatherer.cdm.Subcollection;
import org.greenstone.gatherer.gui.DesignPaneHeader;
import org.greenstone.gatherer.gui.GLIButton;
import org.greenstone.gatherer.gui.NonWhitespaceField;
import org.greenstone.gatherer.gui.TestingPreparation;
import org.greenstone.gatherer.metadata.MetadataElement;
import org.greenstone.gatherer.metadata.MetadataSetManager;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SubcollectionManager
extends DOMProxyListModel {
    private static final String DISABLED_CONTROLS = "Disabled";
    private static final String ENABLED_CONTROLS = "Normal";
    private static final String CLASS_DICTIONARY_NAME = "CDM.SubcollectionManager.";
    private Control controls = null;
    private DOMProxyListModel model;

    public SubcollectionManager() {
        super(CollectionDesignManager.collect_config.getDocumentElement(), "Subcollection", new Subcollection());
        DebugStream.println("SubcollectionManager: " + this.getSize() + " subcollections parsed.");
        this.model = this;
    }

    private void addSubcollection(Subcollection subcollection) {
        if (!this.contains(subcollection)) {
            Element element = subcollection.getElement();
            Node node = CollectionConfiguration.findInsertionPoint(element);
            this.add(this.root, subcollection, node);
        }
    }

    public void destroy() {
        if (this.controls != null) {
            this.controls.destroy();
            this.controls = null;
        }
    }

    public Control getControls() {
        if (this.controls == null) {
            this.controls = new SubcollectionControl();
        }
        return this.controls;
    }

    private Subcollection getSubcollection(String string) {
        Subcollection subcollection = null;
        int n = this.getSize();
        for (int i = 0; i < n; ++i) {
            Subcollection subcollection2 = (Subcollection)this.getElementAt(i);
            if (!subcollection2.getName().equals(string)) continue;
            subcollection = subcollection2;
        }
        return subcollection;
    }

    public void modeChanged(int n) {
    }

    private void removeSubcollection(Subcollection subcollection) {
        this.remove(subcollection);
    }

    private void updateSubcollection(Subcollection subcollection, String string, boolean bl, String string2, String string3, String string4) {
        subcollection.setFlags(string4);
        subcollection.setInclusive(bl);
        subcollection.setName(string);
        subcollection.setPattern(string3);
        subcollection.setSource(string2);
        this.refresh(subcollection);
    }

    private class SubcollectionControl
    extends JPanel
    implements Control,
    ChangeListener {
        private JButton add_button;
        private JButton remove_button;
        private JButton update_button;
        private JComboBox source_combobox;
        private JList subcollection_list;
        private JTabbedPane tabbed_pane;
        private JTextField flags_field;
        private JTextField match_field;
        private JTextField name_field;
        private JRadioButton exclude_button;
        private JRadioButton include_button;

        public SubcollectionControl() {
            DesignPaneHeader designPaneHeader = new DesignPaneHeader("CDM.GUI.Subcollections", "partitionindexes");
            this.tabbed_pane = new JTabbedPane();
            this.tabbed_pane.addChangeListener(this);
            this.tabbed_pane.setComponentOrientation(Dictionary.getOrientation());
            JPanel jPanel = new JPanel();
            jPanel.setComponentOrientation(Dictionary.getOrientation());
            this.add_button = new GLIButton(Dictionary.get("CDM.SubcollectionManager.Add"), Dictionary.get("CDM.SubcollectionManager.Add_Tooltip"));
            this.add_button.setEnabled(false);
            this.remove_button = new GLIButton(Dictionary.get("CDM.SubcollectionManager.Remove"), Dictionary.get("CDM.SubcollectionManager.Remove_Tooltip"));
            this.remove_button.setEnabled(false);
            this.update_button = new GLIButton(Dictionary.get("CDM.SubcollectionManager.Replace"), Dictionary.get("CDM.SubcollectionManager.Replace_Tooltip"));
            this.update_button.setEnabled(false);
            JPanel jPanel2 = new JPanel();
            jPanel2.setComponentOrientation(Dictionary.getOrientation());
            JPanel jPanel3 = new JPanel();
            jPanel3.setComponentOrientation(Dictionary.getOrientation());
            this.include_button = new JRadioButton(Dictionary.get("CDM.SubcollectionManager.Include"));
            this.include_button.setComponentOrientation(Dictionary.getOrientation());
            this.include_button.setBackground(Configuration.getColor("coloring.collection_tree_background", false));
            this.include_button.setOpaque(false);
            this.exclude_button = new JRadioButton(Dictionary.get("CDM.SubcollectionManager.Exclude"));
            this.exclude_button.setBackground(Configuration.getColor("coloring.collection_tree_background", false));
            this.exclude_button.setOpaque(false);
            this.exclude_button.setComponentOrientation(Dictionary.getOrientation());
            JLabel jLabel = new JLabel(Dictionary.get("CDM.SubcollectionManager.Flags"));
            jLabel.setComponentOrientation(Dictionary.getOrientation());
            this.flags_field = new NonWhitespaceField();
            this.flags_field.setToolTipText(Dictionary.get("CDM.SubcollectionManager.Flags_Tooltip"));
            this.flags_field.setComponentOrientation(Dictionary.getOrientation());
            JPanel jPanel4 = new JPanel();
            jPanel4.setComponentOrientation(Dictionary.getOrientation());
            JLabel jLabel2 = new JLabel(Dictionary.get("CDM.SubcollectionManager.Inclusive"));
            jLabel2.setComponentOrientation(Dictionary.getOrientation());
            JLabel jLabel3 = new JLabel(Dictionary.get("CDM.SubcollectionManager.Match"));
            jLabel3.setComponentOrientation(Dictionary.getOrientation());
            this.match_field = new JTextField();
            this.match_field.setToolTipText(Dictionary.get("CDM.SubcollectionManager.Match_Tooltip"));
            this.match_field.setComponentOrientation(Dictionary.getOrientation());
            JLabel jLabel4 = new JLabel(Dictionary.get("CDM.SubcollectionManager.Name"));
            jLabel4.setComponentOrientation(Dictionary.getOrientation());
            this.name_field = new NonWhitespaceField();
            this.name_field.setToolTipText(Dictionary.get("CDM.SubcollectionManager.Name_Tooltip"));
            JLabel jLabel5 = new JLabel(Dictionary.get("CDM.SubcollectionManager.Source"));
            jLabel5.setComponentOrientation(Dictionary.getOrientation());
            ArrayList arrayList = MetadataSetManager.getEveryMetadataSetElement();
            Vector<String> vector = new Vector<String>(arrayList);
            vector.add(0, "Filename");
            this.source_combobox = new JComboBox(vector);
            this.source_combobox.setComponentOrientation(Dictionary.getOrientation());
            this.source_combobox.setOpaque(false);
            this.source_combobox.setToolTipText(Dictionary.get("CDM.SubcollectionManager.Source_Tooltip"));
            this.subcollection_list = new JList(SubcollectionManager.this.model);
            this.subcollection_list.setSelectionMode(0);
            JPanel jPanel5 = new JPanel();
            jPanel5.setComponentOrientation(Dictionary.getOrientation());
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.include_button);
            buttonGroup.add(this.exclude_button);
            this.include_button.setSelected(true);
            JPanel jPanel6 = new JPanel();
            jPanel6.setComponentOrientation(Dictionary.getOrientation());
            JLabel jLabel6 = new JLabel(Dictionary.get("CDM.SubcollectionManager.Assigned"));
            jLabel6.setComponentOrientation(Dictionary.getOrientation());
            SubCollectionChangeListener subCollectionChangeListener = new SubCollectionChangeListener();
            this.add_button.addActionListener(new AddSubCollectionListener());
            this.add_button.addActionListener(CollectionDesignManager.buildcol_change_listener);
            this.remove_button.addActionListener(new RemoveSubCollectionListener());
            this.remove_button.addActionListener(CollectionDesignManager.buildcol_change_listener);
            this.update_button.addActionListener(new UpdateSubCollectionListener());
            this.update_button.addActionListener(CollectionDesignManager.buildcol_change_listener);
            this.exclude_button.addActionListener(subCollectionChangeListener);
            this.include_button.addActionListener(subCollectionChangeListener);
            this.source_combobox.addActionListener(subCollectionChangeListener);
            this.flags_field.getDocument().addDocumentListener(subCollectionChangeListener);
            this.match_field.getDocument().addDocumentListener(subCollectionChangeListener);
            this.name_field.getDocument().addDocumentListener(subCollectionChangeListener);
            this.subcollection_list.addListSelectionListener(new SubCollectionListListener());
            jPanel4.setLayout(new GridLayout());
            jPanel4.add(this.include_button);
            jPanel4.add(this.exclude_button);
            jPanel3.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
            jPanel3.setLayout(new GridLayout(5, 2));
            jPanel3.add(jLabel4);
            jPanel3.add(this.name_field);
            jPanel3.add(jLabel5);
            jPanel3.add(this.source_combobox);
            jPanel3.add(jLabel3);
            jPanel3.add(this.match_field);
            jPanel3.add(jLabel2);
            jPanel3.add(jPanel4);
            jPanel3.add(jLabel);
            jPanel3.add(this.flags_field);
            jPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
            jPanel.setLayout(new GridLayout(1, 3));
            jPanel.add(this.add_button);
            jPanel.add(this.update_button);
            jPanel.add(this.remove_button);
            jPanel2.setLayout(new BorderLayout());
            jPanel2.add((Component)jPanel3, "Center");
            jPanel2.add((Component)jPanel, "South");
            jPanel6.setLayout(new BorderLayout());
            jPanel6.add((Component)jLabel6, "North");
            jPanel6.add((Component)new JScrollPane(this.subcollection_list), "Center");
            jPanel5.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            jPanel5.setLayout(new BorderLayout());
            jPanel5.add((Component)jPanel6, "Center");
            jPanel5.add((Component)jPanel2, "South");
            this.tabbed_pane.addTab(Dictionary.get("CDM.SubcollectionManager.Subcollection_Controls"), jPanel5);
            this.tabbed_pane.addTab(Dictionary.get("CDM.SubcollectionManager.Subindex_Controls"), (JPanel)((Object)CollectionDesignManager.subcollectionindex_manager.getControls()));
            this.tabbed_pane.addTab(Dictionary.get("CDM.SubcollectionManager.Language_Controls"), (JPanel)((Object)CollectionDesignManager.language_manager.getControls()));
            this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            this.setLayout(new BorderLayout());
            this.add((Component)designPaneHeader, "North");
            this.add((Component)this.tabbed_pane, "Center");
            TestingPreparation.setIndividualSubcomponentNames(this, this.name_field, this.source_combobox, this.match_field, this.flags_field);
        }

        @Override
        public void destroy() {
        }

        @Override
        public void gainFocus() {
            ArrayList arrayList = MetadataSetManager.getEveryMetadataSetElement();
            Vector<String> vector = new Vector<String>(arrayList);
            vector.add(0, "Filename");
            this.source_combobox.setModel(new DefaultComboBoxModel(vector));
        }

        @Override
        public void loseFocus() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            if (this.tabbed_pane.getSelectedIndex() == 1) {
                CollectionDesignManager.subcollectionindex_manager.getControls().gainFocus();
            }
            if (this.tabbed_pane.getSelectedIndex() == 2) {
                CollectionDesignManager.language_manager.getControls().gainFocus();
            }
        }

        private class SubCollectionListListener
        implements ListSelectionListener {
            private SubCollectionListListener() {
            }

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                if (!SubcollectionControl.this.subcollection_list.isSelectionEmpty()) {
                    Subcollection subcollection = (Subcollection)SubcollectionControl.this.subcollection_list.getSelectedValue();
                    SubcollectionControl.this.flags_field.setText(subcollection.getFlags());
                    SubcollectionControl.this.include_button.setSelected(subcollection.isInclusive());
                    SubcollectionControl.this.exclude_button.setSelected(!subcollection.isInclusive());
                    SubcollectionControl.this.match_field.setText(subcollection.getPattern());
                    SubcollectionControl.this.name_field.setText(subcollection.getName());
                    String string = subcollection.getSource();
                    int n = 0;
                    Object e = SubcollectionControl.this.source_combobox.getItemAt(n);
                    while (e != null) {
                        if (e instanceof MetadataElement) {
                            MetadataElement metadataElement = (MetadataElement)e;
                            String string2 = metadataElement.getFullName();
                            if (string2.equals(string)) {
                                SubcollectionControl.this.source_combobox.setSelectedIndex(n);
                                e = null;
                                continue;
                            }
                            e = SubcollectionControl.this.source_combobox.getItemAt(++n);
                            continue;
                        }
                        if (e.toString().equals(string)) {
                            SubcollectionControl.this.source_combobox.setSelectedIndex(n);
                            e = null;
                            continue;
                        }
                        e = SubcollectionControl.this.source_combobox.getItemAt(++n);
                    }
                    SubcollectionControl.this.add_button.setEnabled(false);
                    SubcollectionControl.this.remove_button.setEnabled(true);
                    SubcollectionControl.this.update_button.setEnabled(true);
                } else {
                    SubcollectionControl.this.flags_field.setText("");
                    SubcollectionControl.this.include_button.setSelected(true);
                    SubcollectionControl.this.match_field.setText("");
                    SubcollectionControl.this.name_field.setText("");
                    SubcollectionControl.this.source_combobox.setSelectedIndex(0);
                    SubcollectionControl.this.remove_button.setEnabled(false);
                    SubcollectionControl.this.update_button.setEnabled(false);
                }
            }
        }

        private class UpdateSubCollectionListener
        implements ActionListener {
            private UpdateSubCollectionListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!SubcollectionControl.this.subcollection_list.isSelectionEmpty()) {
                    Object object;
                    Subcollection subcollection = (Subcollection)SubcollectionControl.this.subcollection_list.getSelectedValue();
                    String string = SubcollectionControl.this.name_field.getText();
                    String string2 = null;
                    Object object2 = SubcollectionControl.this.source_combobox.getSelectedItem();
                    if (object2 instanceof MetadataElement) {
                        object = (MetadataElement)object2;
                        string2 = ((MetadataElement)object).getFullName();
                    } else {
                        string2 = object2.toString();
                    }
                    object = SubcollectionControl.this.match_field.getText();
                    String string3 = SubcollectionControl.this.flags_field.getText();
                    if (string.length() > 0 && (string2 == null || string2.length() > 0) && ((String)object).length() > 0) {
                        SubcollectionManager.this.updateSubcollection(subcollection, string, SubcollectionControl.this.include_button.isSelected(), string2, (String)object, string3);
                    }
                }
            }
        }

        private class RemoveSubCollectionListener
        implements ActionListener {
            private RemoveSubCollectionListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!SubcollectionControl.this.subcollection_list.isSelectionEmpty()) {
                    Subcollection subcollection = (Subcollection)SubcollectionControl.this.subcollection_list.getSelectedValue();
                    SubcollectionManager.this.removeSubcollection(subcollection);
                    CollectionDesignManager.subcollectionindex_manager.removeSubcollectionIndexes(subcollection);
                }
                SubcollectionControl.this.remove_button.setEnabled(false);
            }
        }

        private class SubCollectionChangeListener
        implements DocumentListener,
        ActionListener {
            private SubCollectionChangeListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                this.validateAdd();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.validateAdd();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.validateAdd();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.validateAdd();
            }

            private void validateAdd() {
                if (SubcollectionControl.this.name_field.getText().length() > 0 && SubcollectionControl.this.match_field.getText().length() > 0) {
                    if (SubcollectionManager.this.getSubcollection(SubcollectionControl.this.name_field.getText()) == null) {
                        SubcollectionControl.this.add_button.setEnabled(true);
                    } else {
                        SubcollectionControl.this.add_button.setEnabled(false);
                    }
                } else {
                    SubcollectionControl.this.add_button.setEnabled(false);
                }
            }
        }

        private class AddSubCollectionListener
        implements ActionListener {
            private AddSubCollectionListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                String string = SubcollectionControl.this.name_field.getText();
                String string2 = null;
                Object object2 = SubcollectionControl.this.source_combobox.getSelectedItem();
                if (object2 instanceof MetadataElement) {
                    object = (MetadataElement)object2;
                    string2 = ((MetadataElement)object).getFullName();
                } else {
                    string2 = object2.toString();
                }
                object = SubcollectionControl.this.match_field.getText();
                String string3 = SubcollectionControl.this.flags_field.getText();
                if (string.length() > 0 && (string2 == null || string2.length() > 0) && ((String)object).length() > 0) {
                    Subcollection subcollection = new Subcollection(string, SubcollectionControl.this.include_button.isSelected(), string2, (String)object, string3);
                    SubcollectionManager.this.addSubcollection(subcollection);
                    SubcollectionControl.this.subcollection_list.setSelectedValue(subcollection, true);
                }
                SubcollectionControl.this.add_button.setEnabled(false);
            }
        }
    }
}

