/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.cdm;

import java.util.ArrayList;
import java.util.Collections;
import org.greenstone.gatherer.cdm.CollectionConfiguration;
import org.greenstone.gatherer.cdm.DOMProxyListEntry;
import org.greenstone.gatherer.cdm.Subcollection;
import org.greenstone.gatherer.util.XMLTools;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SubcollectionIndex
implements Comparable,
DOMProxyListEntry {
    private ArrayList sources = null;
    private Element element = null;
    private String id = null;

    public SubcollectionIndex() {
    }

    public SubcollectionIndex(Element element) {
        this.element = element;
    }

    public SubcollectionIndex(Object[] objectArray) {
        this.sources = new ArrayList();
        this.element = CollectionConfiguration.createElement("Index");
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Subcollection subcollection = (Subcollection)objectArray[i];
            String string = subcollection.getName();
            this.sources.add(string);
            Element element = CollectionConfiguration.createElement("content");
            element.setAttribute("name", string);
            this.element.appendChild(element);
            element = null;
        }
    }

    public int compareTo(Object object) {
        return this.getID().compareTo(((SubcollectionIndex)object).getID());
    }

    @Override
    public DOMProxyListEntry create(Element element) {
        return new SubcollectionIndex(element);
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    @Override
    public Element getElement() {
        return this.element;
    }

    public String getID() {
        if (this.id == null) {
            StringBuffer stringBuffer = new StringBuffer();
            ArrayList arrayList = this.getSources();
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                stringBuffer.append((String)arrayList.get(i));
                stringBuffer.append(",");
            }
            arrayList = null;
            this.id = stringBuffer.substring(0, stringBuffer.length() - 1);
        }
        return this.id;
    }

    public ArrayList getSources() {
        if (this.sources == null) {
            this.sources = new ArrayList();
            if (this.element == null) {
                return this.sources;
            }
            NodeList nodeList = this.element.getElementsByTagName("content");
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element = (Element)nodeList.item(i);
                this.sources.add(element.getAttribute("name"));
            }
            nodeList = null;
            Collections.sort(this.sources);
        }
        return this.sources;
    }

    @Override
    public boolean isAssigned() {
        return this.element != null && !this.element.getAttribute("assigned").equals("false");
    }

    @Override
    public void setAssigned(boolean bl) {
        if (this.element != null) {
            this.element.setAttribute("assigned", bl ? "true" : "false");
        }
    }

    @Override
    public void setElement(Element element) {
        this.element = element;
        this.id = null;
        this.sources = null;
    }

    public void setSources(ArrayList arrayList) {
        if (this.element != null) {
            XMLTools.clear(this.element);
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Element element = this.element.getOwnerDocument().createElement("content");
                element.setAttribute("name", (String)arrayList.get(i));
                this.element.appendChild(element);
                element = null;
            }
            this.id = null;
            this.sources = arrayList;
        }
    }

    public String toString() {
        return this.getID();
    }
}

