/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.cdm;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.cdm.BuildTypeManager;
import org.greenstone.gatherer.cdm.CollectionDesignManager;
import org.greenstone.gatherer.cdm.Control;
import org.greenstone.gatherer.cdm.FacetManager;
import org.greenstone.gatherer.cdm.IndexOptionManager;
import org.greenstone.gatherer.cdm.SearchIndexManager;
import org.greenstone.gatherer.cdm.SortFieldManager;
import org.greenstone.gatherer.gui.DesignPaneHeader;

public class IndexingManager {
    private IndexOptionManager option_manager = null;
    private SearchIndexManager index_manager = null;
    private BuildTypeManager build_type_manager = new BuildTypeManager();
    private SortFieldManager sortfield_manager = null;
    private FacetManager facet_manager = null;
    private String build_type = this.build_type_manager.getBuildType();
    private Control controls = null;

    public IndexingManager() {
        this.option_manager = new IndexOptionManager(this.build_type);
        this.index_manager = this.isMG() ? new SearchIndexManager(CollectionDesignManager.collect_config.getMGIndexes(), this.build_type) : new SearchIndexManager(CollectionDesignManager.collect_config.getMGPPIndexes(), this.build_type);
        this.sortfield_manager = new SortFieldManager(CollectionDesignManager.collect_config.getSorts(), this.build_type);
        this.facet_manager = new FacetManager(CollectionDesignManager.collect_config.getFacets(), this.build_type);
    }

    public boolean isMGPP() {
        return this.build_type_manager.isMGPP();
    }

    public boolean isLucene() {
        return this.build_type_manager.isLucene();
    }

    public boolean isMG() {
        return this.build_type_manager.isMG();
    }

    public boolean isSOLR() {
        return this.build_type_manager.isSOLR();
    }

    public int getNumLevels() {
        return this.option_manager.getNumLevels();
    }

    public int getNumIndexes() {
        return this.index_manager.getSize();
    }

    public ArrayList getIndexes() {
        return this.index_manager.getIndexes();
    }

    public ArrayList getLevels() {
        if (!this.isMG()) {
            return this.option_manager.getLevels();
        }
        return null;
    }

    public ArrayList getSortFields() {
        if (this.isLucene() || this.isSOLR()) {
            return this.sortfield_manager.getIndexes();
        }
        return null;
    }

    public ArrayList getFacets() {
        if (this.isSOLR()) {
            return this.facet_manager.getIndexes();
        }
        return null;
    }

    public Control getControls() {
        if (this.controls == null) {
            this.controls = new IndexingControl();
        }
        return this.controls;
    }

    public void destroy() {
    }

    public void modeChanged(int n) {
    }

    private class IndexingControl
    extends JPanel
    implements Control,
    BuildTypeManager.BuildTypeListener {
        JPanel main_index_pane = null;
        JPanel index_options_panel = null;
        JPanel index_sort_facet_panel = null;
        private JPanel sortfield_panel = null;
        private JPanel facet_panel = null;

        public IndexingControl() {
            this.setComponentOrientation(Dictionary.getOrientation());
            DesignPaneHeader designPaneHeader = new DesignPaneHeader("CDM.GUI.Indexes", "searchindexes");
            JPanel jPanel = (JPanel)((Object)IndexingManager.this.build_type_manager.getControls());
            this.index_options_panel = (JPanel)((Object)IndexingManager.this.option_manager.getControls());
            this.index_sort_facet_panel = new JPanel();
            this.index_sort_facet_panel.setLayout(new GridLayout(0, 1, 0, 5));
            JPanel jPanel2 = (JPanel)((Object)IndexingManager.this.index_manager.getControls());
            this.index_sort_facet_panel.add(jPanel2);
            if (IndexingManager.this.isLucene() || IndexingManager.this.isSOLR()) {
                this.sortfield_panel = (JPanel)((Object)IndexingManager.this.sortfield_manager.getControls());
                this.index_sort_facet_panel.add(this.sortfield_panel);
            }
            if (IndexingManager.this.isSOLR()) {
                this.facet_panel = (JPanel)((Object)IndexingManager.this.facet_manager.getControls());
                this.index_sort_facet_panel.add(this.facet_panel);
            }
            this.main_index_pane = new JPanel();
            this.main_index_pane.setLayout(new BorderLayout());
            this.main_index_pane.add((Component)jPanel, "North");
            this.main_index_pane.add((Component)this.index_sort_facet_panel, "Center");
            this.main_index_pane.add((Component)this.index_options_panel, "South");
            this.main_index_pane.setComponentOrientation(Dictionary.getOrientation());
            this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            this.setLayout(new BorderLayout());
            this.add((Component)designPaneHeader, "North");
            this.add((Component)this.main_index_pane, "Center");
            IndexingManager.this.build_type_manager.addBuildTypeListener(this);
            IndexingManager.this.build_type_manager.addBuildTypeListener(IndexingManager.this.index_manager);
            IndexingManager.this.build_type_manager.addBuildTypeListener(IndexingManager.this.sortfield_manager);
            IndexingManager.this.build_type_manager.addBuildTypeListener(IndexingManager.this.facet_manager);
            IndexingManager.this.build_type_manager.addBuildTypeListener(IndexingManager.this.option_manager);
        }

        @Override
        public void loseFocus() {
        }

        @Override
        public void gainFocus() {
        }

        @Override
        public void destroy() {
        }

        @Override
        public void buildTypeChanged(String string) {
            if (IndexingManager.this.build_type.equals(string)) {
                return;
            }
            if (this.hasSorts(string) && !this.hasSorts(IndexingManager.this.build_type)) {
                this.sortfield_panel = (JPanel)((Object)IndexingManager.this.sortfield_manager.getControls());
                this.index_sort_facet_panel.add(this.sortfield_panel);
            }
            if (this.hasSorts(IndexingManager.this.build_type) && !this.hasSorts(string)) {
                this.index_sort_facet_panel.remove(this.sortfield_panel);
            }
            if (this.hasFacets(string) && !this.hasFacets(IndexingManager.this.build_type)) {
                this.facet_panel = (JPanel)((Object)IndexingManager.this.facet_manager.getControls());
                this.index_sort_facet_panel.add(this.facet_panel);
            }
            if (this.hasFacets(IndexingManager.this.build_type) && !this.hasFacets(string)) {
                this.index_sort_facet_panel.remove(this.facet_panel);
            }
            IndexingManager.this.build_type = string;
        }

        private boolean hasSorts(String string) {
            return string.equals("lucene") || string.equals("solr");
        }

        private boolean hasFacets(String string) {
            return string.equals("solr");
        }
    }
}

