/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.cdm;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoManager;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.DebugStream;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.cdm.Classifier;
import org.greenstone.gatherer.cdm.CollectionConfiguration;
import org.greenstone.gatherer.cdm.CollectionDesignManager;
import org.greenstone.gatherer.cdm.Control;
import org.greenstone.gatherer.cdm.DOMProxyListModel;
import org.greenstone.gatherer.cdm.Format;
import org.greenstone.gatherer.cdm.SharedByTwoFormatManager;
import org.greenstone.gatherer.gui.DesignPaneHeader;
import org.greenstone.gatherer.gui.GLIButton;
import org.greenstone.gatherer.metadata.MetadataElement;
import org.greenstone.gatherer.metadata.MetadataSetManager;
import org.greenstone.gatherer.util.Utility;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FormatManager
extends DOMProxyListModel
implements SharedByTwoFormatManager {
    private static final String BLANK = "blank";
    private static final String FLAG = "flag";
    private static final String VALUE = "value";
    private static final String DATELIST = "DateList";
    private static final String DATELIST_DEFAULT_FORMAT = "<td>[link][icon][/link]</td>\n<td>[highlight]{Or}{[dc.Title],[exp.Title],[ex.Title],Untitled}[/highlight]</td>\n<td>{Or}{[format:dc.Date],[format:exp.Date],[format:ex.Date]}</td>";
    private static final String HLIST = "HList";
    private static final String HLIST_DEFAULT_FORMAT = "[link][highlight][ex.Title][/highlight][/link]";
    private static final String VLIST = "VList";
    private static final String VLIST_DEFAULT_FORMAT = "<td valign=\"top\">[link][icon][/link]</td>\n<td valign=\"top\">[ex.srclink]{Or}{[ex.thumbicon],[ex.srcicon]}[ex./srclink]</td>\n<td valign=\"top\">[highlight]\n{Or}{[dc.Title],[exp.Title],[ex.Title],Untitled}\n[/highlight]{If}{[ex.Source],<br><i>([ex.Source])</i>}</td>";
    private static final String DOCUMENTHEADING = "DocumentHeading";
    private static final String DOCUMENTHEADING_DEFAULT_FORMAT = "{Or}{[parent(Top):Title],[Title],untitled}<br>";
    private static final String DOCUMENTTEXT = "DocumentText";
    private static final String DOCUMENTTEXT_DEFAULT_FORMAT = "[Text]";
    private static final String DOCUMENTBUTTONS = "DocumentButtons";
    private static final String DOCUMENTBUTTONS_DEFAULT_FORMAT = "Detach|Highlight";
    private static final String SEARCHTYPES = "SearchTypes";
    private static final String SEARCHTYPES_DEFAULT_FORMAT = "plain,form";
    private static final String NAVBAR = "NavigationBar";
    private static final String NAVBAR_OPTION = "pulldown";
    private static HashMap default_format_map = null;
    private Control controls = null;
    private DOMProxyListModel model = this;

    public FormatManager() {
        super(CollectionDesignManager.collect_config.getDocumentElement(), "Format", new Format());
        default_format_map = new HashMap();
        default_format_map.put(DATELIST, DATELIST_DEFAULT_FORMAT);
        default_format_map.put(HLIST, HLIST_DEFAULT_FORMAT);
        default_format_map.put(VLIST, VLIST_DEFAULT_FORMAT);
        default_format_map.put(DOCUMENTHEADING, DOCUMENTHEADING_DEFAULT_FORMAT);
        default_format_map.put(DOCUMENTTEXT, DOCUMENTTEXT_DEFAULT_FORMAT);
        default_format_map.put(DOCUMENTBUTTONS, DOCUMENTBUTTONS_DEFAULT_FORMAT);
        default_format_map.put(SEARCHTYPES, SEARCHTYPES_DEFAULT_FORMAT);
        default_format_map.put(NAVBAR, NAVBAR_OPTION);
        default_format_map.put("", "");
        DebugStream.println("FormatManager: parsed " + this.getSize() + " format statements.");
        int n = this.getSize();
        for (int i = 0; i < n; ++i) {
            this.getElementAt(i);
        }
        if (this.getFormat(VLIST) == null) {
            this.addFormat(new Format((Object)"", VLIST, VLIST_DEFAULT_FORMAT));
        }
        if (this.getFormat(HLIST) == null) {
            this.addFormat(new Format((Object)"", HLIST, HLIST_DEFAULT_FORMAT));
        }
        if (this.getFormat(DATELIST) == null && CollectionDesignManager.classifier_manager.isDateListClassifierAssigned()) {
            this.addFormat(new Format((Object)"", DATELIST, DATELIST_DEFAULT_FORMAT));
        }
        if (this.getFormat(DOCUMENTHEADING) == null) {
            this.addFormat(new Format((Object)DOCUMENTHEADING, "", DOCUMENTHEADING_DEFAULT_FORMAT));
        }
        if (this.getFormat(DOCUMENTTEXT) == null) {
            this.addFormat(new Format((Object)DOCUMENTTEXT, "", DOCUMENTTEXT_DEFAULT_FORMAT));
        }
        if (this.getFormat(DOCUMENTBUTTONS) == null) {
            this.addFormat(new Format((Object)DOCUMENTBUTTONS, "", DOCUMENTBUTTONS_DEFAULT_FORMAT));
        }
        if (this.getFormat(SEARCHTYPES) == null && CollectionDesignManager.index_manager.isMGPP() || CollectionDesignManager.index_manager.isLucene()) {
            this.addFormat(new Format((Object)SEARCHTYPES, "", SEARCHTYPES_DEFAULT_FORMAT));
        }
    }

    private void addFormat(Format format) {
        if (!this.contains(format)) {
            Element element = format.getElement();
            Node node = CollectionConfiguration.findInsertionPoint(element);
            this.add(this.root, format, node);
        }
    }

    @Override
    public void destroy() {
        if (this.controls != null) {
            this.controls.destroy();
            this.controls = null;
        }
    }

    private Format getFormat(String string) {
        int n = this.getSize();
        for (int i = 0; i < n; ++i) {
            Format format = (Format)this.getElementAt(i);
            if (!format.getName().equals(string)) continue;
            return format;
        }
        return null;
    }

    public String getDefaultFormatString(String string) {
        String string2 = "";
        try {
            String string3 = string.toUpperCase() + "_DEFAULT_FORMAT";
            Field field = this.getClass().getDeclaredField(string3);
            Class<?> clazz = field.getType();
            string2 = (String)field.get(clazz);
        }
        catch (SecurityException securityException) {
            string2 = VLIST_DEFAULT_FORMAT;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            string2 = VLIST_DEFAULT_FORMAT;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            string2 = VLIST_DEFAULT_FORMAT;
        }
        catch (IllegalAccessException illegalAccessException) {
            string2 = VLIST_DEFAULT_FORMAT;
        }
        return string2;
    }

    @Override
    public Control getControls() {
        if (this.controls == null) {
            this.controls = new FormatControl();
        }
        return this.controls;
    }

    public void modeChanged(int n) {
    }

    @Override
    public synchronized void refresh() {
        for (int i = 0; i < this.getSize(); ++i) {
            Format format = (Format)this.getElementAt(i);
            format.update();
            format = null;
        }
        super.refresh();
    }

    private void removeFormat(Format format) {
        this.remove(format);
    }

    private ArrayList buildFeatureModel() {
        int n;
        ArrayList<Entry> arrayList = new ArrayList<Entry>();
        for (n = 0; n < Format.DEFAULT_FEATURES.length; ++n) {
            arrayList.add(new Entry(Format.DEFAULT_FEATURES[n]));
        }
        for (n = 0; n < CollectionDesignManager.classifier_manager.getSize(); ++n) {
            arrayList.add(new Entry(CollectionDesignManager.classifier_manager.getClassifier(n)));
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    private ArrayList buildPartModel() {
        DebugStream.println("buildPartModel(): replace me with something that reads in a data xml file.");
        ArrayList<Part> arrayList = new ArrayList<Part>();
        arrayList.add(new Part("", ""));
        arrayList.add(new Part(DATELIST, DATELIST_DEFAULT_FORMAT));
        arrayList.add(new Part(HLIST, HLIST_DEFAULT_FORMAT));
        arrayList.add(new Part(VLIST, VLIST_DEFAULT_FORMAT));
        return arrayList;
    }

    private ArrayList buildVariableModel() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(Dictionary.get("CDM.FormatManager.Insert_Variable"));
        arrayList.add(DOCUMENTTEXT_DEFAULT_FORMAT);
        ArrayList arrayList2 = MetadataSetManager.getEveryMetadataSetElement();
        for (int i = 0; i < arrayList2.size(); ++i) {
            arrayList.add("[" + ((MetadataElement)arrayList2.get(i)).getFullName() + "]");
        }
        arrayList.add("[link]");
        arrayList.add("[/link]");
        arrayList.add("[icon]");
        arrayList.add("[numleafdocs]");
        arrayList.add("[num]");
        arrayList.add("[parent():_]");
        arrayList.add("[parent(Top):_]");
        arrayList.add("[parent(All'_'):_]");
        arrayList.add("[child():_]");
        arrayList.add("[child(All'_'):_]");
        arrayList.add("[sibling():_]");
        arrayList.add("[sibling(All'_'):_]");
        return arrayList;
    }

    private class Part
    implements Comparable {
        private String default_format = null;
        private String name = null;

        public Part(String string, String string2) {
            this.default_format = string2;
            this.name = string;
        }

        public int compareTo(Object object) {
            if (object instanceof Part) {
                return this.name.compareTo(((Part)object).getName());
            }
            return this.name.compareTo(object.toString());
        }

        public boolean equals(Object object) {
            if (object instanceof Part) {
                return this.name.equals(((Part)object).getName());
            }
            return this.name.equals(object.toString());
        }

        public String getDefaultFormat() {
            Format format = FormatManager.this.getFormat(this.name);
            if (format != null) {
                return format.getValue();
            }
            return this.default_format;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            if (this.name.equals("")) {
                return "<html><body><i>" + Dictionary.get("CDM.FormatManager.AllParts") + "</i></body></html>";
            }
            return this.name;
        }
    }

    private class Entry
    implements Comparable {
        private Classifier classifier = null;
        private String text = null;

        public Entry(Object object) {
            if (object instanceof Classifier) {
                this.classifier = (Classifier)object;
            } else {
                this.text = object instanceof String ? (String)object : "";
            }
        }

        public Entry(String string) {
            this.text = string;
        }

        public boolean canHavePart() {
            if (this.classifier != null) {
                return true;
            }
            return Format.canHavePart(this.text);
        }

        public int compareTo(Object object) {
            if (object == null) {
                return 1;
            }
            if (this.toString() == null) {
                return -1;
            }
            String string = object.toString();
            if (string == null) {
                return 1;
            }
            return this.toString().compareTo(string);
        }

        public boolean equals(Object object) {
            return this.compareTo(object) == 0;
        }

        public Classifier getClassifier() {
            return this.classifier;
        }

        public Object getFeature() {
            if (this.classifier != null) {
                return this.classifier;
            }
            if (this.text.startsWith("<html>")) {
                return "";
            }
            return this.text;
        }

        public ArrayList getPartModel() {
            String string;
            DebugStream.println("getPartModel(): get appopriate affected components of this classifier");
            String string2 = string = this.classifier == null ? "" : this.classifier.toString();
            if (!string.equals("")) {
                string = string.substring(0, string.indexOf("-")).trim();
            }
            ArrayList arrayList = new ArrayList();
            if (string.equals(FormatManager.DATELIST)) {
                arrayList.add(new Part(FormatManager.DATELIST, FormatManager.DATELIST_DEFAULT_FORMAT));
            } else if (string.equals("")) {
                arrayList = FormatManager.this.buildPartModel();
            } else {
                arrayList.add(new Part(FormatManager.HLIST, FormatManager.HLIST_DEFAULT_FORMAT));
                arrayList.add(new Part(FormatManager.VLIST, FormatManager.VLIST_DEFAULT_FORMAT));
            }
            return arrayList;
        }

        public String toString() {
            if (this.classifier != null) {
                return this.classifier.getPositionString() + ":" + " " + this.classifier.toString();
            }
            if (this.text.equals("")) {
                return "<html><body><i>" + Dictionary.get("CDM.FormatManager.AllFeatures") + "</i></body></html>";
            }
            return this.text;
        }
    }

    public class FormatControl
    extends JPanel
    implements Control {
        private ArrayList feature_model;
        private ArrayList part_model;
        private ArrayList variable_model;
        private boolean ignore_event = false;
        private boolean ready = false;
        private CardLayout card_layout;
        private JButton add_button;
        private JButton insert_button;
        private JButton remove_button;
        private JButton default_button;
        private JButton undo_button;
        private JButton redo_button;
        private JCheckBox enabled_checkbox;
        private JComboBox feature_combobox;
        private JComboBox part_combobox;
        private JComboBox variable_combobox;
        private JList format_list;
        private RSyntaxTextArea editor_textarea;
        private JPanel blank_pane;
        private JPanel control_pane;
        private JPanel part_pane;
        private JPanel selection_pane;
        private String view_type;
        private final Dimension FIELD_SIZE = new Dimension(200, 30);
        private final UndoManager undo = new UndoManager();
        private boolean newtext = true;
        private Format previousFormat = null;
        private Format currentFormat = null;
        private boolean fresh = true;

        public FormatControl() {
            this.setComponentOrientation(Dictionary.getOrientation());
            this.feature_model = FormatManager.this.buildFeatureModel();
            this.part_model = FormatManager.this.buildPartModel();
            this.variable_model = FormatManager.this.buildVariableModel();
            DesignPaneHeader designPaneHeader = new DesignPaneHeader("CDM.GUI.Formats", "formatstatements");
            this.format_list = new JList(FormatManager.this.model);
            this.selection_pane = new JPanel();
            JPanel jPanel = new JPanel();
            jPanel.setComponentOrientation(Dictionary.getOrientation());
            JLabel jLabel = new JLabel(Dictionary.get("CDM.FormatManager.Feature"));
            jLabel.setComponentOrientation(Dictionary.getOrientation());
            this.feature_combobox = new JComboBox<Object>(this.feature_model.toArray());
            this.feature_combobox.setComponentOrientation(Dictionary.getOrientation());
            this.feature_combobox.setOpaque(!Utility.isMac());
            this.feature_combobox.setPreferredSize(this.FIELD_SIZE);
            this.feature_combobox.setEditable(false);
            this.feature_combobox.setToolTipText(Dictionary.get("CDM.FormatManager.Feature_Tooltip"));
            this.part_pane = new JPanel();
            this.part_pane.setComponentOrientation(Dictionary.getOrientation());
            JLabel jLabel2 = new JLabel(Dictionary.get("CDM.FormatManager.Part"));
            jLabel2.setComponentOrientation(Dictionary.getOrientation());
            this.part_combobox = new JComboBox<Object>(this.part_model.toArray());
            this.part_combobox.setComponentOrientation(Dictionary.getOrientation());
            this.part_combobox.setOpaque(!Utility.isMac());
            this.part_combobox.setPreferredSize(this.FIELD_SIZE);
            this.part_combobox.setEditable(false);
            this.part_combobox.setToolTipText(Dictionary.get("CDM.FormatManager.Part_Tooltip"));
            this.blank_pane = new JPanel();
            JPanel jPanel2 = new JPanel();
            this.card_layout = new CardLayout();
            this.control_pane = new JPanel();
            JPanel jPanel3 = new JPanel();
            JPanel jPanel4 = new JPanel();
            JPanel jPanel5 = new JPanel();
            JLabel jLabel3 = new JLabel(Dictionary.get("CDM.FormatManager.Editor"));
            jLabel3.setComponentOrientation(Dictionary.getOrientation());
            this.editor_textarea = new RSyntaxTextArea();
            this.editor_textarea.setSyntaxEditingStyle("text/html");
            this.editor_textarea.setBracketMatchingEnabled(true);
            this.editor_textarea.setAnimateBracketMatching(true);
            this.editor_textarea.setAntiAliasingEnabled(true);
            this.editor_textarea.setAutoIndentEnabled(true);
            this.editor_textarea.setPaintMarkOccurrencesBorder(false);
            this.editor_textarea.setBackground(Configuration.getColor("coloring.editable_background", false));
            this.editor_textarea.setCaretPosition(0);
            this.editor_textarea.setLineWrap(true);
            this.editor_textarea.setRows(6);
            this.editor_textarea.setWrapStyleWord(false);
            this.editor_textarea.setToolTipText(Dictionary.get("CDM.FormatManager.Add_Tooltip"));
            this.variable_combobox = new JComboBox<Object>(this.variable_model.toArray());
            this.variable_combobox.setComponentOrientation(Dictionary.getOrientation());
            this.variable_combobox.setOpaque(!Utility.isMac());
            this.variable_combobox.setToolTipText(Dictionary.get("CDM.FormatManager.Variable_Tooltip"));
            this.insert_button = new GLIButton(Dictionary.get("CDM.FormatManager.Insert"), Dictionary.get("CDM.FormatManager.Insert_Tooltip"));
            this.default_button = new GLIButton(Dictionary.get("CDM.FormatManager.Default"), Dictionary.get("CDM.FormatManager.Default_Tooltip"));
            JPanel jPanel6 = new JPanel();
            this.enabled_checkbox = new JCheckBox(Dictionary.get("CDM.FormatManager.Enabled"));
            this.enabled_checkbox.setComponentOrientation(Dictionary.getOrientation());
            JPanel jPanel7 = new JPanel();
            jPanel7.setComponentOrientation(Dictionary.getOrientation());
            this.add_button = new GLIButton(Dictionary.get("CDM.FormatManager.Add"), Dictionary.get("CDM.FormatManager.Add_Tooltip"));
            this.add_button.setEnabled(false);
            this.remove_button = new GLIButton(Dictionary.get("CDM.FormatManager.Remove"), Dictionary.get("CDM.FormatManager.Remove_Tooltip"));
            this.remove_button.setEnabled(false);
            this.undo_button = new GLIButton(Dictionary.get("General.Undo"), Dictionary.get("General.Undo_Tooltip"));
            this.undo_button.setEnabled(false);
            this.redo_button = new GLIButton(Dictionary.get("General.Redo"), Dictionary.get("General.Redo_Tooltip"));
            this.redo_button.setEnabled(false);
            this.add_button.addActionListener(new AddListener());
            this.remove_button.addActionListener(new RemoveListener());
            this.default_button.addActionListener(new DefaultListener());
            this.undo_button.addActionListener(new UndoListener());
            this.redo_button.addActionListener(new RedoListener());
            this.enabled_checkbox.addActionListener(new EnabledListener());
            this.feature_combobox.addActionListener(new FeatureListener());
            this.part_combobox.addActionListener(new PartListener());
            this.editor_textarea.getDocument().addDocumentListener(new EditorListener());
            this.editor_textarea.getDocument().addUndoableEditListener(new UndoableEditListener(){

                @Override
                public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
                    FormatControl.this.undo.addEdit(undoableEditEvent.getEdit());
                }
            });
            this.format_list.addListSelectionListener(new FormatListListener());
            this.variable_combobox.addActionListener(new VariableListener());
            JPanel jPanel8 = new JPanel();
            jPanel8.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
            jPanel8.setLayout(new BorderLayout());
            jPanel8.add((Component)new JScrollPane(this.format_list), "Center");
            jPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
            jPanel.setLayout(new BorderLayout(5, 0));
            jPanel.add((Component)jLabel, "Before");
            jPanel.add((Component)this.feature_combobox, "Center");
            this.part_pane.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
            this.part_pane.setLayout(new BorderLayout(5, 0));
            this.part_pane.add((Component)jLabel2, "Before");
            this.part_pane.add((Component)this.part_combobox, "Center");
            jPanel6.add(this.enabled_checkbox);
            jPanel5.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
            jPanel5.setLayout(new GridLayout(1, 3));
            jPanel5.add(jLabel3);
            JPanel jPanel9 = new JPanel();
            jPanel9.setComponentOrientation(Dictionary.getOrientation());
            jPanel9.setLayout(new GridLayout(1, 2));
            jPanel9.add(this.undo_button);
            jPanel9.add(this.redo_button);
            JPanel jPanel10 = new JPanel();
            jPanel10.setComponentOrientation(Dictionary.getOrientation());
            jPanel10.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
            jPanel10.setLayout(new GridLayout(1, 3));
            jPanel10.add(new JPanel());
            jPanel10.add(this.variable_combobox);
            jPanel10.add(jPanel9);
            jPanel4.setLayout(new BorderLayout());
            jPanel4.add((Component)jPanel5, "North");
            jPanel4.add((Component)new JScrollPane(this.editor_textarea), "Center");
            this.selection_pane.setLayout(new BorderLayout());
            this.selection_pane.add((Component)this.part_pane, "North");
            this.selection_pane.add((Component)jPanel4, "Center");
            this.selection_pane.add((Component)jPanel10, "South");
            this.control_pane.setLayout(this.card_layout);
            this.control_pane.add((Component)jPanel6, FormatManager.FLAG);
            this.control_pane.add((Component)this.selection_pane, FormatManager.VALUE);
            this.control_pane.add((Component)jPanel3, FormatManager.BLANK);
            jPanel7.setLayout(new GridLayout(1, 3));
            jPanel7.add(this.add_button);
            jPanel7.add(this.remove_button);
            jPanel7.add(this.default_button);
            jPanel2.setLayout(new BorderLayout());
            jPanel2.add((Component)jPanel, "North");
            jPanel2.add((Component)this.control_pane, "Center");
            jPanel2.add((Component)jPanel7, "South");
            this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            this.setLayout(new BorderLayout());
            this.add((Component)designPaneHeader, "North");
            this.add((Component)jPanel8, "Center");
            this.add((Component)jPanel2, "South");
            this.ready = true;
        }

        @Override
        public void destroy() {
        }

        @Override
        public void gainFocus() {
            if (this.ready) {
                FormatManager.this.model.refresh();
                Object object = this.feature_combobox.getSelectedItem();
                this.feature_model = FormatManager.this.buildFeatureModel();
                this.feature_combobox.setModel(new DefaultComboBoxModel<Object>(this.feature_model.toArray()));
                this.feature_combobox.setSelectedItem(object);
                this.variable_model = FormatManager.this.buildVariableModel();
                this.variable_combobox.setModel(new DefaultComboBoxModel<Object>(this.variable_model.toArray()));
            }
        }

        @Override
        public void loseFocus() {
            FormatManager.this.model.refresh();
        }

        public Format getCurrentFormat() {
            return (Format)this.format_list.getSelectedValue();
        }

        private void newFormat() {
            this.editor_textarea.setEditable(false);
            this.editor_textarea.setBackground(Color.lightGray);
            this.editor_textarea.setToolTipText(Dictionary.get("CDM.FormatManager.Editor_Disabled_Tooltip"));
            this.enabled_checkbox.setEnabled(false);
            this.undo_button.setEnabled(false);
            this.redo_button.setEnabled(false);
            this.variable_combobox.setEnabled(false);
            this.add_button.setEnabled(true);
            this.remove_button.setEnabled(false);
            this.default_button.setEnabled(false);
        }

        private void existingFormat() {
            this.editor_textarea.setEditable(true);
            this.editor_textarea.setBackground(Color.white);
            this.editor_textarea.setToolTipText(Dictionary.get("CDM.FormatManager.Editor_Tooltip"));
            this.enabled_checkbox.setEnabled(true);
            this.variable_combobox.setEnabled(true);
            this.add_button.setEnabled(false);
            this.remove_button.setEnabled(true);
            this.default_button.setEnabled(true);
        }

        private class RedoListener
        implements ActionListener {
            private RedoListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (FormatControl.this.undo.canRedo()) {
                        int n = FormatControl.this.editor_textarea.getCaretPosition();
                        FormatControl.this.undo.redo();
                        FormatControl.this.editor_textarea.setCaretPosition(n);
                    }
                    if (!FormatControl.this.undo.canRedo()) {
                        FormatControl.this.redo_button.setEnabled(false);
                    } else {
                        FormatControl.this.redo_button.setEnabled(true);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        private class UndoListener
        implements ActionListener {
            private UndoListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (FormatControl.this.undo.canUndo()) {
                        int n = FormatControl.this.editor_textarea.getCaretPosition();
                        FormatControl.this.redo_button.setEnabled(true);
                        FormatControl.this.undo.undo();
                        if (n > 0) {
                            FormatControl.this.editor_textarea.setCaretPosition(n - 1);
                        } else {
                            FormatControl.this.editor_textarea.setCaretPosition(n);
                        }
                    }
                    if (!FormatControl.this.undo.canUndo()) {
                        FormatControl.this.undo_button.setEnabled(false);
                    } else {
                        FormatControl.this.undo_button.setEnabled(true);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        private class DefaultListener
        implements ActionListener {
            private DefaultListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = JOptionPane.showConfirmDialog(Gatherer.g_man, Dictionary.get("CDM.FormatManager.Default_Warning"), Dictionary.get("General.Warning"), 2, 2);
                if (n == 2) {
                    return;
                }
                FormatControl.this.newtext = false;
                if (!FormatControl.this.ignore_event) {
                    Entry entry = (Entry)FormatControl.this.feature_combobox.getSelectedItem();
                    Object object = entry.getFeature();
                    String string = "";
                    String string2 = "";
                    Part part = null;
                    if (entry.canHavePart()) {
                        part = (Part)FormatControl.this.part_combobox.getSelectedItem();
                        string2 = part.getName();
                        string = Format.generateName(object, string2);
                    } else {
                        string = entry.toString();
                    }
                    Format format = FormatManager.this.getFormat(string);
                    if (format != null) {
                        FormatControl.this.remove_button.setEnabled(true);
                    } else {
                        FormatControl.this.add_button.setEnabled(true);
                    }
                    if (Format.isParamType(string)) {
                        FormatControl.this.card_layout.show(FormatControl.this.control_pane, FormatManager.FLAG);
                        FormatControl.this.view_type = FormatManager.FLAG;
                        FormatControl.this.enabled_checkbox.setSelected(false);
                    } else {
                        FormatControl.this.card_layout.show(FormatControl.this.control_pane, FormatManager.VALUE);
                        FormatControl.this.view_type = FormatManager.VALUE;
                        if (string2 != null && string2.length() != 0) {
                            FormatControl.this.editor_textarea.setText((String)default_format_map.get(string2));
                            FormatControl.this.editor_textarea.setCaretPosition(0);
                        } else {
                            FormatControl.this.editor_textarea.setText((String)default_format_map.get(string));
                            FormatControl.this.editor_textarea.setCaretPosition(0);
                        }
                    }
                }
            }
        }

        private class RemoveListener
        implements ActionListener {
            private RemoveListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!FormatControl.this.format_list.isSelectionEmpty()) {
                    FormatManager.this.removeFormat((Format)FormatControl.this.format_list.getSelectedValue());
                    FormatControl.this.add_button.setEnabled(true);
                    FormatControl.this.newFormat();
                }
            }
        }

        private class PartListener
        implements ActionListener {
            private PartListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FormatControl.this.undo_button.setEnabled(false);
                FormatControl.this.redo_button.setEnabled(false);
                FormatControl.this.default_button.setEnabled(true);
                FormatControl.this.newtext = true;
                if (!FormatControl.this.ignore_event) {
                    Entry entry = (Entry)FormatControl.this.feature_combobox.getSelectedItem();
                    Object object = entry.getFeature();
                    Part part = (Part)FormatControl.this.part_combobox.getSelectedItem();
                    String string = part.getName();
                    if (object.toString().length() == 0 && string.length() == 0) {
                        FormatControl.this.add_button.setEnabled(false);
                        FormatControl.this.remove_button.setEnabled(false);
                    } else {
                        String string2 = Format.generateName(object, string);
                        Format format = FormatManager.this.getFormat(string2);
                        if (format != null) {
                            FormatControl.this.format_list.setSelectedValue(format, true);
                            if (format.isParamType()) {
                                FormatControl.this.card_layout.show(FormatControl.this.control_pane, FormatManager.FLAG);
                                FormatControl.this.view_type = FormatManager.FLAG;
                                FormatControl.this.enabled_checkbox.setSelected(format.getState());
                            } else {
                                FormatControl.this.card_layout.show(FormatControl.this.control_pane, FormatManager.VALUE);
                                FormatControl.this.view_type = FormatManager.VALUE;
                                FormatControl.this.editor_textarea.setText(format.getValue());
                                FormatControl.this.editor_textarea.setCaretPosition(0);
                            }
                            FormatControl.this.control_pane.updateUI();
                            FormatControl.this.existingFormat();
                        } else {
                            FormatControl.this.format_list.clearSelection();
                            if (Format.isParamType(string2)) {
                                FormatControl.this.card_layout.show(FormatControl.this.control_pane, FormatManager.FLAG);
                                FormatControl.this.view_type = FormatManager.FLAG;
                                FormatControl.this.enabled_checkbox.setSelected(false);
                                FormatControl.this.enabled_checkbox.setEnabled(false);
                            } else {
                                FormatControl.this.card_layout.show(FormatControl.this.control_pane, FormatManager.VALUE);
                                FormatControl.this.view_type = FormatManager.VALUE;
                                FormatControl.this.editor_textarea.setText(part.getDefaultFormat());
                                FormatControl.this.editor_textarea.setCaretPosition(0);
                            }
                            FormatControl.this.newFormat();
                        }
                        format = null;
                        string2 = null;
                    }
                    string = null;
                    part = null;
                    object = null;
                    entry = null;
                }
                FormatControl.this.undo.discardAllEdits();
            }
        }

        private class VariableListener
        implements ActionListener {
            private VariableListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = FormatControl.this.variable_combobox.getSelectedIndex();
                if (n == 0) {
                    return;
                }
                String string = (String)FormatControl.this.variable_combobox.getSelectedItem();
                FormatControl.this.editor_textarea.insert(string, FormatControl.this.editor_textarea.getCaretPosition());
                FormatControl.this.undo_button.setEnabled(true);
                FormatControl.this.variable_combobox.setSelectedIndex(0);
            }
        }

        private class FormatListListener
        implements ListSelectionListener {
            private FormatListListener() {
            }

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                FormatControl.this.undo_button.setEnabled(false);
                FormatControl.this.redo_button.setEnabled(false);
                FormatControl.this.default_button.setEnabled(true);
                FormatControl.this.newtext = true;
                if (!(FormatControl.this.ignore_event || listSelectionEvent.getValueIsAdjusting() || FormatControl.this.format_list.isSelectionEmpty())) {
                    FormatControl.this.existingFormat();
                    FormatControl.this.ignore_event = true;
                    Format format = (Format)FormatControl.this.format_list.getSelectedValue();
                    Entry entry = new Entry(format.getFeature());
                    FormatControl.this.feature_combobox.setSelectedItem(entry);
                    Entry entry2 = (Entry)FormatControl.this.feature_combobox.getSelectedItem();
                    if (!entry.equals(entry2)) {
                        FormatControl.this.feature_combobox.insertItemAt(entry, FormatControl.this.feature_combobox.getItemCount());
                        FormatControl.this.feature_combobox.setSelectedItem(entry);
                    }
                    if (format.isParamType()) {
                        FormatControl.this.card_layout.show(FormatControl.this.control_pane, FormatManager.FLAG);
                        FormatControl.this.view_type = FormatManager.FLAG;
                        FormatControl.this.enabled_checkbox.setSelected(format.getState());
                    } else {
                        FormatControl.this.card_layout.show(FormatControl.this.control_pane, FormatManager.VALUE);
                        FormatControl.this.view_type = FormatManager.VALUE;
                        if (format.canHavePart()) {
                            FormatControl.this.part_combobox.setEnabled(true);
                            FormatControl.this.part_model = entry2.getPartModel();
                            FormatControl.this.part_combobox.setModel(new DefaultComboBoxModel<Object>(FormatControl.this.part_model.toArray()));
                            FormatControl.this.part_combobox.updateUI();
                            String string = format.getPart();
                            boolean bl = false;
                            for (int i = 0; i < FormatControl.this.part_combobox.getItemCount(); ++i) {
                                Part part = (Part)FormatControl.this.part_combobox.getItemAt(i);
                                if (part.equals(string)) {
                                    FormatControl.this.part_combobox.setSelectedItem(part);
                                    bl = true;
                                }
                                part = null;
                            }
                            if (!bl) {
                                Part part = new Part(string, "");
                                FormatControl.this.part_combobox.insertItemAt(part, FormatControl.this.part_combobox.getItemCount());
                                FormatControl.this.part_combobox.setSelectedItem(part);
                            }
                        } else {
                            FormatControl.this.part_combobox.setEnabled(false);
                            FormatControl.this.part_combobox.setSelectedIndex(0);
                        }
                        FormatControl.this.editor_textarea.setText(format.getValue());
                        FormatControl.this.editor_textarea.setCaretPosition(0);
                    }
                    FormatControl.this.ignore_event = false;
                }
                FormatControl.this.undo.discardAllEdits();
            }
        }

        private class FeatureListener
        implements ActionListener {
            private FeatureListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FormatControl.this.undo_button.setEnabled(false);
                FormatControl.this.redo_button.setEnabled(false);
                FormatControl.this.default_button.setEnabled(true);
                FormatControl.this.newtext = true;
                if (!FormatControl.this.ignore_event) {
                    FormatControl.this.ignore_event = true;
                    Entry entry = (Entry)FormatControl.this.feature_combobox.getSelectedItem();
                    if (entry.canHavePart()) {
                        FormatControl.this.part_model = entry.getPartModel();
                        FormatControl.this.part_combobox.setModel(new DefaultComboBoxModel<Object>(FormatControl.this.part_model.toArray()));
                        FormatControl.this.part_combobox.updateUI();
                        FormatControl.this.part_combobox.setEnabled(true);
                        FormatControl.this.part_combobox.setSelectedIndex(FormatControl.this.part_combobox.getModel().getSize() - 1);
                    } else {
                        FormatControl.this.part_combobox.setEnabled(false);
                        FormatControl.this.part_combobox.setSelectedIndex(0);
                    }
                    String string = entry.toString();
                    Object object = entry.getFeature();
                    Part part = (Part)FormatControl.this.part_combobox.getSelectedItem();
                    String string2 = part.getName();
                    if (object.toString().length() == 0 && string2.length() == 0) {
                        FormatControl.this.add_button.setEnabled(false);
                        FormatControl.this.remove_button.setEnabled(false);
                    } else {
                        Format format = FormatManager.this.getFormat(Format.generateName(object, string2));
                        if (format != null) {
                            FormatControl.this.format_list.setSelectedValue(format, true);
                            if (format.isParamType()) {
                                FormatControl.this.card_layout.show(FormatControl.this.control_pane, FormatManager.FLAG);
                                FormatControl.this.view_type = FormatManager.FLAG;
                                FormatControl.this.enabled_checkbox.setSelected(format.getState());
                            } else {
                                FormatControl.this.card_layout.show(FormatControl.this.control_pane, FormatManager.VALUE);
                                FormatControl.this.view_type = FormatManager.VALUE;
                                FormatControl.this.editor_textarea.setText(format.getValue());
                                FormatControl.this.editor_textarea.setCaretPosition(0);
                            }
                            FormatControl.this.existingFormat();
                            FormatControl.this.control_pane.updateUI();
                        } else {
                            FormatControl.this.format_list.clearSelection();
                            if (Format.isParamType(string)) {
                                FormatControl.this.card_layout.show(FormatControl.this.control_pane, FormatManager.FLAG);
                                FormatControl.this.view_type = FormatManager.FLAG;
                                FormatControl.this.enabled_checkbox.setSelected(false);
                                FormatControl.this.enabled_checkbox.setEnabled(false);
                            } else {
                                FormatControl.this.card_layout.show(FormatControl.this.control_pane, FormatManager.VALUE);
                                FormatControl.this.view_type = FormatManager.VALUE;
                                String string3 = (String)default_format_map.get(object.toString());
                                if (string3 != null) {
                                    FormatControl.this.editor_textarea.setText(string3);
                                } else {
                                    FormatControl.this.editor_textarea.setText(part.getDefaultFormat());
                                }
                                FormatControl.this.editor_textarea.setCaretPosition(0);
                            }
                            FormatControl.this.newFormat();
                        }
                        format = null;
                        string = null;
                    }
                    part = null;
                    string2 = null;
                    object = null;
                    string = null;
                    entry = null;
                    FormatControl.this.ignore_event = false;
                }
                FormatControl.this.undo.discardAllEdits();
            }
        }

        private class EnabledListener
        implements ActionListener {
            private EnabledListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Format format;
                boolean bl;
                if (!FormatControl.this.format_list.isSelectionEmpty() && (bl = (format = (Format)FormatControl.this.format_list.getSelectedValue()).isParamType())) {
                    format.setState(FormatControl.this.enabled_checkbox.isSelected());
                    FormatManager.this.model.refresh(format);
                }
            }
        }

        private class EditorListener
        implements DocumentListener {
            private EditorListener() {
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.update();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.update();
                this.updateUndo("insert");
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.update();
                this.updateUndo("remove");
            }

            private void updateUndo(String string) {
                if (!FormatControl.this.newtext) {
                    FormatControl.this.undo_button.setEnabled(true);
                }
                if (FormatControl.this.editor_textarea.getText().length() != 0 && FormatControl.this.newtext) {
                    FormatControl.this.newtext = false;
                }
            }

            public void update() {
                if (!FormatControl.this.format_list.isSelectionEmpty()) {
                    boolean bl;
                    Format format = (Format)FormatControl.this.format_list.getSelectedValue();
                    boolean bl2 = bl = !format.isParamType();
                    if (bl) {
                        format.setValue(FormatControl.this.editor_textarea.getText().trim());
                        FormatManager.this.model.refresh(format);
                    }
                } else {
                    FormatControl.this.add_button.setEnabled(false);
                }
            }
        }

        private class AddListener
        implements ActionListener {
            private AddListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FormatControl.this.ignore_event = true;
                Entry entry = (Entry)FormatControl.this.feature_combobox.getSelectedItem();
                Object object = entry.getFeature();
                String string = "";
                if (entry.canHavePart()) {
                    string = ((Part)FormatControl.this.part_combobox.getSelectedItem()).getName();
                }
                Format format = null;
                format = FormatControl.this.view_type.equals(FormatManager.FLAG) ? new Format(object, string, FormatControl.this.enabled_checkbox.isSelected()) : new Format(object, string, FormatControl.this.editor_textarea.getText());
                FormatManager.this.addFormat(format);
                FormatControl.this.existingFormat();
                FormatControl.this.format_list.setSelectedValue(format, true);
                format = null;
                string = null;
                object = null;
                entry = null;
                FormatControl.this.ignore_event = false;
            }
        }
    }
}

