/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.cdm;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.xml.parsers.DocumentBuilderFactory;
import org.greenstone.gatherer.DebugStream;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.cdm.Classifier;
import org.greenstone.gatherer.cdm.CollectionDesignManager;
import org.greenstone.gatherer.cdm.Control;
import org.greenstone.gatherer.cdm.DOMProxyListModel;
import org.greenstone.gatherer.cdm.Format4gs3;
import org.greenstone.gatherer.cdm.SharedByTwoFormatManager;
import org.greenstone.gatherer.gui.DesignPaneHeader;
import org.greenstone.gatherer.gui.FormatPane;
import org.greenstone.gatherer.gui.GLIButton;
import org.greenstone.gatherer.gui.NumberedJTextArea;
import org.greenstone.gatherer.gui.TestingPreparation;
import org.greenstone.gatherer.util.Utility;
import org.greenstone.gatherer.util.XMLTools;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class Format4gs3Manager
implements SharedByTwoFormatManager {
    private static final String GLOBAL_FORMAT;
    private static final String GLOBAL = "global";
    private static final String SEARCH_FORMAT;
    private static final String SEARCH = "search";
    private static final String DISPLAY_DEFAULT_FORMAT;
    private static final String DISPLAY = "display";
    private static final String CLASSIFIER_DEFAULT_FORMAT;
    private static final String CLASSIFIER_DEFAULT = "browse";
    private static final String SEARCHTYPE_FORMAT = "plain,simpleform,advancedform";
    private static final String SEARCHTYPE = "searchType";
    private static final String[] FEATURE_NAME;
    private static final String[] FEATURE_FORMAT;
    private static HashMap default_format_map;
    private static HashMap default_format_formated_map;
    private Control controls = null;
    private DOMProxyListModel format_list_model = null;

    public Format4gs3Manager() {
        Element element = CollectionDesignManager.collect_config.getDocumentElement();
        this.format_list_model = new DOMProxyListModel(element, "format", new Format4gs3());
        this.initDefault(this.format_list_model, FEATURE_NAME, FEATURE_FORMAT);
        this.initFormatMap(FEATURE_NAME, FEATURE_FORMAT);
    }

    private void initFormatMap(String[] stringArray, String[] stringArray2) {
        default_format_map = new HashMap();
        default_format_formated_map = new HashMap();
        for (int i = 0; i < stringArray.length; ++i) {
            default_format_map.put(stringArray[i], stringArray2[i]);
            default_format_formated_map.put(stringArray[i], Format4gs3.toFormatedFormat(stringArray2[i]));
        }
    }

    public void initDefault(DOMProxyListModel dOMProxyListModel, String[] stringArray, String[] stringArray2) {
        int n;
        for (n = 0; n < dOMProxyListModel.getSize(); ++n) {
            dOMProxyListModel.getElementAt(n);
        }
        for (n = 0; n < stringArray.length; ++n) {
            if (this.getFormat(dOMProxyListModel, stringArray[n]) != null) continue;
            dOMProxyListModel.add(new Format4gs3(stringArray[n], stringArray2[n]));
        }
    }

    private void removeFormat(DOMProxyListModel dOMProxyListModel, Format4gs3 format4gs3) {
        dOMProxyListModel.remove(format4gs3);
    }

    private Format4gs3 getFormat(DOMProxyListModel dOMProxyListModel, String string) {
        for (int i = 0; i < dOMProxyListModel.getSize(); ++i) {
            Format4gs3 format4gs3 = (Format4gs3)dOMProxyListModel.getElementAt(i);
            if (!format4gs3.getFeatureName().equals(string)) continue;
            return format4gs3;
        }
        return null;
    }

    private void addFormat(Element element, Format4gs3 format4gs3) {
        if (!this.format_list_model.contains(format4gs3)) {
            this.format_list_model.add(element, format4gs3, null);
        }
    }

    @Override
    public void destroy() {
        if (this.controls != null) {
            this.controls.destroy();
            this.controls = null;
        }
    }

    @Override
    public Control getControls() {
        if (this.controls == null) {
            this.controls = new FormatControl();
        }
        return this.controls;
    }

    public void modeChanged(int n) {
    }

    @Override
    public synchronized void refresh() {
        for (int i = 0; i < this.format_list_model.getSize(); ++i) {
            Format4gs3 format4gs3 = (Format4gs3)this.format_list_model.getElementAt(i);
            format4gs3.update();
            format4gs3 = null;
        }
        if (this.controls == null) {
            this.controls = new FormatControl();
        }
        this.controls.gainFocus();
    }

    private ArrayList buildFeatureModel() {
        Object object;
        ArrayList<Entry> arrayList = new ArrayList<Entry>();
        arrayList.add(new Entry(""));
        for (int i = 0; i < this.format_list_model.getSize(); ++i) {
            object = (Format4gs3)this.format_list_model.getElementAt(i);
            String string = ((Format4gs3)object).getFeatureName();
            if (string.startsWith("CL")) continue;
            arrayList.add(new Entry(((Format4gs3)object).getFeatureName()));
        }
        Element element = CollectionDesignManager.collect_config.getDocumentElement();
        object = element.getElementsByTagName("Classify");
        for (int i = 0; i < object.getLength(); ++i) {
            arrayList.add(new Entry(CollectionDesignManager.classifier_manager.getClassifier(i)));
        }
        return arrayList;
    }

    private String addSurroundingTags(String string) {
        return "<ROOTELEMENT>" + string + "</ROOTELEMENT>";
    }

    private String removeSurroundingTags(String string) {
        return string.replace("<ROOTELEMENT>\n", "").replace("<ROOTELEMENT>", "").replace("</ROOTELEMENT>", "").replace("<ROOTELEMENT/>", "");
    }

    static {
        String string;
        GLOBAL_FORMAT = string = "<gsf:template name=\"choose-title\"><gsf:choose-metadata><gsf:metadata name=\"dc.Title\"/><gsf:metadata name=\"exp.Title\"/><gsf:metadata name=\"ex.dc.Title\"/><gsf:metadata name=\"Title\"/><gsf:default>Untitled</gsf:default></gsf:choose-metadata></gsf:template>";
        SEARCH_FORMAT = string = "<gsf:template match=\"documentNode\"><td valign=\"top\"><gsf:link type=\"document\"><gsf:icon type=\"document\"/></gsf:link></td><td><gsf:link type=\"document\"><xsl:call-template name=\"choose-title\"/></gsf:link></td></gsf:template>";
        DISPLAY_DEFAULT_FORMAT = string = "<gsf:option name=\"TOC\" value=\"true\"/><gsf:option name=\"AllowUserComments\" value=\"false\"/><!--Overwriting this template allows you to change the heading of the document.--><!--<gsf:template name=\"documentHeading\"><span style=\"font-weight:bold; font-size: 120%;\"><xsl:call-template name=\"choose-title\"/></span></gsf:template>--><!--Overwriting this template can be used to redefine the content of the whole document.This is useful for simple documents, but not recommended for more complex documents(e.g. hierachical and paged documents) as it can prevent any sub-sections from showing.--><!--<gsf:template name=\"documentContent\"><div id=\"gs-document\"><xsl:call-template name=\"documentPre\"/><xsl:call-template name=\"wrappedSectionImage\"/><div id=\"gs-document-text\"><xsl:call-template name=\"documentNodeText\"/></div></div></gsf:template>--><!--Overwriting this template can be used to change the content of section headings.--><!--<gsf:template name=\"sectionHeading\"><xsl:call-template name=\"choose-title\"/></gsf:template>--><!--Overwriting this template can be used to change the content of the top-level section.--><!--<gsf:template name=\"topLevelSectionContent\"><xsl:call-template name=\"wrappedSectionImage\"/><xsl:call-template name=\"wrappedSectionText\"/></gsf:template>--><!--Overwriting this template can be used to change the content of sections.--><!--<gsf:template name=\"sectionContent\"><xsl:call-template name=\"wrappedSectionImage\"/><xsl:call-template name=\"wrappedSectionText\"/></gsf:template>-->";
        CLASSIFIER_DEFAULT_FORMAT = string = "<gsf:template match=\"documentNode\"><td valign=\"top\"><gsf:link type=\"document\"><gsf:icon type=\"document\"/></gsf:link></td><td valign=\"top\"><gsf:link type=\"source\"><gsf:choose-metadata><gsf:metadata name=\"thumbicon\"/><gsf:metadata name=\"srcicon\"/></gsf:choose-metadata></gsf:link></td><td valign=\"top\"><gsf:link type=\"document\"><xsl:call-template name=\"choose-title\"/></gsf:link><gsf:switch><gsf:metadata name=\"Source\"/><gsf:when test=\"exists\"><br/><i>(<gsf:metadata name=\"Source\"/>)</i></gsf:when></gsf:switch></td></gsf:template><gsf:template match=\"classifierNode[@classifierStyle = 'VList']\"><td valign=\"top\"><gsf:link type=\"classifier\" style=\"static\"><gsf:icon type=\"classifier\"/></gsf:link></td><td valign=\"top\"><gsf:link type=\"classifier\"><gsf:metadata name=\"Title\"/></gsf:link></td></gsf:template><gsf:template match=\"classifierNode[@classifierStyle = 'HList']\"><gsf:link type=\"classifier\"><gsf:metadata name=\"Title\"/></gsf:link></gsf:template>";
        FEATURE_NAME = new String[]{SEARCH, GLOBAL, DISPLAY, CLASSIFIER_DEFAULT, SEARCHTYPE};
        FEATURE_FORMAT = new String[]{SEARCH_FORMAT, GLOBAL_FORMAT, DISPLAY_DEFAULT_FORMAT, CLASSIFIER_DEFAULT_FORMAT, SEARCHTYPE_FORMAT};
        default_format_map = null;
        default_format_formated_map = null;
    }

    private class Entry
    implements Comparable {
        private Classifier classifier = null;
        private String feature_name = null;

        public Entry(Object object) {
            if (object instanceof Classifier) {
                this.classifier = (Classifier)object;
                this.feature_name = this.classifier.getPositionString();
            } else {
                this.feature_name = object instanceof String ? (String)object : "";
            }
        }

        public Entry(String string) {
            this.feature_name = string;
        }

        public int compareTo(Object object) {
            if (object == null) {
                return 1;
            }
            if (this.toString() == null) {
                return -1;
            }
            String string = object.toString();
            if (string == null) {
                return 1;
            }
            return this.toString().compareTo(string);
        }

        public boolean equals(Object object) {
            return this.compareTo(object) == 0;
        }

        public Classifier getClassifier() {
            return this.classifier;
        }

        public String toString() {
            if (this.classifier != null) {
                return this.classifier.getPositionString() + " " + this.classifier.toString();
            }
            if (this.feature_name.equals("")) {
                return "<html><body><i>Choose a feature</i></body></html>";
            }
            return this.feature_name;
        }

        public String getFeatureName() {
            return this.feature_name;
        }
    }

    public class FormatControl
    extends JPanel
    implements Control {
        private ArrayList feature_model;
        private boolean ignore_event = false;
        private boolean ready = false;
        private JButton add_button;
        private JButton remove_button;
        private JButton default_button;
        private JComboBox feature_combobox;
        private JList format_list;
        private NumberedJTextArea editor_textarea;
        private JTextArea editor_msgarea;
        private JPanel validation_msg_panel;
        private JPanel selection_pane;
        private final Dimension FIELD_SIZE = new Dimension(200, 30);
        private boolean newtext = true;
        private Format4gs3 previousFormat = null;
        private Format4gs3 currentFormat = null;
        private boolean fresh = true;

        public FormatControl() {
            this.feature_model = Format4gs3Manager.this.buildFeatureModel();
            DesignPaneHeader designPaneHeader = new DesignPaneHeader("CDM.GUI.Formats", "formatstatements");
            this.format_list = new JList(Format4gs3Manager.this.format_list_model);
            this.selection_pane = new JPanel();
            JPanel jPanel = new JPanel();
            JLabel jLabel = new JLabel(Dictionary.get("CDM.FormatManager.Feature"));
            this.feature_combobox = new JComboBox<Object>(this.feature_model.toArray());
            this.feature_combobox.setOpaque(!Utility.isMac());
            this.feature_combobox.setPreferredSize(this.FIELD_SIZE);
            this.feature_combobox.setEditable(false);
            this.feature_combobox.setToolTipText(Dictionary.get("CDM.FormatManager.Feature_Tooltip"));
            JPanel jPanel2 = new JPanel();
            JPanel jPanel3 = new JPanel();
            this.editor_textarea = new NumberedJTextArea(Dictionary.get("CDM.FormatManager.Add_Tooltip"));
            this.default_button = new GLIButton(Dictionary.get("CDM.FormatManager.Default"), Dictionary.get("CDM.FormatManager.Default_Tooltip"));
            JPanel jPanel4 = new JPanel();
            this.add_button = new GLIButton(Dictionary.get("CDM.FormatManager.Add"), Dictionary.get("CDM.FormatManager.Add_Tooltip"));
            this.add_button.setEnabled(false);
            this.remove_button = new GLIButton(Dictionary.get("CDM.FormatManager.Remove"), Dictionary.get("CDM.FormatManager.Remove_Tooltip"));
            this.remove_button.setEnabled(false);
            this.add_button.addActionListener(new AddListener());
            this.remove_button.addActionListener(new RemoveListener());
            this.default_button.addActionListener(new DefaultListener());
            this.feature_combobox.addActionListener(new FeatureListener());
            this.editor_textarea.getDocument().addDocumentListener(new EditorListener());
            this.format_list.addListSelectionListener(new FormatListListener());
            JPanel jPanel5 = new JPanel();
            jPanel5.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
            jPanel5.setLayout(new BorderLayout());
            jPanel5.add((Component)new JScrollPane(this.format_list), "Center");
            jPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
            jPanel.setLayout(new BorderLayout(5, 0));
            jPanel.add((Component)jLabel, "West");
            jPanel.add((Component)this.feature_combobox, "Center");
            JPanel jPanel6 = new JPanel();
            jPanel6.setLayout(new GridLayout(1, 2));
            jPanel6.add(this.editor_textarea.undoButton);
            jPanel6.add(this.editor_textarea.redoButton);
            jPanel3.setLayout(new BorderLayout());
            jPanel3.add((Component)new JScrollPane(this.editor_textarea), "Center");
            this.validation_msg_panel = new JPanel();
            JLabel jLabel2 = new JLabel(Dictionary.get("CDM.FormatManager.MessageBox"));
            this.editor_msgarea = new JTextArea();
            this.editor_msgarea.setCaretPosition(0);
            this.editor_msgarea.setLineWrap(true);
            this.editor_msgarea.setRows(3);
            this.editor_msgarea.setWrapStyleWord(false);
            this.editor_msgarea.setEditable(false);
            this.editor_msgarea.setToolTipText(Dictionary.get("CDM.FormatManager.MessageBox_Tooltip"));
            this.validation_msg_panel.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
            this.validation_msg_panel.setLayout(new BorderLayout(5, 0));
            this.validation_msg_panel.add((Component)jLabel2, "West");
            this.validation_msg_panel.add((Component)new JScrollPane(this.editor_msgarea), "Center");
            this.selection_pane.setLayout(new BorderLayout());
            this.selection_pane.add((Component)this.validation_msg_panel, "North");
            this.selection_pane.add((Component)jPanel6, "South");
            this.selection_pane.add((Component)jPanel3, "Center");
            jPanel4.setLayout(new GridLayout(1, 3));
            jPanel4.add(this.add_button);
            jPanel4.add(this.remove_button);
            jPanel4.add(this.default_button);
            jPanel2.setLayout(new BorderLayout());
            jPanel2.add((Component)jPanel, "North");
            jPanel2.add((Component)this.selection_pane, "Center");
            jPanel2.add((Component)jPanel4, "South");
            JSplitPane jSplitPane = new JSplitPane(0);
            jSplitPane.add((Component)jPanel5, "top");
            jSplitPane.add((Component)jPanel2, "bottom");
            jSplitPane.setDividerLocation(150);
            this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            this.setLayout(new BorderLayout());
            this.add((Component)designPaneHeader, "North");
            this.add((Component)jSplitPane, "Center");
            this.ready = true;
            TestingPreparation.setNamesRecursively(this);
        }

        @Override
        public void destroy() {
        }

        @Override
        public void gainFocus() {
            if (this.ready) {
                Format4gs3Manager.this.format_list_model.refresh();
                Object object = this.feature_combobox.getSelectedItem();
                this.feature_combobox.setSelectedItem(object);
                this.feature_model = Format4gs3Manager.this.buildFeatureModel();
                this.feature_combobox.setModel(new DefaultComboBoxModel<Object>(this.feature_model.toArray()));
            }
        }

        @Override
        public void loseFocus() {
            String string = XMLTools.parse(this.editor_textarea.getText());
            if (string.startsWith("not well-formed")) {
                JOptionPane.showMessageDialog(null, string, "not well-formed", 0);
            }
            Format4gs3Manager.this.format_list_model.refresh();
        }

        public Format4gs3 getCurrentFormat() {
            return (Format4gs3)this.format_list.getSelectedValue();
        }

        private void newFormat() {
            this.editor_textarea.setEditable(false);
            this.editor_textarea.setBackground(Color.lightGray);
            this.editor_textarea.setToolTipText(Dictionary.get("CDM.FormatManager.Editor_Disabled_Tooltip"));
            this.editor_textarea.undoButton.setEnabled(false);
            this.editor_textarea.redoButton.setEnabled(false);
            this.add_button.setEnabled(true);
            this.remove_button.setEnabled(false);
            this.default_button.setEnabled(false);
            FormatPane.setPreviewButton(true);
        }

        private void existingFormat(boolean bl) {
            this.editor_textarea.setEditable(true);
            this.editor_textarea.setBackground(Color.white);
            this.editor_textarea.setToolTipText(Dictionary.get("CDM.FormatManager.Editor_Tooltip"));
            this.add_button.setEnabled(false);
            this.remove_button.setEnabled(bl);
            this.default_button.setEnabled(true);
            FormatPane.setPreviewButton(true);
        }

        private class DefaultListener
        implements ActionListener {
            private DefaultListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FormatControl.this.newtext = false;
                if (!FormatControl.this.ignore_event) {
                    Entry entry = (Entry)FormatControl.this.feature_combobox.getSelectedItem();
                    String string = entry.getFeatureName();
                    Format4gs3 format4gs3 = Format4gs3Manager.this.getFormat(Format4gs3Manager.this.format_list_model, string);
                    if (format4gs3 != null) {
                        if (format4gs3.isClassifier()) {
                            FormatControl.this.editor_textarea.setText((String)default_format_formated_map.get(Format4gs3Manager.CLASSIFIER_DEFAULT));
                            FormatControl.this.editor_textarea.setCaretPosition(0);
                            FormatControl.this.remove_button.setEnabled(true);
                        } else {
                            FormatControl.this.editor_textarea.setText((String)default_format_formated_map.get(format4gs3.getFeatureName()));
                            FormatControl.this.editor_textarea.setCaretPosition(0);
                            FormatControl.this.remove_button.setEnabled(false);
                        }
                    } else {
                        FormatControl.this.editor_textarea.setText((String)default_format_formated_map.get(Format4gs3Manager.CLASSIFIER_DEFAULT));
                        FormatControl.this.editor_textarea.setCaretPosition(0);
                        FormatControl.this.remove_button.setEnabled(false);
                        FormatControl.this.add_button.setEnabled(true);
                    }
                }
            }
        }

        private class RemoveListener
        implements ActionListener {
            private RemoveListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!FormatControl.this.format_list.isSelectionEmpty()) {
                    Format4gs3 format4gs3 = (Format4gs3)FormatControl.this.format_list.getSelectedValue();
                    Format4gs3Manager.this.removeFormat(Format4gs3Manager.this.format_list_model, format4gs3);
                    FormatControl.this.add_button.setEnabled(true);
                    FormatControl.this.feature_combobox.setSelectedItem(new Entry(""));
                    FormatControl.this.newFormat();
                }
            }
        }

        private class FormatListListener
        implements ListSelectionListener {
            private FormatListListener() {
            }

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ((FormatControl)FormatControl.this).editor_textarea.undoButton.setEnabled(false);
                ((FormatControl)FormatControl.this).editor_textarea.redoButton.setEnabled(false);
                FormatControl.this.default_button.setEnabled(true);
                FormatControl.this.newtext = true;
                if (!(FormatControl.this.ignore_event || listSelectionEvent.getValueIsAdjusting() || FormatControl.this.format_list.isSelectionEmpty())) {
                    Object object;
                    FormatControl.this.ignore_event = true;
                    Format4gs3 format4gs3 = (Format4gs3)FormatControl.this.format_list.getSelectedValue();
                    String string = format4gs3.getFeatureName();
                    Entry entry = null;
                    entry = string.startsWith("CL") ? new Entry(format4gs3.getClassifier()) : new Entry(string);
                    FormatControl.this.feature_combobox.setSelectedItem(entry);
                    FormatControl.this.existingFormat(format4gs3.getFeatureName().startsWith("CL"));
                    Element element = null;
                    try {
                        object = new InputSource(new ByteArrayInputStream(Format4gs3Manager.this.addSurroundingTags(format4gs3.getPureFormat()).getBytes("utf-8")));
                        element = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse((InputSource)object).getDocumentElement();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    if (element != null) {
                        object = new StringBuffer();
                        XMLTools.xmlNodeToString((StringBuffer)object, element, true, "  ", 0);
                        FormatControl.this.editor_textarea.setText(Format4gs3Manager.this.removeSurroundingTags(((StringBuffer)object).toString()));
                    } else {
                        FormatControl.this.editor_textarea.setText(format4gs3.getPureFormat());
                    }
                    FormatControl.this.editor_textarea.setCaretPosition(0);
                    FormatControl.this.ignore_event = false;
                }
                FormatControl.this.editor_textarea.discardAllEdits();
            }
        }

        private class FeatureListener
        implements ActionListener {
            private FeatureListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ((FormatControl)FormatControl.this).editor_textarea.undoButton.setEnabled(false);
                ((FormatControl)FormatControl.this).editor_textarea.redoButton.setEnabled(false);
                FormatControl.this.default_button.setEnabled(true);
                FormatControl.this.newtext = true;
                if (FormatControl.this.ignore_event) {
                    FormatControl.this.editor_textarea.discardAllEdits();
                    return;
                }
                FormatControl.this.ignore_event = true;
                Entry entry = (Entry)FormatControl.this.feature_combobox.getSelectedItem();
                String string = entry.getFeatureName();
                Format4gs3 format4gs3 = Format4gs3Manager.this.getFormat(Format4gs3Manager.this.format_list_model, string);
                if (format4gs3 != null) {
                    Object object;
                    FormatControl.this.format_list.setSelectedValue(format4gs3, true);
                    Element element = null;
                    try {
                        object = new InputSource(new ByteArrayInputStream(Format4gs3Manager.this.addSurroundingTags(format4gs3.getPureFormat()).getBytes("utf-8")));
                        element = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse((InputSource)object).getDocumentElement();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    if (element != null) {
                        object = new StringBuffer();
                        XMLTools.xmlNodeToString((StringBuffer)object, element, true, "  ", 0);
                        FormatControl.this.editor_textarea.setText(Format4gs3Manager.this.removeSurroundingTags(((StringBuffer)object).toString()));
                    } else {
                        FormatControl.this.editor_textarea.setText(format4gs3.getPureFormat());
                    }
                    FormatControl.this.editor_textarea.setCaretPosition(0);
                    FormatControl.this.existingFormat(string.startsWith("CL"));
                } else {
                    FormatControl.this.format_list.clearSelection();
                    if (string.equals("")) {
                        FormatControl.this.editor_textarea.setText("");
                    } else {
                        if (entry.getClassifier() == null) {
                            DebugStream.println("It should be a classifier or choose a feature. What is it? " + entry.toString());
                        }
                        FormatControl.this.editor_textarea.setText(Format4gs3.toFormatedFormat(CLASSIFIER_DEFAULT_FORMAT));
                        FormatControl.this.editor_textarea.setCaretPosition(0);
                        FormatControl.this.newFormat();
                    }
                }
                FormatControl.this.ignore_event = false;
                FormatControl.this.editor_textarea.discardAllEdits();
            }
        }

        private class EditorListener
        implements DocumentListener {
            private EditorListener() {
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.update();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.update();
                this.updateUndo("insert");
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.update();
                this.updateUndo("remove");
            }

            private void updateUndo(String string) {
                if (!FormatControl.this.newtext) {
                    ((FormatControl)FormatControl.this).editor_textarea.undoButton.setEnabled(true);
                }
                if (FormatControl.this.editor_textarea.getText().length() != 0 && FormatControl.this.newtext) {
                    FormatControl.this.newtext = false;
                }
            }

            public void update() {
                if (!FormatControl.this.format_list.isSelectionEmpty()) {
                    Format4gs3 format4gs3 = (Format4gs3)FormatControl.this.format_list.getSelectedValue();
                    String string = FormatControl.this.editor_textarea.getText();
                    String string2 = XMLTools.parse(string);
                    FormatControl.this.editor_msgarea.setText(string2);
                    if (string2.startsWith("well-formed !")) {
                        format4gs3.setPureFormat(string);
                        format4gs3.update();
                        Format4gs3Manager.this.format_list_model.refresh(format4gs3);
                        FormatControl.this.editor_msgarea.setBackground(Color.white);
                        FormatPane.setPreviewButton(true);
                    } else {
                        FormatControl.this.editor_msgarea.setBackground(Color.red);
                        FormatPane.setPreviewButton(false);
                    }
                } else {
                    FormatControl.this.add_button.setEnabled(false);
                }
            }
        }

        private class AddListener
        implements ActionListener {
            private AddListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FormatControl.this.ignore_event = true;
                String string = FormatControl.this.editor_textarea.getText();
                Entry entry = (Entry)FormatControl.this.feature_combobox.getSelectedItem();
                String string2 = entry.getClassifier().getPositionString();
                Format4gs3 format4gs3 = new Format4gs3(string2, string);
                Element element = format4gs3.getClassifyElement();
                Format4gs3Manager.this.addFormat(element, format4gs3);
                FormatControl.this.existingFormat(format4gs3.getFeatureName().startsWith("CL"));
                FormatControl.this.format_list.setSelectedValue(format4gs3, true);
                format4gs3 = null;
                FormatControl.this.ignore_event = false;
            }
        }
    }
}

