/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.cdm;

import org.greenstone.gatherer.DebugStream;
import org.greenstone.gatherer.cdm.Classifier;
import org.greenstone.gatherer.cdm.CollectionConfiguration;
import org.greenstone.gatherer.cdm.CollectionDesignManager;
import org.greenstone.gatherer.cdm.DOMProxyListEntry;
import org.greenstone.gatherer.util.Codec;
import org.greenstone.gatherer.util.XMLTools;
import org.w3c.dom.Element;

public class Format
implements DOMProxyListEntry {
    public static final String[] DEFAULT_FEATURES = new String[]{"", "AllowExtendedOptions", "Document", "DocumentArrowsBottom", "DocumentArrowsTop", "DocumentSearchResultLinks", "DocumentButtons", "DocumentContents", "DocumentHeading", "DocumentImages", "DocumentText", "DocumentTitles", "DocumentUseHTML", "NavigationBar", "RelatedDocuments", "Search", "SearchTypes", "AllowUserComments"};
    public static final String[] DEFAULT_PARTS = new String[]{"", "DateList", "HList", "VList"};
    private Classifier classifier = null;
    private Element element = null;
    private String part = null;
    private String feature_name = null;
    private String text = null;

    public static boolean canHavePart(String string) {
        return string.startsWith("<html>") || string.equalsIgnoreCase("") || string.equalsIgnoreCase("Search") || string.equalsIgnoreCase("Document");
    }

    public static String generateName(Object object, String string) {
        if (object instanceof Classifier) {
            return ((Classifier)object).getPositionString() + string;
        }
        return object.toString() + string;
    }

    public static boolean isParamType(String string) {
        return string.equalsIgnoreCase("AllowExtendedOptions") || string.equalsIgnoreCase("DocumentArrowsBottom") || string.equalsIgnoreCase("DocumentArrowsTop") || string.equalsIgnoreCase("DocumentSearchResultLinks") || string.equalsIgnoreCase("DocumentContents") || string.equalsIgnoreCase("DocumentImages") || string.equalsIgnoreCase("DocumentTitles") || string.equalsIgnoreCase("DocumentUseHTML") || string.equalsIgnoreCase("AllowUserComments");
    }

    public Format() {
    }

    public Format(Element element) {
        this.element = element;
        Object object = this.getFeature();
        if (object == null) {
            DebugStream.println("No matching classifier for format statement!");
            return;
        }
        if (object instanceof Classifier) {
            this.classifier = (Classifier)object;
        } else {
            String string = (String)object;
            if (string.toUpperCase().startsWith("CL")) {
                int n = Integer.parseInt(string.substring("CL".length()));
                this.classifier = CollectionDesignManager.classifier_manager.getClassifier(--n);
            }
        }
    }

    public Format(Object object, String string, boolean bl) {
        this.element = CollectionConfiguration.createElement("Format");
        this.setName(object, string);
        this.setState(bl);
    }

    public Format(Object object, String string, String string2) {
        this.element = CollectionConfiguration.createElement("Format");
        this.setName(object, string);
        this.setValue(string2);
    }

    public boolean canHavePart() {
        return Format.canHavePart(this.getFeatureName());
    }

    public int compareTo(Object object) {
        if (object == null) {
            return -1;
        }
        if (object instanceof Format && this.element != null) {
            return this.element.getAttribute("name").compareTo(((Format)object).getName());
        }
        return this.toString().compareTo(object.toString());
    }

    @Override
    public DOMProxyListEntry create(Element element) {
        return new Format(element);
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    @Override
    public Element getElement() {
        return this.element;
    }

    public Object getFeature() {
        if (this.classifier != null) {
            return this.classifier;
        }
        if (this.element != null) {
            String string = this.getFeatureName();
            if (string.toUpperCase().startsWith("CL")) {
                int n = Integer.parseInt(string.substring("CL".length()));
                this.classifier = CollectionDesignManager.classifier_manager.getClassifier(--n);
                return this.classifier;
            }
            return string;
        }
        return "Error";
    }

    public String getFeatureName() {
        if (this.feature_name == null) {
            String string = this.element.getAttribute("name");
            String string2 = this.getPart();
            this.feature_name = string2 != null ? string.substring(0, string.length() - string2.length()) : string;
            string2 = null;
            string = null;
        }
        return this.feature_name;
    }

    public String getName() {
        if (this.element != null) {
            String string = this.element.getAttribute("name");
            return this.element.getAttribute("name");
        }
        return "Error";
    }

    public String getPart() {
        if (this.part == null && this.element != null) {
            String string = this.element.getAttribute("name");
            string = string.toLowerCase();
            for (int i = 1; this.part == null && i < DEFAULT_PARTS.length; ++i) {
                if (!string.endsWith(DEFAULT_PARTS[i].toLowerCase())) continue;
                this.part = DEFAULT_PARTS[i];
            }
            if (this.part == null) {
                this.part = DEFAULT_PARTS[0];
            }
        }
        return this.part;
    }

    public boolean getState() {
        return this.element != null && this.element.getAttribute("value").equals("true");
    }

    public String getValue() {
        String string = "Error";
        if (this.element != null) {
            string = XMLTools.getValue(this.element);
            string = Codec.transform(string, "DOM_TO_TEXT");
        }
        return string;
    }

    @Override
    public boolean isAssigned() {
        return this.element != null && !this.element.getAttribute("assigned").equals("false");
    }

    public boolean isParamType() {
        return this.element != null && this.element.getAttribute("value").length() > 0;
    }

    @Override
    public void setAssigned(boolean bl) {
        if (this.element != null) {
            this.element.setAttribute("assigned", bl ? "true" : "false");
        }
    }

    @Override
    public void setElement(Element element) {
        this.element = element;
        this.part = null;
        this.text = null;
        this.getFeature();
    }

    public void setName(Object object, String string) {
        if (this.element != null) {
            this.part = string;
            if (object instanceof Classifier) {
                this.classifier = (Classifier)object;
                this.feature_name = this.classifier.getPositionString();
                this.element.setAttribute("name", this.classifier.getPositionString() + string);
            } else {
                this.feature_name = object.toString().startsWith("<html>") ? "" : object.toString();
                this.element.setAttribute("name", this.feature_name + string);
            }
            this.text = null;
        }
    }

    public void setState(boolean bl) {
        if (this.element != null) {
            this.element.setAttribute("value", bl ? "true" : "false");
            this.text = null;
        }
    }

    public void setValue(String string) {
        if (this.element != null) {
            if (string.startsWith("\"") && string.startsWith("\"")) {
                string = string.substring(1, string.length() - 1);
            }
            string = Codec.transform(string, "TEXT_TO_DOM");
            XMLTools.setValue(this.element, string);
            this.text = null;
        }
    }

    public String toString() {
        if (this.text == null && this.element != null) {
            StringBuffer stringBuffer = new StringBuffer(" ");
            stringBuffer.append(this.element.getAttribute("name"));
            stringBuffer.append(" ");
            String string = this.element.getAttribute("value");
            if (string.length() > 0) {
                stringBuffer.append(string);
            } else {
                string = XMLTools.getValue(this.element);
                if (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("false")) {
                    stringBuffer.append(string);
                } else {
                    stringBuffer.append("\"");
                    string = Codec.transform(string, "DOM_TO_TEXT");
                    stringBuffer.append(string);
                    stringBuffer.append("\"");
                }
            }
            this.text = stringBuffer.toString();
            stringBuffer = null;
        }
        return this.text;
    }

    public void update() {
        if (this.classifier != null) {
            this.element.setAttribute("name", this.classifier.getPositionString() + this.getPart());
            this.feature_name = this.classifier.getPositionString();
            this.text = null;
        }
    }
}

