/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.cdm;

import java.util.ArrayList;
import java.util.TreeSet;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.DebugStream;
import org.greenstone.gatherer.cdm.CollectionConfiguration;
import org.greenstone.gatherer.cdm.CollectionDesignManager;
import org.greenstone.gatherer.cdm.CollectionMeta;
import org.greenstone.gatherer.cdm.DOMProxyListEntry;
import org.greenstone.gatherer.cdm.DOMProxyListModel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CollectionMetaManager
extends DOMProxyListModel {
    public CollectionMetaManager() {
        super(CollectionDesignManager.collect_config.getDocumentElement(), "CollectionMetadata", new CollectionMeta(""));
        DebugStream.println("CollectionMetaManager: " + this.getSize() + " metadata parsed.");
    }

    public CollectionMetaManager(Element element, String string, DOMProxyListEntry dOMProxyListEntry) {
        super(element, string, dOMProxyListEntry);
    }

    public void destroy() {
    }

    public void addMetadatum(CollectionMeta collectionMeta) {
        if (!this.contains(collectionMeta)) {
            Element element = collectionMeta.getElement();
            Node node = CollectionConfiguration.findInsertionPoint(element);
            this.add(this.root, collectionMeta, node);
        }
    }

    public CollectionMeta get(int n) {
        return (CollectionMeta)this.getElementAt(n);
    }

    public TreeSet getLanguages() {
        TreeSet<String> treeSet = new TreeSet<String>();
        int n = this.getSize();
        for (int i = 0; i < n; ++i) {
            CollectionMeta collectionMeta = (CollectionMeta)this.getElementAt(i);
            String string = collectionMeta.getLanguage();
            if (string.equals("")) continue;
            treeSet.add(string);
        }
        return treeSet;
    }

    public ArrayList getMetadata() {
        ArrayList<CollectionMeta> arrayList = new ArrayList<CollectionMeta>();
        int n = this.getSize();
        for (int i = 0; i < n; ++i) {
            CollectionMeta collectionMeta = (CollectionMeta)this.getElementAt(i);
            arrayList.add(collectionMeta);
        }
        return arrayList;
    }

    public ArrayList getMetadata(String string) {
        ArrayList<CollectionMeta> arrayList = new ArrayList<CollectionMeta>();
        int n = this.getSize();
        for (int i = 0; i < n; ++i) {
            CollectionMeta collectionMeta = (CollectionMeta)this.getElementAt(i);
            if (!collectionMeta.getName().equals(string)) continue;
            arrayList.add(collectionMeta);
        }
        return arrayList;
    }

    public CollectionMeta getMetadatum(String string) {
        return this.getMetadatum(string, true);
    }

    public CollectionMeta getMetadatum(String string, boolean bl) {
        int n = this.getSize();
        for (int i = 0; i < n; ++i) {
            CollectionMeta collectionMeta = (CollectionMeta)this.getElementAt(i);
            if (collectionMeta.getName().equals(string) && collectionMeta.getLanguage().equals(Configuration.getLanguage())) {
                DebugStream.println("Found '" + collectionMeta + "'");
                return collectionMeta;
            }
            collectionMeta = null;
        }
        if (bl) {
            CollectionMeta collectionMeta = new CollectionMeta(string);
            this.addMetadatum(collectionMeta);
            DebugStream.println("Added new metadata: " + string);
            return collectionMeta;
        }
        return null;
    }

    public CollectionMeta getMetadata(String string, String string2, boolean bl) {
        CollectionMeta collectionMeta = null;
        for (int i = 0; i < this.getSize(); ++i) {
            CollectionMeta collectionMeta2 = (CollectionMeta)this.getElementAt(i);
            String string3 = collectionMeta2.getName();
            if (!string3.equals(string)) continue;
            if (collectionMeta2.getLanguage().equals(string2)) {
                return collectionMeta2;
            }
            collectionMeta = collectionMeta2;
        }
        if (bl) {
            return collectionMeta;
        }
        return null;
    }

    public void modeChanged(int n) {
    }

    public void removeMetadata(CollectionMeta collectionMeta) {
        if (collectionMeta != null) {
            String string = collectionMeta.getName();
            String string2 = collectionMeta.getLanguage();
            for (int i = 0; i < this.getSize(); ++i) {
                CollectionMeta collectionMeta2 = (CollectionMeta)this.getElementAt(i);
                if (string.equals(collectionMeta2.getName()) && string2.equals(collectionMeta2.getLanguage())) {
                    this.remove(i);
                    return;
                }
                collectionMeta2 = null;
            }
            string2 = null;
            string = null;
        }
    }

    public void removeMetadata(String string) {
        for (int i = this.getSize(); i != 0; --i) {
            CollectionMeta collectionMeta = (CollectionMeta)this.getElementAt(i - 1);
            if (string.equals(collectionMeta.getName())) {
                this.remove(i - 1);
            }
            collectionMeta = null;
        }
    }

    public int size() {
        return this.getSize();
    }
}

