/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.cdm;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.greenstone.gatherer.DebugStream;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.cdm.ClassifierManager;
import org.greenstone.gatherer.cdm.CollectionConfiguration;
import org.greenstone.gatherer.cdm.CollectionMetaManager;
import org.greenstone.gatherer.cdm.DepositorMetadataManager;
import org.greenstone.gatherer.cdm.DesignChangeListener;
import org.greenstone.gatherer.cdm.Format4gs3Manager;
import org.greenstone.gatherer.cdm.FormatManager;
import org.greenstone.gatherer.cdm.GeneralManager;
import org.greenstone.gatherer.cdm.IndexingManager;
import org.greenstone.gatherer.cdm.LanguageManager;
import org.greenstone.gatherer.cdm.MacrosManager;
import org.greenstone.gatherer.cdm.PluginManager;
import org.greenstone.gatherer.cdm.SearchMetadataManager;
import org.greenstone.gatherer.cdm.SharedByTwoFormatManager;
import org.greenstone.gatherer.cdm.SubcollectionIndexManager;
import org.greenstone.gatherer.cdm.SubcollectionManager;
import org.greenstone.gatherer.cdm.SuperCollectionManager;
import org.greenstone.gatherer.cdm.TranslationView;

public class CollectionDesignManager {
    public static CDMChangeListener change_listener;
    public static DesignChangeListener all_change_listener;
    public static DesignChangeListener buildcol_change_listener;
    public static DesignChangeListener databasecol_change_listener;
    public static CollectionConfiguration collect_config;
    public static ClassifierManager classifier_manager;
    public static CollectionMetaManager collectionmeta_manager;
    public static DepositorMetadataManager depositormetadata_manager;
    public static SharedByTwoFormatManager format_manager;
    public static GeneralManager general_manager;
    public static IndexingManager index_manager;
    public static LanguageManager language_manager;
    public static MacrosManager macros_manager;
    public static PluginManager plugin_manager;
    public static SearchMetadataManager searchmeta_manager;
    public static SubcollectionManager subcollection_manager;
    public static SubcollectionIndexManager subcollectionindex_manager;
    public static SuperCollectionManager supercollection_manager;
    public static TranslationView translation_manager;
    public static final int ALL = 3;
    public static final int BUILDCOL = 2;
    public static final int NOTHING = 0;
    private static int rebuildTypeRequired;
    private static boolean isCompleteBuild;
    private static boolean importWasFull;
    private static boolean buildcolWasFull;

    public CollectionDesignManager(File file) {
        DebugStream.println("Initializaing CollectionDesignModule.");
        change_listener = new CDMChangeListener();
        all_change_listener = new DesignChangeListener(3);
        buildcol_change_listener = new DesignChangeListener(2);
        databasecol_change_listener = new DesignChangeListener(2);
        collect_config = new CollectionConfiguration(file);
        if (DebugStream.isDebuggingEnabled()) {
            collect_config.display();
        }
        this.loadDesignDetails();
        DebugStream.println("CollectionDesignModule loaded.");
    }

    public void reloadConfig() {
        collect_config.reload();
        if (DebugStream.isDebuggingEnabled()) {
            collect_config.display();
        }
        this.destroy();
        this.loadDesignDetails();
        DebugStream.println("CollectionDesignModule loaded.");
    }

    private void loadDesignDetails() {
        classifier_manager = new ClassifierManager();
        collectionmeta_manager = new CollectionMetaManager();
        depositormetadata_manager = new DepositorMetadataManager();
        format_manager = Gatherer.GS3 ? new Format4gs3Manager() : new FormatManager();
        general_manager = new GeneralManager();
        index_manager = new IndexingManager();
        language_manager = new LanguageManager(collect_config.getLanguages());
        macros_manager = new MacrosManager();
        plugin_manager = new PluginManager();
        searchmeta_manager = new SearchMetadataManager();
        subcollection_manager = new SubcollectionManager();
        subcollectionindex_manager = new SubcollectionIndexManager(collect_config.getSubIndexes());
        supercollection_manager = new SuperCollectionManager(collect_config.getSuperCollection());
        translation_manager = new TranslationView();
    }

    public void destroy() {
        classifier_manager.destroy();
        classifier_manager = null;
        collectionmeta_manager.destroy();
        collectionmeta_manager = null;
        depositormetadata_manager.destroy();
        depositormetadata_manager = null;
        format_manager.destroy();
        format_manager = null;
        general_manager.destroy();
        general_manager = null;
        index_manager.destroy();
        index_manager = null;
        language_manager.destroy();
        language_manager = null;
        macros_manager.destroy();
        macros_manager = null;
        plugin_manager.destroy();
        plugin_manager = null;
        searchmeta_manager.destroy();
        searchmeta_manager = null;
        subcollection_manager.destroy();
        subcollection_manager = null;
        subcollectionindex_manager.destroy();
        subcollectionindex_manager = null;
        supercollection_manager.destroy();
        supercollection_manager = null;
        translation_manager.destroy();
        translation_manager = null;
    }

    public void modeChanged(int n) {
        if (classifier_manager != null) {
            classifier_manager.modeChanged(n);
        }
        if (collectionmeta_manager != null) {
            collectionmeta_manager.modeChanged(n);
        }
        if (depositormetadata_manager != null) {
            depositormetadata_manager.modeChanged(n);
        }
        if (general_manager != null) {
            general_manager.modeChanged(n);
        }
        if (index_manager != null) {
            index_manager.modeChanged(n);
        }
        if (language_manager != null) {
            language_manager.modeChanged(n);
        }
        if (macros_manager != null) {
            macros_manager.modeChanged(n);
        }
        if (plugin_manager != null) {
            plugin_manager.modeChanged(n);
        }
        if (searchmeta_manager != null) {
            searchmeta_manager.modeChanged(n);
        }
        if (subcollection_manager != null) {
            subcollection_manager.modeChanged(n);
        }
        if (subcollectionindex_manager != null) {
            subcollectionindex_manager.modeChanged(n);
        }
        if (supercollection_manager != null) {
            supercollection_manager.modeChanged(n);
        }
        if (translation_manager != null) {
            translation_manager.modeChanged(n);
        }
    }

    public boolean ready() {
        return collect_config.ready();
    }

    public void save() {
        collect_config.saveIfNecessary();
    }

    public static int getRebuildTypeRequired() {
        return rebuildTypeRequired;
    }

    public static void resetRebuildTypeRequired() {
        CollectionDesignManager.setRebuildTypeRequired(0);
    }

    public static void setRebuildTypeRequired(int n) {
        rebuildTypeRequired = n;
    }

    public static boolean isCompleteBuild() {
        return isCompleteBuild;
    }

    public static void setCompleteBuild(boolean bl) {
        isCompleteBuild = bl;
    }

    public static void setImportWasFull(boolean bl) {
        importWasFull = bl;
    }

    public static boolean importWasFull() {
        return importWasFull;
    }

    public static void setBuildcolWasFull(boolean bl) {
        buildcolWasFull = bl;
    }

    public static boolean buildcolWasFull() {
        return buildcolWasFull;
    }

    static {
        rebuildTypeRequired = 0;
        isCompleteBuild = false;
        importWasFull = false;
        buildcolWasFull = false;
    }

    private class CDMChangeListener
    implements ActionListener,
    DocumentListener {
        private CDMChangeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Gatherer.c_man.getCollection().setSaved(false);
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            Gatherer.c_man.getCollection().setSaved(false);
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            Gatherer.c_man.getCollection().setSaved(false);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            Gatherer.c_man.getCollection().setSaved(false);
        }
    }
}

