/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.cdm;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.greenstone.gatherer.DebugStream;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.cdm.ArgumentConfiguration;
import org.greenstone.gatherer.cdm.Classifier;
import org.greenstone.gatherer.cdm.CollectionConfiguration;
import org.greenstone.gatherer.cdm.CollectionDesignManager;
import org.greenstone.gatherer.cdm.Control;
import org.greenstone.gatherer.cdm.DOMProxyListModel;
import org.greenstone.gatherer.cdm.DatabaseTypeManager;
import org.greenstone.gatherer.greenstone.Classifiers;
import org.greenstone.gatherer.gui.DesignPaneHeader;
import org.greenstone.gatherer.gui.GLIButton;
import org.greenstone.gatherer.gui.TestingPreparation;
import org.greenstone.gatherer.util.JarTools;
import org.greenstone.gatherer.util.Utility;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ClassifierManager
extends DOMProxyListModel {
    private DatabaseTypeManager database_type_manager = null;
    private String database_type = null;
    private Control controls = null;
    private DOMProxyListModel model = this;
    private Classifier default_classifier = null;

    public ClassifierManager() {
        super(CollectionDesignManager.collect_config.getDocumentElement(), "Classify", new Classifier());
        DebugStream.println("ClassifierManager: " + this.getSize() + " classifiers parsed.");
        this.database_type_manager = new DatabaseTypeManager();
        this.database_type = this.database_type_manager.getDatabaseType();
        for (int i = 0; i < this.getSize(); ++i) {
            this.getElementAt(i);
        }
    }

    private Object[] getAvailableClassifiers() {
        ArrayList<Classifier> arrayList = new ArrayList<Classifier>();
        ArrayList arrayList2 = Classifiers.getClassifiersList();
        for (int i = 0; i < arrayList2.size(); ++i) {
            Classifier classifier = (Classifier)arrayList2.get(i);
            if (!classifier.isAbstract()) {
                arrayList.add(classifier);
            }
            if (!classifier.toString().equals("List")) continue;
            this.default_classifier = classifier;
        }
        Collections.sort(arrayList);
        return arrayList.toArray();
    }

    private void assignClassifier(Classifier classifier) {
        if (!this.contains(classifier)) {
            Element element = classifier.getElement();
            Node node = CollectionConfiguration.findInsertionPoint(element);
            this.add(this.root, classifier, node);
            CollectionDesignManager cfr_ignored_0 = Gatherer.c_man.getCollection().cdm;
            CollectionDesignManager.format_manager.refresh();
        }
    }

    public void destroy() {
        if (this.controls != null) {
            this.controls.destroy();
            this.controls = null;
        }
    }

    public Classifier getClassifier(int n) {
        if (0 <= n && n < this.getSize()) {
            return (Classifier)this.getElementAt(n);
        }
        return null;
    }

    public Control getControls() {
        if (this.controls == null) {
            this.controls = new ClassifierControl();
        }
        return this.controls;
    }

    public void modeChanged(int n) {
    }

    public boolean isPhindClassifierAssigned() {
        for (int i = 0; i < this.getSize(); ++i) {
            Classifier classifier = (Classifier)this.getElementAt(i);
            if (classifier.getName().equalsIgnoreCase("Phind")) {
                return true;
            }
            classifier = null;
        }
        return false;
    }

    public boolean isDateListClassifierAssigned() {
        for (int i = 0; i < this.getSize(); ++i) {
            Classifier classifier = (Classifier)this.getElementAt(i);
            if (classifier.getName().equalsIgnoreCase("DateList")) {
                return true;
            }
            classifier = null;
        }
        return false;
    }

    private void moveClassifier(Classifier classifier, boolean bl, boolean bl2) {
        if (this.getSize() < 2) {
            DebugStream.println("Not enough classifiers to allow moving.");
            return;
        }
        if (bl2) {
            if (bl) {
                this.remove(classifier);
                Classifier classifier2 = (Classifier)this.getElementAt(0);
                this.addBefore(classifier, classifier2);
                classifier2 = null;
            } else {
                this.remove(classifier);
                this.add(this.getSize(), classifier);
            }
        } else {
            int n = this.indexOf(classifier);
            if (bl) {
                if (--n < 0) {
                    String[] stringArray = new String[]{Dictionary.get("CDM.ClassifierManager.Classifier"), classifier.getName()};
                    JOptionPane.showMessageDialog(Gatherer.g_man, Dictionary.get("CDM.Move.At_Top", stringArray), Dictionary.get("CDM.Move.Title"), 0);
                    return;
                }
                this.remove(classifier);
                this.add(n, classifier);
            } else {
                if (++n >= this.getSize()) {
                    String[] stringArray = new String[]{Dictionary.get("CDM.ClassifierManager.Classifier_Str"), classifier.getName()};
                    JOptionPane.showMessageDialog(Gatherer.g_man, Dictionary.get("CDM.Move.At_Bottom", stringArray), Dictionary.get("CDM.Move.Title"), 0);
                    return;
                }
                this.remove(classifier);
                this.add(n, classifier);
            }
        }
        CollectionDesignManager cfr_ignored_0 = Gatherer.c_man.getCollection().cdm;
        CollectionDesignManager.format_manager.refresh();
    }

    private void removeClassifier(Classifier classifier) {
        this.remove(classifier);
        CollectionDesignManager cfr_ignored_0 = Gatherer.c_man.getCollection().cdm;
        CollectionDesignManager.format_manager.refresh();
    }

    static /* synthetic */ DatabaseTypeManager access$000(ClassifierManager classifierManager) {
        return classifierManager.database_type_manager;
    }

    private class ClassifierControl
    extends JPanel
    implements Control,
    DatabaseTypeManager.DatabaseTypeListener {
        private JComboBox classifier_combobox = null;
        private JButton add = null;
        private JButton configure = null;
        private JButton move_down_button;
        private JButton move_up_button;
        private JButton remove = null;
        private JPanel database_type_panel = (JPanel)((Object)ClassifierManager.access$000(ClassifierManager.this).getControls());
        private JList classifier_list = null;

        public ClassifierControl() {
            this.setComponentOrientation(Dictionary.getOrientation());
            this.add = new GLIButton(Dictionary.get("CDM.ClassifierManager.Add"), Dictionary.get("CDM.ClassifierManager.Add_Tooltip"));
            JPanel jPanel = new JPanel();
            jPanel.setComponentOrientation(Dictionary.getOrientation());
            JPanel jPanel2 = new JPanel();
            jPanel2.setComponentOrientation(Dictionary.getOrientation());
            this.configure = new GLIButton(Dictionary.get("CDM.ClassifierManager.Configure"), Dictionary.get("CDM.ClassifierManager.Configure_Tooltip"));
            this.configure.setEnabled(false);
            DesignPaneHeader designPaneHeader = new DesignPaneHeader("CDM.GUI.Classifiers", "classifiers");
            ClassifierComboboxListener classifierComboboxListener = new ClassifierComboboxListener();
            this.classifier_combobox = new JComboBox<Object>(ClassifierManager.this.getAvailableClassifiers());
            this.classifier_combobox.setComponentOrientation(Dictionary.getOrientation());
            this.classifier_combobox.setOpaque(!Utility.isMac());
            this.classifier_combobox.setEditable(false);
            if (this.classifier_combobox.getItemCount() > 0) {
                if (ClassifierManager.this.default_classifier != null) {
                    this.classifier_combobox.setSelectedItem(ClassifierManager.this.default_classifier);
                } else {
                    this.classifier_combobox.setSelectedIndex(0);
                }
                classifierComboboxListener.itemStateChanged(new ItemEvent(this.classifier_combobox, 0, null, 1));
            }
            JLabel jLabel = new JLabel(Dictionary.get("CDM.ClassifierManager.Classifier"));
            jLabel.setComponentOrientation(Dictionary.getOrientation());
            this.classifier_list = new JList(ClassifierManager.this.model);
            this.classifier_list.setComponentOrientation(Dictionary.getOrientation());
            this.classifier_list.setOpaque(true);
            this.classifier_list.setSelectionMode(0);
            JLabel jLabel2 = new JLabel(Dictionary.get("CDM.ClassifierManager.Assigned"));
            jLabel2.setComponentOrientation(Dictionary.getOrientation());
            jLabel2.setOpaque(true);
            JPanel jPanel3 = new JPanel();
            jPanel3.setComponentOrientation(Dictionary.getOrientation());
            JPanel jPanel4 = new JPanel();
            jPanel4.setComponentOrientation(Dictionary.getOrientation());
            this.remove = new GLIButton(Dictionary.get("CDM.ClassifierManager.Remove"), Dictionary.get("CDM.ClassifierManager.Remove_Tooltip"));
            this.remove.setEnabled(false);
            JPanel jPanel5 = new JPanel(new BorderLayout());
            jPanel5.setComponentOrientation(Dictionary.getOrientation());
            JPanel jPanel6 = new JPanel();
            jPanel6.setComponentOrientation(Dictionary.getOrientation());
            this.move_up_button = new GLIButton(Dictionary.get("CDM.Move.Move_Up"), JarTools.getImage("arrow-up.gif"), Dictionary.get("CDM.Move.Move_Up_Tooltip"));
            this.move_up_button.setEnabled(false);
            this.move_down_button = new GLIButton(Dictionary.get("CDM.Move.Move_Down"), JarTools.getImage("arrow-down.gif"), Dictionary.get("CDM.Move.Move_Down_Tooltip"));
            this.move_down_button.setEnabled(false);
            this.add.addActionListener(new AddListener());
            this.classifier_combobox.addItemListener(classifierComboboxListener);
            this.configure.addActionListener(new ConfigureListener());
            this.remove.addActionListener(new RemoveListener());
            this.remove.addActionListener(CollectionDesignManager.buildcol_change_listener);
            this.classifier_list.addMouseListener(new ClickListener());
            this.classifier_list.addListSelectionListener(new ListListener());
            classifierComboboxListener = null;
            MoveListener moveListener = new MoveListener();
            this.move_down_button.addActionListener(moveListener);
            this.move_down_button.addActionListener(CollectionDesignManager.buildcol_change_listener);
            this.move_up_button.addActionListener(moveListener);
            this.move_up_button.addActionListener(CollectionDesignManager.buildcol_change_listener);
            jPanel6.setLayout(new GridLayout(4, 1));
            jPanel6.add(this.move_up_button);
            JPanel jPanel7 = new JPanel();
            jPanel7.setComponentOrientation(Dictionary.getOrientation());
            jPanel6.add(jPanel7);
            jPanel7 = new JPanel();
            jPanel7.setComponentOrientation(Dictionary.getOrientation());
            jPanel6.add(jPanel7);
            jPanel6.add(this.move_down_button);
            jLabel2.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
            jPanel3.setLayout(new BorderLayout());
            jPanel3.add((Component)jLabel2, "North");
            jPanel3.add((Component)new JScrollPane(this.classifier_list), "Center");
            jPanel3.add((Component)jPanel6, "After");
            jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
            jPanel4.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
            jPanel4.setLayout(new BorderLayout(5, 0));
            jPanel4.add((Component)jLabel, "Before");
            jPanel4.add((Component)this.classifier_combobox, "Center");
            jPanel.setLayout(new GridLayout(1, 3));
            jPanel.add(this.add);
            jPanel.add(this.configure);
            jPanel.add(this.remove);
            jPanel5.add((Component)jPanel4, "North");
            jPanel5.add((Component)jPanel, "South");
            jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
            jPanel2.setLayout(new BorderLayout());
            jPanel2.add((Component)this.database_type_panel, "North");
            jPanel2.add((Component)jPanel3, "Center");
            jPanel2.add((Component)jPanel5, "South");
            this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            this.setLayout(new BorderLayout());
            this.add((Component)designPaneHeader, "North");
            this.add((Component)jPanel2, "Center");
            TestingPreparation.setNamesRecursively(this);
        }

        @Override
        public void destroy() {
            this.add = null;
            this.classifier_combobox = null;
            this.classifier_list = null;
            this.configure = null;
            this.remove = null;
        }

        @Override
        public void gainFocus() {
        }

        @Override
        public void loseFocus() {
        }

        @Override
        public void databaseTypeChanged(String string) {
            if (ClassifierManager.this.database_type.equals(string)) {
                return;
            }
            ClassifierManager.this.database_type = string;
        }

        private class RemoveListener
        implements ActionListener {
            private RemoveListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ClassifierControl.this.classifier_list.isSelectionEmpty()) {
                    ClassifierControl.this.remove.setEnabled(false);
                    return;
                }
                int n = ClassifierControl.this.classifier_list.getSelectedIndex();
                Object e = ClassifierControl.this.classifier_list.getSelectedValue();
                if (!(e instanceof Classifier)) {
                    return;
                }
                ClassifierManager.this.removeClassifier((Classifier)e);
                if (n >= ClassifierControl.this.classifier_list.getModel().getSize()) {
                    --n;
                }
                if (n >= 0) {
                    ClassifierControl.this.classifier_list.setSelectedIndex(n);
                } else {
                    ClassifierControl.this.remove.setEnabled(false);
                }
            }
        }

        private class MoveListener
        implements ActionListener {
            private MoveListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object e;
                if (!ClassifierControl.this.classifier_list.isSelectionEmpty() && (e = ClassifierControl.this.classifier_list.getSelectedValue()) instanceof Classifier) {
                    Classifier classifier = (Classifier)e;
                    if (actionEvent.getSource() == ClassifierControl.this.move_up_button) {
                        ClassifierManager.this.moveClassifier(classifier, true, false);
                    } else if (actionEvent.getSource() == ClassifierControl.this.move_down_button) {
                        ClassifierManager.this.moveClassifier(classifier, false, false);
                    }
                    ClassifierControl.this.classifier_list.setSelectedValue(classifier, true);
                }
            }
        }

        private class ListListener
        implements ListSelectionListener {
            private ListListener() {
            }

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    if (ClassifierControl.this.classifier_list.isSelectionEmpty()) {
                        ClassifierControl.this.move_up_button.setEnabled(false);
                        ClassifierControl.this.move_down_button.setEnabled(false);
                        ClassifierControl.this.configure.setEnabled(false);
                        ClassifierControl.this.remove.setEnabled(false);
                    } else {
                        ClassifierControl.this.configure.setEnabled(true);
                        ClassifierControl.this.remove.setEnabled(true);
                        int n = ClassifierControl.this.classifier_list.getSelectedIndex();
                        ClassifierControl.this.move_up_button.setEnabled(n != 0);
                        ClassifierControl.this.move_down_button.setEnabled(n != ClassifierManager.this.model.getSize() - 1);
                    }
                }
            }
        }

        private class ConfigureListener
        implements ActionListener {
            private ConfigureListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!ClassifierControl.this.classifier_list.isSelectionEmpty()) {
                    Classifier classifier = (Classifier)ClassifierControl.this.classifier_list.getSelectedValue();
                    ArgumentConfiguration argumentConfiguration = new ArgumentConfiguration(classifier);
                    argumentConfiguration.addOKButtonActionListener(CollectionDesignManager.buildcol_change_listener);
                    if (argumentConfiguration.display()) {
                        ClassifierManager.this.refresh(classifier);
                    }
                    argumentConfiguration.destroy();
                    argumentConfiguration = null;
                }
            }
        }

        private class ClickListener
        extends MouseAdapter {
            private ClickListener() {
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && !ClassifierControl.this.classifier_list.isSelectionEmpty()) {
                    Classifier classifier = (Classifier)ClassifierControl.this.classifier_list.getSelectedValue();
                    ArgumentConfiguration argumentConfiguration = new ArgumentConfiguration(classifier);
                    argumentConfiguration.addOKButtonActionListener(CollectionDesignManager.buildcol_change_listener);
                    if (argumentConfiguration.display()) {
                        ClassifierManager.this.refresh(classifier);
                    }
                    argumentConfiguration.destroy();
                    argumentConfiguration = null;
                }
            }
        }

        private class ClassifierComboboxListener
        implements ItemListener {
            private ClassifierComboboxListener() {
            }

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    Classifier classifier = (Classifier)ClassifierControl.this.classifier_combobox.getSelectedItem();
                    ClassifierControl.this.classifier_combobox.setToolTipText(Utility.formatHTMLWidth(classifier.getDescription(), 40));
                    classifier = null;
                }
            }
        }

        private class AddClassifierTask
        extends Thread {
            private String classifier_name;

            public AddClassifierTask(String string) {
                this.classifier_name = string;
            }

            @Override
            public void run() {
                Classifier classifier = Classifiers.getClassifier(this.classifier_name, true);
                if (classifier == null) {
                    System.err.println("Error: getClassifier() returned null.");
                    return;
                }
                Element element = CollectionConfiguration.createElement("Classify");
                element.setAttribute("type", classifier.getName());
                final Classifier classifier2 = new Classifier(element, classifier);
                Gatherer.invokeInEDT_replacesProceedInCurrThread("ClassifierManager.AddClassifierTask.run()", false, new Runnable(){

                    @Override
                    public void run() {
                        ArgumentConfiguration argumentConfiguration = new ArgumentConfiguration(classifier2);
                        argumentConfiguration.addOKButtonActionListener(CollectionDesignManager.buildcol_change_listener);
                        if (argumentConfiguration.display()) {
                            ClassifierManager.this.assignClassifier(classifier2);
                            ClassifierControl.this.classifier_list.setSelectedValue(classifier2, true);
                        }
                    }
                });
            }
        }

        private class AddListener
        implements ActionListener {
            private AddListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ClassifierControl.this.classifier_combobox.getSelectedItem() != null) {
                    new AddClassifierTask(ClassifierControl.this.classifier_combobox.getSelectedItem().toString()).start();
                }
            }
        }
    }
}

