/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import org.greenstone.gatherer.DebugStream;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.FedoraInfo;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.util.Utility;
import org.greenstone.gatherer.util.XMLTools;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Configuration
extends Hashtable {
    public static final boolean COLLECTION_SPECIFIC = true;
    public static final boolean GENERAL_SETTING = true;
    public static final int ASSISTANT_MODE = 1;
    public static final int LIBRARIAN_MODE = 2;
    public static final int EXPERT_MODE = 3;
    public static final String CONFIG_XML_TEMPLATE = "config.xml";
    public static final String CONFIG_XML_2 = "config2.xml";
    public static final String CONFIG_XML_3 = "config3.xml";
    public static final String CONFIG_REMOTE_XML = "configRemote.xml";
    public static final String CONFIG_WEBSWING_XML = "configWebswing.xml";
    public static final String TEMPLATE_CONFIG_PREFIX = "xml/";
    public static final String FEDORA_CONFIG_PREFIX = "fedora-";
    private static final String ARGUMENT_NAME = "name";
    private static final String GATHERER_CONFIG = "GathererConfig";
    private static final String GATHERER_CONFIG_ARGUMENT = "Argument";
    private static final String GENERAL_EMAIL_SETTING = "general.email";
    private static final String LANGUAGE = "lang";
    private static final String NAME = "Name";
    private static final String OTHER = "Other";
    private static final String TOKENIZER_PATTERN1 = " ,\n\t";
    private static final String TOKENIZER_PATTERN2 = "_\n\t";
    private static final String TOKENIZER_PATTERN3 = ",\n\t";
    public static Configuration self = null;
    public static String gli_user_directory_path = null;
    public static String config_xml = "config2.xml";
    public static String template_config_xml = "xml/config.xml";
    public static boolean just_updated_config_xml_file = false;
    public static String gsdl_path = "";
    public static String gsdl3_web_path = "";
    public static String gsdl3_writableweb_path = "";
    public static String gsdl3_src_path = "";
    public static FedoraInfo fedora_info = null;
    public static String startup_lang = null;
    public static String perl_path = "";
    public static String proxy_pass = null;
    public static String proxy_user = null;
    public static Dimension screen_size = Toolkit.getDefaultToolkit().getScreenSize();
    public static String site_name = "";
    public static String servlet_path = "";
    private static Document collection_config;
    private static Document general_config;
    private static Element directory_mappings_element;
    private static int cache_hit;
    private static int cache_miss;
    public static URL gliserver_url;
    public static URL library_url;
    public static URL local_url;

    public Configuration(String string, String string2, String string3, String string4, String string5, String string6, String string7, FedoraInfo fedoraInfo, String string8) {
        String string9;
        self = this;
        try {
            gli_user_directory_path = new File(string).getCanonicalPath() + File.separator;
            if (string2 != null) {
                gsdl_path = new File(string2).getCanonicalPath() + File.separator;
            }
            if (string3 != null) {
                gsdl3_web_path = new File(string3).getCanonicalPath() + File.separator;
            }
            if (string4 != null) {
                gsdl3_writableweb_path = new File(string4).getCanonicalPath() + File.separator;
            }
            if (string5 != null) {
                gsdl3_src_path = new File(string5).getCanonicalPath() + File.separator;
            }
        }
        catch (IOException iOException) {
            System.err.println("IOException with supplied path arguments:" + iOException.getMessage());
            System.exit(0);
        }
        site_name = string6;
        servlet_path = string7;
        fedora_info = fedoraInfo;
        startup_lang = string8;
        String string10 = config_xml;
        File file = new File(string + string10);
        if (file != null && file.exists()) {
            just_updated_config_xml_file = Configuration.updateUserConfigXMLFileIfNecessary(file);
            general_config = XMLTools.parseXMLFile(file);
        }
        if (general_config == null) {
            general_config = XMLTools.parseXMLFile(template_config_xml, true);
            just_updated_config_xml_file = true;
        }
        directory_mappings_element = (Element)XMLTools.getNodeFromNamed(general_config.getDocumentElement(), "DirectoryMappings");
        if (string8 != null) {
            Configuration.setLocale("general.locale", true, new Locale(string8));
        }
        Configuration.updateUI();
        String string11 = Configuration.getString("general.library_url" + Configuration.gliPropertyNameSuffix(), true);
        if (!string11.equals("")) {
            try {
                library_url = new URL(string11);
            }
            catch (MalformedURLException malformedURLException) {
                DebugStream.printStackTrace(malformedURLException);
            }
        }
        if (Gatherer.isGsdlRemote && !(string9 = Configuration.getString("general.gliserver_url", true)).equals("")) {
            try {
                gliserver_url = new URL(string9);
            }
            catch (MalformedURLException malformedURLException) {
                DebugStream.printStackTrace(malformedURLException);
            }
        }
        if (Gatherer.isWebswing && !(string9 = Configuration.getString("general.local_url", true)).equals("")) {
            try {
                local_url = new URL(string9);
            }
            catch (MalformedURLException malformedURLException) {
                DebugStream.printStackTrace(malformedURLException);
            }
        }
        if (Gatherer.GS3) {
            Configuration.prepareForGS3();
        }
    }

    public static String gliPropertyNameSuffix() {
        if (Gatherer.isGsdlRemote) {
            return "";
        }
        if (Gatherer.GS3) {
            return "_gs3";
        }
        return "_gs2";
    }

    public static void prepareForGS3() {
        if (site_name == null || site_name.equals("")) {
            site_name = Configuration.getString("general.site_name", true);
            servlet_path = Configuration.getString("general.servlet_path", true);
        } else {
            Configuration.setString("general.site_name", true, site_name);
            if (servlet_path != null && !servlet_path.equals("")) {
                Configuration.setString("general.servlet_path", true, servlet_path);
            }
        }
    }

    private static boolean updateUserConfigXMLFileIfNecessary(File file) {
        NodeList nodeList;
        NodeList nodeList2;
        NodeList nodeList3;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        String string;
        Document document = XMLTools.parseXMLFile(template_config_xml, true);
        Document document2 = XMLTools.parseXMLFile(file);
        if (document == null || document2 == null) {
            return false;
        }
        String string2 = document.getDocumentElement().getAttribute("version");
        if (string2.equals(string = document2.getDocumentElement().getAttribute("version"))) {
            return false;
        }
        System.err.println("Converting user config.xml from version " + string + " to version " + string2 + "...");
        file.renameTo(new File(file.getAbsolutePath() + ".old"));
        NodeList nodeList4 = document.getElementsByTagName(GATHERER_CONFIG_ARGUMENT);
        NodeList nodeList5 = document2.getElementsByTagName(GATHERER_CONFIG_ARGUMENT);
        block0: for (int i = 0; i < nodeList4.getLength(); ++i) {
            object4 = (Element)nodeList4.item(i);
            String string3 = object4.getAttribute(ARGUMENT_NAME);
            object3 = XMLTools.getElementTextValue((Element)object4);
            for (int j = nodeList5.getLength() - 1; j >= 0; --j) {
                String string4;
                object2 = (Element)nodeList5.item(j);
                object = object2.getAttribute(ARGUMENT_NAME);
                if (!((String)object).equals(string3)) continue;
                if (!(string3.equals("general.open_collection" + Configuration.gliPropertyNameSuffix()) || string3.equals("general.library_url" + Configuration.gliPropertyNameSuffix()) || string3.equals("general.local_url") || (string4 = XMLTools.getElementTextValue((Element)object2)).equals(object3))) {
                    XMLTools.setElementTextValue((Element)object4, string4);
                }
                object2.getParentNode().removeChild((Node)object2);
                continue block0;
            }
        }
        nodeList5 = document2.getElementsByTagName(GATHERER_CONFIG_ARGUMENT);
        if (nodeList5.getLength() > 0 && (nodeList3 = document.getElementsByTagName(GATHERER_CONFIG)).getLength() > 0) {
            object4 = (Element)nodeList3.item(0);
            object4.appendChild(document.createComment(" Legacy options "));
            for (int i = 0; i < nodeList5.getLength(); ++i) {
                object3 = (Element)nodeList5.item(i);
                object4.appendChild(document.importNode((Node)object3, true));
            }
        }
        if ((nodeList2 = document.getElementsByTagName("DirectoryMappings")).getLength() > 0) {
            object4 = (Element)nodeList2.item(0);
            NodeList nodeList6 = document2.getElementsByTagName("Mapping");
            for (int i = 0; i < nodeList6.getLength(); ++i) {
                Element element = (Element)nodeList6.item(i);
                object4.appendChild(document.importNode(element, true));
            }
        }
        object4 = document.getElementsByTagName("Entry");
        NodeList nodeList7 = document2.getElementsByTagName("Entry");
        block4: for (int i = 0; i < object4.getLength(); ++i) {
            Element element = (Element)object4.item(i);
            object2 = element.getAttribute("extension");
            object = XMLTools.getElementTextValue(element);
            for (int j = nodeList7.getLength() - 1; j >= 0; --j) {
                Element element2 = (Element)nodeList7.item(j);
                String string5 = element2.getAttribute("extension");
                if (!string5.equals(object2)) continue;
                String string6 = XMLTools.getElementTextValue(element2);
                if (!string6.equals(object)) {
                    XMLTools.setElementTextValue(element, string6);
                }
                element2.getParentNode().removeChild(element2);
                continue block4;
            }
        }
        nodeList7 = document2.getElementsByTagName("Entry");
        if (nodeList7.getLength() > 0 && (nodeList = document.getElementsByTagName("Associations")).getLength() > 0) {
            Element element = (Element)nodeList.item(0);
            for (int i = 0; i < nodeList7.getLength(); ++i) {
                object = (Element)nodeList7.item(i);
                element.appendChild(document.importNode((Node)object, true));
            }
        }
        XMLTools.writeXMLFile(file, document);
        return true;
    }

    public static boolean addDirectoryMapping(String string, File file) {
        boolean bl = false;
        try {
            boolean bl2 = false;
            NodeList nodeList = directory_mappings_element.getElementsByTagName("Mapping");
            for (int i = 0; !bl2 && i < nodeList.getLength(); ++i) {
                Element element = (Element)nodeList.item(i);
                if (element.getAttribute(ARGUMENT_NAME).equalsIgnoreCase(string)) {
                    bl2 = true;
                }
                element = null;
            }
            if (!bl2) {
                Element element = general_config.createElement("Mapping");
                element.setAttribute(ARGUMENT_NAME, string);
                element.setAttribute("file", file.toString());
                directory_mappings_element.appendChild(element);
                bl = true;
                element = null;
            }
            nodeList = null;
        }
        catch (Exception exception) {
            DebugStream.printStackTrace(exception);
        }
        return bl;
    }

    public static boolean get(String string, boolean bl) {
        String string2 = Configuration.getString(string, bl);
        return string2 != null && string2.equalsIgnoreCase("true");
    }

    public static HashMap getAll(String string, boolean bl) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            Element element = null;
            if (bl) {
                element = general_config.getDocumentElement();
            } else if (collection_config != null) {
                element = collection_config.getDocumentElement();
            }
            if (element != null) {
                Element element2 = (Element)XMLTools.getNodeFromNamed(element, GATHERER_CONFIG);
                NodeList nodeList = element2.getElementsByTagName(GATHERER_CONFIG_ARGUMENT);
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element element3 = (Element)nodeList.item(i);
                    if (!element3.getAttribute(ARGUMENT_NAME).matches(string)) continue;
                    String string2 = XMLTools.getValue(element3);
                    self.put(element3.getAttribute(ARGUMENT_NAME) + bl, new SoftReference<Element>(element3));
                    hashMap.put(element3.getAttribute(ARGUMENT_NAME), string2);
                }
            }
        }
        catch (Exception exception) {
            DebugStream.printStackTrace(exception);
        }
        return hashMap;
    }

    public static Rectangle getBounds(String string, boolean bl) {
        Rectangle rectangle = null;
        try {
            String string2 = Configuration.getString(string, bl);
            StringTokenizer stringTokenizer = new StringTokenizer(string2, TOKENIZER_PATTERN1);
            int n = Integer.parseInt(stringTokenizer.nextToken());
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            int n3 = Integer.parseInt(stringTokenizer.nextToken());
            int n4 = Integer.parseInt(stringTokenizer.nextToken());
            rectangle = new Rectangle(n, n2, n3, n4);
        }
        catch (Exception exception) {
            DebugStream.printStackTrace(exception);
        }
        return rectangle;
    }

    public static Color getColor(String string, boolean bl) {
        Color color = Color.white;
        try {
            String string2 = Configuration.getString(string, bl);
            StringTokenizer stringTokenizer = new StringTokenizer(string2, TOKENIZER_PATTERN1);
            int n = Integer.parseInt(stringTokenizer.nextToken());
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            int n3 = Integer.parseInt(stringTokenizer.nextToken());
            color = new Color(n, n2, n3);
        }
        catch (Exception exception) {
            DebugStream.printStackTrace(exception);
        }
        return color;
    }

    public static HashMap getDirectoryMappings() {
        HashMap<String, File> hashMap = new HashMap<String, File>();
        try {
            boolean bl = false;
            NodeList nodeList = directory_mappings_element.getElementsByTagName("Mapping");
            for (int i = 0; !bl && i < nodeList.getLength(); ++i) {
                Element element = (Element)nodeList.item(i);
                String string = element.getAttribute(ARGUMENT_NAME);
                File file = new File(element.getAttribute("file"));
                if (file.exists()) {
                    hashMap.put(string, file);
                }
                file = null;
                string = null;
                element = null;
            }
            nodeList = null;
        }
        catch (Exception exception) {
            DebugStream.printStackTrace(exception);
        }
        return hashMap;
    }

    public static String getEmail() {
        String string = Configuration.getString(GENERAL_EMAIL_SETTING, true);
        return string.length() > 0 ? string : null;
    }

    public static Element getFileAssociations() {
        NodeList nodeList = general_config.getDocumentElement().getElementsByTagName("Associations");
        return (Element)nodeList.item(0);
    }

    public static FontUIResource getFont(String string, boolean bl) {
        FontUIResource fontUIResource = new FontUIResource("Times New Roman", 0, 10);
        try {
            String string2 = Configuration.getString(string, bl);
            StringTokenizer stringTokenizer = new StringTokenizer(string2, TOKENIZER_PATTERN3);
            String string3 = stringTokenizer.nextToken().trim();
            int n = 0;
            String string4 = stringTokenizer.nextToken().toUpperCase().trim();
            if (string4.equals("BOLD")) {
                n = 1;
            } else if (string4.equals("ITALIC")) {
                n = 2;
            }
            int n2 = Integer.parseInt(stringTokenizer.nextToken().trim());
            fontUIResource = new FontUIResource(string3, n, n2);
        }
        catch (Exception exception) {
            DebugStream.printStackTrace(exception);
        }
        return fontUIResource;
    }

    public static int getInt(String string, boolean bl) {
        int n = 0;
        try {
            String string2 = Configuration.getString(string, bl);
            n = Integer.parseInt(string2);
        }
        catch (Exception exception) {
            DebugStream.printStackTrace(exception);
        }
        return n;
    }

    public static String getLanguage() {
        Locale locale = Configuration.getLocale("general.locale", true);
        String string = "en";
        if (locale != null) {
            string = locale.getLanguage();
        }
        return string;
    }

    public static Locale getLocale(String string, boolean bl) {
        Locale locale = Locale.getDefault();
        try {
            String string2 = Configuration.getString(string, bl);
            StringTokenizer stringTokenizer = new StringTokenizer(string2, TOKENIZER_PATTERN2);
            String string3 = stringTokenizer.nextToken();
            if (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                locale = new Locale(string3, string4);
            } else {
                locale = new Locale(string3);
            }
        }
        catch (Exception exception) {
            DebugStream.printStackTrace(exception);
        }
        return locale;
    }

    public static int getMode() {
        return Configuration.getInt("general.mode", true);
    }

    public static String getModeAsString() {
        String string;
        switch (Configuration.getInt("general.mode", true)) {
            case 1: {
                string = Dictionary.get("Preferences.Mode.Assistant");
                break;
            }
            case 3: {
                string = Dictionary.get("Preferences.Mode.Expert");
                break;
            }
            default: {
                string = Dictionary.get("Preferences.Mode.Librarian");
            }
        }
        return string;
    }

    public static String getPreviewCommand() {
        return Configuration.getString("general.preview_program", true);
    }

    public static String getApplicationTitle() {
        String string;
        String string2 = Configuration.getString("GLI.Title", true);
        String string3 = string = string2 == "" ? "Greenstone Librarian Interface" : string2;
        if (Gatherer.isWebswing) {
            string = string + " (webswing)";
        }
        return string;
    }

    public static String getServletPath() {
        return servlet_path;
    }

    public static String getString(String string, boolean bl) {
        String string2 = "";
        try {
            Element element;
            SoftReference softReference = (SoftReference)self.get(string + bl);
            if (softReference != null && (element = (Element)softReference.get()) != null) {
                ++cache_hit;
                string2 = XMLTools.getValue(element);
            }
            if (string2.length() == 0) {
                ++cache_miss;
                element = null;
                if (bl) {
                    element = general_config.getDocumentElement();
                } else if (collection_config != null) {
                    element = collection_config.getDocumentElement();
                }
                if (element != null) {
                    Element element2 = (Element)XMLTools.getNodeFromNamed(element, GATHERER_CONFIG);
                    NodeList nodeList = element2.getElementsByTagName(GATHERER_CONFIG_ARGUMENT);
                    for (int i = 0; string2.length() == 0 && i < nodeList.getLength(); ++i) {
                        Element element3 = (Element)nodeList.item(i);
                        if (!element3.getAttribute(ARGUMENT_NAME).equalsIgnoreCase(string)) continue;
                        string2 = XMLTools.getValue(element3);
                        self.put(string + bl, new SoftReference<Element>(element3));
                    }
                }
            }
        }
        catch (Exception exception) {
            DebugStream.printStackTrace(exception);
        }
        if (string2.length() == 0 && !bl) {
            string2 = Configuration.getString(string, true);
        }
        return string2;
    }

    public static String getGS3ScriptPath() {
        return gsdl3_src_path + "bin" + File.separator + "script" + File.separator;
    }

    public static String getGS3BinPath() {
        return gsdl3_src_path + "bin" + File.separator;
    }

    public static String getGS3BinOSPath() {
        return Configuration.getGS3BinPath() + Utility.getOSdirName() + File.separator;
    }

    public static File removeDirectoryMapping(String string) {
        File file = null;
        try {
            boolean bl = false;
            NodeList nodeList = directory_mappings_element.getElementsByTagName("Mapping");
            for (int i = 0; !bl && i < nodeList.getLength(); ++i) {
                Element element = (Element)nodeList.item(i);
                if (element.getAttribute(ARGUMENT_NAME).equalsIgnoreCase(string)) {
                    file = new File(element.getAttribute("file"));
                    directory_mappings_element.removeChild(element);
                    bl = true;
                }
                element = null;
            }
            nodeList = null;
        }
        catch (Exception exception) {
            DebugStream.printStackTrace(exception);
        }
        return file;
    }

    public static void save() {
        File file = null;
        String string = config_xml;
        try {
            file = new File(gli_user_directory_path + string);
            file.getParentFile().mkdirs();
            XMLTools.writeXMLFile(new File(file.getAbsolutePath()), general_config);
        }
        catch (Exception exception) {
            DebugStream.printStackTrace(exception);
            file = null;
        }
    }

    public static void set(String string, boolean bl, boolean bl2) {
        if (string.startsWith("workflow")) {
            DebugStream.println("Set property: " + string + ", general=" + bl + ", value=" + bl2);
        }
        Configuration.setString(string, bl, bl2 ? "true" : "false");
    }

    public static void setCollectionConfiguration(Document document) {
        self.clear();
        collection_config = document;
        Configuration.updateUI();
    }

    public static void setBounds(String string, boolean bl, Rectangle rectangle) {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(rectangle.x);
        stringBuffer.append(", ");
        stringBuffer.append(rectangle.y);
        stringBuffer.append(", ");
        stringBuffer.append(rectangle.width);
        stringBuffer.append(", ");
        stringBuffer.append(rectangle.height);
        Configuration.setString(string, bl, stringBuffer.toString());
    }

    public static void setColor(String string, boolean bl, Color color) {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(color.getRed());
        stringBuffer.append(", ");
        stringBuffer.append(color.getGreen());
        stringBuffer.append(", ");
        stringBuffer.append(color.getBlue());
        Configuration.setString(string, bl, stringBuffer.toString());
    }

    public static void setEmail(String string) {
        Configuration.setString(GENERAL_EMAIL_SETTING, true, string);
    }

    public static void setFont(String string, boolean bl, Font font) {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(font.getName());
        stringBuffer.append(", ");
        switch (font.getStyle()) {
            case 1: {
                stringBuffer.append("BOLD");
                break;
            }
            case 2: {
                stringBuffer.append("ITALIC");
                break;
            }
            default: {
                stringBuffer.append("PLAIN");
            }
        }
        stringBuffer.append(", ");
        stringBuffer.append(font.getSize());
        Configuration.setString(string, bl, stringBuffer.toString());
    }

    public static void setInt(String string, boolean bl, int n) {
        Configuration.setString(string, bl, String.valueOf(n));
    }

    public static void setLocale(String string, boolean bl, Locale locale) {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(locale.getLanguage());
        String string2 = locale.getCountry();
        if (string2 != null && string2.length() > 0) {
            stringBuffer.append("_");
            stringBuffer.append(string2);
        }
        string2 = null;
        Configuration.setString(string, bl, stringBuffer.toString());
    }

    public static void setMode(int n) {
        Configuration.setInt("general.mode", true, n);
    }

    public static void setPreviewCommand(String string) {
        Configuration.setString("general.preview_program", true, string);
    }

    public static void setSiteAndServlet(String string, String string2) {
        site_name = string;
        servlet_path = string2;
        Configuration.setString("general.site_name", true, string);
        Configuration.setString("general.servlet_path", true, string2);
    }

    public static void setString(String string, boolean bl, String string2) {
        DebugStream.println("Set configuration property: " + string + " = " + string2 + (bl ? "" : " [Collection]"));
        try {
            Document document = general_config;
            if (!bl && collection_config != null) {
                document = collection_config;
            }
            if (document != null) {
                Object object;
                Element element = null;
                SoftReference softReference = (SoftReference)self.get(string + bl);
                if (softReference != null) {
                    element = (Element)softReference.get();
                }
                if (element == null) {
                    object = document.getDocumentElement();
                    Element element2 = (Element)XMLTools.getNodeFromNamed((Node)object, GATHERER_CONFIG);
                    NodeList nodeList = object.getElementsByTagName(GATHERER_CONFIG_ARGUMENT);
                    boolean bl2 = false;
                    for (int i = 0; element == null && i < nodeList.getLength(); ++i) {
                        Element element3 = (Element)nodeList.item(i);
                        if (!element3.getAttribute(ARGUMENT_NAME).equalsIgnoreCase(string)) continue;
                        element = element3;
                    }
                    if (element == null) {
                        element = document.createElement(GATHERER_CONFIG_ARGUMENT);
                        element.setAttribute(ARGUMENT_NAME, string);
                        element2.appendChild(element);
                    }
                    self.put(string + bl, new SoftReference<Element>(element));
                }
                if (string2 == null) {
                    string2 = "";
                }
                object = element.getChildNodes();
                for (int i = 0; i < object.getLength(); ++i) {
                    element.removeChild(object.item(i));
                }
                element.appendChild(document.createTextNode(string2));
            }
        }
        catch (Exception exception) {
            DebugStream.printStackTrace(exception);
        }
    }

    private static void updateUI() {
        UIManager.put("Button.select", new ColorUIResource(Configuration.getColor("coloring.button_selected_background", false)));
        UIManager.put("Button.background", new ColorUIResource(Configuration.getColor("coloring.button_background", false)));
        UIManager.put("Button.foreground", new ColorUIResource(Configuration.getColor("coloring.button_foreground", false)));
        UIManager.put("ToggleButton.background", new ColorUIResource(Configuration.getColor("coloring.button_background", false)));
        UIManager.put("ToggleButton.foreground", new ColorUIResource(Configuration.getColor("coloring.button_foreground", false)));
        UIManager.put("ToggleButton.select", new ColorUIResource(Configuration.getColor("coloring.button_selected_background", false)));
        UIManager.put("OptionPane.background", new ColorUIResource(Configuration.getColor("coloring.collection_heading_background", false)));
        UIManager.put("Panel.background", new ColorUIResource(Configuration.getColor("coloring.collection_heading_background", false)));
        UIManager.put("Label.background", new ColorUIResource(Configuration.getColor("coloring.collection_heading_background", false)));
        UIManager.put("SplitPane.background", new ColorUIResource(Configuration.getColor("coloring.collection_heading_background", false)));
        UIManager.put("CheckBox.background", new ColorUIResource(Configuration.getColor("coloring.collection_heading_background", false)));
        UIManager.put("ComboBox.background", new ColorUIResource(Configuration.getColor("coloring.collection_tree_background", false)));
        UIManager.put("Tree.background", new ColorUIResource(Configuration.getColor("coloring.collection_tree_background", false)));
        UIManager.put("Tree.textBackground", new ColorUIResource(Configuration.getColor("coloring.collection_tree_background", false)));
        UIManager.put("ProgressBar.background", new ColorUIResource(Configuration.getColor("coloring.collection_tree_background", false)));
        UIManager.put("TextArea.background", new ColorUIResource(Configuration.getColor("coloring.collection_tree_background", false)));
        UIManager.put("TextField.background", new ColorUIResource(Configuration.getColor("coloring.editable_background", false)));
        UIManager.put("Table.background", new ColorUIResource(Configuration.getColor("coloring.collection_tree_background", false)));
        UIManager.put("List.background", new ColorUIResource(Configuration.getColor("coloring.collection_tree_background", false)));
        UIManager.put("RadioButton.background", new ColorUIResource(Configuration.getColor("coloring.collection_tree_background", false)));
        UIManager.put("TabbedPane.selected", new ColorUIResource(Configuration.getColor("coloring.collection_selection_background", false)));
        UIManager.put("Tree.selectionBackground", new ColorUIResource(Configuration.getColor("coloring.collection_selection_background", false)));
        UIManager.put("ComboBox.selectionBackground", new ColorUIResource(Configuration.getColor("coloring.collection_selection_background", false)));
        UIManager.put("ProgressBar.selectionBackground", new ColorUIResource(Configuration.getColor("coloring.collection_selection_background", false)));
        UIManager.put("TextArea.selectionBackground", new ColorUIResource(Configuration.getColor("coloring.collection_selection_background", false)));
        UIManager.put("TextField.selectionBackground", new ColorUIResource(Configuration.getColor("coloring.collection_selection_background", false)));
        UIManager.put("List.selectionBackground", new ColorUIResource(Configuration.getColor("coloring.collection_selection_background", false)));
        UIManager.put("ScrollBar.background", new ColorUIResource(Configuration.getColor("coloring.scrollbar_background", false)));
        UIManager.put("ScrollBar.thumb", new ColorUIResource(Configuration.getColor("coloring.scrollbar_foreground", false)));
    }

    static {
        cache_hit = 0;
        cache_miss = 0;
        gliserver_url = null;
        library_url = null;
        local_url = null;
    }
}

