/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gsdl3.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.axis.encoding.Base64;
import org.apache.log4j.Logger;

public class GSFile {
    static Logger logger = Logger.getLogger((String)GSFile.class.getName());

    public static String siteConfigFile(String site_home) {
        return site_home + File.separatorChar + "siteConfig.xml";
    }

    public static String interfaceConfigFile(String interface_home) {
        return interface_home + File.separatorChar + "interfaceConfig.xml";
    }

    public static String collectDir(String site_home) {
        return site_home + File.separatorChar + "collect";
    }

    public static String collectionConfigFile(String site_home, String collection_name) {
        return GSFile.collectionConfigFile(GSFile.collectionBaseDir(site_home, collection_name));
    }

    public static String collectionConfigFile(String collection_home) {
        return GSFile.collectionEtcDir(collection_home) + File.separatorChar + "collectionConfig.xml";
    }

    public static String collectionInitFile(String site_home, String collection_name) {
        return site_home + File.separatorChar + "collect" + File.separatorChar + collection_name + File.separatorChar + "etc" + File.separatorChar + "collectionInit.xml";
    }

    public static String collectionBuildConfigFile(String site_home, String collection_name) {
        return site_home + File.separatorChar + "collect" + File.separatorChar + collection_name + File.separatorChar + "index" + File.separatorChar + "buildConfig.xml";
    }

    public static String collectionBuildConfigFileBuilding(String site_home, String collection_name) {
        return GSFile.collectionBuildConfigFileBuilding(GSFile.collectionBaseDir(site_home, collection_name));
    }

    public static String collectionBuildConfigFileBuilding(String collection_home) {
        return collection_home + File.separatorChar + "building" + File.separatorChar + "buildConfig.xml";
    }

    public static String xmlTransformDir(String interface_home) {
        return interface_home + File.separatorChar + "transform";
    }

    public static String collectionBaseDir(String site_home, String collection_name) {
        return site_home + File.separatorChar + "collect" + File.separatorChar + collection_name;
    }

    public static String collectionArchiveDir(String site_home, String collection_name) {
        return GSFile.collectionArchiveDir(GSFile.collectionBaseDir(site_home, collection_name));
    }

    public static String collectionArchiveDir(String collection_home) {
        return collection_home + File.separatorChar + "archives";
    }

    public static String collectionBuildDir(String site_home, String collection_name) {
        return GSFile.collectionBuildDir(GSFile.collectionBaseDir(site_home, collection_name));
    }

    public static String collectionBuildDir(String collection_home) {
        return collection_home + File.separator + "building";
    }

    public static String collectionEtcDir(String site_home, String collection_name) {
        return GSFile.collectionEtcDir(GSFile.collectionBaseDir(site_home, collection_name));
    }

    public static String collectionEtcDir(String collection_home) {
        return collection_home + File.separator + "etc";
    }

    public static String collectionImportDir(String site_home, String collection_name) {
        return GSFile.collectionImportDir(GSFile.collectionBaseDir(site_home, collection_name));
    }

    public static String collectionImportDir(String collection_home) {
        return collection_home + File.separatorChar + "import";
    }

    public static String collectionIndexDir(String site_home, String collection_name) {
        return GSFile.collectionIndexDir(GSFile.collectionBaseDir(site_home, collection_name));
    }

    public static String collectionIndexDir(String collection_home) {
        return collection_home + File.separatorChar + "index";
    }

    public static String collectionTextPath(String index_stem) {
        return "index" + File.separatorChar + "text" + File.separatorChar + index_stem;
    }

    public static String collectionIndexPath(String index_stem, String index_name) {
        return "index" + File.separatorChar + index_name + File.separatorChar + index_stem;
    }

    public static String collectionResourceDir(String site_home, String collection_name) {
        return GSFile.collectionResourceDir(GSFile.collectionBaseDir(site_home, collection_name));
    }

    public static String collectionResourceDir(String collection_home) {
        return collection_home + File.separatorChar + "resources";
    }

    public static String assocFileAbsolutePath(String site_home, String collection_name, String assoc_file_path, String filename) {
        return GSFile.collectionBaseDir(site_home, collection_name) + File.separatorChar + "index" + File.separatorChar + "assoc" + File.separatorChar + assoc_file_path + File.separatorChar + filename;
    }

    public static String siteHome(String gsdl3_home, String site_name) {
        return gsdl3_home + File.separatorChar + "sites" + File.separatorChar + site_name;
    }

    public static String interfaceHome(String gsdl3_home, String interface_name) {
        return gsdl3_home + File.separatorChar + "interfaces" + File.separatorChar + interface_name;
    }

    public static String siteStylesheetFile(String site_home, String filename) {
        return site_home + File.separatorChar + "transform" + File.separatorChar + filename;
    }

    public static String collStylesheetFile(String site_home, String coll_name, String filename) {
        return GSFile.collectionBaseDir(site_home, coll_name) + File.separatorChar + "transform" + File.separatorChar + filename;
    }

    public static String stylesheetFile(String gsdl3_home, String site_name, String collection, String interface_name, ArrayList base_interfaces, String filename) {
        String coll_home;
        String site_home = GSFile.siteHome(gsdl3_home, site_name);
        File stylesheet = null;
        if (!collection.equals("") && (stylesheet = new File((coll_home = GSFile.collectionBaseDir(site_home, collection)) + File.separatorChar + "transform" + File.separatorChar + filename)).exists()) {
            return stylesheet.getPath();
        }
        stylesheet = new File(site_home + File.separatorChar + "transform" + File.separatorChar + filename);
        if (stylesheet.exists()) {
            return stylesheet.getPath();
        }
        String interface_home = GSFile.interfaceHome(gsdl3_home, interface_name);
        stylesheet = new File(interface_home + File.separatorChar + "transform" + File.separatorChar + filename);
        if (stylesheet.exists()) {
            return stylesheet.getPath();
        }
        if (base_interfaces == null || base_interfaces.size() == 0) {
            return null;
        }
        for (int i = 0; i < base_interfaces.size(); ++i) {
            interface_home = GSFile.interfaceHome(gsdl3_home, (String)base_interfaces.get(i));
            stylesheet = new File(interface_home + File.separatorChar + "transform" + File.separatorChar + filename);
            if (!stylesheet.exists()) continue;
            return stylesheet.getPath();
        }
        return null;
    }

    public static String phindBaseDir(String site_home, String coll_name, String phind_index) {
        return site_home + File.separatorChar + "collect" + File.separatorChar + coll_name + File.separatorChar + "index" + File.separatorChar + "phind" + phind_index;
    }

    public static String collectionDatabaseFile(String site_home, String collection_name, String index_stem, String database_type) {
        String db_ext = null;
        db_ext = database_type.equalsIgnoreCase("jdbm") ? ".jdb" : ".gdb";
        return site_home + File.separatorChar + "collect" + File.separatorChar + collection_name + File.separatorChar + "index" + File.separatorChar + "text" + File.separatorChar + index_stem + db_ext;
    }

    public static String base64EncodeFromFile(String in_filename) {
        byte[] data = null;
        try {
            data = GSFile.readFile(in_filename);
        }
        catch (Exception e) {
            logger.error((Object)"couldn't read the file");
        }
        String encodedString = Base64.encode((byte[])data);
        return encodedString;
    }

    public static boolean base64DecodeToFile(String data, String out_filename) {
        try {
            byte[] buffer = Base64.decode((String)data);
            GSFile.writeFile(buffer, out_filename);
        }
        catch (Exception e) {
            logger.error((Object)("file opening/closing errors" + e.getMessage()));
            return false;
        }
        return true;
    }

    public static byte[] readFile(String filename) throws IOException {
        File file = new File(filename);
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
        int bytes = (int)file.length();
        byte[] buffer = new byte[bytes];
        int readBytes = bis.read(buffer);
        bis.close();
        return buffer;
    }

    public static void writeFile(byte[] buffer, String filename) throws IOException {
        File file = new File(filename);
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));
        bos.write(buffer);
        bos.close();
    }

    public static boolean deleteFile(File f) {
        if (f.isDirectory()) {
            File[] files = f.listFiles();
            for (int i = 0; files != null && i < files.length; ++i) {
                GSFile.deleteFile(files[i]);
            }
        }
        return f.delete();
    }

    public static boolean copyFile(File source, File destination) {
        if (!source.isFile()) {
            logger.error((Object)(source.getPath() + " is not a file!"));
            return false;
        }
        try {
            destination.getParentFile().mkdirs();
            FileInputStream in = new FileInputStream(source);
            FileOutputStream out = new FileOutputStream(destination);
            int value = 0;
            while ((value = in.read()) != -1) {
                out.write(value);
            }
            in.close();
            out.close();
        }
        catch (Exception e) {
            logger.error((Object)("something went wrong copying " + source.getPath() + " to " + destination.getPath()));
            logger.error((Object)("Exception: " + e.getMessage()));
            return false;
        }
        return true;
    }

    public static boolean moveDirectory(File source, File destination) {
        if (source.renameTo(destination)) {
            return true;
        }
        File[] input = source.listFiles();
        for (int i = 0; i < input.length; ++i) {
            File output = new File(destination, input[i].getName());
            if (input[i].isDirectory()) {
                GSFile.moveDirectory(input[i], output);
                continue;
            }
            try {
                output.getParentFile().mkdirs();
                FileInputStream in = new FileInputStream(input[i]);
                FileOutputStream out = new FileOutputStream(output);
                int value = 0;
                while ((value = in.read()) != -1) {
                    out.write(value);
                }
                in.close();
                out.close();
                input[i].delete();
                continue;
            }
            catch (Exception e) {
                logger.error((Object)("exception: " + e.getMessage()));
                return false;
            }
        }
        return true;
    }
}

