/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gsdl3.service;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.greenstone.LuceneWrapper.GS2LuceneQuery;
import org.greenstone.LuceneWrapper.LuceneQueryResult;
import org.greenstone.gsdl3.service.AbstractGS2FieldSearch;
import org.greenstone.gsdl3.util.GSFile;
import org.greenstone.gsdl3.util.GSXML;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GS2LuceneSearch
extends AbstractGS2FieldSearch {
    protected static final String RANK_PARAM_RANK_VALUE = "rank";
    static Logger logger = Logger.getLogger((String)GS2LuceneSearch.class.getName());
    private GS2LuceneQuery lucene_src = new GS2LuceneQuery();

    public GS2LuceneSearch() {
        this.AND_OPERATOR = "&&";
        this.OR_OPERATOR = "||";
        this.does_paging = true;
        this.does_chunking = true;
    }

    public void cleanUp() {
        super.cleanUp();
        this.lucene_src.cleanUp();
    }

    public boolean configure(Element info, Element extra_info) {
        if (!super.configure(info, extra_info)) {
            return false;
        }
        this.does_case = false;
        this.does_stem = false;
        this.does_accent = false;
        return true;
    }

    protected void addCustomQueryParams(Element param_list, String lang) {
        super.addCustomQueryParams(param_list, lang);
        this.createParameter("sortBy", param_list, lang);
    }

    protected void createParameter(String name, Element param_list, String lang) {
        Element param = null;
        if (name.equals("sortBy")) {
            ArrayList<String> fields = new ArrayList<String>();
            fields.add(RANK_PARAM_RANK_VALUE);
            ArrayList<String> field_names = new ArrayList<String>();
            field_names.add(this.getTextString("param.sortBy.rank", lang));
            this.getSortByIndexData(fields, field_names, lang);
            param = GSXML.createParameterDescription2(this.doc, name, this.getTextString("param." + name, lang), "enum_single", (String)fields.get(0), fields, field_names);
        }
        if (param != null) {
            param_list.appendChild(param);
        } else {
            super.createParameter(name, param_list, lang);
        }
    }

    protected void getSortByIndexData(ArrayList index_ids, ArrayList index_names, String lang) {
        Element index_list = (Element)GSXML.getChildByTagName(this.config_info, "indexList");
        NodeList indexes = index_list.getElementsByTagName("index");
        int len = indexes.getLength();
        for (int i = 0; i < len; ++i) {
            Element index = (Element)indexes.item(i);
            String shortname = index.getAttribute("shortname");
            if (shortname.equals("") || shortname.equals("ZZ") || shortname.equals("TX")) continue;
            index_ids.add("by" + shortname);
            String display_name = GSXML.getDisplayText(index, "name", lang, "en");
            if (display_name.equals("") && (display_name = index.getAttribute("name")).equals("")) {
                display_name = shortname;
            }
            index_names.add(display_name);
        }
    }

    protected boolean setUpQueryer(HashMap params) {
        String indexdir = GSFile.collectionBaseDir(this.site_home, this.cluster_name) + File.separatorChar + "index" + File.separatorChar;
        String index = "didx";
        String physical_index_language_name = null;
        String physical_sub_index_name = null;
        int maxdocs = 100;
        int hits_per_page = 20;
        int start_page = 1;
        Set entries = params.entrySet();
        for (Map.Entry m : entries) {
            String name = (String)m.getKey();
            String value = (String)m.getValue();
            if (name.equals("maxDocs") && !value.equals("")) {
                maxdocs = Integer.parseInt(value);
                continue;
            }
            if (name.equals("hitsPerPage")) {
                hits_per_page = Integer.parseInt(value);
                continue;
            }
            if (name.equals("startPage")) {
                start_page = Integer.parseInt(value);
                continue;
            }
            if (name.equals("matchMode")) {
                if (value.equals("all")) {
                    this.lucene_src.setDefaultConjunctionOperator("AND");
                    continue;
                }
                this.lucene_src.setDefaultConjunctionOperator("OR");
                continue;
            }
            if (name.equals("sortBy")) {
                if (value.equals(RANK_PARAM_RANK_VALUE)) {
                    value = null;
                }
                this.lucene_src.setSortField(value);
                continue;
            }
            if (name.equals("level")) {
                if (value.toUpperCase().equals("SEC")) {
                    index = "sidx";
                    continue;
                }
                index = "didx";
                continue;
            }
            if (name.equals("indexSubcollection")) {
                physical_sub_index_name = value;
                continue;
            }
            if (!name.equals("indexLanguage")) continue;
            physical_index_language_name = value;
        }
        int start_results = 1;
        if (start_page != 1) {
            start_results = (start_page - 1) * hits_per_page + 1;
        }
        int end_results = hits_per_page * start_page;
        this.lucene_src.setStartResults(start_results);
        this.lucene_src.setEndResults(end_results);
        if (index.equals("sidx") || index.equals("didx")) {
            if (physical_sub_index_name != null) {
                index = index + physical_sub_index_name;
            }
            if (physical_index_language_name != null) {
                index = index + physical_index_language_name;
            }
        }
        this.lucene_src.setIndexDir(indexdir + index);
        this.lucene_src.initialise();
        return true;
    }

    protected Object runQuery(String query) {
        try {
            LuceneQueryResult lqr = this.lucene_src.runQuery(query);
            return lqr;
        }
        catch (Exception e) {
            logger.error((Object)"exception happened in run query: ", (Throwable)e);
            return null;
        }
    }

    protected long numDocsMatched(Object query_result) {
        return ((LuceneQueryResult)query_result).getTotalDocs();
    }

    protected String[] getDocIDs(Object query_result) {
        Vector docs = ((LuceneQueryResult)query_result).getDocs();
        String[] doc_nums = new String[docs.size()];
        for (int d = 0; d < docs.size(); ++d) {
            String doc_num;
            doc_nums[d] = doc_num = ((LuceneQueryResult.DocInfo)docs.elementAt((int)d)).id_;
        }
        return doc_nums;
    }

    protected String[] getDocRanks(Object query_result) {
        Vector docs = ((LuceneQueryResult)query_result).getDocs();
        String[] doc_ranks = new String[docs.size()];
        for (int d = 0; d < docs.size(); ++d) {
            doc_ranks[d] = Float.toString(((LuceneQueryResult.DocInfo)docs.elementAt((int)d)).rank_);
        }
        return doc_ranks;
    }

    protected boolean addTermInfo(Element term_list, HashMap params, Object query_result) {
        String query_level = (String)params.get("level");
        Vector terms = ((LuceneQueryResult)query_result).getTerms();
        for (int t = 0; t < terms.size(); ++t) {
            LuceneQueryResult.TermInfo term_info = (LuceneQueryResult.TermInfo)terms.get(t);
            Element term_elem = this.doc.createElement("term");
            term_elem.setAttribute("name", term_info.term_);
            term_elem.setAttribute("freq", "" + term_info.term_freq_);
            term_elem.setAttribute("numDocsMatch", "" + term_info.match_docs_);
            term_elem.setAttribute("field", term_info.field_);
            term_list.appendChild(term_elem);
        }
        return true;
    }

    protected String addFieldInfo(String query, String field) {
        if (field.equals("") || field.equals("ZZ")) {
            return query;
        }
        return field + ":(" + query + ")";
    }

    protected void addQueryElem(StringBuffer s, String q, String f, String c) {
        String combine = "";
        if (s.length() > 0) {
            combine = " " + c + " ";
        }
        s.append(combine + this.addFieldInfo(q, f));
    }

    protected String addStemOptions(String query, String stem, String casef, String accent) {
        return query;
    }

    protected String internalNum2OID(long docnum) {
        return Long.toString(docnum);
    }

    protected String internalNum2OID(String docnum) {
        return docnum;
    }
}

