/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gsdl3.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.greenstone.gsdl3.service.GS2MGPPSearch;
import org.greenstone.gsdl3.util.DBInfo;
import org.greenstone.mgpp.MGPPDocInfo;
import org.greenstone.mgpp.MGPPQueryResult;
import org.w3c.dom.Element;

public class GoogleNgramMGPPSearch
extends GS2MGPPSearch {
    static Logger logger = Logger.getLogger((String)GoogleNgramMGPPSearch.class.getName());

    public boolean configure(Element info, Element extra_info) {
        if (!super.configure(info, extra_info)) {
            return false;
        }
        this.default_max_docs = "-1";
        this.default_hits_per_page = "30";
        this.does_stem = false;
        this.does_paging = true;
        return true;
    }

    protected String[] getDocIDs(Object query_result) {
        try {
            Vector docs = ((MGPPQueryResult)query_result).getDocs();
            ArrayList<DocWrapper> docList = new ArrayList<DocWrapper>();
            for (int d = 0; d < docs.size(); ++d) {
                String num = Long.toString(((MGPPDocInfo)docs.elementAt((int)d)).num_);
                String doc_id = this.internalNum2OID(num);
                DBInfo dbInfo = this.coll_db.getInfo(doc_id);
                String fre = dbInfo.getInfo("Frequency");
                String tense = dbInfo.getInfo("Tense");
                if (fre.equals("")) continue;
                docList.add(new DocWrapper(num, Integer.parseInt(fre), tense));
            }
            Collections.sort(docList);
            boolean i_pa = false;
            boolean i_f = false;
            boolean i_pre = false;
            String[] doc_nums = new String[docList.size()];
            int interval = 10;
            for (int d = 0; d < doc_nums.length; ++d) {
                doc_nums[d] = ((DocWrapper)docList.get((int)d)).num;
            }
            return doc_nums;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static class DocWrapper
    implements Comparable {
        public int fre = 0;
        public String num = "";
        public String tense = "";

        public DocWrapper(String num, int fre, String tense) {
            this.fre = fre;
            this.num = num;
            this.tense = tense;
        }

        public int compareTo(Object o) {
            if (!(o instanceof DocWrapper)) {
                return -1;
            }
            DocWrapper docIn = (DocWrapper)o;
            if (this.num.equals(docIn.num)) {
                return 0;
            }
            if (this.fre > docIn.fre) {
                return -1;
            }
            return 1;
        }

        public boolean equals(Object o) {
            if (!(o instanceof DocWrapper)) {
                return false;
            }
            DocWrapper docIn = (DocWrapper)o;
            return this.num.equals(docIn.num);
        }
    }
}

