/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gsdl3.action;

import java.util.HashMap;
import org.apache.log4j.Logger;
import org.greenstone.gsdl3.action.Action;
import org.greenstone.gsdl3.util.GSPath;
import org.greenstone.gsdl3.util.GSXML;
import org.greenstone.gsdl3.util.GlobalProperties;
import org.greenstone.gsdl3.util.XMLConverter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PageAction
extends Action {
    static Logger logger = Logger.getLogger((String)PageAction.class.getName());
    public static final String HOME_PAGE = "home";
    public static final String ABOUT_PAGE = "about";
    public static final String PREFS_PAGE = "pref";
    public static final String GLI4GS3_PAGE = "gli4gs3";

    public Node process(Node message_node) {
        Element response;
        Element message = XMLConverter.nodeToElement(message_node);
        Element request = (Element)GSXML.getChildByTagName(message, "request");
        String page_name = request.getAttribute("subaction");
        if (page_name.equals("")) {
            page_name = HOME_PAGE;
        }
        Element result = this.doc.createElement("message");
        if (page_name.equals(HOME_PAGE)) {
            response = this.homePage(request);
        } else if (page_name.equals(ABOUT_PAGE) || page_name.equals(PREFS_PAGE)) {
            response = this.aboutPage(request);
        } else if (page_name.equals(GLI4GS3_PAGE)) {
            response = this.gli4gs3Page(request);
        } else {
            logger.error((Object)"unknown page specified!");
            response = this.unknownPage(request);
        }
        result.appendChild(this.doc.importNode(response, true));
        logger.debug((Object)("page action result: " + XMLConverter.getPrettyString(result)));
        return result;
    }

    protected Element homePage(Element request) {
        NodeList clusters;
        Element cluster_list;
        NodeList services;
        Element service_list;
        NodeList colls;
        String lang = request.getAttribute("lang");
        String uid = request.getAttribute("uid");
        Element info_message = this.doc.createElement("message");
        Element coll_list_request = GSXML.createBasicRequest(this.doc, "describe", "", lang, uid);
        info_message.appendChild(coll_list_request);
        Element info_response_message = (Element)this.mr.process(info_message);
        if (info_response_message == null) {
            logger.error((Object)" couldn't query the message router!");
            return null;
        }
        Element info_response = (Element)GSXML.getChildByTagName(info_response_message, "response");
        if (info_response == null) {
            logger.error((Object)"couldn't query the message router!");
            return null;
        }
        Element collection_list = (Element)GSXML.getChildByTagName(info_response, "collectionList");
        logger.info((Object)GSXML.xmlNodeToString(collection_list));
        if (collection_list != null && (colls = GSXML.getChildrenByTagName(collection_list, "collection")).getLength() > 0) {
            this.sendMultipleRequests(colls, null, "describe", lang, uid);
        }
        if ((service_list = (Element)GSXML.getChildByTagName(info_response, "serviceList")) != null && (services = GSXML.getChildrenByTagName(service_list, "service")).getLength() > 0) {
            this.sendMultipleRequests(services, null, "describe", lang, uid);
        }
        if ((cluster_list = (Element)GSXML.getChildByTagName(info_response, "serviceClusterList")) != null && (clusters = GSXML.getChildrenByTagName(cluster_list, "serviceCluster")).getLength() > 0) {
            this.sendMultipleRequests(clusters, null, "describe", lang, uid);
        }
        return info_response;
    }

    protected Element aboutPage(Element request) {
        String lang = request.getAttribute("lang");
        String uid = request.getAttribute("uid");
        Element cgi_paramList = (Element)GSXML.getChildByTagName(request, "paramList");
        HashMap params = GSXML.extractParams(cgi_paramList, false);
        String coll_name = (String)params.get("c");
        if (coll_name == null || coll_name.equals("")) {
            logger.error((Object)"about page requested with no collection or cluster specified!");
            return this.doc.createElement("response");
        }
        Element coll_about_message = this.doc.createElement("message");
        Element coll_about_request = GSXML.createBasicRequest(this.doc, "describe", coll_name, lang, uid);
        coll_about_message.appendChild(coll_about_request);
        Element coll_about_response = (Element)this.mr.process(coll_about_message);
        String col_type = "";
        NodeList collect_elem = coll_about_response.getElementsByTagName("collection");
        if (collect_elem.getLength() != 0) {
            for (int i = 0; i < collect_elem.getLength(); ++i) {
                Element e = (Element)collect_elem.item(i);
                col_type = e.getAttribute("type");
            }
        } else {
            logger.error((Object)"collection element is null");
        }
        NodeList paramList = request.getElementsByTagName("paramList");
        if (paramList.getLength() != 0) {
            for (int i = 0; i < paramList.getLength(); ++i) {
                Element e = (Element)paramList.item(i);
                Element ct = GSXML.createParameter(request.getOwnerDocument(), "ct", col_type.equalsIgnoreCase("mg") ? "0" : "1");
                e.appendChild(ct);
            }
        } else {
            logger.info((Object)"paramList is null!!");
        }
        if (coll_about_response == null) {
            return null;
        }
        NodeList services = coll_about_response.getElementsByTagName("service");
        if (services.getLength() > 0) {
            this.sendMultipleRequests(services, coll_name, "describe", lang, uid);
        }
        Element response = (Element)GSXML.getChildByTagName(coll_about_response, "response");
        return response;
    }

    protected Element unknownPage(Element request) {
        String lang = request.getAttribute("lang");
        String uid = request.getAttribute("uid");
        String page_name = request.getAttribute("subaction");
        Element cgi_paramList = (Element)GSXML.getChildByTagName(request, "paramList");
        HashMap params = GSXML.extractParams(cgi_paramList, false);
        String coll_name = (String)params.get("c");
        if (coll_name == null || coll_name.equals("")) {
            return this.doc.createElement("response");
        }
        Element coll_about_message = this.doc.createElement("message");
        Element coll_about_request = GSXML.createBasicRequest(this.doc, "describe", coll_name, lang, uid);
        coll_about_message.appendChild(coll_about_request);
        Element coll_about_response = (Element)this.mr.process(coll_about_message);
        Element response = (Element)GSXML.getChildByTagName(coll_about_response, "response");
        return response;
    }

    protected boolean sendMultipleRequests(NodeList items, String path_prefix, String request_type, String lang, String uid) {
        Element message = this.doc.createElement("message");
        for (int i = 0; i < items.getLength(); ++i) {
            Element c = (Element)items.item(i);
            String path = c.getAttribute("name");
            if (path_prefix != null) {
                path = GSPath.appendLink(path_prefix, path);
            }
            Element request = GSXML.createBasicRequest(this.doc, request_type, path, lang, uid);
            message.appendChild(request);
        }
        Element response_message = (Element)this.mr.process(message);
        NodeList responses = response_message.getElementsByTagName("response");
        if (items.getLength() != responses.getLength()) {
            logger.error((Object)"didn't get a response for each request - somethings gone wrong!");
            return false;
        }
        for (int i = 0; i < items.getLength(); ++i) {
            Element c1 = (Element)items.item(i);
            Element c2 = (Element)GSXML.getChildByTagName((Element)responses.item(i), c1.getTagName());
            if (c1 != null && c2 != null && c1.getAttribute("name").endsWith(c2.getAttribute("name"))) {
                GSXML.mergeElements(c1, c2);
                continue;
            }
            logger.error((Object)" response does not correspond to request!");
        }
        return true;
    }

    protected Element gli4gs3Page(Element request) {
        String lang = request.getAttribute("lang");
        String uid = request.getAttribute("uid");
        Element page_response = this.doc.createElement("response");
        Element applet_elem = this.doc.createElement("Applet");
        page_response.appendChild(applet_elem);
        applet_elem.setAttribute("ARCHIVE", "SignedGatherer.jar");
        applet_elem.setAttribute("CODE", "org.greenstone.gatherer.GathererApplet");
        applet_elem.setAttribute("CODEBASE", "applet");
        applet_elem.setAttribute("HEIGHT", "50");
        applet_elem.setAttribute("WIDTH", "380");
        Element gwcgi_param_elem = this.doc.createElement("PARAM");
        gwcgi_param_elem.setAttribute("name", "gwcgi");
        String library_name = GlobalProperties.getGSDL3WebAddress();
        gwcgi_param_elem.setAttribute("value", library_name);
        applet_elem.appendChild(gwcgi_param_elem);
        Element gsdl3_param_elem = this.doc.createElement("PARAM");
        gsdl3_param_elem.setAttribute("name", "gsdl3");
        gsdl3_param_elem.setAttribute("value", "true");
        applet_elem.appendChild(gsdl3_param_elem);
        return page_response;
    }
}

