/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.LuceneWrapper4;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.core.StopAnalyzer;
import org.apache.lucene.analysis.core.StopFilter;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.analysis.util.CharArraySet;
import org.apache.lucene.analysis.util.StopwordAnalyzerBase;
import org.apache.lucene.analysis.util.WordlistLoader;
import org.apache.lucene.util.Version;

public class GS2StandardAnalyzer
extends StopwordAnalyzerBase {
    public static final int DEFAULT_MAX_TOKEN_LENGTH = 255;
    protected int maxTokenLength = 255;
    protected final boolean replaceInvalidAcronym;
    public static final CharArraySet STOP_WORDS_SET = StopAnalyzer.ENGLISH_STOP_WORDS_SET;

    public GS2StandardAnalyzer(Version version, CharArraySet charArraySet) {
        super(version, charArraySet);
        this.replaceInvalidAcronym = true;
    }

    public GS2StandardAnalyzer(Version version) {
        this(version, STOP_WORDS_SET);
    }

    public GS2StandardAnalyzer(Version version, File file) throws IOException {
        this(version, WordlistLoader.getWordSet((Reader)new FileReader(file), version));
    }

    public GS2StandardAnalyzer(Version version, Reader reader) throws IOException {
        this(version, WordlistLoader.getWordSet(reader, version));
    }

    public void setMaxTokenLength(int n) {
        this.maxTokenLength = n;
    }

    public int getMaxTokenLength() {
        return this.maxTokenLength;
    }

    @Override
    protected Analyzer.TokenStreamComponents createComponents(String string, Reader reader) {
        final StandardTokenizer standardTokenizer = new StandardTokenizer(this.matchVersion, reader);
        standardTokenizer.setMaxTokenLength(this.maxTokenLength);
        TokenFilter tokenFilter = new StandardFilter(this.matchVersion, standardTokenizer);
        tokenFilter = new LowerCaseFilter(this.matchVersion, tokenFilter);
        tokenFilter = new StopFilter(this.matchVersion, tokenFilter, this.stopwords);
        return new Analyzer.TokenStreamComponents(standardTokenizer, tokenFilter){

            @Override
            protected void setReader(Reader reader) throws IOException {
                standardTokenizer.setMaxTokenLength(GS2StandardAnalyzer.this.maxTokenLength);
                super.setReader(reader);
            }
        };
    }
}

