/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.server;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;
import org.apache.log4j.Logger;
import org.greenstone.server.BaseServer;

public abstract class BaseServerControl
extends JFrame {
    static Logger logger = Logger.getLogger((String)BaseServerControl.class.getName());
    private static final Dimension FRAME_SIZE = new Dimension(430, 310);
    Color bg_color = Color.white;
    protected JLabel info_label;
    protected JButton enter_button;
    protected JMenu fMenu;
    protected BaseServer server;
    protected JFrame thisframe;

    public BaseServerControl(BaseServer server, String frame_title) {
        super(frame_title);
        this.server = server;
        this.thisframe = this;
        this.setSize(FRAME_SIZE);
        this.setDefaultCloseOperation(3);
        try {
            ImageIcon image = new ImageIcon(this.getClass().getResource("/images/servericon.png"));
            if (image != null) {
                this.setIconImage(image.getImage());
            }
        }
        catch (Exception exception) {
            System.err.println("Error: Could not load servericon.png");
            logger.error((Object)"Error: Could not load servericon.png");
        }
        Dimension screen_size = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screen_size.width - BaseServerControl.FRAME_SIZE.width) / 2, (screen_size.height - BaseServerControl.FRAME_SIZE.height) / 2);
        this.setBackground(Color.white);
        this.addWindowListener(new MyAdapter());
        JPanel title_panel = new JPanel();
        title_panel.setLayout(new BorderLayout());
        JLabel title_label = new JLabel();
        String title = BaseServer.dictionary.get(BaseServer.Property.SERVER_CONTROL + ".Title");
        title_label.setText(this.stringToHTML(title));
        title_label.setOpaque(false);
        title_label.setHorizontalAlignment(0);
        title_label.setFont(new Font("SansSerif", 0, 18));
        JLabel version_label = new JLabel();
        String version = BaseServer.dictionary.get(BaseServer.Property.SERVER_CONTROL + ".Version").toLowerCase();
        version_label.setText(this.stringToHTML(version));
        version_label.setOpaque(false);
        version_label.setHorizontalAlignment(0);
        version_label.setFont(new Font("SansSerif", 0, 14));
        title_panel.add((Component)title_label, "Center");
        title_panel.add((Component)version_label, "South");
        title_panel.setBackground(this.bg_color);
        title_panel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        this.info_label = new JLabel();
        this.info_label.setOpaque(false);
        this.info_label.setHorizontalAlignment(2);
        this.info_label.setVerticalAlignment(0);
        this.info_label.setFont(new Font("SansSerif", 0, 14));
        this.info_label.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        JPanel button_panel = new JPanel(new FlowLayout(1));
        this.enter_button = new JButton();
        this.enter_button.setEnabled(false);
        this.enter_button.addActionListener(new EnterButtonListener());
        this.enter_button.setText(BaseServer.dictionary.get("ServerControl.EnterLibrary"));
        button_panel.add(this.enter_button);
        button_panel.setBackground(this.bg_color);
        button_panel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        this.getRootPane().setDefaultButton(this.enter_button);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)title_panel, "North");
        this.getContentPane().add((Component)this.info_label, "Center");
        this.getContentPane().add((Component)button_panel, "South");
        this.getContentPane().setBackground(this.bg_color);
        this.setJMenuBar(this.createMenu());
        this.setVisible(true);
    }

    protected abstract JMenuBar createMenu();

    protected JMenuBar createMenu(JMenuItem iConf) {
        JMenuBar menuBar = new JMenuBar();
        this.fMenu = new JMenu(BaseServer.dictionary.get("ServerControl.Menu.File"));
        JMenuItem iExit = new JMenuItem(BaseServer.dictionary.get("ServerControl.Menu.Exit"));
        iExit.setBackground(Color.white);
        iExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                BaseServerControl.this.thisframe.dispose();
                BaseServerControl.this.server.stop();
                System.exit(0);
            }
        });
        this.fMenu.add(iConf);
        this.fMenu.add(iExit);
        this.fMenu.setEnabled(false);
        menuBar.add(this.fMenu);
        menuBar.setBorder(new BevelBorder(0));
        return menuBar;
    }

    public void updateControl() {
        switch (this.server.getServerState()) {
            case 4: {
                this.info_label.setText(this.stringToHTML(BaseServer.dictionary.get("ServerControl.Help_EnterLibrary")));
                this.enter_button.setText(this.stringToHTML(BaseServer.dictionary.get("ServerControl.EnterLibrary")));
                this.enter_button.setEnabled(true);
                this.fMenu.setEnabled(true);
                break;
            }
            case 0: {
                this.info_label.setText(this.stringToHTML(BaseServer.dictionary.get("ServerControl.Help_RestartLibrary")));
                this.enter_button.setText(this.stringToHTML(BaseServer.dictionary.get("ServerControl.RestartLibrary")));
                this.enter_button.setEnabled(true);
                this.fMenu.setEnabled(true);
                break;
            }
            case 1: {
                this.enter_button.setText(this.stringToHTML(BaseServer.dictionary.get("ServerControl.StartServer")));
                this.enter_button.setEnabled(true);
                this.fMenu.setEnabled(true);
                break;
            }
            case 2: {
                this.info_label.setText(this.stringToHTML(BaseServer.dictionary.get("ServerControl.BrowserLaunched", new String[]{this.server.getBrowserURL()}) + BaseServer.dictionary.get("ServerControl.Help_RestartLibrary")));
                this.enter_button.setText(this.stringToHTML(BaseServer.dictionary.get("ServerControl.RestartLibrary")));
                this.thisframe.setState(1);
                this.enter_button.setEnabled(true);
                this.fMenu.setEnabled(true);
                break;
            }
            case 3: {
                this.info_label.setText(this.stringToHTML(BaseServer.dictionary.get("ServerControl.BrowserLaunchFailed", new String[]{this.server.getBrowserURL()})));
                this.enter_button.setText(this.stringToHTML(BaseServer.dictionary.get("ServerControl.EnterLibrary")));
                this.enter_button.setEnabled(true);
                this.fMenu.setEnabled(true);
                break;
            }
            default: {
                this.enter_button.setText(BaseServer.dictionary.get("ServerControl.EnterLibrary"));
                this.enter_button.setEnabled(false);
                this.fMenu.setEnabled(false);
            }
        }
    }

    public void displayMessage(String message) {
        this.info_label.setText(this.stringToHTML("<br>" + message));
    }

    private String stringToHTML(String s) {
        return "<html><body>" + s + "</body></html>";
    }

    public void errorMessage(String message) {
        JOptionPane.showMessageDialog(null, message, "Error", 0);
    }

    private class EnterButtonListener
    implements ActionListener {
        private EnterButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            switch (BaseServerControl.this.server.getServerState()) {
                case 4: {
                    Thread runInThread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            BaseServerControl.this.server.start();
                            BaseServerControl.this.server.launchBrowser();
                        }
                    }, "start server and launch browser");
                    runInThread.start();
                    break;
                }
                case 0: {
                    Thread runInThread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            BaseServerControl.this.server.launchBrowser();
                        }
                    }, "launch browser");
                    runInThread.start();
                    break;
                }
                case 1: {
                    Thread runInThread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            BaseServerControl.this.server.start();
                        }
                    }, "start server");
                    runInThread.start();
                    break;
                }
                case 2: 
                case 3: {
                    Thread runInThread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            BaseServerControl.this.server.restart();
                        }
                    }, "restart server");
                    runInThread.start();
                }
            }
        }
    }

    private class MyAdapter
    extends WindowAdapter {
        private MyAdapter() {
        }

        @Override
        public void windowClosing(WindowEvent env) {
            BaseServerControl.this.thisframe.dispose();
            BaseServerControl.this.server.stop();
            System.exit(0);
        }
    }
}

