/*
 * Decompiled with CFR 0.152.
 */
package jdbm.recman;

import java.io.IOException;
import java.util.Enumeration;
import jdbm.RecordManager;
import jdbm.helper.CacheEvictionException;
import jdbm.helper.CachePolicy;
import jdbm.helper.CachePolicyListener;
import jdbm.helper.DefaultSerializer;
import jdbm.helper.Serializer;
import jdbm.helper.WrappedRuntimeException;

public class CacheRecordManager
implements RecordManager {
    protected RecordManager _recman;
    protected CachePolicy _cache;

    public CacheRecordManager(RecordManager recordManager, CachePolicy cachePolicy) {
        if (recordManager == null) {
            throw new IllegalArgumentException("Argument 'recman' is null");
        }
        if (cachePolicy == null) {
            throw new IllegalArgumentException("Argument 'cache' is null");
        }
        this._recman = recordManager;
        this._cache = cachePolicy;
        this._cache.addListener(new CacheListener());
    }

    public RecordManager getRecordManager() {
        return this._recman;
    }

    public CachePolicy getCachePolicy() {
        return this._cache;
    }

    @Override
    public long insert(Object object) throws IOException {
        return this.insert(object, DefaultSerializer.INSTANCE);
    }

    @Override
    public synchronized long insert(Object object, Serializer serializer) throws IOException {
        this.checkIfClosed();
        long l = this._recman.insert(object, serializer);
        try {
            this._cache.put(new Long(l), new CacheEntry(l, object, serializer, false));
        }
        catch (CacheEvictionException cacheEvictionException) {
            throw new WrappedRuntimeException(cacheEvictionException);
        }
        return l;
    }

    @Override
    public synchronized void delete(long l) throws IOException {
        this.checkIfClosed();
        this._recman.delete(l);
        this._cache.remove(new Long(l));
    }

    @Override
    public void update(long l, Object object) throws IOException {
        this.update(l, object, DefaultSerializer.INSTANCE);
    }

    @Override
    public synchronized void update(long l, Object object, Serializer serializer) throws IOException {
        this.checkIfClosed();
        Long l2 = new Long(l);
        try {
            CacheEntry cacheEntry = (CacheEntry)this._cache.get(l2);
            if (cacheEntry != null) {
                cacheEntry._obj = object;
                cacheEntry._serializer = serializer;
                cacheEntry._isDirty = true;
            } else {
                this._cache.put(l2, new CacheEntry(l, object, serializer, true));
            }
        }
        catch (CacheEvictionException cacheEvictionException) {
            throw new IOException(cacheEvictionException.getMessage());
        }
    }

    @Override
    public Object fetch(long l) throws IOException {
        return this.fetch(l, DefaultSerializer.INSTANCE);
    }

    @Override
    public synchronized Object fetch(long l, Serializer serializer) throws IOException {
        this.checkIfClosed();
        Long l2 = new Long(l);
        CacheEntry cacheEntry = (CacheEntry)this._cache.get(l2);
        if (cacheEntry == null) {
            cacheEntry = new CacheEntry(l, null, serializer, false);
            cacheEntry._obj = this._recman.fetch(l, serializer);
            try {
                this._cache.put(l2, cacheEntry);
            }
            catch (CacheEvictionException cacheEvictionException) {
                throw new WrappedRuntimeException(cacheEvictionException);
            }
        }
        return cacheEntry._obj;
    }

    @Override
    public synchronized void close() throws IOException {
        this.checkIfClosed();
        this.updateCacheEntries();
        this._recman.close();
        this._recman = null;
        this._cache = null;
    }

    @Override
    public synchronized int getRootCount() {
        this.checkIfClosed();
        return this._recman.getRootCount();
    }

    @Override
    public synchronized long getRoot(int n) throws IOException {
        this.checkIfClosed();
        return this._recman.getRoot(n);
    }

    @Override
    public synchronized void setRoot(int n, long l) throws IOException {
        this.checkIfClosed();
        this._recman.setRoot(n, l);
    }

    @Override
    public synchronized void commit() throws IOException {
        this.checkIfClosed();
        this.updateCacheEntries();
        this._recman.commit();
    }

    @Override
    public synchronized void rollback() throws IOException {
        this.checkIfClosed();
        this._recman.rollback();
        this._cache.removeAll();
    }

    @Override
    public synchronized long getNamedObject(String string) throws IOException {
        this.checkIfClosed();
        return this._recman.getNamedObject(string);
    }

    @Override
    public synchronized void setNamedObject(String string, long l) throws IOException {
        this.checkIfClosed();
        this._recman.setNamedObject(string, l);
    }

    private void checkIfClosed() throws IllegalStateException {
        if (this._recman == null) {
            throw new IllegalStateException("RecordManager has been closed");
        }
    }

    protected void updateCacheEntries() throws IOException {
        Enumeration enumeration = this._cache.elements();
        while (enumeration.hasMoreElements()) {
            CacheEntry cacheEntry = (CacheEntry)enumeration.nextElement();
            if (!cacheEntry._isDirty) continue;
            this._recman.update(cacheEntry._recid, cacheEntry._obj, cacheEntry._serializer);
            cacheEntry._isDirty = false;
        }
    }

    private class CacheListener
    implements CachePolicyListener {
        private CacheListener() {
        }

        @Override
        public void cacheObjectEvicted(Object object) throws CacheEvictionException {
            CacheEntry cacheEntry = (CacheEntry)object;
            if (cacheEntry._isDirty) {
                try {
                    CacheRecordManager.this._recman.update(cacheEntry._recid, cacheEntry._obj, cacheEntry._serializer);
                }
                catch (IOException iOException) {
                    throw new CacheEvictionException(iOException);
                }
            }
        }
    }

    private class CacheEntry {
        long _recid;
        Object _obj;
        Serializer _serializer;
        boolean _isDirty;

        CacheEntry(long l, Object object, Serializer serializer, boolean bl) {
            this._recid = l;
            this._obj = object;
            this._serializer = serializer;
            this._isDirty = bl;
        }
    }
}

