/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.vmem;

import com.sun.jimi.core.vmem.IntPageFrame;
import com.sun.jimi.core.vmem.PageFrame;
import com.sun.jimi.core.vmem.PageMapper;
import com.sun.jimi.util.RandomAccessStorage;
import java.awt.Dimension;
import java.io.IOException;

public class IntPageMapper
extends PageMapper {
    protected static final int SIZEOF_INT = 4;
    protected IntPageFrame[] pageFrames;
    protected int width;
    protected int height;
    protected int pageWidth;
    protected int pageHeight;
    protected int widthInPages;
    protected int heightInPages;

    public int getPixel(int n, int n2) throws IOException {
        int n3 = this.getLogicalPageNumberForLocation(n, n2);
        return ((IntPageFrame)this.getPageFrameForReading(n3)).getPageData()[n % this.pageWidth + n2 % this.pageHeight * this.pageWidth];
    }

    public void setPixel(int n, int n2, int n3) throws IOException {
        int n4 = this.getLogicalPageNumberForLocation(n, n2);
        ((IntPageFrame)this.getPageFrameForWriting((int)n4)).getPageData()[n % this.pageWidth + n2 % this.pageHeight * this.pageWidth] = n3;
    }

    public void getRectangle(int n, int n2, int n3, int n4, int[] nArray, int n5, int n6) throws IOException {
        int n7 = n5;
        int n8 = n4;
        int n9 = n2;
        while (n8 != 0) {
            int n10 = n3;
            int n11 = n;
            int n12 = Math.min(this.pageHeight - n9 % this.pageHeight, n8);
            while (n10 != 0) {
                int n13 = this.getLogicalPageNumberForLocation(n11, n9);
                IntPageFrame intPageFrame = (IntPageFrame)this.getPageFrameForReading(n13);
                int n14 = Math.min(this.pageWidth - n11 % this.pageWidth, n10);
                int[] nArray2 = intPageFrame.getPageData();
                int n15 = 0;
                while (n15 < n12) {
                    System.arraycopy(nArray2, n11 % this.pageWidth + (n9 % this.pageHeight + n15) * this.pageWidth, nArray, n7 + n11 - n + (n9 - n2 + n15) * n6, n14);
                    ++n15;
                }
                n11 += n14;
                n10 -= n14;
            }
            n9 += n12;
            n8 -= n12;
        }
    }

    public void setRectangle(int n, int n2, int n3, int n4, int[] nArray, int n5, int n6) throws IOException {
        int n7 = n5;
        int n8 = n4;
        int n9 = n2;
        while (n8 != 0) {
            int n10 = n3;
            int n11 = n;
            int n12 = Math.min(this.pageHeight - n9 % this.pageHeight, n8);
            while (n10 != 0) {
                int n13 = this.getLogicalPageNumberForLocation(n11, n9);
                IntPageFrame intPageFrame = (IntPageFrame)this.getPageFrameForWriting(n13);
                int n14 = Math.min(this.pageWidth - n11 % this.pageWidth, n10);
                int[] nArray2 = intPageFrame.getPageData();
                int n15 = 0;
                while (n15 < n12) {
                    System.arraycopy(nArray, n7 + n11 - n + (n9 - n2 + n15) * n6, nArray2, n11 % this.pageWidth + (n9 % this.pageHeight + n15) * this.pageWidth, n14);
                    ++n15;
                }
                n11 += n14;
                n10 -= n14;
            }
            n9 += n12;
            n8 -= n12;
        }
    }

    public void setChannelRectangle(int n, int n2, int n3, int n4, int n5, byte[] byArray, int n6, int n7) throws IOException {
        int n8 = n;
        int n9 = ~(255 << n8);
        int n10 = n6;
        int n11 = n5;
        int n12 = n3;
        while (n11 != 0) {
            int n13 = n4;
            int n14 = n2;
            int n15 = Math.min(this.pageHeight - n12 % this.pageHeight, n11);
            while (n13 != 0) {
                int n16 = this.getLogicalPageNumberForLocation(n14, n12);
                IntPageFrame intPageFrame = (IntPageFrame)this.getPageFrameForWriting(n16);
                int n17 = Math.min(this.pageWidth - n14 % this.pageWidth, n13);
                int[] nArray = intPageFrame.getPageData();
                int n18 = 0;
                while (n18 < n15) {
                    int n19 = n14 % this.pageWidth + (n12 % this.pageHeight + n18) * this.pageWidth;
                    int n20 = n10 + n14 - n2 + (n12 - n3 + n18) * n7;
                    int n21 = 0;
                    while (n21 < n17) {
                        int n22 = n19 + n21;
                        nArray[n22] = nArray[n22] & n9;
                        int n23 = n19 + n21;
                        nArray[n23] = nArray[n23] | (0xFF000000 | (byArray[n20 + n21] & 0xFF) << n8);
                        ++n21;
                    }
                    ++n18;
                }
                n14 += n17;
                n13 -= n17;
            }
            n12 += n15;
            n11 -= n15;
        }
    }

    public int getLogicalPageNumberForLocation(int n, int n2) {
        return n / this.pageWidth + n2 / this.pageHeight * this.widthInPages;
    }

    public int getPageSize() {
        return this.pageWidth * this.pageHeight << 2;
    }

    protected int getPixelSize() {
        return 4;
    }

    public PageFrame[] getPageFrames() {
        return this.pageFrames;
    }

    public Dimension getPageDimensions() {
        return new Dimension(this.pageWidth, this.pageHeight);
    }

    public IntPageMapper(RandomAccessStorage randomAccessStorage, Dimension dimension, int n) {
        super(randomAccessStorage, dimension, n);
        this.width = dimension.width;
        this.height = dimension.height;
        this.pageWidth = this.pageDimensions.width;
        this.pageHeight = this.pageDimensions.height;
        this.widthInPages = this.width % this.pageWidth == 0 ? this.width / this.pageWidth : this.width / this.pageWidth + 1;
        this.heightInPages = this.height % this.pageHeight == 0 ? this.height / this.pageHeight : this.height / this.pageHeight + 1;
        int n2 = this.pageWidth * this.pageHeight;
        this.pageFrames = new IntPageFrame[this.numberOfPageFrames];
        int n3 = 0;
        while (n3 < this.pageFrames.length) {
            this.pageFrames[n3] = new IntPageFrame(n2);
            ++n3;
        }
    }
}

