/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.util;

import java.util.HashMap;
import org.greenstone.gatherer.util.HashMap3D;
import org.greenstone.gatherer.util.Utility;

public class Codec {
    public static final String DECODE_PATH = "DECODE_PATH";
    public static final String DECODE_SQUARE_BRACKETS = "DECODE_SQUARE_BRACKETS";
    public static final String DOM_TO_GREENSTONE = "DOM_TO_GREENSTONE";
    public static final String DOM_TO_TEXT = "DOM_TO_TEXT";
    public static final String ENCODE_PATH = "ENCODE_PATH";
    public static final String ENCODE_SQUARE_BRACKETS = "ENCODE_SQUARE_BRACKETS";
    public static final String ESCAPEDHTML_TO_UNESCAPED = "ESCAPEDHTML_TO_UNESCAPED";
    public static final String REINSTATE_HTML_TAGS = "REINSTATE_HTML_TAGS";
    public static final String GREENSTONE_TO_DOM = "GREENSTONE_TO_DOM";
    public static final String GREENSTONE_TO_TEXT = "GREENSTONE_TO_TEXT";
    public static final String TEXT_TO_DOM = "TEXT_TO_DOM";
    public static final String TEXT_TO_DOM_PRESERVE_TAGS = "TEXT_TO_DOM_PRESERVE_TAGS";
    public static final String TEXT_TO_DOM_PRESERVE_TAGS_GS3 = "TEXT_TO_DOM_PRESERVE_TAGS_GS3";
    public static final String TEXT_TO_GREENSTONE = "TEXT_TO_GREENSTONE";
    public static final String TEXT_TO_REGEXP = "TEXT_TO_REGEXP";
    public static final String TEXT_TO_SHELL_UNIX = "TEXT_TO_SHELL_UNIX";
    public static final String TEXT_TO_SHELL_WINDOWS = "TEXT_TO_SHELL_WINDOWS";
    private static final int MAX_CACHE_SIZE = 100;
    private static HashMap TRANSFORMS = new HashMap();
    private static HashMap3D CACHE;
    private static final char AND_CHAR = '&';
    private static final char ESCAPE_CHAR = '\\';
    private static final char HASH_CHAR = '#';
    private static final char LOWER_U_CHAR = 'u';
    private static final char UPPER_U_CHAR = 'U';
    private static final char SEMICOLON_CHAR = ';';

    public static String transform(String string, String string2) {
        if (string == null) {
            return string;
        }
        String string3 = (String)CACHE.get(string2, string);
        if (string3 == null) {
            string3 = string;
            String[] stringArray = (String[])TRANSFORMS.get(string2);
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; i += 2) {
                    String string4 = stringArray[i];
                    String string5 = stringArray[i + 1];
                    string3 = string3.replaceAll(string4, string5);
                }
            }
            if (CACHE.size() == 100) {
                CACHE.clear();
            }
            CACHE.put(string2, string, string3);
        }
        return string3;
    }

    public static String transformUnicode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        block4: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '&': {
                    char c2;
                    CharSequence charSequence;
                    char c3;
                    if (i + 1 < n && (c3 = string.charAt(i + 1)) == '#') {
                        charSequence = new StringBuffer();
                        int n2 = 2;
                        while (i + n2 < n && (c2 = string.charAt(i + n2)) != ';') {
                            ((StringBuffer)charSequence).append(c2);
                            ++n2;
                        }
                        if (i + n2 < n && string.charAt(i + n2) == ';') {
                            int n3 = Integer.parseInt(((StringBuffer)charSequence).toString());
                            stringBuffer.append((char)n3);
                            i += n2;
                            charSequence = null;
                            continue block4;
                        }
                        charSequence = null;
                    }
                    stringBuffer.append(c);
                    continue block4;
                }
                case '\\': {
                    char c2;
                    CharSequence charSequence;
                    char c3;
                    if (i + 1 < n && ((c3 = string.charAt(i + 1)) == 'U' || c3 == 'u') && i + 5 < n) {
                        charSequence = string.substring(i + 2, i + 6);
                        c2 = Integer.parseInt((String)charSequence, 16);
                        charSequence = null;
                        stringBuffer.append(c2);
                        i += 5;
                        continue block4;
                    }
                    stringBuffer.append(c);
                    continue block4;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 2) {
            System.err.println("Running Test Suite");
            String string = DOM_TO_GREENSTONE;
            System.err.println("Test " + string);
            String string2 = "A &amp;lt;\nand a &lt;a href=&quot;here.html&quot;&gt;&lt;font size=&apos;2&apos;&gt;URL&lt;/font&gt;&lt;/a&gt;";
            System.err.println("Raw:       '" + string2 + "'");
            String string3 = Codec.transform(string2, string);
            System.err.println("Processed: '" + string3 + "'");
            string = DOM_TO_TEXT;
            System.err.println("Test " + string);
            string2 = "A &amp;lt;\nand a &lt;a href=&quot;here.html&quot;&gt;&lt;font size=&apos;2&apos;&gt;URL&lt;/font&gt;&lt;/a&gt;";
            System.err.println("Raw:       '" + string2 + "'");
            string3 = Codec.transform(string2, string);
            System.err.println("Processed: '" + string3 + "'");
            string = GREENSTONE_TO_DOM;
            System.err.println("Test " + string);
            string2 = "A &lt;\\nand a <a href=\\\"here.html\\\"><font size=\\'2\\'URL</font></a>";
            System.err.println("Raw:       '" + string2 + "'");
            string3 = Codec.transform(string2, string);
            System.err.println("Processed: '" + string3 + "'");
            string = GREENSTONE_TO_TEXT;
            System.err.println("Test " + string);
            string2 = "These \\[ \\] should be escaped, and so should \\\\ that. These &quot; &apos; \\n are encoded.";
            System.err.println("Raw:       '" + string2 + "'");
            string3 = Codec.transform(string2, string);
            System.err.println("Processed: '" + string3 + "'");
            string = TEXT_TO_DOM;
            System.err.println("Test " + string);
            string2 = "A &lt;\nand a <a href=\"here.html\"><font size='2'>URL</font></a>";
            System.err.println("Raw:       '" + string2 + "'");
            string3 = Codec.transform(string2, string);
            System.err.println("Processed: '" + string3 + "'");
            string = TEXT_TO_GREENSTONE;
            System.err.println("Test " + string);
            string2 = "These [ ] should be escaped, and so should \\ that. These \" ' \n are encoded.";
            System.err.println("Raw:       '" + string2 + "'");
            string3 = Codec.transform(string2, string);
            System.err.println("Processed: '" + string3 + "'");
            string = "TEXT_TO_SHELL";
            System.err.println("Test " + string);
            if (Utility.isWindows()) {
                System.err.println("[Windows Version]");
                string = TEXT_TO_SHELL_WINDOWS;
            } else {
                System.err.println("[Unix Version]");
                string = TEXT_TO_SHELL_UNIX;
            }
            string2 = "A &lt;\nand a <a href=\"here.html\"><font size='2'>URL</font></a>";
            System.err.println("Raw:       '" + string2 + "'");
            string3 = Codec.transform(string2, string);
            System.err.println("Processed: '" + string3 + "'");
            System.err.println("***** UNICODE TEST *****");
            System.err.println("\\u0030 => " + Codec.transformUnicode("\\u0030"));
            System.err.println("\\u0041 => " + Codec.transformUnicode("\\u0041"));
            System.err.println("\\u007a => " + Codec.transformUnicode("\\u007a"));
            System.err.println("\\u00e7 => " + Codec.transformUnicode("\\u00e7"));
            System.err.println("&#48;   => " + Codec.transformUnicode("&#48;"));
            System.err.println("&#65;   => " + Codec.transformUnicode("&#65;"));
            System.err.println("&#122;  => " + Codec.transformUnicode("&#122;"));
            System.err.println("&#231;  => " + Codec.transformUnicode("&#231;"));
        } else {
            System.err.println("Raw:       '" + stringArray[0] + "'");
            System.err.println("Transform: " + stringArray[1]);
            String string = Codec.transform(stringArray[0], stringArray[1]);
            System.err.println("Processed: '" + string + "'");
        }
    }

    static {
        String[] stringArray = new String[]{"\\|", "\\\\", "&#124;", "\\|"};
        TRANSFORMS.put(DECODE_PATH, stringArray);
        stringArray = null;
        String[] stringArray2 = new String[]{"&#091;", "\\[", "&#093;", "\\]"};
        TRANSFORMS.put(DECODE_SQUARE_BRACKETS, stringArray2);
        stringArray2 = null;
        String[] stringArray3 = new String[]{"&apos;", "\\\\'", "&gt;", ">", "&lt;", "<", "&quot;", "\\\\\"", "&amp;", "&"};
        TRANSFORMS.put(DOM_TO_GREENSTONE, stringArray3);
        stringArray3 = null;
        String[] stringArray4 = new String[]{"&amp;#091;", "\\[", "&amp;#093;", "\\]", "&apos;", "'", "&gt;", ">", "&lt;", "<", "&quot;", "\"", "&amp;", "&"};
        TRANSFORMS.put(DOM_TO_TEXT, stringArray4);
        stringArray4 = null;
        String[] stringArray5 = new String[]{"\\\\", "\\\\\\\\", "\\(", "\\\\(", "\\)", "\\\\)", "\\[", "\\\\[", "\\]", "\\\\]", "\\{", "\\\\{", "\\}", "\\\\}", "\\.", "\\\\."};
        TRANSFORMS.put(TEXT_TO_REGEXP, stringArray5);
        stringArray5 = null;
        String[] stringArray6 = new String[]{"\\|", "&#124;", "\\\\", "\\|"};
        TRANSFORMS.put(ENCODE_PATH, stringArray6);
        stringArray6 = null;
        String[] stringArray7 = new String[]{"\\[", "&#091;", "\\]", "&#093;"};
        TRANSFORMS.put(ENCODE_SQUARE_BRACKETS, stringArray7);
        stringArray7 = null;
        String[] stringArray8 = new String[]{"&", "&amp;", "<", "&lt;", ">", "&gt;", "\\\\\"", "&quot;", "\\\\'", "&apos;", "\"", "&quot;", "'", "&apos;"};
        TRANSFORMS.put(GREENSTONE_TO_DOM, stringArray8);
        stringArray8 = null;
        String[] stringArray9 = new String[]{"\\\\\"", "\"", "\\\\'", "'", "&quot;", "\"", "&apos;", "'", "&#091;", "\\[", "&#093;", "\\]"};
        TRANSFORMS.put(GREENSTONE_TO_TEXT, stringArray9);
        stringArray9 = null;
        String[] stringArray10 = new String[]{"&", "&amp;", "<", "&lt;", ">", "&gt;", "\"", "&quot;", "'", "&apos;"};
        TRANSFORMS.put(TEXT_TO_DOM, stringArray10);
        stringArray10 = null;
        String[] stringArray11 = new String[]{"&", "&amp;", "\"", "&quot;"};
        TRANSFORMS.put(TEXT_TO_DOM_PRESERVE_TAGS, stringArray11);
        stringArray11 = null;
        String[] stringArray12 = new String[]{"&", "&amp;"};
        TRANSFORMS.put(TEXT_TO_DOM_PRESERVE_TAGS_GS3, stringArray12);
        stringArray12 = null;
        String[] stringArray13 = new String[]{"&amp;", "&", "&lt;", "<", "&gt;", ">", "&quot;", "\""};
        TRANSFORMS.put(ESCAPEDHTML_TO_UNESCAPED, stringArray13);
        stringArray13 = null;
        String[] stringArray14 = new String[]{"&lt;", "<", "&gt;", ">"};
        TRANSFORMS.put(REINSTATE_HTML_TAGS, stringArray14);
        stringArray14 = null;
        String[] stringArray15 = new String[]{"\\[", "&#091;", "\\]", "&#093;", "\"", "&quot;", "\n", "\\\\n"};
        TRANSFORMS.put(TEXT_TO_GREENSTONE, stringArray15);
        stringArray15 = null;
        String[] stringArray16 = new String[]{"\"", "\\\\\"", "'", "\\\\'", "\n", "\\\\n"};
        TRANSFORMS.put(TEXT_TO_SHELL_UNIX, stringArray16);
        stringArray16 = null;
        String[] stringArray17 = new String[]{"\"", "\\\\\\\\\\\\\"", "'", "\\\\'", "\n", "\\\\n"};
        TRANSFORMS.put(TEXT_TO_SHELL_WINDOWS, stringArray17);
        stringArray17 = null;
        CACHE = new HashMap3D();
    }
}

