/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.shell;

import java.awt.Component;
import java.util.ArrayList;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.DebugStream;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.cdm.CollectionDesignManager;
import org.greenstone.gatherer.gui.GProgressBar;
import org.greenstone.gatherer.shell.GShellElement;
import org.greenstone.gatherer.shell.GShellEvent;
import org.greenstone.gatherer.shell.GShellProgressMonitor;

public class GBuildProgressMonitor
implements GShellProgressMonitor {
    private static final int MIN = 0;
    private static final int MAX = 1000000;
    static final int BASE = -1;
    static final int BUILD = 0;
    static final int COMPRESSTEXT = 10;
    static final int COMPRESSTEXT_COLLECTTEXTSTATS = 11;
    static final int COMPRESSTEXT_CREATINGCOMPRESS = 12;
    static final int COMPRESSTEXT_COMPRESSINGTEXT = 13;
    static final int INDEX = 20;
    static final int INDEX_CREATINGINDEXDIC = 21;
    static final int INDEX_INVERTINGTEXT = 22;
    static final int INDEX_CREATETHEWEIGHTS = 23;
    static final int INDEX_CREATESTEMMEDDIC = 24;
    static final int INDEX_CREATINGSTEMINDX = 25;
    static final int CREATEINFODATA = 30;
    static final int PHIND = 40;
    static final int PHIND_EXTRACTINGVOCAB = 41;
    static final int PHIND_EXTRACTINGPHRASE = 42;
    static final int PHIND_SORTANDRENUMBER = 43;
    static final int PHIND_PHRASEDATABASES = 44;
    static final int PHIND_WORDLEVELINDEXES = 45;
    static final int PHIND_DOCINFODATABASES = 46;
    static final int CREATINGAUXILARY = 50;
    static final String BADARGUMENT_ELEMENT = "BadArgument";
    static final String BADARGUMENTVALUE_ELEMENT = "BadArgumentValue";
    static final String BADCLASSIFIER_ELEMENT = "BadClassifier";
    static final String BADPLUGIN_ELEMENT = "BadPlugin";
    static final String BUILD_ELEMENT = "Build";
    static final String COLLECTTEXTSTATS_VALUE = "CollectTextStats";
    static final String COMPRESSINGTEXT_VALUE = "CompressingText";
    static final String COMPRESSTEXT_VALUE = "CompressText";
    static final String CREATINGAUXILARY_VALUE = "CreatingAuxilary";
    static final String CREATINGCOMPRESS_VALUE = "CreatingCompress";
    static final String CREATINGINDEXDIC_VALUE = "CreatingIndexDic";
    static final String CREATINGSTEMINDX_VALUE = "CreatingStemIndx";
    static final String CREATEINFODATA_VALUE = "CreateInfoData";
    static final String CREATESTEMMEDDIC_VALUE = "CreateStemmedDic";
    static final String CREATETHEWEIGHTS_VALUE = "CreateTheWeights";
    static final String DOCINFODATABASES_VALUE = "DocInfoDatabases";
    static final String EXTRACTINGPHRASE_VALUE = "ExtractingPhrase";
    static final String EXTRACTINGVOCAB_VALUE = "ExtractingVocab";
    static final String FATALERROR_ELEMENT = "FatalError";
    static final String INDEX_VALUE = "Index";
    static final String INVERTINGTEXT_VALUE = "InvertingText";
    static final String NAME_ATTRIBUTE = "name";
    static final String PHASE_ELEMENT = "Phase";
    static final String PHIND_VALUE = "Phind";
    static final String PHRASEDATABASES_VALUE = "PhraseDatabases";
    static final String SKIPCREATINGCOMP_VALUE = "SkipCreatingComp";
    static final String SORTANDRENUMBER_VALUE = "SortAndRenumber";
    static final String SOURCE_ATTRIBUTE = "source";
    static final String STAGE_ELEMENT = "Stage";
    static final String WARNING_ELEMENT = "Warning";
    static final String WORDLEVELINDEXES_VALUE = "WordLevelIndexes";
    private static final String ARGUMENT_ATTRIBUTE = "a";
    private static final String CLASSIFIER_ATTRIBUTE = "c";
    private static final String PLUGIN_ATTRIBUTE = "p";
    private boolean stop = false;
    private int current_stages = 0;
    private int expected_stages = 0;
    private int threshold = 2;
    private int state = -1;
    private GProgressBar progress_bar;
    private GProgressBar shared_progress_bar;

    public GBuildProgressMonitor(GProgressBar gProgressBar) {
        this.shared_progress_bar = gProgressBar;
        this.progress_bar = new GProgressBar();
        this.progress_bar.setMaximum(1000000);
        this.progress_bar.setMinimum(0);
        this.progress_bar.setString(null);
        this.progress_bar.setStringPainted(true);
        this.setValue(0);
    }

    @Override
    public void addProgressBar(GProgressBar gProgressBar) {
        this.progress_bar = gProgressBar;
        gProgressBar.setMaximum(1000000);
        gProgressBar.setMinimum(0);
        gProgressBar.setStringPainted(false);
        gProgressBar.setString(null);
        this.setValue(0);
    }

    @Override
    public int exitValue() {
        if (this.state == -1) {
            return 0;
        }
        return 1;
    }

    @Override
    public Component getProgress() {
        return this.progress_bar;
    }

    @Override
    public GProgressBar getSharedProgress() {
        return this.shared_progress_bar;
    }

    @Override
    public void messageOnProgressBar(String string) {
        if (string != null && !string.equals("")) {
            this.progress_bar.setString(string);
            this.shared_progress_bar.setString(string);
        } else {
            this.progress_bar.setString(null);
            this.shared_progress_bar.setString(null);
        }
    }

    @Override
    public synchronized boolean hasSignalledStop() {
        return this.stop;
    }

    @Override
    public void increment() {
    }

    @Override
    public void process(ArrayList arrayList) {
        GShellEvent gShellEvent = (GShellEvent)arrayList.get(0);
        String string = gShellEvent.getMessage();
        string = string.substring(string.indexOf(">") + 1);
        if ((string = string.trim()).startsWith("<") && string.endsWith(">")) {
            gShellEvent.veto();
            GShellElement gShellElement = new GShellElement(string);
            String string2 = null;
            String string3 = null;
            switch (this.state) {
                case -1: {
                    string2 = gShellElement.getElementName();
                    if (string2.equals(BUILD_ELEMENT)) {
                        this.progress_bar.setIndeterminate(false);
                        this.state = 0;
                        if (Configuration.getMode() <= this.threshold && !this.stop) {
                            arrayList.add(new GShellEvent(gShellEvent.getSource(), 0, gShellEvent.getType(), Dictionary.get("GShell.Build.BuildBegun1"), gShellEvent.getStatus()));
                        }
                    } else {
                        DebugStream.println("Unknown name: " + string2);
                        this.progress_bar.setIndeterminate(true);
                    }
                    string2 = null;
                    break;
                }
                case 0: {
                    string2 = gShellElement.getElementName();
                    if (string2.equals(STAGE_ELEMENT)) {
                        this.progress_bar.setIndeterminate(false);
                        string3 = gShellElement.getAttribute(NAME_ATTRIBUTE);
                        if (string3.equals(COMPRESSTEXT_VALUE)) {
                            this.state = 10;
                            if (Configuration.getMode() <= this.threshold) {
                                arrayList.add(new GShellEvent(gShellEvent.getSource(), 0, gShellEvent.getType(), Dictionary.get("GShell.Build.CompressText"), gShellEvent.getStatus()));
                            }
                        } else if (string3.equals(INDEX_VALUE)) {
                            this.state = 20;
                            if (Configuration.getMode() <= this.threshold) {
                                String[] stringArray = new String[]{gShellElement.getAttribute(SOURCE_ATTRIBUTE)};
                                arrayList.add(new GShellEvent(gShellEvent.getSource(), 0, gShellEvent.getType(), Dictionary.get("GShell.Build.Index", stringArray), gShellEvent.getStatus()));
                                stringArray = null;
                            }
                        } else if (string3.equals(CREATEINFODATA_VALUE)) {
                            this.state = 30;
                            if (Configuration.getMode() <= this.threshold) {
                                arrayList.add(new GShellEvent(gShellEvent.getSource(), 0, gShellEvent.getType(), Dictionary.get("GShell.Build.InfoDatabase"), gShellEvent.getStatus()));
                            }
                        } else if (string3.equals(PHIND_VALUE)) {
                            this.state = 40;
                            if (Configuration.getMode() <= this.threshold) {
                                arrayList.add(new GShellEvent(gShellEvent.getSource(), 0, gShellEvent.getType(), Dictionary.get("GShell.Build.Phind"), gShellEvent.getStatus()));
                            }
                        } else if (string3.equals(CREATINGAUXILARY_VALUE)) {
                            this.state = 50;
                            if (Configuration.getMode() <= this.threshold) {
                                arrayList.add(new GShellEvent(gShellEvent.getSource(), 0, gShellEvent.getType(), Dictionary.get("GShell.Build.Auxilary"), gShellEvent.getStatus()));
                            }
                        } else {
                            DebugStream.println("Unknown value: " + string3);
                            this.progress_bar.setIndeterminate(true);
                        }
                        string3 = null;
                    } else if (string2.equals(BUILD_ELEMENT) && gShellElement.isClosed()) {
                        this.progress_bar.setIndeterminate(false);
                        this.setValue(1000000);
                        this.state = -1;
                        if (Configuration.getMode() <= this.threshold) {
                            arrayList.add(new GShellEvent(gShellEvent.getSource(), 0, gShellEvent.getType(), Dictionary.get("GShell.Build.BuildComplete1"), gShellEvent.getStatus()));
                        }
                    } else if (string2.equals(BADARGUMENT_ELEMENT)) {
                        if (Configuration.getMode() <= this.threshold) {
                            String[] stringArray = new String[]{gShellElement.getAttribute(ARGUMENT_ATTRIBUTE)};
                            arrayList.add(new GShellEvent(gShellEvent.getSource(), 0, gShellEvent.getType(), Dictionary.get("GShell.BadArgument", stringArray), gShellEvent.getStatus()));
                            stringArray = null;
                        }
                    } else if (string2.equals(BADARGUMENTVALUE_ELEMENT)) {
                        if (Configuration.getMode() <= this.threshold) {
                            String[] stringArray = new String[]{gShellElement.getAttribute(ARGUMENT_ATTRIBUTE)};
                            arrayList.add(new GShellEvent(gShellEvent.getSource(), 0, gShellEvent.getType(), Dictionary.get("GShell.BadArgumentValue", stringArray), gShellEvent.getStatus()));
                            stringArray = null;
                        }
                    } else if (string2.equals(BADPLUGIN_ELEMENT)) {
                        if (Configuration.getMode() <= this.threshold) {
                            String[] stringArray = new String[]{gShellElement.getAttribute(PLUGIN_ATTRIBUTE)};
                            arrayList.add(new GShellEvent(gShellEvent.getSource(), 0, gShellEvent.getType(), Dictionary.get("GShell.BadPluginOptions", stringArray), gShellEvent.getStatus()));
                            stringArray = null;
                        }
                    } else if (string2.equals(BADCLASSIFIER_ELEMENT)) {
                        if (Configuration.getMode() <= this.threshold) {
                            String[] stringArray = new String[]{gShellElement.getAttribute(CLASSIFIER_ATTRIBUTE)};
                            arrayList.add(new GShellEvent(gShellEvent.getSource(), 0, gShellEvent.getType(), Dictionary.get("GShell.BadClassifierOptions", stringArray), gShellEvent.getStatus()));
                            stringArray = null;
                        }
                    } else {
                        DebugStream.println("Unknown name: " + string2);
                        this.progress_bar.setIndeterminate(true);
                    }
                    string2 = null;
                    break;
                }
                case 10: {
                    string2 = gShellElement.getElementName();
                    if (string2.equals(PHASE_ELEMENT)) {
                        string3 = gShellElement.getAttribute(NAME_ATTRIBUTE);
                        if (!string3.equals(COLLECTTEXTSTATS_VALUE)) {
                            if (string3.equals(CREATINGCOMPRESS_VALUE) || string3.equals(SKIPCREATINGCOMP_VALUE)) {
                                this.progress_bar.setIndeterminate(false);
                                this.setValue((int)(((double)this.current_stages + 0.3) * 1000000.0) / this.expected_stages);
                            } else if (string3.equals(COMPRESSINGTEXT_VALUE)) {
                                this.progress_bar.setIndeterminate(false);
                                this.setValue((int)(((double)this.current_stages + 0.6) * 1000000.0) / this.expected_stages);
                            } else {
                                DebugStream.println("Unknown value: " + string3);
                                this.progress_bar.setIndeterminate(true);
                            }
                        }
                        string3 = null;
                    } else if (string2.equals(FATALERROR_ELEMENT)) {
                        arrayList.add(new GShellEvent(gShellEvent.getSource(), 0, gShellEvent.getType(), Dictionary.get("GShell.Build.FatalError"), gShellEvent.getStatus()));
                    } else if (string2.equals(STAGE_ELEMENT) && gShellElement.isClosed()) {
                        ++this.current_stages;
                        this.progress_bar.setIndeterminate(false);
                        this.setValue(this.current_stages * 1000000 / this.expected_stages);
                        this.state = 0;
                    } else {
                        DebugStream.println("Unknown name: " + string2);
                        this.progress_bar.setIndeterminate(true);
                    }
                    string2 = null;
                    break;
                }
                case 20: {
                    string2 = gShellElement.getElementName();
                    if (string2.equals(PHASE_ELEMENT)) {
                        string3 = gShellElement.getAttribute(NAME_ATTRIBUTE);
                        if (!string3.equals(CREATINGINDEXDIC_VALUE)) {
                            if (string3.equals(INVERTINGTEXT_VALUE)) {
                                this.progress_bar.setIndeterminate(false);
                                this.setValue((int)(((double)this.current_stages + 0.2) * 1000000.0) / this.expected_stages);
                            } else if (string3.equals(CREATETHEWEIGHTS_VALUE)) {
                                this.progress_bar.setIndeterminate(false);
                                this.setValue((int)(((double)this.current_stages + 0.4) * 1000000.0) / this.expected_stages);
                            } else if (string3.equals(CREATESTEMMEDDIC_VALUE)) {
                                this.progress_bar.setIndeterminate(false);
                                this.setValue((int)(((double)this.current_stages + 0.6) * 1000000.0) / this.expected_stages);
                            } else if (string3.equals(CREATINGSTEMINDX_VALUE)) {
                                this.progress_bar.setIndeterminate(false);
                                this.setValue((int)(((double)this.current_stages + 0.8) * 1000000.0) / this.expected_stages);
                            } else {
                                DebugStream.println("Unknown value: " + string3);
                                this.progress_bar.setIndeterminate(true);
                            }
                        }
                        string3 = null;
                    } else if (!string2.equals(WARNING_ELEMENT) && !string2.equals(FATALERROR_ELEMENT)) {
                        if (string2.equals(STAGE_ELEMENT) && gShellElement.isClosed()) {
                            ++this.current_stages;
                            this.progress_bar.setIndeterminate(false);
                            this.setValue(this.current_stages * 1000000 / this.expected_stages);
                            this.state = 0;
                        } else {
                            DebugStream.println("Unknown name: " + string2);
                            this.progress_bar.setIndeterminate(true);
                        }
                    }
                    string2 = null;
                    break;
                }
                case 40: {
                    string2 = gShellElement.getElementName();
                    if (string2.equals(PHASE_ELEMENT)) {
                        string3 = gShellElement.getAttribute(NAME_ATTRIBUTE);
                        if (!string3.equals(EXTRACTINGVOCAB_VALUE)) {
                            if (string3.equals(EXTRACTINGPHRASE_VALUE)) {
                                this.progress_bar.setIndeterminate(false);
                                this.setValue((int)(((double)this.current_stages + 0.16) * 1000000.0) / this.expected_stages);
                            } else if (string3.equals(SORTANDRENUMBER_VALUE)) {
                                this.progress_bar.setIndeterminate(false);
                                this.setValue((int)(((double)this.current_stages + 0.33) * 1000000.0) / this.expected_stages);
                            } else if (string3.equals(PHRASEDATABASES_VALUE)) {
                                this.progress_bar.setIndeterminate(false);
                                this.setValue((int)(((double)this.current_stages + 0.5) * 1000000.0) / this.expected_stages);
                            } else if (string3.equals(WORDLEVELINDEXES_VALUE)) {
                                this.progress_bar.setIndeterminate(false);
                                this.setValue((int)(((double)this.current_stages + 0.66) * 1000000.0) / this.expected_stages);
                            } else if (string3.equals(DOCINFODATABASES_VALUE)) {
                                this.progress_bar.setIndeterminate(false);
                                this.setValue((int)(((double)this.current_stages + 0.83) * 1000000.0) / this.expected_stages);
                            } else {
                                DebugStream.println("Unknown value: " + string3);
                                this.progress_bar.setIndeterminate(true);
                            }
                        }
                        string3 = null;
                    } else if (string2.equals(STAGE_ELEMENT) && gShellElement.isClosed()) {
                        ++this.current_stages;
                        this.progress_bar.setIndeterminate(false);
                        this.setValue(this.current_stages * 1000000 / this.expected_stages);
                        this.state = 0;
                    } else {
                        DebugStream.println("Unknown name: " + string2);
                        this.progress_bar.setIndeterminate(true);
                    }
                    string2 = null;
                    break;
                }
                case 30: 
                case 50: {
                    string2 = gShellElement.getElementName();
                    if (string2.equals(STAGE_ELEMENT) && gShellElement.isClosed()) {
                        ++this.current_stages;
                        this.progress_bar.setIndeterminate(false);
                        this.setValue(this.current_stages * 1000000 / this.expected_stages);
                        this.state = 0;
                    } else {
                        DebugStream.println("Unknown name: " + string2);
                        this.progress_bar.setIndeterminate(true);
                    }
                    string2 = null;
                    break;
                }
                default: {
                    DebugStream.println("Unknown name: " + string2);
                    this.progress_bar.setIndeterminate(true);
                    break;
                }
            }
        } else if (Configuration.getMode() <= this.threshold) {
            gShellEvent.veto();
        }
    }

    @Override
    public void reset() {
        this.current_stages = 0;
        this.expected_stages = 0;
        this.progress_bar.setIndeterminate(false);
        this.progress_bar.setString(null);
        this.setValue(0);
        this.state = -1;
        this.progress_bar.updateUI();
    }

    @Override
    public void saving() {
    }

    public void setSharedProgressBar(GProgressBar gProgressBar) {
        this.shared_progress_bar = gProgressBar;
    }

    @Override
    public synchronized void setStop(boolean bl) {
        this.stop = bl;
        this.progress_bar.setIndeterminate(false);
    }

    @Override
    public void start() {
        this.stop = false;
        this.setValue(0);
        this.expected_stages = 3;
        CollectionDesignManager collectionDesignManager = Gatherer.c_man.getCollection().cdm;
        if (CollectionDesignManager.index_manager.isMGPP()) {
            ++this.expected_stages;
        } else if (CollectionDesignManager.index_manager.isLucene()) {
            int n = CollectionDesignManager.index_manager.getNumLevels();
            if (n == 0) {
                n = 1;
            }
            this.expected_stages += n;
        } else {
            int n;
            int n2 = CollectionDesignManager.index_manager.getNumIndexes();
            int n3 = CollectionDesignManager.subcollectionindex_manager.getSize();
            if (n3 > 0) {
                n2 *= n3;
            }
            if ((n = CollectionDesignManager.language_manager.getSize()) > 0) {
                n2 *= n;
            }
            this.expected_stages += n2;
        }
        if (CollectionDesignManager.classifier_manager.isPhindClassifierAssigned()) {
            ++this.expected_stages;
        }
        collectionDesignManager = null;
    }

    @Override
    public void stop() {
        this.progress_bar.setIndeterminate(false);
        this.setValue(1000000);
    }

    private void setValue(int n) {
        this.progress_bar.setValue(n);
        if (n > 0) {
            this.shared_progress_bar.setValue(1000000 + n);
        }
    }
}

