/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.remote;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.greenstone.gatherer.remote.ZipTools;

public class ZipCollectionConfigurations {
    public static void main(String[] stringArray) {
        if (stringArray.length != 4) {
            System.err.println("Usage: ZipCollectionConfigurations <zip-file> <collect-directory-path> <user-name> <user-groups>");
            return;
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        String string4 = stringArray[3];
        if (!string2.endsWith(File.separator)) {
            string2 = string2 + File.separator;
        }
        File file = new File(string2);
        try {
            ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(string));
            CollectionEtcZipFilter collectionEtcZipFilter = new CollectionEtcZipFilter();
            CollectionMetadataZipFilter collectionMetadataZipFilter = new CollectionMetadataZipFilter();
            ZipCollectionConfigurations.addUserAccessibleCollections(string2, "", file, zipOutputStream, collectionEtcZipFilter, collectionMetadataZipFilter, string3, string4);
            zipOutputStream.putNextEntry(new ZipEntry(".gli"));
            zipOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void addUserAccessibleCollections(String string, String string2, File file, ZipOutputStream zipOutputStream, ZipTools.ZipFilter zipFilter, ZipTools.ZipFilter zipFilter2, String string3, String string4) {
        if (!string2.equals("")) {
            string2 = string2 + File.separator;
        }
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            String string5;
            if (!fileArray[i].isDirectory() || !ZipCollectionConfigurations.checkAccess(string5 = fileArray[i].getName(), string3, string4)) continue;
            String string6 = string2 + fileArray[i].getName() + File.separator + "etc";
            ZipTools.addFileToZip(zipOutputStream, string, string6, zipFilter);
            String string7 = string2 + fileArray[i].getName() + File.separator + "metadata";
            File file2 = new File(string + File.separator + string7);
            if (file2.exists()) {
                ZipTools.addFileToZip(zipOutputStream, string, string7, zipFilter2);
                continue;
            }
            File file3 = new File(fileArray[i], "etc" + File.separator + "collect.cfg");
            if (!file3.exists()) continue;
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file3)));
                String string8 = null;
                while ((string8 = bufferedReader.readLine()) != null) {
                    if (!(string8 = string8.trim()).startsWith("collectgroup") || !string8.endsWith("true")) continue;
                    ZipCollectionConfigurations.addUserAccessibleCollections(string, string2 + fileArray[i].getName(), fileArray[i], zipOutputStream, zipFilter, zipFilter2, string3, string4);
                }
                bufferedReader.close();
                continue;
            }
            catch (Exception exception) {
                System.err.println("Exception reading from file " + file3 + ": " + exception);
                exception.printStackTrace();
            }
        }
    }

    private static boolean checkAccess(String string, String string2, String string3) {
        String[] stringArray = string3.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("administrator") || stringArray[i].equals("all-collections-editor")) {
                return true;
            }
            if (stringArray[i].equals("shared-collections-editor") && !string.contains("@")) {
                return true;
            }
            if (stringArray[i].equals("personal-collections-editor") && string.startsWith(string2 + "@")) {
                return true;
            }
            if (!stringArray[i].equals(string + "-collection-editor")) continue;
            return true;
        }
        return false;
    }

    private static class CollectionMetadataZipFilter
    extends ZipTools.NullZipFilter {
        private CollectionMetadataZipFilter() {
        }

        @Override
        public boolean shouldIncludeFileContent(String string) {
            return false;
        }
    }

    private static class CollectionEtcZipFilter
    extends ZipTools.NullZipFilter {
        private CollectionEtcZipFilter() {
        }

        @Override
        public boolean shouldIncludeFile(String string) {
            if (string.endsWith("collect.cfg")) {
                return string.equals("collect.cfg") || string.endsWith(File.separator + "collect.cfg");
            }
            if (string.endsWith("collectionConfig.xml")) {
                return string.equals("collectionConfig.xml") || string.endsWith(File.separator + "collectionConfig.xml");
            }
            return false;
        }
    }
}

