/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.remote;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class Unzip {
    public static final void copyInputStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) >= 0) {
            outputStream.write(byArray, 0, n);
        }
        inputStream.close();
        outputStream.close();
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 2) {
            System.err.println("Usage: Unzip <zip-file> <destination-directory>");
            return;
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        if (!string2.endsWith(File.separator)) {
            string2 = string2 + File.separator;
        }
        try {
            ZipFile zipFile = new ZipFile(string);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                File file;
                String string3;
                String string4;
                ZipEntry zipEntry = enumeration.nextElement();
                if (zipEntry.isDirectory()) {
                    string4 = zipEntry.getName();
                    string3 = string2 + string4;
                    file = new File(string3);
                    file.mkdir();
                    continue;
                }
                string4 = zipEntry.getName();
                string3 = string2 + string4;
                file = new File(string3).getParentFile();
                if (!file.exists() && !file.mkdirs()) {
                    System.err.println("Error: Could not create directory " + file + "!");
                }
                FileOutputStream fileOutputStream = new FileOutputStream(string3);
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                Unzip.copyInputStream(zipFile.getInputStream(zipEntry), bufferedOutputStream);
            }
            zipFile.close();
        }
        catch (Exception exception) {
            System.out.println("ERROR: " + exception);
            exception.printStackTrace();
            System.exit(1);
        }
    }
}

