/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.metadata;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.DebugStream;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.collection.CollectionTreeNode;
import org.greenstone.gatherer.gui.ModalDialog;
import org.greenstone.gatherer.gui.WarningDialog;
import org.greenstone.gatherer.metadata.DocXMLFileManager;
import org.greenstone.gatherer.metadata.MetadataElement;
import org.greenstone.gatherer.metadata.MetadataSetManager;
import org.greenstone.gatherer.metadata.MetadataValue;
import org.greenstone.gatherer.metadata.MetadataValueTableEntry;
import org.greenstone.gatherer.metadata.MetadataValueTreeNode;
import org.greenstone.gatherer.metadata.MetadataXMLFileManager;

public class MetadataValueTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 0L;
    private CollectionTreeNode[] file_nodes = null;
    private ArrayList metadata_value_table_entries = new ArrayList();
    private static final String[] COLUMN_NAMES = new String[]{"", Dictionary.get("Metadata.Element"), Dictionary.get("Metadata.Value")};

    public int addBlankRowForMetadataElement(MetadataElement metadataElement) {
        MetadataValueTableModelBuilder metadataValueTableModelBuilder = new MetadataValueTableModelBuilder();
        MetadataValue metadataValue = new MetadataValue(metadataElement, new MetadataValueTreeNode(""));
        return metadataValueTableModelBuilder.insertMetadataValue(metadataValue);
    }

    public int findMetadataValueTableEntryToSelect(MetadataValueTableEntry metadataValueTableEntry) {
        MetadataElement metadataElement = metadataValueTableEntry.getMetadataElement();
        for (int i = 0; i < this.metadata_value_table_entries.size(); ++i) {
            int n;
            MetadataValueTableEntry metadataValueTableEntry2 = (MetadataValueTableEntry)this.metadata_value_table_entries.get(i);
            int n2 = MetadataSetManager.compareMetadataElements(metadataValueTableEntry2.getMetadataElement(), metadataElement);
            if (n2 == 0 && (n = metadataValueTableEntry2.compareTo(metadataValueTableEntry)) == 0) {
                return i;
            }
            if (n2 <= 0) continue;
            return i - 1;
        }
        return this.metadata_value_table_entries.size() - 1;
    }

    public Class getColumnClass(int n) {
        return this.getValueAt(0, n).getClass();
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public String getColumnName(int n) {
        return COLUMN_NAMES[n];
    }

    public synchronized MetadataValueTableEntry getMetadataValueTableEntry(int n) {
        if (n >= 0 && n < this.metadata_value_table_entries.size()) {
            return (MetadataValueTableEntry)this.metadata_value_table_entries.get(n);
        }
        return null;
    }

    @Override
    public int getRowCount() {
        return this.metadata_value_table_entries.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n < 0 || n >= this.metadata_value_table_entries.size() || n2 < 0 || n2 >= COLUMN_NAMES.length) {
            return null;
        }
        MetadataValueTableEntry metadataValueTableEntry = (MetadataValueTableEntry)this.metadata_value_table_entries.get(n);
        if (metadataValueTableEntry == null) {
            System.err.println("\n@@@@@ MetadataValueTableModel.getValueAt(): metadata_value_table_entry is unexpectedly null!\n");
            return null;
        }
        if (n2 == 0 && metadataValueTableEntry.isInheritedMetadata()) {
            return metadataValueTableEntry.getFolderMetadataInheritedFrom();
        }
        if (n2 == 1) {
            return metadataValueTableEntry.getMetadataElement();
        }
        if (n2 == 2) {
            return this.decodeHTMLEntities(metadataValueTableEntry.getFullValue());
        }
        return null;
    }

    public String decodeHTMLEntities(String string) {
        string = string.replace("&amp;#40;", "(");
        string = string.replace("&amp;#41;", ")");
        string = string.replace("&amp;#44;", ",");
        string = string.replace("&amp;#60;", "<");
        string = string.replace("&amp;#62;", ">");
        string = string.replace("&amp;#91;", "[");
        string = string.replace("&amp;#93;", "]");
        string = string.replace("&amp;#123;", "{");
        string = string.replace("&amp;#125;", "}");
        return string;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (n2 < 2) {
            return false;
        }
        MetadataValueTableEntry metadataValueTableEntry = (MetadataValueTableEntry)this.metadata_value_table_entries.get(n);
        return !metadataValueTableEntry.getMetadataElement().isExtractedMetadataElement() && !metadataValueTableEntry.isInheritedMetadata();
    }

    public boolean isCommon(MetadataValueTableEntry metadataValueTableEntry) {
        return this.file_nodes != null && metadataValueTableEntry.getOccurrences() == this.file_nodes.length;
    }

    public boolean isCommon(int n) {
        if (n >= 0 && n < this.metadata_value_table_entries.size()) {
            return this.isCommon((MetadataValueTableEntry)this.metadata_value_table_entries.get(n));
        }
        return false;
    }

    public void rebuild(CollectionTreeNode[] collectionTreeNodeArray) {
        this.file_nodes = collectionTreeNodeArray;
        this.metadata_value_table_entries.clear();
        if (!Gatherer.c_man.ready()) {
            return;
        }
        if (collectionTreeNodeArray == null || collectionTreeNodeArray.length == 0) {
            return;
        }
        MetadataValueTableModelBuilder metadataValueTableModelBuilder = new MetadataValueTableModelBuilder();
        metadataValueTableModelBuilder.run();
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        MetadataValueTableEntry metadataValueTableEntry = this.getMetadataValueTableEntry(n);
        if (metadataValueTableEntry == null) {
            System.err.println("\n@@@@@ MetadataValueTableModel.setValueAt(): metadata_value_table_entry is unexpectedly null!\n");
            return;
        }
        String string = metadataValueTableEntry.getFullValue();
        if (object.equals(string)) {
            return;
        }
        Gatherer.g_man.wait(true);
        MetadataElement metadataElement = metadataValueTableEntry.getMetadataElement();
        if (!object.equals("") && metadataElement.isRestricted() && metadataElement.getMetadataValueTreeNode((String)object) == null) {
            WarningDialog warningDialog = new WarningDialog("warning.InvalidMetadata", Dictionary.get("InvalidMetadata.Title"), Dictionary.get("InvalidMetadata.Message"), null, false);
            int n3 = warningDialog.display();
            warningDialog.dispose();
            Gatherer.g_man.wait(false);
            return;
        }
        if (string.equals("") && !object.equals("")) {
            Serializable serializable;
            if (!this.file_nodes[0].isLeaf()) {
                serializable = new WarningDialog("warning.DirectoryLevelMetadata", Dictionary.get("DirectoryLevelMetadata.Title"), Dictionary.get("DirectoryLevelMetadata.Message"), null, true);
                int n4 = ((WarningDialog)serializable).display();
                ((ModalDialog)serializable).dispose();
                if (n4 != 0) {
                    Gatherer.g_man.wait(false);
                    return;
                }
            }
            serializable = metadataElement.addMetadataValue((String)object);
            MetadataValue metadataValue = new MetadataValue(metadataElement, (MetadataValueTreeNode)serializable);
            metadataValue.setIsAccumulatingMetadata(true);
            new AppendMetadataTask(metadataValue).run();
        } else if (!string.equals("") && object.equals("")) {
            new RemoveMetadataTask(metadataValueTableEntry).run();
        } else {
            MetadataValueTreeNode metadataValueTreeNode = metadataElement.addMetadataValue((String)object);
            MetadataValue metadataValue = new MetadataValue(metadataElement, metadataValueTreeNode);
            metadataValue.setIsAccumulatingMetadata(!metadataValueTableEntry.isInheritedMetadata());
            new ReplaceMetadataTask(metadataValueTableEntry, metadataValue).run();
        }
    }

    private class MetadataValueTableModelBuilder {
        private MetadataValueTableModelBuilder() {
        }

        public void run() {
            Object object;
            boolean bl = false;
            ArrayList<MetadataElement> arrayList = new ArrayList<MetadataElement>();
            for (int i = 0; i < MetadataValueTableModel.this.file_nodes.length; ++i) {
                Object object2;
                File file = MetadataValueTableModel.this.file_nodes[i].getFile();
                object = MetadataXMLFileManager.getMetadataAssignedToFile(file);
                for (int j = 0; j < ((ArrayList)object).size(); ++j) {
                    MetadataValue metadataValue = (MetadataValue)((ArrayList)object).get(j);
                    object2 = metadataValue.getMetadataElement();
                    this.insertMetadataValue(metadataValue);
                    if (arrayList.contains(object2)) continue;
                    arrayList.add((MetadataElement)object2);
                }
                if (!Configuration.get("general.view_extracted_metadata", true)) continue;
                ArrayList arrayList2 = DocXMLFileManager.getMetadataExtractedFromFile(file);
                for (int j = 0; j < arrayList2.size(); ++j) {
                    object2 = (MetadataValue)arrayList2.get(j);
                    this.insertMetadataValue((MetadataValue)object2);
                }
            }
            ArrayList arrayList3 = MetadataSetManager.getEveryMetadataSetElement();
            for (int i = 0; i < arrayList3.size(); ++i) {
                object = (MetadataElement)arrayList3.get(i);
                if (arrayList.contains(object) || ((MetadataElement)object).isExtractedMetadataElement()) continue;
                MetadataValueTableEntry metadataValueTableEntry = new MetadataValueTableEntry((MetadataElement)object, new MetadataValueTreeNode(""));
                metadataValueTableEntry.setOccurrences(MetadataValueTableModel.this.file_nodes.length);
                this.insertMetadataValueTableEntry(metadataValueTableEntry);
            }
            if (bl) {
                this.showExtractedMetadataWarning();
            }
        }

        private int insertMetadataValue(MetadataValue metadataValue) {
            return this.insertMetadataValueTableEntry(new MetadataValueTableEntry(metadataValue));
        }

        private int insertMetadataValueTableEntry(MetadataValueTableEntry metadataValueTableEntry) {
            MetadataElement metadataElement = metadataValueTableEntry.getMetadataElement();
            for (int i = 0; i < MetadataValueTableModel.this.metadata_value_table_entries.size(); ++i) {
                int n;
                MetadataValueTableEntry metadataValueTableEntry2 = (MetadataValueTableEntry)MetadataValueTableModel.this.metadata_value_table_entries.get(i);
                int n2 = MetadataSetManager.compareMetadataElements(metadataValueTableEntry2.getMetadataElement(), metadataElement);
                if (n2 == 0 && (n = metadataValueTableEntry2.compareTo(metadataValueTableEntry)) == 0) {
                    if (!metadataValueTableEntry.getFullValue().equals("")) {
                        metadataValueTableEntry2.anotherOccurrence();
                    }
                    return i;
                }
                if (n2 <= 0) continue;
                MetadataValueTableModel.this.metadata_value_table_entries.add(i, metadataValueTableEntry);
                MetadataValueTableModel.this.fireTableRowsInserted(i, i);
                return i;
            }
            MetadataValueTableModel.this.metadata_value_table_entries.add(metadataValueTableEntry);
            MetadataValueTableModel.this.fireTableRowsInserted(MetadataValueTableModel.this.metadata_value_table_entries.size() - 1, MetadataValueTableModel.this.metadata_value_table_entries.size() - 1);
            return MetadataValueTableModel.this.metadata_value_table_entries.size() - 1;
        }

        private void showExtractedMetadataWarning() {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    WarningDialog warningDialog = new WarningDialog("warning.ExtractedMetadata", Dictionary.get("ExtractedMetadata.Title"), Dictionary.get("ExtractedMetadata.Message"), null, false);
                    warningDialog.display();
                    warningDialog.dispose();
                    warningDialog = null;
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    private class RemoveMetadataTask {
        private MetadataValueTableEntry selected_metadata_value_table_entry = null;

        private RemoveMetadataTask(MetadataValueTableEntry metadataValueTableEntry) {
            this.selected_metadata_value_table_entry = metadataValueTableEntry;
        }

        public void run() {
            try {
                MetadataXMLFileManager.removeMetadata(MetadataValueTableModel.this.file_nodes, this.selected_metadata_value_table_entry);
            }
            catch (Exception exception) {
                DebugStream.printStackTrace(exception);
            }
            Gatherer.g_man.wait(false);
        }
    }

    private class ReplaceMetadataTask {
        private MetadataValueTableEntry selected_metadata_value_table_entry = null;
        private MetadataValue metadata_value = null;

        private ReplaceMetadataTask(MetadataValueTableEntry metadataValueTableEntry, MetadataValue metadataValue) {
            this.selected_metadata_value_table_entry = metadataValueTableEntry;
            this.metadata_value = metadataValue;
        }

        public void run() {
            try {
                MetadataXMLFileManager.replaceMetadata(MetadataValueTableModel.this.file_nodes, this.selected_metadata_value_table_entry, this.metadata_value);
            }
            catch (Exception exception) {
                DebugStream.printStackTrace(exception);
            }
            Gatherer.g_man.wait(false);
        }
    }

    private class AppendMetadataTask {
        private MetadataValue metadata_value = null;

        private AppendMetadataTask(MetadataValue metadataValue) {
            this.metadata_value = metadataValue;
        }

        public void run() {
            try {
                MetadataXMLFileManager.addMetadata(MetadataValueTableModel.this.file_nodes, this.metadata_value);
            }
            catch (Exception exception) {
                DebugStream.printStackTrace(exception);
            }
            Gatherer.g_man.wait(false);
        }
    }
}

