/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.metadata;

import java.io.File;
import java.util.ArrayList;
import javax.swing.filechooser.FileFilter;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.metadata.MetadataElement;
import org.greenstone.gatherer.metadata.MetadataTools;
import org.greenstone.gatherer.util.XMLTools;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MetadataSet {
    private File metadata_set_file = null;
    private ArrayList metadata_set_elements = new ArrayList();
    private String metadata_set_namespace = null;

    public MetadataSet(File file) {
        this.metadata_set_file = file;
        Document document = XMLTools.parseXMLFile(file);
        if (document == null) {
            System.err.println("Error: Could not parse metadata set file " + file.getAbsolutePath());
            return;
        }
        this.metadata_set_namespace = document.getDocumentElement().getAttribute("namespace");
        NodeList nodeList = document.getElementsByTagName("Element");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string;
            Element element = (Element)nodeList.item(i);
            String string2 = element.getAttribute("name");
            Element element2 = (Element)element.getParentNode();
            while (element2.getTagName().equals("Element")) {
                string = element2.getAttribute("name");
                string2 = string + "^" + string2;
                element2 = (Element)element2.getParentNode();
            }
            string = this.metadata_set_namespace + "." + string2;
            this.metadata_set_elements.add(new MetadataElement(string, element));
        }
    }

    public MetadataElement addMetadataElementForThisSession(String string) {
        String string2 = this.metadata_set_namespace + "." + string;
        MetadataElement metadataElement = new MetadataElement(string2, null);
        this.metadata_set_elements.add(metadataElement);
        return metadataElement;
    }

    public int compareMetadataElements(MetadataElement metadataElement, MetadataElement metadataElement2) {
        if (this.metadata_set_namespace.equals("ex")) {
            return metadataElement.getName().compareTo(metadataElement2.getName());
        }
        return this.metadata_set_elements.indexOf(metadataElement) - this.metadata_set_elements.indexOf(metadataElement2);
    }

    public boolean equals(Object object) {
        if (object instanceof MetadataSet) {
            return this.toString().equals(object.toString());
        }
        return false;
    }

    public String getAttribute(String string, String string2) {
        Object object;
        Element element;
        Document document = XMLTools.parseXMLFile(this.metadata_set_file);
        if (document == null) {
            System.err.println("Error: Could not parse metadata set file " + this.metadata_set_file.getAbsolutePath());
            return null;
        }
        Element element2 = element = document.getDocumentElement();
        boolean bl = false;
        NodeList nodeList = element.getElementsByTagName("SetLanguage");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element3 = (Element)nodeList.item(i);
            object = element3.getAttribute("code");
            if (!((String)object).equals(string2)) continue;
            element2 = element3;
            bl = true;
            break;
        }
        NodeList nodeList2 = element2.getElementsByTagName(string);
        for (int i = 0; i < nodeList2.getLength(); ++i) {
            object = (Element)nodeList2.item(i);
            String string3 = object.getAttribute("language");
            if (!bl && !string3.equals(string2)) continue;
            return XMLTools.getElementTextValue((Element)object);
        }
        return null;
    }

    public MetadataElement getMetadataElementWithDisplayName(String string) {
        for (int i = 0; i < this.metadata_set_elements.size(); ++i) {
            MetadataElement metadataElement = (MetadataElement)this.metadata_set_elements.get(i);
            if (!metadataElement.getDisplayName().equals(string)) continue;
            return metadataElement;
        }
        return null;
    }

    public MetadataElement getMetadataElementWithName(String string) {
        for (int i = 0; i < this.metadata_set_elements.size(); ++i) {
            MetadataElement metadataElement = (MetadataElement)this.metadata_set_elements.get(i);
            if (!metadataElement.getName().equals(string)) continue;
            return metadataElement;
        }
        return null;
    }

    public ArrayList getMetadataSetElements() {
        return (ArrayList)this.metadata_set_elements.clone();
    }

    public File getMetadataSetFile() {
        return this.metadata_set_file;
    }

    public String getNamespace() {
        return this.metadata_set_namespace;
    }

    public String toString() {
        return MetadataTools.getMetadataSetAttribute(this, "Name", Configuration.getLanguage(), "en") + " (" + this.metadata_set_namespace + ")";
    }

    public static class MetadataSetFileFilter
    extends FileFilter {
        @Override
        public boolean accept(File file) {
            String string = file.getName().toLowerCase();
            return string.endsWith(".mds") || string.indexOf(".") == -1;
        }

        @Override
        public String getDescription() {
            return Dictionary.get("MetadataSet.Files");
        }
    }
}

