/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.gui.metaaudit;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.collection.CollectionTreeNode;
import org.greenstone.gatherer.gui.GLIButton;
import org.greenstone.gatherer.gui.ModalDialog;
import org.greenstone.gatherer.gui.SimpleMenuBar;
import org.greenstone.gatherer.gui.metaaudit.AutofilterDialog;
import org.greenstone.gatherer.gui.metaaudit.MetaAuditTable;

public class MetaAuditFrame
extends ModalDialog
implements TreeSelectionListener {
    public AutofilterDialog autofilter_dialog = new AutofilterDialog(this);
    private boolean invalid = true;
    private CollectionTreeNode[] records = null;
    private MetaAuditFrame self = this;
    private MetaAuditTable table = new MetaAuditTable(this);
    private static final Dimension SIZE = new Dimension(640, 505);

    public MetaAuditFrame() {
        super(Gatherer.g_man);
        this.setComponentOrientation(Dictionary.getOrientation());
        this.setDefaultCloseOperation(1);
        this.setSize(SIZE);
        this.setTitle(Dictionary.get("MetaAudit.Title"));
        this.setJMenuBar(new SimpleMenuBar("reviewingmetadata"));
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setComponentOrientation(Dictionary.getOrientation());
        JPanel jPanel2 = new JPanel();
        jPanel2.setComponentOrientation(Dictionary.getOrientation());
        GLIButton gLIButton = new GLIButton(Dictionary.get("MetaAudit.Close"), Dictionary.get("MetaAudit.Close_Tooltip"));
        gLIButton.addActionListener(new CloseListener());
        Gatherer.c_man.getCollectionTree().addTreeSelectionListener(this);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)gLIButton, "Center");
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)new JScrollPane(this.table), "Center");
        jPanel.add((Component)jPanel2, "South");
        Dimension dimension = Configuration.screen_size;
        this.setLocation((dimension.width - MetaAuditFrame.SIZE.width) / 2, (dimension.height - MetaAuditFrame.SIZE.height) / 2);
        dimension = null;
        gLIButton = null;
        jPanel2 = null;
        jPanel = null;
    }

    public void destroy() {
        this.records = null;
        this.self = null;
        this.table = null;
    }

    public void display() {
        if (this.invalid) {
            this.rebuildModel();
        }
        this.setVisible(true);
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreePath[] treePathArray;
        Object object = treeSelectionEvent.getSource();
        if (object instanceof JTree && (treePathArray = ((JTree)object).getSelectionPaths()) != null) {
            this.records = new CollectionTreeNode[treePathArray.length];
            for (int i = 0; i < treePathArray.length; ++i) {
                this.records[i] = (CollectionTreeNode)treePathArray[i].getLastPathComponent();
            }
            if (this.isVisible()) {
                this.rebuildModel();
            } else {
                this.invalid = true;
            }
        }
    }

    public void wait(boolean bl) {
        Component component = this.getGlassPane();
        if (bl) {
            component.setCursor(Cursor.getPredefinedCursor(3));
            component.setVisible(true);
        } else {
            component.setVisible(false);
            component.setCursor(Cursor.getPredefinedCursor(0));
        }
        component = null;
    }

    private void rebuildModel() {
        this.table.newModel(this.records);
        this.invalid = false;
    }

    private class CloseListener
    implements ActionListener {
        private CloseListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MetaAuditFrame.this.self.setVisible(false);
        }
    }
}

