/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.collection.CollectionManager;
import org.greenstone.gatherer.gui.GLIButton;
import org.greenstone.gatherer.gui.ModalDialog;
import org.greenstone.gatherer.gui.WarningDialog;
import org.greenstone.gatherer.util.JarTools;
import org.greenstone.gatherer.util.Utility;

public class WarnIncrBuildDialog
extends ModalDialog
implements ActionListener,
KeyListener {
    public static final int CANCEL = 0;
    public static final int USE_KEEPOLD = 1;
    public static final int REMOVE_KEEPOLD = 2;
    private static final Dimension SIZE = new Dimension(650, 200);
    private int result = 2;
    private JButton revert_button;
    private JButton remove_button;
    private JButton cancel_button;

    public WarnIncrBuildDialog() {
        super(Gatherer.g_man, "Warning", true);
        this.setComponentOrientation(Dictionary.getOrientation());
        this.setSize(SIZE);
        this.setTitle(Dictionary.get("WarnIncrBuildDialog.Title"));
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setComponentOrientation(Dictionary.getOrientation());
        JPanel jPanel2 = new JPanel();
        jPanel2.setComponentOrientation(Dictionary.getOrientation());
        String string = "gatherer_medium.png";
        if (Configuration.fedora_info != null && Configuration.fedora_info.isActive()) {
            string = "fli-" + string;
        }
        JLabel jLabel = new JLabel(JarTools.getImage(string));
        jLabel.setComponentOrientation(Dictionary.getOrientation());
        JTextArea jTextArea = new JTextArea();
        jTextArea.setComponentOrientation(Dictionary.getOrientation());
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setText(Dictionary.get("WarnIncrBuildDialog.Message"));
        jTextArea.setCaretPosition(0);
        jTextArea.setWrapStyleWord(true);
        JPanel jPanel3 = new JPanel();
        jPanel3.setComponentOrientation(Dictionary.getOrientation());
        JPanel jPanel4 = new JPanel();
        jPanel4.setComponentOrientation(Dictionary.getOrientation());
        this.revert_button = new GLIButton(Dictionary.get("WarnIncrBuildDialog.Revert"), Dictionary.get("WarnIncrBuildDialog.Revert_Tooltip"));
        this.remove_button = new GLIButton(Dictionary.get("WarnIncrBuildDialog.Remove"), Dictionary.get("WarnIncrBuildDialog.Remove_Tooltip"));
        this.cancel_button = new GLIButton(Dictionary.get("General.Cancel"), Dictionary.get("General.Pure_Cancel_Tooltip"));
        this.revert_button.addActionListener(this);
        this.remove_button.addActionListener(this);
        this.cancel_button.addActionListener(this);
        this.revert_button.addKeyListener(this);
        this.remove_button.addKeyListener(this);
        this.cancel_button.addKeyListener(this);
        this.getRootPane().setDefaultButton(this.revert_button);
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)jLabel, "Before");
        jPanel2.add((Component)new JScrollPane(jTextArea), "Center");
        jPanel4.setLayout(new GridLayout(1, 3, 5, 0));
        jPanel4.add(this.revert_button);
        jPanel4.add(this.remove_button);
        jPanel4.add(this.cancel_button);
        jPanel3.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)jPanel4, "After");
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jPanel2, "Center");
        jPanel.add((Component)jPanel3, "South");
        Dimension dimension = this.getSize();
        if (Gatherer.g_man != null) {
            Rectangle rectangle = Gatherer.g_man.getBounds();
            this.setLocation(rectangle.x + (rectangle.width - dimension.width) / 2, rectangle.y + (rectangle.height - dimension.height) / 2);
        } else {
            Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl = true;
        if (actionEvent.getSource() == this.cancel_button) {
            this.result = 0;
        } else {
            String string = CollectionManager.getLoadedCollectionArchivesKeepOldDirectoryPath();
            File file = new File(string);
            if (actionEvent.getSource() == this.revert_button) {
                WarningDialog warningDialog;
                this.result = 1;
                String string2 = CollectionManager.getLoadedCollectionArchivesDirectoryPath();
                File file2 = new File(string2);
                if (file2.exists() && !Utility.delete(file2)) {
                    warningDialog = new WarningDialog("warning.UnableToDeleteFolder", Dictionary.get("UnableToDeleteFolder.Title"), Dictionary.get("UnableToDeleteFolder.Message", file2.getPath()), null, false, false);
                    warningDialog.display();
                    warningDialog.dispose();
                    warningDialog = null;
                }
                if (!file2.exists() && !file.renameTo(file2)) {
                    warningDialog = new WarningDialog("warning.UnableToRenameFolder", Dictionary.get("UnableToRenameFolder.Title"), Dictionary.get("UnableToRenameFolder.Message", new String[]{file.getPath(), file2.getPath()}), null, false, false);
                    warningDialog.display();
                    warningDialog.dispose();
                    warningDialog = null;
                }
            } else if (actionEvent.getSource() == this.remove_button) {
                this.result = 2;
                if (!Utility.delete(file)) {
                    WarningDialog warningDialog = new WarningDialog("warning.UnableToDeleteFolder", Dictionary.get("UnableToDeleteFolder.Title"), Dictionary.get("UnableToDeleteFolder.Message", file.getPath()), null, false, false);
                    warningDialog.display();
                    warningDialog.dispose();
                    warningDialog = null;
                }
            }
        }
        this.setVisible(false);
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        Object object;
        if (keyEvent.getKeyCode() == 10 && (object = keyEvent.getSource()) instanceof AbstractButton) {
            ((AbstractButton)object).doClick();
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    public int display() {
        this.setVisible(true);
        if (Gatherer.g_man != null) {
            Gatherer.g_man.repaint();
        }
        return this.result;
    }

    @Override
    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 205) {
            this.revert_button.requestFocus();
        } else {
            super.processWindowEvent(windowEvent);
        }
    }
}

