/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.file.FileNode;
import org.greenstone.gatherer.gui.GLIButton;
import org.greenstone.gatherer.gui.TestingPreparation;

public class RenamePrompt
extends JDialog
implements ActionListener,
KeyListener {
    private JButton cancel_button;
    private JButton ok_button;
    private JTextField name_textfield;
    private String name;
    private static final Dimension SIZE = new Dimension(350, 100);

    public RenamePrompt(FileNode fileNode) {
        super((Frame)Gatherer.g_man, true);
        this.setComponentOrientation(Dictionary.getOrientation());
        this.setTitle(Dictionary.get("RenamePrompt.Title"));
        this.name = fileNode.getFile().getName();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.ok_button) {
            this.name = this.name_textfield.getText();
        } else if (actionEvent.getSource() == this.cancel_button) {
            this.name = null;
        }
        this.dispose();
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            Object object = keyEvent.getSource();
            if (object instanceof AbstractButton) {
                ((AbstractButton)object).doClick();
            } else if (object == this.name_textfield) {
                this.ok_button.doClick();
            }
        }
    }

    public String getNewName() {
        return this.name;
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    public String display() {
        this.setSize(SIZE);
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setComponentOrientation(Dictionary.getOrientation());
        JPanel jPanel2 = new JPanel();
        jPanel2.setComponentOrientation(Dictionary.getOrientation());
        JLabel jLabel = new JLabel(Dictionary.get("RenamePrompt.Name"));
        jLabel.setComponentOrientation(Dictionary.getOrientation());
        this.name_textfield = new JTextField(this.name);
        this.name_textfield.setComponentOrientation(Dictionary.getOrientation());
        JPanel jPanel3 = new JPanel();
        jPanel3.setComponentOrientation(Dictionary.getOrientation());
        this.ok_button = new GLIButton(Dictionary.get("General.OK"), Dictionary.get("General.OK_Tooltip"));
        this.cancel_button = new GLIButton(Dictionary.get("General.Cancel"), Dictionary.get("General.Pure_Cancel_Tooltip"));
        this.cancel_button.addActionListener(this);
        this.ok_button.addActionListener(this);
        this.ok_button.addKeyListener(this);
        this.name_textfield.addKeyListener(this);
        jPanel2.setLayout(new BorderLayout(5, 0));
        jPanel2.add((Component)jLabel, "Before");
        jPanel2.add((Component)this.name_textfield, "Center");
        jPanel3.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        jPanel3.setLayout(new GridLayout(1, 2, 0, 5));
        jPanel3.add(this.ok_button);
        jPanel3.add(this.cancel_button);
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jPanel2, "Center");
        jPanel.add((Component)jPanel3, "South");
        Rectangle rectangle = Gatherer.g_man.getBounds();
        this.setLocation(rectangle.x + (rectangle.width - RenamePrompt.SIZE.width) / 2, rectangle.y + (rectangle.height - RenamePrompt.SIZE.height) / 2);
        TestingPreparation.setNamesRecursively(this);
        this.setVisible(true);
        return this.name;
    }
}

