/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.gui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.collection.CollectionTreeNode;
import org.greenstone.gatherer.gui.EditorDialog;
import org.greenstone.gatherer.metadata.MetadataChangedListener;
import org.greenstone.gatherer.metadata.MetadataElement;
import org.greenstone.gatherer.metadata.MetadataTools;
import org.greenstone.gatherer.metadata.MetadataValueTableEntry;
import org.greenstone.gatherer.metadata.MetadataValueTableModel;
import org.greenstone.gatherer.metadata.MetadataXMLFileManager;
import org.greenstone.gatherer.util.JarTools;
import org.greenstone.gatherer.util.Utility;

public class MetadataValueTablePane
extends JPanel {
    private MetadataValueTable metadata_value_table = null;
    private CardLayout card_layout = null;
    private String METADATA_VALUE_TABLE_CARD = "";
    private String NO_METADATA_AVAILABLE_CARD = "No metadata available";
    private String NO_FILES_SELECTED_CARD = "No files selected";

    public MetadataValueTablePane() {
        this.setComponentOrientation(Dictionary.getOrientation());
        this.metadata_value_table = new MetadataValueTable();
        JScrollPane jScrollPane = new JScrollPane(this.metadata_value_table);
        jScrollPane.getViewport().setBackground(Configuration.getColor("coloring.collection_tree_background", false));
        jScrollPane.setOpaque(true);
        jScrollPane.setComponentOrientation(Dictionary.getOrientation());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.setComponentOrientation(Dictionary.getOrientation());
        JLabel jLabel = new JLabel(Dictionary.get("EnrichPane.No_Metadata"));
        jLabel.setHorizontalAlignment(0);
        jLabel.setOpaque(false);
        jLabel.setVerticalAlignment(0);
        jLabel.setComponentOrientation(Dictionary.getOrientation());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)jLabel, "Center");
        jPanel2.setComponentOrientation(Dictionary.getOrientation());
        JLabel jLabel2 = new JLabel(Dictionary.get("EnrichPane.No_File"));
        jLabel2.setHorizontalAlignment(0);
        jLabel2.setOpaque(false);
        jLabel2.setVerticalAlignment(0);
        jLabel2.setComponentOrientation(Dictionary.getOrientation());
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)jLabel2, "Center");
        jPanel3.setComponentOrientation(Dictionary.getOrientation());
        this.card_layout = new CardLayout();
        this.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        this.setFont(Configuration.getFont("general.font", false));
        this.setLayout(this.card_layout);
        this.add((Component)jPanel, this.METADATA_VALUE_TABLE_CARD);
        this.add((Component)jPanel2, this.NO_METADATA_AVAILABLE_CARD);
        this.add((Component)jPanel3, this.NO_FILES_SELECTED_CARD);
    }

    public void addMetadataValueTableListSelectionListener(ListSelectionListener listSelectionListener) {
        this.metadata_value_table.getSelectionModel().addListSelectionListener(listSelectionListener);
    }

    public void addMetadataValueTableMouseListener(MouseListener mouseListener) {
        this.metadata_value_table.addMouseListener(mouseListener);
    }

    public void addMetadataValueTextFieldDocumentListener(DocumentListener documentListener) {
        this.metadata_value_table.getMetadataValueTextField().getDocument().addDocumentListener(documentListener);
    }

    public void addMetadataValueTextFieldKeyListener(KeyListener keyListener) {
        this.metadata_value_table.getMetadataValueTextField().addKeyListener(keyListener);
    }

    public MetadataValueTableEntry getSelectedMetadataValueTableEntry() {
        return this.metadata_value_table.getSelectedMetadataValueTableEntry();
    }

    public boolean isMouseEventForInheritedMetadataValueTableColumn(MouseEvent mouseEvent) {
        return this.metadata_value_table.isMouseEventForInheritedMetadataValueTableColumn(mouseEvent);
    }

    public void setMetadataValueTextFieldValue(String string) {
        this.metadata_value_table.setMetadataValueTextFieldValue(string);
    }

    public void stopEditingAndAddBlankRowForSelectedMetadataElement() {
        this.metadata_value_table.stopEditing();
        this.metadata_value_table.addBlankRowForSelectedMetadataElement();
    }

    public void stopEditingAndRebuild(CollectionTreeNode[] collectionTreeNodeArray) {
        this.metadata_value_table.stopEditing();
        this.metadata_value_table.rebuild(collectionTreeNodeArray);
        if (collectionTreeNodeArray == null) {
            this.card_layout.show(this, this.NO_FILES_SELECTED_CARD);
        } else if (this.metadata_value_table.getRowCount() == 0) {
            this.card_layout.show(this, this.NO_METADATA_AVAILABLE_CARD);
        } else {
            this.card_layout.show(this, this.METADATA_VALUE_TABLE_CARD);
        }
    }

    private class MetadataValueTable
    extends JTable
    implements MetadataChangedListener {
        private int MINIMUM_TABLE_HEADER_SIZE = 15;
        private MetadataValueTableModel metadata_value_table_model = null;
        private JTextField metadata_value_text_field = new JTextField();

        public MetadataValueTable() {
            this.setComponentOrientation(Dictionary.getOrientation());
            this.metadata_value_table_model = new MetadataValueTableModel();
            this.setModel(this.metadata_value_table_model);
            this.setSelectionMode(0);
            this.setDefaultEditor(String.class, new DefaultCellEditor(this.metadata_value_text_field));
            this.metadata_value_text_field.addMouseListener(new MetadataValueTextFieldMouseListener());
            this.metadata_value_text_field.setBorder(null);
            this.metadata_value_text_field.setComponentOrientation(Dictionary.getOrientation());
            this.addKeyListener(new MetadataValueTableKeyListener());
            MetadataXMLFileManager.addMetadataChangedListener(this);
            JTableHeader jTableHeader = this.getTableHeader();
            jTableHeader.setComponentOrientation(Dictionary.getOrientation());
            Dimension dimension = jTableHeader.getPreferredSize();
            if (dimension.height < this.MINIMUM_TABLE_HEADER_SIZE) {
                dimension.setSize(dimension.width, this.MINIMUM_TABLE_HEADER_SIZE);
                jTableHeader.setPreferredSize(dimension);
            }
            TableColumnModel tableColumnModel = this.getColumnModel();
            TableColumn tableColumn = tableColumnModel.getColumn(0);
            tableColumn.setMinWidth(25);
            tableColumn.setPreferredWidth(25);
            tableColumn.setMaxWidth(25);
            TableColumn tableColumn2 = tableColumnModel.getColumn(1);
            tableColumn2.setPreferredWidth(200);
            TableColumn tableColumn3 = tableColumnModel.getColumn(2);
            tableColumn3.setPreferredWidth(500);
            MetadataValueTableCellRenderer metadataValueTableCellRenderer = new MetadataValueTableCellRenderer();
            tableColumn.setCellRenderer(metadataValueTableCellRenderer);
            tableColumn2.setCellRenderer(metadataValueTableCellRenderer);
            tableColumn3.setCellRenderer(metadataValueTableCellRenderer);
        }

        private void addBlankRowForSelectedMetadataElement() {
            MetadataElement metadataElement = this.getSelectedMetadataValueTableEntry().getMetadataElement();
            int n = this.metadata_value_table_model.addBlankRowForMetadataElement(metadataElement);
            this.changeSelection(n, 2, false, false);
        }

        private JTextField getMetadataValueTextField() {
            return this.metadata_value_text_field;
        }

        private MetadataValueTableEntry getSelectedMetadataValueTableEntry() {
            return this.metadata_value_table_model.getMetadataValueTableEntry(this.getSelectedRow());
        }

        private boolean isMouseEventForInheritedMetadataValueTableColumn(MouseEvent mouseEvent) {
            return this.columnAtPoint(mouseEvent.getPoint()) == 0;
        }

        @Override
        public void metadataChanged(CollectionTreeNode[] collectionTreeNodeArray) {
            this.rebuild(collectionTreeNodeArray);
        }

        private void rebuild(CollectionTreeNode[] collectionTreeNodeArray) {
            MetadataValueTableEntry metadataValueTableEntry = this.getSelectedMetadataValueTableEntry();
            this.clearSelection();
            this.metadata_value_table_model.rebuild(collectionTreeNodeArray);
            if (metadataValueTableEntry != null) {
                int n = this.metadata_value_table_model.findMetadataValueTableEntryToSelect(metadataValueTableEntry);
                this.changeSelection(n, 2, false, false);
            }
        }

        private void setMetadataValueTextFieldValue(String string) {
            this.metadata_value_text_field.setText(string);
            this.metadata_value_text_field.requestFocus();
        }

        private void stopEditing() {
            TableCellEditor tableCellEditor = this.getCellEditor();
            if (tableCellEditor != null) {
                Object object = tableCellEditor.getCellEditorValue();
                this.setValueAt(object, this.editingRow, this.editingColumn);
                this.removeEditor();
            }
        }

        private class MetadataValueTextFieldMouseListener
        extends MouseAdapter {
            private MetadataValueTextFieldMouseListener() {
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                EditorDialog editorDialog;
                String string;
                if (mouseEvent.getClickCount() == 2 && (string = (editorDialog = new EditorDialog()).display(MetadataValueTable.this.metadata_value_text_field.getText())) != null) {
                    MetadataValueTable.this.setMetadataValueTextFieldValue(string);
                }
            }
        }

        private class MetadataValueTableKeyListener
        extends KeyAdapter {
            private MetadataValueTableKeyListener() {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    MetadataValueTableEntry metadataValueTableEntry = MetadataValueTable.this.getSelectedMetadataValueTableEntry();
                    if (!metadataValueTableEntry.getMetadataElement().isExtractedMetadataElement()) {
                        MetadataValueTable.this.addBlankRowForSelectedMetadataElement();
                    }
                    keyEvent.consume();
                }
            }
        }

        private class MetadataValueTableCellRenderer
        extends DefaultTableCellRenderer {
            private MetadataValueTableCellRenderer() {
            }

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                String string;
                String string2;
                JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                jLabel.setComponentOrientation(Dictionary.getOrientation());
                int n3 = jTable.convertColumnIndexToModel(n2);
                if (n3 == 0 && object != null) {
                    jLabel = new JLabel(JarTools.getImage("upfolder.gif"));
                    jLabel.setToolTipText(Dictionary.get("EnrichPane.InheritedMetadata_Tooltip"));
                }
                if (n3 == 2 && bl) {
                    jTable.editCellAt(n, n2);
                    if (jTable.isEditing()) {
                        jTable.getEditorComponent().requestFocus();
                    }
                }
                jLabel.setOpaque(true);
                if (MetadataValueTable.this.metadata_value_table_model.isCommon(n)) {
                    jLabel.setForeground(Color.black);
                } else {
                    jLabel.setForeground(Color.gray);
                }
                if (bl) {
                    jLabel.setBackground(Configuration.getColor("coloring.workspace_heading_background", true));
                } else if (n3 < 2) {
                    jLabel.setBackground(Configuration.getColor("coloring.collection_heading_background", true));
                } else {
                    jLabel.setBackground(Configuration.getColor("coloring.collection_tree_background", true));
                }
                if (n3 == 2) {
                    jLabel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
                }
                if (object instanceof MetadataElement && (string2 = MetadataTools.getMetadataElementAttribute((MetadataElement)object, "definition", string = Configuration.getLanguage(), "en")) != null) {
                    jLabel.setToolTipText(Utility.formatHTMLWidth(string2, 60));
                }
                return jLabel;
            }
        }
    }
}

