/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.file;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.DebugStream;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.file.FileSystem;
import org.greenstone.gatherer.file.FileSystemModel;
import org.greenstone.gatherer.file.WorkspaceTreeNode;
import org.greenstone.gatherer.util.SynchronizedTreeModelTools;
import org.greenstone.gatherer.util.Utility;

public class WorkspaceTreeModel
extends FileSystemModel {
    private WorkspaceTreeNode workspace_tree_root = null;
    private WorkspaceTreeNode greenstone_collections_node = null;
    private WorkspaceTreeNode local_filespace_node = null;
    private WorkspaceTreeNode downloaded_files_node = null;
    private WorkspaceTreeNode[] folder_shortcuts = null;

    public WorkspaceTreeModel(WorkspaceTreeNode workspaceTreeNode) {
        super(workspaceTreeNode);
    }

    public static WorkspaceTreeNode[] getFolderShortcuts() {
        HashMap hashMap = Configuration.getDirectoryMappings();
        WorkspaceTreeNode[] workspaceTreeNodeArray = new WorkspaceTreeNode[hashMap.size()];
        Iterator iterator = hashMap.keySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            File file = (File)hashMap.get(string);
            workspaceTreeNodeArray[n] = new WorkspaceTreeNode(file, string);
            ++n;
        }
        return workspaceTreeNodeArray;
    }

    public static WorkspaceTreeModel getWorkspaceTreeModel(int n) {
        WorkspaceTreeNode workspaceTreeNode = new WorkspaceTreeNode(null, "ABS_ROOT");
        WorkspaceTreeModel workspaceTreeModel = new WorkspaceTreeModel(workspaceTreeNode);
        workspaceTreeModel.workspace_tree_root = workspaceTreeNode;
        workspaceTreeModel.greenstone_collections_node = n == Utility.IMPORT_MODE ? new WorkspaceTreeNode(null, Dictionary.get("Tree.World"), n) : new WorkspaceTreeNode(null, Dictionary.get("Tree.CollFiles"), n);
        workspaceTreeNode.add(workspaceTreeModel.greenstone_collections_node);
        if (!Gatherer.isWebswing) {
            workspaceTreeModel.local_filespace_node = FileSystem.getLocalFilespaceNode(workspaceTreeModel);
            workspaceTreeNode.add(workspaceTreeModel.local_filespace_node);
            workspaceTreeNode.add(FileSystem.getHomeFolderNode());
        }
        if (Gatherer.g_man.download_pane != null) {
            workspaceTreeModel.downloaded_files_node = FileSystem.getDownloadedFilesNode();
            workspaceTreeNode.add(workspaceTreeModel.downloaded_files_node);
        }
        workspaceTreeModel.refreshFolderShortcuts();
        return workspaceTreeModel;
    }

    public void refreshGreenstoneCollectionsNode() {
        this.greenstone_collections_node.refresh();
    }

    public void refreshDownloadedFilesNode() {
        this.downloaded_files_node.refresh();
    }

    public void refreshFolderShortcuts() {
        int n;
        Object[] objectArray = this.folder_shortcuts;
        this.folder_shortcuts = WorkspaceTreeModel.getFolderShortcuts();
        if (objectArray != null) {
            for (n = 0; n < objectArray.length; ++n) {
                if (WorkspaceTreeModel.doesArrayContain(this.folder_shortcuts, objectArray[n])) continue;
                DebugStream.println("Deleted shortcut: " + objectArray[n]);
                SynchronizedTreeModelTools.removeShortcutFromRoot(this, this.workspace_tree_root, (MutableTreeNode)objectArray[n]);
            }
        }
        if (this.folder_shortcuts != null) {
            for (n = 0; n < this.folder_shortcuts.length; ++n) {
                if (WorkspaceTreeModel.doesArrayContain(objectArray, this.folder_shortcuts[n])) continue;
                DebugStream.println("Added shortcut: " + this.folder_shortcuts[n]);
                SynchronizedTreeModelTools.insertNodeInto(this, this.workspace_tree_root, this.folder_shortcuts[n], false);
            }
        }
    }

    @Override
    public void refresh(TreePath treePath) {
        if (treePath != null) {
            super.refresh(treePath);
            return;
        }
        for (int i = 0; i < this.workspace_tree_root.getChildCount(); ++i) {
            WorkspaceTreeNode workspaceTreeNode = (WorkspaceTreeNode)this.workspace_tree_root.getChildAt(i);
            super.refresh(new TreePath(workspaceTreeNode.getPath()));
        }
    }

    private static boolean doesArrayContain(Object[] objectArray, Object object) {
        if (objectArray == null) {
            return false;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (!object.toString().equals(objectArray[i].toString())) continue;
            return true;
        }
        return false;
    }
}

