/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.file;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.geom.AffineTransform;
import java.io.File;
import javax.swing.tree.TreePath;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.file.FileNode;
import org.greenstone.gatherer.file.FileSystemModel;
import org.greenstone.gatherer.gui.GLIButton;
import org.greenstone.gatherer.gui.tree.DragTree;
import org.greenstone.gatherer.util.DragComponent;
import org.greenstone.gatherer.util.DragGroup;
import org.greenstone.gatherer.util.JarTools;

public class RecycleBin
extends GLIButton
implements DragComponent,
DropTargetListener {
    private boolean ignore = false;
    private DragGroup group;
    private DropTarget drop_target;
    private FileSystemModel model;
    private int drag_action = 2;
    private Point pt_last = null;
    private Rectangle ra_ghost = new Rectangle();

    public RecycleBin() {
        super(JarTools.getImage("bin.gif"));
        this.drop_target = new DropTarget(this, this.drag_action, this, true);
        this.setBackground(Configuration.getColor("coloring.button_background", true));
        this.setForeground(Configuration.getColor("coloring.button_foreground", true));
        this.setOpaque(true);
        this.model = new FileSystemModel(new RecycleBinNode(new File(Gatherer.getGLIUserDirectoryPath() + "recycle")));
    }

    @Override
    public void clearGhost() {
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        this.group.grabFocus(this);
        this.setBackground(Configuration.getColor("coloring.button_selected_background", true));
        this.setForeground(Configuration.getColor("coloring.button_selected_foreground", true));
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
        this.setBackground(Configuration.getColor("coloring.button_background", true));
        this.setForeground(Configuration.getColor("coloring.button_foreground", true));
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        Graphics2D graphics2D = (Graphics2D)this.getGraphics();
        Point point = dropTargetDragEvent.getLocation();
        if (this.pt_last != null && point.equals(this.pt_last)) {
            return;
        }
        this.pt_last = point;
        if (!DragSource.isDragImageSupported()) {
            this.paintImmediately(this.ra_ghost.getBounds());
            this.ra_ghost.setRect(point.x - this.group.mouse_offset.x, point.y - this.group.mouse_offset.y, this.group.image_ghost.getWidth(), this.group.image_ghost.getHeight());
            graphics2D.drawImage(this.group.image_ghost, AffineTransform.getTranslateInstance(this.ra_ghost.getX(), this.ra_ghost.getY()), null);
        }
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        this.ignore = true;
        this.group.grabFocus(this);
        this.setBackground(Configuration.getColor("coloring.button_background", true));
        this.setForeground(Configuration.getColor("coloring.button_foreground", true));
        try {
            DragTree dragTree = this.group.getSource();
            TreePath[] treePathArray = this.group.getSelection();
            FileNode[] fileNodeArray = new FileNode[treePathArray.length];
            for (int i = 0; i < fileNodeArray.length; ++i) {
                fileNodeArray[i] = (FileNode)treePathArray[i].getLastPathComponent();
            }
            dropTargetDropEvent.acceptDrop(this.drag_action);
            Gatherer.f_man.action(dragTree, fileNodeArray, this, null);
            this.group.setSource(null);
            this.group.setSelection(null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            dropTargetDropEvent.rejectDrop();
        }
        this.ignore = false;
        this.paintImmediately(this.ra_ghost.getBounds());
        dropTargetDropEvent.getDropTargetContext().dropComplete(true);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void gainFocus() {
    }

    @Override
    public FileSystemModel getTreeModel() {
        return this.model;
    }

    public boolean ignore() {
        return this.ignore;
    }

    @Override
    public void loseFocus() {
    }

    @Override
    public void setGroup(DragGroup dragGroup) {
        this.group = dragGroup;
    }

    public class RecycleBinNode
    extends FileNode {
        public RecycleBinNode(File file) {
            super(file);
        }

        @Override
        public FileNode addChildNode(File file) {
            return null;
        }
    }
}

