/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.DebugStream;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.collection.CollectionTreeModel;
import org.greenstone.gatherer.collection.CollectionTreeNode;
import org.greenstone.gatherer.collection.FullCollectionTreeNode;
import org.greenstone.gatherer.file.FileAlreadyExistsException;
import org.greenstone.gatherer.file.FileCopiedSuccessListener;
import org.greenstone.gatherer.file.FileJob;
import org.greenstone.gatherer.file.FileNode;
import org.greenstone.gatherer.file.FileSystemModel;
import org.greenstone.gatherer.file.InsufficientSpaceException;
import org.greenstone.gatherer.file.ReadNotPermittedException;
import org.greenstone.gatherer.file.UnknownFileErrorException;
import org.greenstone.gatherer.file.WriteNotPermittedException;
import org.greenstone.gatherer.gui.GProgressBar;
import org.greenstone.gatherer.metadata.MetadataXMLFileManager;
import org.greenstone.gatherer.util.DragComponent;
import org.greenstone.gatherer.util.SynchronizedTreeModelTools;
import org.greenstone.gatherer.util.Utility;

public class FileQueue
extends Thread {
    private static final int BUFFER_SIZE = 1024;
    private boolean cancel_action = false;
    private JButton stop_button = null;
    private boolean yes_to_all = false;
    private JLabel file_status = null;
    private ArrayList queue = null;
    private GProgressBar progress = null;
    private ArrayList file_copied_success_listeners = new ArrayList();

    public FileQueue() {
        DebugStream.println("FileQueue started.");
        this.queue = new ArrayList();
        this.file_status = new JLabel(Dictionary.get("FileActions.No_Activity"));
        this.progress = new GProgressBar();
        this.progress.setBackground(Configuration.getColor("coloring.collection_tree_background", false));
        this.progress.setForeground(Configuration.getColor("coloring.collection_tree_foreground", false));
        this.progress.setString(Dictionary.get("FileActions.No_Activity"));
        this.progress.setStringPainted(true);
    }

    public void fireFileCopiedSuccessfully(File file) {
        for (int i = 0; i < this.file_copied_success_listeners.size(); ++i) {
            ((FileCopiedSuccessListener)this.file_copied_success_listeners.get(i)).fileCopiedSuccessfully(file);
        }
    }

    public void addFileCopiedSuccessListener(FileCopiedSuccessListener fileCopiedSuccessListener) {
        this.file_copied_success_listeners.add(fileCopiedSuccessListener);
    }

    public void removeFileCopiedSuccessListener(FileCopiedSuccessListener fileCopiedSuccessListener) {
        this.file_copied_success_listeners.remove(fileCopiedSuccessListener);
    }

    public void addJob(long l, DragComponent dragComponent, FileNode[] fileNodeArray, DragComponent dragComponent2, FileNode fileNode, byte by) {
        for (int i = 0; i < fileNodeArray.length; ++i) {
            this.addJob(l, dragComponent, fileNodeArray[i], dragComponent2, fileNode, by, -1);
        }
    }

    private synchronized void addJob(long l, DragComponent dragComponent, FileNode fileNode, DragComponent dragComponent2, FileNode fileNode2, byte by, int n) {
        FileJob fileJob = new FileJob(l, dragComponent, fileNode, dragComponent2, fileNode2, by);
        DebugStream.println("Adding job: " + fileJob);
        if (n != -1 && n <= this.queue.size() + 1) {
            this.queue.add(n, fileJob);
        } else {
            this.queue.add(fileJob);
        }
        this.notify();
    }

    public boolean calculateSize(FileNode[] fileNodeArray) {
        Gatherer.invokeInEDT_replacesProceedInCurrThread("FileQueue.calculateSize()", true, new Runnable(){

            @Override
            public void run() {
                FileQueue.this.file_status.setText(Dictionary.get("FileActions.Calculating_Size"));
            }
        });
        this.progress.setString(Dictionary.get("FileActions.Calculating_Size"));
        Vector<TreeNode> vector = new Vector<TreeNode>();
        for (int i = 0; !this.cancel_action && i < fileNodeArray.length; ++i) {
            vector.add(fileNodeArray[i]);
        }
        while (!this.cancel_action && vector.size() > 0) {
            FileNode fileNode = (FileNode)vector.remove(0);
            if (fileNode.isLeaf()) {
                this.progress.addMaximum(fileNode.getFile().length());
                continue;
            }
            for (int i = 0; !this.cancel_action && i < fileNode.getChildCount(); ++i) {
                vector.add(fileNode.getChildAt(i));
            }
        }
        if (this.cancel_action) {
            this.cancel_action = false;
            return true;
        }
        return false;
    }

    public void cancelAction() {
        this.cancel_action = true;
        this.clearJobs();
    }

    String formatPath(String string, String string2, int n) {
        JLabel jLabel = new JLabel(Dictionary.get(string, string2));
        int n2 = -1;
        while (jLabel.getPreferredSize().width > n && (n2 = string2.indexOf(File.separator)) != -1) {
            string2 = "..." + string2.substring(n2 + 1);
            jLabel.setText(Dictionary.get(string, string2));
        }
        if (string2.indexOf(File.separator) == -1 && string2.startsWith("...")) {
            string2 = string2.substring(3);
        }
        return string2;
    }

    public JLabel getFileStatus() {
        return this.file_status;
    }

    public GProgressBar getProgressBar() {
        return this.progress;
    }

    private synchronized void addFileJob(long l, DragComponent dragComponent, FileNode fileNode, DragComponent dragComponent2, FileNode fileNode2, byte by) {
        this.queue.add(new FileJob(l, dragComponent, fileNode, dragComponent2, fileNode2, by));
        this.notify();
    }

    private void doEmptyDirectoryDelete(FileJob fileJob) {
        FileNode fileNode = fileJob.getOrigin();
        File file = fileNode.getFile();
        if (!file.delete()) {
            if (this.showErrorDialog(Dictionary.get("FileActions.Could_Not_Delete", file.getAbsolutePath())) == 2) {
                this.clearJobs();
            }
            return;
        }
        SynchronizedTreeModelTools.removeNodeFromParent(fileJob.source.getTreeModel(), fileNode);
    }

    private void doDirectoryDelete(FileJob fileJob) {
        FileNode fileNode;
        int n;
        FileNode fileNode2 = fileJob.getOrigin();
        File file = fileNode2.getFile();
        this.addFileJob(fileJob.ID(), fileJob.source, fileNode2, null, null, (byte)5);
        fileNode2.refresh();
        for (n = 0; n < fileNode2.size(); ++n) {
            fileNode = fileNode2.getChildAtUnfiltered(n);
            if (fileNode.getFile().getName().equals("metadata.xml")) continue;
            this.addFileJob(fileJob.ID(), fileJob.source, fileNode, null, null, (byte)2);
        }
        for (n = 0; n < fileNode2.size(); ++n) {
            fileNode = fileNode2.getChildAtUnfiltered(n);
            if (!fileNode.getFile().getName().equals("metadata.xml")) continue;
            this.addFileJob(fileJob.ID(), fileJob.source, fileNode, null, null, (byte)2);
            break;
        }
    }

    private void doDirectoryCopy(FileJob fileJob) {
        FileNode fileNode = fileJob.getOrigin();
        FileNode fileNode2 = fileJob.getDestination();
        File file = fileNode.getFile();
        File file2 = new File(fileNode2.getFile(), file.getName());
        if (file2.getAbsolutePath().startsWith(file.getAbsolutePath())) {
            if (this.showErrorDialog(Dictionary.get("FileActions.Cyclic_Path", file.getName())) == 2) {
                this.clearJobs();
            }
            return;
        }
        if (file2.exists()) {
            if (this.showErrorDialog(Dictionary.get("FileActions.Folder_Already_Exists", file2.getAbsolutePath())) == 2) {
                this.clearJobs();
            }
            return;
        }
        file2.mkdirs();
        FileSystemModel fileSystemModel = fileJob.target.getTreeModel();
        boolean bl = true;
        if (fileSystemModel instanceof CollectionTreeModel) {
            bl = false;
        }
        FullCollectionTreeNode fullCollectionTreeNode = bl ? new FullCollectionTreeNode(file2) : new CollectionTreeNode(file2);
        SynchronizedTreeModelTools.insertNodeInto(fileSystemModel, fileNode2, fullCollectionTreeNode);
        fullCollectionTreeNode.setParent(fileNode2);
        if (!bl) {
            ArrayList arrayList = MetadataXMLFileManager.getMetadataAssignedDirectlyToExternalFile(file);
            MetadataXMLFileManager.addMetadata((CollectionTreeNode)fullCollectionTreeNode, arrayList);
        }
        fileNode.refresh();
        for (int i = 0; i < fileNode.size(); ++i) {
            FileNode fileNode3 = fileNode.getChildAtUnfiltered(i);
            if (!bl && fileNode3.getFile().getName().equals("metadata.xml")) continue;
            this.addFileJob(fileJob.ID(), fileJob.source, fileNode3, fileJob.target, fullCollectionTreeNode, (byte)1);
        }
    }

    private void doDirectoryMove(FileJob fileJob) {
        FileNode fileNode;
        int n;
        FileNode fileNode2 = fileJob.getOrigin();
        FileNode fileNode3 = fileJob.getDestination();
        File file = fileNode2.getFile();
        File file2 = new File(fileNode3.getFile(), file.getName());
        if (fileJob.type == 6) {
            file2 = fileNode3.getFile();
            fileNode3 = (FileNode)fileNode2.getParent();
        }
        if (file2.equals(file)) {
            DebugStream.println("Target directory is the source directory!");
            return;
        }
        if (file2.exists()) {
            if (this.showErrorDialog(Dictionary.get("FileActions.Folder_Already_Exists", file2.getAbsolutePath())) == 2) {
                this.clearJobs();
            }
            return;
        }
        file2.mkdirs();
        FileSystemModel fileSystemModel = fileJob.target.getTreeModel();
        boolean bl = true;
        if (fileSystemModel instanceof CollectionTreeModel) {
            bl = false;
        }
        FullCollectionTreeNode fullCollectionTreeNode = bl ? new FullCollectionTreeNode(file2) : new CollectionTreeNode(file2);
        SynchronizedTreeModelTools.insertNodeInto(fileSystemModel, fileNode3, fullCollectionTreeNode);
        fullCollectionTreeNode.setParent(fileNode3);
        if (!bl) {
            ArrayList arrayList = MetadataXMLFileManager.getMetadataAssignedDirectlyToFile(file);
            MetadataXMLFileManager.removeMetadata((CollectionTreeNode)fileNode2, arrayList);
            MetadataXMLFileManager.addMetadata((CollectionTreeNode)fullCollectionTreeNode, arrayList);
        }
        this.addFileJob(fileJob.ID(), fileJob.source, fileNode2, null, null, (byte)2);
        fileNode2.refresh();
        for (n = 0; n < fileNode2.size(); ++n) {
            fileNode = fileNode2.getChildAtUnfiltered(n);
            if (!fileNode.getFile().getName().equals("metadata.xml")) continue;
            this.addFileJob(fileJob.ID(), fileJob.source, fileNode, null, null, (byte)2);
            break;
        }
        for (n = 0; n < fileNode2.size(); ++n) {
            fileNode = fileNode2.getChildAtUnfiltered(n);
            if (fileNode.getFile().getName().equals("metadata.xml")) continue;
            this.addFileJob(fileJob.ID(), fileJob.source, fileNode, fileJob.target, fullCollectionTreeNode, (byte)3);
        }
    }

    private void doFileDelete(FileJob fileJob) {
        FileNode fileNode = fileJob.getOrigin();
        File file = fileNode.getFile();
        if (fileNode instanceof CollectionTreeNode) {
            boolean bl = file.getName().equals("metadata.xml");
            if (bl) {
                MetadataXMLFileManager.unloadMetadataXMLFile(file);
            } else {
                ArrayList arrayList = MetadataXMLFileManager.getMetadataAssignedDirectlyToFile(file);
                MetadataXMLFileManager.removeMetadata((CollectionTreeNode)fileNode, arrayList);
            }
        }
        if (!Utility.delete(file)) {
            if (this.showErrorDialog(Dictionary.get("FileActions.File_Not_Deleted_Message", file.getAbsolutePath())) == 2) {
                this.clearJobs();
            }
            return;
        }
        SynchronizedTreeModelTools.removeNodeFromParent(fileJob.source.getTreeModel(), fileNode);
    }

    private void doFileCopy(FileJob fileJob) {
        Serializable serializable;
        FileNode fileNode = fileJob.getOrigin();
        FileNode fileNode2 = fileJob.getDestination();
        File file = fileNode.getFile();
        File file2 = new File(fileNode2.getFile(), file.getName());
        boolean bl = false;
        if (file2.exists()) {
            int n = this.showOverwriteDialog(file2.getName());
            if (n == 1) {
                return;
            }
            if (n == 2) {
                this.clearJobs();
                return;
            }
            bl = true;
        }
        try {
            this.copyFile(file, file2, true);
            this.fireFileCopiedSuccessfully(file);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            DebugStream.printStackTrace(fileAlreadyExistsException);
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            DebugStream.printStackTrace(fileNotFoundException);
            if (this.showErrorDialog(Dictionary.get("FileActions.File_Not_Found_Message", file.getAbsolutePath())) == 2) {
                this.clearJobs();
            }
            FileSystemModel fileSystemModel = fileJob.source.getTreeModel();
            fileSystemModel.refresh(new TreePath(((FileNode)fileJob.getOrigin().getParent()).getPath()));
            return;
        }
        catch (InsufficientSpaceException insufficientSpaceException) {
            DebugStream.printStackTrace(insufficientSpaceException);
            if (this.showErrorDialog(Dictionary.get("FileActions.Insufficient_Space_Message", insufficientSpaceException.getMessage())) == 2) {
                this.clearJobs();
            }
            return;
        }
        catch (IOException iOException) {
            DebugStream.printStackTrace(iOException);
            if (this.showErrorDialog(iOException.getMessage()) == 2) {
                this.clearJobs();
            }
            return;
        }
        catch (ReadNotPermittedException readNotPermittedException) {
            DebugStream.printStackTrace(readNotPermittedException);
            if (this.showErrorDialog(Dictionary.get("FileActions.Read_Not_Permitted_Message", file.getAbsolutePath())) == 2) {
                this.clearJobs();
            }
            return;
        }
        catch (UnknownFileErrorException unknownFileErrorException) {
            DebugStream.printStackTrace(unknownFileErrorException);
            if (this.showErrorDialog(Dictionary.get("FileActions.Unknown_File_Error_Message")) == 2) {
                this.clearJobs();
            }
            return;
        }
        catch (WriteNotPermittedException writeNotPermittedException) {
            DebugStream.printStackTrace(writeNotPermittedException);
            if (this.showErrorDialog(Dictionary.get("FileActions.Write_Not_Permitted_Message", file2.getAbsolutePath())) == 2) {
                this.clearJobs();
            }
            return;
        }
        FullCollectionTreeNode fullCollectionTreeNode = fileNode2 instanceof CollectionTreeNode ? new CollectionTreeNode(file2) : new FullCollectionTreeNode(file2);
        if (!bl) {
            serializable = fileJob.target.getTreeModel();
            SynchronizedTreeModelTools.insertNodeInto(serializable, fileNode2, fullCollectionTreeNode);
        }
        if (fileNode2 instanceof CollectionTreeNode) {
            Gatherer.c_man.fireFileAddedToCollection(file2);
            if (fileJob.type == 1) {
                serializable = MetadataXMLFileManager.getMetadataAssignedDirectlyToExternalFile(file);
                MetadataXMLFileManager.addMetadata(fullCollectionTreeNode, (ArrayList)serializable);
            }
        }
    }

    private void doFileMove(FileJob fileJob) {
        FileNode fileNode = fileJob.getOrigin();
        FileNode fileNode2 = fileJob.getDestination();
        File file = fileNode.getFile();
        File file2 = new File(fileNode2.getFile(), file.getName());
        if (fileJob.type == 6) {
            file2 = fileNode2.getFile();
            fileNode2 = (FileNode)fileNode.getParent();
        }
        if (file2.equals(file)) {
            DebugStream.println("Target file is the source file!");
            return;
        }
        if (file2.exists()) {
            int n = this.showOverwriteDialog(file2.getName());
            if (n == 1) {
                return;
            }
            if (n == 2) {
                this.clearJobs();
                return;
            }
        }
        if (!file.renameTo(file2)) {
            String[] stringArray = new String[]{file.getName(), file2.getAbsolutePath()};
            if (this.showErrorDialog(Dictionary.get("FileActions.File_Move_Error_Message", stringArray)) == 2) {
                this.clearJobs();
            }
            return;
        }
        SynchronizedTreeModelTools.removeNodeFromParent(fileJob.source.getTreeModel(), fileNode);
        FullCollectionTreeNode fullCollectionTreeNode = fileNode2 instanceof CollectionTreeNode ? new CollectionTreeNode(file2) : new FullCollectionTreeNode(file2);
        FileSystemModel fileSystemModel = fileJob.target.getTreeModel();
        SynchronizedTreeModelTools.insertNodeInto(fileSystemModel, fileNode2, fullCollectionTreeNode);
        if (fileNode2 instanceof CollectionTreeNode) {
            ArrayList arrayList = MetadataXMLFileManager.getMetadataAssignedDirectlyToFile(file);
            MetadataXMLFileManager.removeMetadata((CollectionTreeNode)fileNode, arrayList);
            MetadataXMLFileManager.addMetadata(fullCollectionTreeNode, arrayList);
        }
    }

    private void doFileReplace(FileJob fileJob) {
        FileNode fileNode = fileJob.getOrigin();
        FileNode fileNode2 = fileJob.getDestination();
        File file = fileNode.getFile();
        File file2 = fileNode2.getFile();
        if (fileNode2 instanceof CollectionTreeNode) {
            CollectionTreeNode collectionTreeNode = new CollectionTreeNode(file2);
            ArrayList arrayList = MetadataXMLFileManager.getMetadataAssignedDirectlyToFile(file);
            MetadataXMLFileManager.removeMetadata((CollectionTreeNode)fileNode, arrayList);
            MetadataXMLFileManager.addMetadata(collectionTreeNode, arrayList);
        }
        this.doFileDelete(fileJob);
    }

    private void processFileJob(FileJob fileJob) {
        DebugStream.println("Processing file job " + fileJob + "...");
        File file = fileJob.getOrigin().getFile();
        if (!file.exists()) {
            if (this.showErrorDialog(Dictionary.get("FileActions.File_Not_Found_Message", file.getAbsolutePath())) == 2) {
                this.clearJobs();
            }
            FileSystemModel fileSystemModel = fileJob.source.getTreeModel();
            fileSystemModel.refresh(new TreePath(((FileNode)fileJob.getOrigin().getParent()).getPath()));
            return;
        }
        this.stop_button.setEnabled(true);
        if (fileJob.type == 5) {
            this.file_status.setText(Dictionary.get("FileActions.Deleting", this.formatPath("FileActions.Deleting", file.getAbsolutePath(), this.file_status.getSize().width)));
            this.doEmptyDirectoryDelete(fileJob);
            return;
        }
        if (fileJob.type == 2) {
            this.file_status.setText(Dictionary.get("FileActions.Deleting", this.formatPath("FileActions.Deleting", file.getAbsolutePath(), this.file_status.getSize().width)));
            if (file.isFile()) {
                long l = file.length();
                this.doFileDelete(fileJob);
                this.progress.addValue(l);
            } else {
                this.doDirectoryDelete(fileJob);
            }
            return;
        }
        if (fileJob.type == 1 || fileJob.type == 8) {
            this.file_status.setText(Dictionary.get("FileActions.Copying", this.formatPath("FileActions.Copying", file.getAbsolutePath(), this.file_status.getSize().width)));
            if (file.isFile()) {
                long l = file.length();
                this.doFileCopy(fileJob);
                this.progress.addValue(l);
            } else {
                this.doDirectoryCopy(fileJob);
            }
            return;
        }
        if (fileJob.type == 3 || fileJob.type == 6) {
            this.file_status.setText(Dictionary.get("FileActions.Moving", this.formatPath("FileActions.Moving", file.getAbsolutePath(), this.file_status.getSize().width)));
            if (file.isFile()) {
                long l = file.length();
                this.doFileMove(fileJob);
                this.progress.addValue(l);
            } else {
                this.doDirectoryMove(fileJob);
            }
            return;
        }
        if (fileJob.type == 7) {
            this.file_status.setText(Dictionary.get("FileActions.Replacing", this.formatPath("FileActions.Replacing", file.getAbsolutePath(), this.file_status.getSize().width)));
            this.doFileReplace(fileJob);
            return;
        }
    }

    private int showErrorDialog(String string) {
        Object[] objectArray = new Object[]{Dictionary.get("General.OK"), Dictionary.get("General.Cancel")};
        int n = JOptionPane.showOptionDialog(Gatherer.g_man, string, Dictionary.get("General.Error"), -1, 0, null, objectArray, objectArray[0]);
        if (n == 0) {
            return 0;
        }
        return 2;
    }

    private int showOverwriteDialog(String string) {
        if (this.yes_to_all) {
            return 0;
        }
        Object[] objectArray = new Object[]{Dictionary.get("General.Yes"), Dictionary.get("FileActions.Yes_To_All"), Dictionary.get("General.No"), Dictionary.get("General.Cancel")};
        int n = JOptionPane.showOptionDialog(Gatherer.g_man, Dictionary.get("FileActions.File_Exists", string), Dictionary.get("General.Warning"), -1, 2, null, objectArray, objectArray[0]);
        if (n == 0) {
            return 0;
        }
        if (n == 1) {
            this.yes_to_all = true;
            return 0;
        }
        if (n == 2) {
            return 1;
        }
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        super.setName("FileQueue");
        while (!Gatherer.exit) {
            Object object;
            int n = this.queue.size() - 1;
            if (n >= 0) {
                object = (FileJob)this.queue.remove(n);
                Gatherer.invokeInEDT_replacesProceedInCurrThread("FileQueue.run() - processFileJob", true, new Runnable((FileJob)object){
                    final /* synthetic */ FileJob val$currentJob;
                    {
                        this.val$currentJob = fileJob;
                    }

                    @Override
                    public void run() {
                        FileQueue.this.processFileJob(this.val$currentJob);
                    }
                });
                continue;
            }
            object = this;
            synchronized (object) {
                Gatherer.invokeInEDT_replacesProceedInCurrThread("FileQueue.run() - processFileJob", true, new Runnable(){

                    @Override
                    public void run() {
                        if (Gatherer.g_man != null) {
                            if (Gatherer.c_man.ready()) {
                                Gatherer.g_man.refreshWorkspaceTree(2);
                                Gatherer.g_man.refreshCollectionTree(2);
                            }
                        }
                        FileQueue.this.file_status.setText(Dictionary.get("FileActions.No_Activity"));
                        FileQueue.this.progress.reset();
                        FileQueue.this.progress.setString(Dictionary.get("FileActions.No_Activity"));
                    }
                });
                this.yes_to_all = false;
                this.cancel_action = false;
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public void registerStopButton(JButton jButton) {
        this.stop_button = jButton;
    }

    private synchronized void clearJobs() {
        this.queue.clear();
    }

    public void copyDirectoryContents(File file, File file2, boolean bl) throws FileAlreadyExistsException, FileNotFoundException, InsufficientSpaceException, IOException, ReadNotPermittedException, UnknownFileErrorException, WriteNotPermittedException {
        if (!file.isDirectory()) {
            return;
        }
        file2.mkdirs();
        File[] fileArray = file.listFiles();
        if (fileArray.length == 0) {
            return;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            File file3 = fileArray[i];
            String string = file3.getName();
            File file4 = new File(file2, string);
            if (file3.isDirectory()) {
                this.copyDirectoryContents(file3, file4, bl);
                continue;
            }
            if (!file3.isFile()) continue;
            this.copyFile(file3, file4, bl);
        }
    }

    public void copyDirectoryContents(File file, File file2) throws FileAlreadyExistsException, FileNotFoundException, InsufficientSpaceException, IOException, ReadNotPermittedException, UnknownFileErrorException, WriteNotPermittedException {
        this.copyDirectoryContents(file, file2, false);
    }

    public void copyFile(File file, File file2, boolean bl) throws FileAlreadyExistsException, FileNotFoundException, InsufficientSpaceException, IOException, ReadNotPermittedException, UnknownFileErrorException, WriteNotPermittedException {
        if (file.isDirectory()) {
            file2.mkdirs();
            return;
        }
        if (!file.exists()) {
            DebugStream.println("Couldn't find the source file.");
            throw new FileNotFoundException();
        }
        if (file2.exists() && !bl) {
            throw new FileAlreadyExistsException();
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ReadNotPermittedException(fileNotFoundException.toString());
        }
        File file3 = file2.getParentFile();
        file3.mkdirs();
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileInputStream.close();
            throw new WriteNotPermittedException(fileNotFoundException.toString());
        }
        byte[] byArray = new byte[1024];
        int n = 0;
        while ((n = fileInputStream.read(byArray, 0, 1024)) != -1 && !this.cancel_action) {
            long l = file2.length();
            try {
                fileOutputStream.write(byArray, 0, n);
            }
            catch (IOException iOException) {
                fileInputStream.close();
                fileOutputStream.close();
                if (l + (long)n > file2.length()) {
                    long l2 = l + (long)n - file2.length();
                    String string = Utility.formatFileLength(l2);
                    throw new InsufficientSpaceException(string);
                }
                throw iOException;
            }
        }
        fileInputStream.close();
        fileOutputStream.close();
        if (!file2.exists() || !this.cancel_action && file.length() != file2.length()) {
            throw new UnknownFileErrorException();
        }
        if (this.cancel_action) {
            file2.delete();
        }
    }
}

