/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.collection;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.collection.CollectionTreeNode;
import org.greenstone.gatherer.collection.FullCollectionTree;
import org.greenstone.gatherer.collection.FullCollectionTreeNode;
import org.greenstone.gatherer.file.FileSystemModel;
import org.greenstone.gatherer.gui.tree.DragTreeCellRenderer;

public class CollectionTree
extends FullCollectionTree
implements MouseListener {
    public CollectionTree(FileSystemModel fileSystemModel, boolean bl) {
        super(fileSystemModel, bl);
        this.setCellRenderer(new CollectionTreeCellRenderer());
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            new CollectionTreeRightClickMenu(this, mouseEvent).showMenu(mouseEvent);
        }
    }

    @Override
    public String toString() {
        return "Collection";
    }

    protected class CollectionTreeRightClickMenu
    extends FullCollectionTree.FullCollectionTreeRightClickMenu {
        protected JMenuItem explode_metadata_database;
        protected JMenuItem replace_srcdoc_with_html;
        protected JMenuItem metaaudit;

        protected CollectionTreeRightClickMenu(CollectionTree collectionTree2, MouseEvent mouseEvent) {
            super(CollectionTree.this, collectionTree2, mouseEvent);
            this.explode_metadata_database = null;
            this.replace_srcdoc_with_html = null;
            this.metaaudit = null;
        }

        @Override
        protected void buildContextMenu(TreePath[] treePathArray) {
            if (treePathArray == null) {
                this.new_folder = new JMenuItem(Dictionary.get("CollectionPopupMenu.New_Folder"), 78);
                this.new_folder.addActionListener(this);
                this.add(this.new_folder);
                this.new_file = new JMenuItem(Dictionary.get("CollectionPopupMenu.New_File"));
                this.new_file.addActionListener(this);
                this.add(this.new_file);
                this.new_dummy_doc = new JMenuItem(Dictionary.get("CollectionPopupMenu.New_Dummy_Doc"));
                this.new_dummy_doc.addActionListener(this);
                this.add(this.new_dummy_doc);
                this.refresh = new JMenuItem(Dictionary.get("CollectionPopupMenu.Refresh"));
                if (Gatherer.isGsdlRemote) {
                    this.refresh.setEnabled(false);
                }
                this.refresh.addActionListener(this);
                this.add(this.refresh);
                this.node = (FullCollectionTreeNode)this.collection_tree.getModel().getRoot();
                return;
            }
            this.metaaudit = new JMenuItem(Dictionary.get("Menu.Metadata_View", this.collection_tree.getSelectionDetails()), 65);
            this.metaaudit.addActionListener(this);
            this.add(this.metaaudit);
            this.delete = new JMenuItem(Dictionary.get("CollectionPopupMenu.Delete"), 68);
            this.delete.addActionListener(this);
            this.add(this.delete);
            CollectionTreeNode collectionTreeNode = (CollectionTreeNode)treePathArray[0].getLastPathComponent();
            if (collectionTreeNode.isSrcReplaceable()) {
                this.replace_srcdoc_with_html = new JMenuItem(Dictionary.get("Menu.Replace_SrcDoc_With_HTML"), 72);
                this.replace_srcdoc_with_html.addActionListener(this);
                this.add(this.replace_srcdoc_with_html);
                if (!this.selectedFilesOfSameType(treePathArray)) {
                    this.replace_srcdoc_with_html.setEnabled(false);
                }
            }
            if (!Gatherer.isGsdlRemote && collectionTreeNode.isZipFile()) {
                this.unzip_file = new JMenuItem(Dictionary.get("CollectionPopupMenu.Unzip"), 85);
                this.unzip_file.addActionListener(this);
                this.add(this.unzip_file);
                if (!this.selectedFilesOfSameType(treePathArray)) {
                    this.unzip_file.setEnabled(false);
                }
            }
            if (treePathArray.length > 1) {
                return;
            }
            this.rename = new JMenuItem(Dictionary.get("CollectionPopupMenu.Rename"), 82);
            this.rename.addActionListener(this);
            this.add(this.rename);
            TreePath treePath = treePathArray[0];
            this.node = (FullCollectionTreeNode)treePath.getLastPathComponent();
            if (this.node.isLeaf()) {
                if (((CollectionTreeNode)this.node).isExplodable()) {
                    this.explode_metadata_database = new JMenuItem(Dictionary.get("Menu.Explode_Metadata_Database"), 69);
                    this.explode_metadata_database.addActionListener(this);
                    this.add(this.explode_metadata_database);
                }
                this.replace = new JMenuItem(Dictionary.get("CollectionPopupMenu.Replace"), 80);
                this.replace.addActionListener(this);
                this.add(this.replace);
                this.open_externally = new JMenuItem(Dictionary.get("Menu.Open_Externally"), 79);
                this.open_externally.addActionListener(this);
                this.add(this.open_externally);
                return;
            }
            if (this.collection_tree.isExpanded(treePath)) {
                this.collapse_folder = new JMenuItem(Dictionary.get("Menu.Collapse"), 67);
                this.collapse_folder.addActionListener(this);
                this.add(this.collapse_folder);
            } else {
                this.expand_folder = new JMenuItem(Dictionary.get("Menu.Expand"), 79);
                this.expand_folder.addActionListener(this);
                this.add(this.expand_folder);
            }
            if (!this.node.isReadOnly()) {
                this.new_folder = new JMenuItem(Dictionary.get("CollectionPopupMenu.New_Folder"), 78);
                this.new_folder.addActionListener(this);
                this.add(this.new_folder);
                this.new_file = new JMenuItem(Dictionary.get("CollectionPopupMenu.New_File"));
                this.new_file.addActionListener(this);
                this.add(this.new_file);
                this.new_dummy_doc = new JMenuItem(Dictionary.get("CollectionPopupMenu.New_Dummy_Doc"));
                this.new_dummy_doc.addActionListener(this);
                this.add(this.new_dummy_doc);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.explode_metadata_database) {
                Gatherer.f_man.explodeMetadataDatabase(this.node.getFile());
            } else if (object == this.replace_srcdoc_with_html) {
                File[] fileArray = new File[this.selection_paths.length];
                for (int i = 0; i < this.selection_paths.length; ++i) {
                    CollectionTreeNode collectionTreeNode = (CollectionTreeNode)this.selection_paths[i].getLastPathComponent();
                    fileArray[i] = collectionTreeNode.getFile();
                }
                Gatherer.f_man.replaceSrcDocWithHtml(fileArray);
            } else if (object == this.metaaudit) {
                Gatherer.g_man.showMetaAuditBox();
            } else if (object == this.new_dummy_doc) {
                Gatherer.f_man.newDummyDoc(this.collection_tree, this.node);
            } else {
                super.actionPerformed(actionEvent);
            }
        }
    }

    protected class CollectionTreeCellRenderer
    extends DragTreeCellRenderer {
        protected CollectionTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            JLabel jLabel = (JLabel)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (object instanceof CollectionTreeNode && (((CollectionTreeNode)object).isExplodable() || ((CollectionTreeNode)object).isSrcReplaceable())) {
                jLabel.setIcon(CollectionTreeNode.GREEN_FILE_ICON);
            }
            return jLabel;
        }
    }
}

