/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.collection;

import java.io.File;
import javax.swing.tree.TreeNode;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.DebugStream;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.cdm.CollectionDesignManager;
import org.greenstone.gatherer.cdm.CollectionMeta;
import org.greenstone.gatherer.collection.CollectionTreeNode;
import org.greenstone.gatherer.collection.ScriptOptions;
import org.greenstone.gatherer.util.XMLTools;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Collection {
    public CollectionDesignManager cdm;
    public ScriptOptions build_options;
    public ScriptOptions import_options;
    public ScriptOptions schedule_options;
    public boolean error = false;
    private boolean saved = false;
    private boolean filesChanged = false;
    private boolean metadataChanged = false;
    private Document document;
    private File file;
    private static final String ARGUMENT = "Argument";
    private static final String BASE_COLLECTION = "base_collection";
    private static final String BUILD = "Build";
    private static final String BUILD_CONFIG = "BuildConfig";
    private static final String COLLECTION_XML_TEMPLATE = "xml/template.col";
    private static final String IMPORT = "Import";
    private static final String SCHEDULE = "Schedule";
    private static final String EXPORT = "Export";
    private static final String IMPORTED = "imported";
    private static final String SKIM_FILE = "skimfile";

    public Collection(File file) {
        this.file = file;
        this.document = XMLTools.parseXMLFile(file);
        if (this.document == null) {
            this.document = XMLTools.parseXMLFile(COLLECTION_XML_TEMPLATE, true);
        }
        if (this.document == null) {
            this.error = true;
            return;
        }
        Configuration.setCollectionConfiguration(this.document);
        if (Gatherer.g_man != null) {
            Gatherer.g_man.updateUI();
        }
        if (Configuration.fedora_info != null && Configuration.fedora_info.isActive()) {
            this.build_options = new ScriptOptions(this.getValues(BUILD), "g2f-buildcol.pl");
            this.import_options = new ScriptOptions(this.getValues(IMPORT), "g2f-import.pl");
        } else {
            this.build_options = new ScriptOptions(this.getBuildValues(), "buildcol.pl");
            this.import_options = new ScriptOptions(this.getImportValues(), "import.pl");
            this.schedule_options = new ScriptOptions(this.getScheduleValues(), "schedule.pl");
        }
    }

    public void destroy() {
        this.cdm.destroy();
        Configuration.setCollectionConfiguration(null);
        this.cdm = null;
        this.document = null;
    }

    public int getCount() {
        return this.getCount((TreeNode)Gatherer.c_man.getCollectionTreeModel().getRoot(), true, true);
    }

    public int getDocumentCount() {
        return this.getCount((TreeNode)Gatherer.c_man.getCollectionTreeModel().getRoot(), false, true);
    }

    public String getDescription() {
        if (this.cdm == null) {
            return "";
        }
        CollectionMeta collectionMeta = CollectionDesignManager.collectionmeta_manager.getMetadatum("collectionextra");
        return collectionMeta.getValue(true);
    }

    public String getEmail() {
        if (this.cdm == null) {
            return "";
        }
        CollectionMeta collectionMeta = new CollectionMeta(CollectionDesignManager.collect_config.getCreator());
        return collectionMeta.getValue(true);
    }

    public String getName() {
        return this.getCollectionTailName();
    }

    public String getCollectionTailName() {
        return this.file.getParentFile().getName();
    }

    public String getCollectionGroupName() {
        String string = this.getGroupQualifiedName(true);
        int n = string.indexOf(47);
        if (n == -1) {
            return "";
        }
        return string.substring(0, n);
    }

    public String getGroupQualifiedName(boolean bl) {
        String string;
        String string2 = Gatherer.getCollectDirectoryPath();
        String string3 = this.file.getParentFile().getAbsolutePath();
        if (string3.startsWith(string2)) {
            string = string3.substring(string2.length());
        } else {
            System.err.println("Current collection " + string3 + " is not located inside collectdir " + string2);
            string = this.getCollectionTailName();
        }
        if (bl) {
            string = string.replace('\\', '/');
        }
        return string;
    }

    public File getCollectionDirectory() {
        return this.file.getParentFile();
    }

    public String getCollectionPath() {
        return this.file.getAbsolutePath();
    }

    public boolean getSaved() {
        return this.saved;
    }

    public boolean getFilesChanged() {
        return this.filesChanged;
    }

    public void setFilesChanged(boolean bl) {
        this.filesChanged = bl;
    }

    public boolean getMetadataChanged() {
        return this.metadataChanged;
    }

    public void setMetadataChanged(boolean bl) {
        this.metadataChanged = bl;
    }

    public String getTitle() {
        if (this.cdm == null) {
            return "";
        }
        CollectionMeta collectionMeta = CollectionDesignManager.collectionmeta_manager.getMetadatum("collectionname");
        return collectionMeta.getValue(true);
    }

    public void save() {
        XMLTools.writeXMLFile(this.file, this.document);
        this.saved = true;
    }

    public void setBaseCollection(String string) {
        this.set(BASE_COLLECTION, string);
    }

    public void setImported(boolean bl) {
        this.set(IMPORTED, bl);
        this.saved = false;
    }

    public void setSaved(boolean bl) {
        this.saved = bl;
    }

    public void setTitle(String string) {
        if (this.cdm != null) {
            CollectionMeta collectionMeta = CollectionDesignManager.collectionmeta_manager.getMetadatum("collectionname");
            collectionMeta.setValue(string);
        }
    }

    public String toString() {
        return this.getTitle();
    }

    public boolean toSkimFile() {
        Element element = this.document.getDocumentElement();
        NodeList nodeList = element.getElementsByTagName(ARGUMENT);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string;
            Element element2 = (Element)nodeList.item(i);
            if (!element2.getAttribute("name").equalsIgnoreCase(SKIM_FILE) || (string = XMLTools.getValue(element2)) == null || !string.trim().toLowerCase().equals("false")) continue;
            return false;
        }
        return true;
    }

    private boolean get(String string) {
        boolean bl = false;
        try {
            Element element = this.document.getDocumentElement();
            NodeList nodeList = element.getElementsByTagName(ARGUMENT);
            boolean bl2 = false;
            for (int i = 0; !bl2 && i < nodeList.getLength(); ++i) {
                Element element2 = (Element)nodeList.item(i);
                if (element2.getParentNode() == element && element2.getAttribute("name").equalsIgnoreCase(string)) {
                    String string2 = XMLTools.getValue(element2);
                    if (string2.equalsIgnoreCase("true")) {
                        bl = true;
                    }
                    bl2 = true;
                    string2 = null;
                }
                element2 = null;
            }
            nodeList = null;
            element = null;
        }
        catch (Exception exception) {
            DebugStream.printStackTrace(exception);
        }
        return bl;
    }

    private String getString(String string) {
        String string2 = "";
        try {
            Element element = this.document.getDocumentElement();
            NodeList nodeList = element.getElementsByTagName(ARGUMENT);
            boolean bl = false;
            for (int i = 0; !bl && i < nodeList.getLength(); ++i) {
                Element element2 = (Element)nodeList.item(i);
                if (element2.getParentNode() == element && element2.getAttribute("name").equalsIgnoreCase(string)) {
                    string2 = XMLTools.getValue(element2);
                    bl = true;
                }
                element2 = null;
            }
            nodeList = null;
            element = null;
        }
        catch (Exception exception) {
            DebugStream.printStackTrace(exception);
        }
        return string2;
    }

    private Element getValues(String string) {
        Element element = null;
        try {
            Element element2 = this.document.getDocumentElement();
            Element element3 = (Element)XMLTools.getNodeFromNamed(element2, BUILD_CONFIG);
            element = (Element)XMLTools.getNodeFromNamed(element3, string);
            element3 = null;
            element2 = null;
        }
        catch (Exception exception) {
            DebugStream.printStackTrace(exception);
        }
        return element;
    }

    private Element getBuildValues() {
        Element element = null;
        try {
            Element element2 = this.document.getDocumentElement();
            Element element3 = (Element)XMLTools.getNodeFromNamed(element2, BUILD_CONFIG);
            element = (Element)XMLTools.getNodeFromNamed(element3, BUILD);
            element3 = null;
            element2 = null;
        }
        catch (Exception exception) {
            DebugStream.printStackTrace(exception);
        }
        return element;
    }

    private Element getScheduleValues() {
        Element element = null;
        try {
            Element element2 = this.document.getDocumentElement();
            Element element3 = (Element)XMLTools.getNodeFromNamed(element2, BUILD_CONFIG);
            element = (Element)XMLTools.getNodeFromNamed(element3, SCHEDULE);
            element3 = null;
            element2 = null;
        }
        catch (Exception exception) {
            DebugStream.printStackTrace(exception);
        }
        return element;
    }

    private int getCount(TreeNode treeNode, boolean bl, boolean bl2) {
        int n = 0;
        File file = ((CollectionTreeNode)treeNode).getFile();
        if (file.isFile() && bl2) {
            ++n;
        } else if (file.isDirectory() && bl) {
            ++n;
        }
        for (int i = 0; !file.getName().equals("CVS") && i < treeNode.getChildCount(); ++i) {
            n += this.getCount(treeNode.getChildAt(i), bl, bl2);
        }
        return n;
    }

    public Element getImportValues() {
        Element element = null;
        try {
            Element element2 = this.document.getDocumentElement();
            Element element3 = (Element)XMLTools.getNodeFromNamed(element2, BUILD_CONFIG);
            element = (Element)XMLTools.getNodeFromNamed(element3, IMPORT);
            element3 = null;
            element2 = null;
        }
        catch (Exception exception) {
            DebugStream.printStackTrace(exception);
        }
        return element;
    }

    private void set(String string, boolean bl) {
        this.set(string, bl ? "true" : "false");
    }

    private void set(String string, String string2) {
        try {
            Element element = this.document.getDocumentElement();
            NodeList nodeList = element.getElementsByTagName(ARGUMENT);
            boolean bl = false;
            for (int i = 0; !bl && i < nodeList.getLength(); ++i) {
                Element element2 = (Element)nodeList.item(i);
                if (element2.getParentNode() == element && element2.getAttribute("name").equalsIgnoreCase(string)) {
                    while (element2.hasChildNodes()) {
                        element2.removeChild(element2.getFirstChild());
                    }
                    element2.appendChild(this.document.createTextNode(string2));
                    bl = true;
                }
                element2 = null;
            }
            if (!bl) {
                Element element3 = this.document.createElement(ARGUMENT);
                element3.setAttribute("name", string);
                element3.appendChild(this.document.createTextNode(string2));
                element.appendChild(element3);
                element3 = null;
            }
            nodeList = null;
            element = null;
        }
        catch (Exception exception) {
            DebugStream.printStackTrace(exception);
        }
    }
}

