/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.cdm;

import java.util.ArrayList;
import org.greenstone.gatherer.DebugStream;
import org.greenstone.gatherer.cdm.CollectionConfiguration;
import org.greenstone.gatherer.cdm.DOMProxyListEntry;
import org.greenstone.gatherer.metadata.MetadataElement;
import org.greenstone.gatherer.metadata.MetadataTools;
import org.greenstone.gatherer.util.XMLTools;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Index
implements Comparable,
DOMProxyListEntry {
    protected ArrayList sources = null;
    protected Element element = null;
    static final String index_element = "Index";
    static final String default_index_element = "DefaultIndex";
    protected String id = null;

    public Index() {
    }

    public Index(Element element) {
        this.element = element;
    }

    public Index(ArrayList arrayList) {
        this.sources = arrayList;
        this.element = CollectionConfiguration.createElement(this.getElementName());
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Element element = CollectionConfiguration.createElement("content");
            Object e = arrayList.get(i);
            if (e instanceof MetadataElement) {
                element.setAttribute("name", ((MetadataElement)e).getFullName());
            } else {
                element.setAttribute("name", e.toString());
            }
            this.element.appendChild(element);
            element = null;
        }
    }

    protected String getElementName() {
        return index_element;
    }

    protected String getDefaultElementName() {
        return default_index_element;
    }

    public int compareTo(Object object) {
        if (object == null) {
            return -1;
        }
        String string = this.getID();
        return string.compareTo(((Index)object).getID());
    }

    @Override
    public DOMProxyListEntry create(Element element) {
        return new Index(element);
    }

    public DOMProxyListEntry create(ArrayList arrayList) {
        return new Index(arrayList);
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    @Override
    public Element getElement() {
        return this.element;
    }

    public String getID() {
        if (this.element == null) {
            this.id = "";
        } else if (this.id == null) {
            StringBuffer stringBuffer = new StringBuffer();
            ArrayList arrayList = this.getSources();
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Object e = arrayList.get(i);
                if (e instanceof MetadataElement) {
                    String string = ((MetadataElement)e).getFullName();
                    if (string.startsWith("ex.") && string.indexOf(46, "ex.".length()) == -1) {
                        stringBuffer.append(string.substring("ex.".length()));
                    } else {
                        stringBuffer.append(string);
                    }
                } else {
                    stringBuffer.append(e.toString());
                }
                stringBuffer.append(",");
            }
            arrayList = null;
            this.id = stringBuffer.length() == 0 ? "" : stringBuffer.substring(0, stringBuffer.length() - 1);
        }
        return this.id;
    }

    public ArrayList getSources() {
        if (this.sources == null) {
            this.sources = new ArrayList();
            NodeList nodeList = this.element.getElementsByTagName("content");
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element = (Element)nodeList.item(i);
                String string = element.getAttribute("name");
                MetadataElement metadataElement = MetadataTools.getMetadataElementWithName(string);
                if (metadataElement != null) {
                    this.sources.add(metadataElement);
                    continue;
                }
                this.sources.add(string);
            }
            nodeList = null;
        }
        return this.sources;
    }

    public String getType() {
        return "index";
    }

    @Override
    public boolean isAssigned() {
        return this.element != null && !this.element.getAttribute("assigned").equals("false");
    }

    @Override
    public void setAssigned(boolean bl) {
        if (this.element != null) {
            this.element.setAttribute("assigned", bl ? "true" : "false");
        }
    }

    @Override
    public void setElement(Element element) {
        this.element = element;
        this.id = null;
        this.sources = null;
    }

    public void setSources(ArrayList arrayList) {
        if (this.element != null && this.element.getNodeName().equals(this.getDefaultElementName())) {
            XMLTools.clear(this.element);
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Element element = this.element.getOwnerDocument().createElement("content");
                Object e = arrayList.get(i);
                if (e instanceof MetadataElement) {
                    String string = ((MetadataElement)e).getFullName();
                    element.setAttribute("name", string);
                    string = null;
                } else {
                    element.setAttribute("name", e.toString());
                }
                e = null;
                this.element.appendChild(element);
                element = null;
            }
            this.id = null;
            this.sources = arrayList;
        } else {
            DebugStream.println("Error! Called setSource() of index other than the default.");
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        ArrayList arrayList = this.getSources();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            String string = arrayList.get(i).toString();
            stringBuffer.append(string);
            if (i >= n - 1) continue;
            stringBuffer.append(",");
        }
        arrayList = null;
        return stringBuffer.toString();
    }
}

