/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.cdm;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.cdm.Argument;
import org.greenstone.gatherer.cdm.ArgumentContainer;
import org.greenstone.gatherer.cdm.ArgumentControl;
import org.greenstone.gatherer.gui.GLIButton;
import org.greenstone.gatherer.gui.ModalDialog;
import org.greenstone.gatherer.gui.SimpleMenuBar;

public class ArgumentConfiguration
extends ModalDialog
implements ActionListener {
    private ArgumentContainer data = null;
    private boolean success = false;
    private JButton cancel = null;
    private JButton ok = null;
    private ArgumentConfiguration self = null;
    private JPanel central_pane = null;
    private static final Dimension LABEL_SIZE = new Dimension(225, 25);
    private static final Dimension LIST_SIZE = new Dimension(380, 50);
    private static final Dimension SIZE = new Dimension(800, 425);

    public ArgumentConfiguration(ArgumentContainer argumentContainer) {
        super(Gatherer.g_man);
        this.data = argumentContainer;
        this.self = this;
        this.setModal(true);
        this.setSize(SIZE);
        this.setJMenuBar(new SimpleMenuBar("designingacollection"));
        this.setTitle(Dictionary.get("CDM.ArgumentConfiguration.Title"));
        this.central_pane = new JPanel();
        JPanel jPanel = (JPanel)this.getContentPane();
        JLabel jLabel = new JLabel(Dictionary.get("CDM.ArgumentConfiguration.Header", argumentContainer.getName()));
        jLabel.setHorizontalAlignment(0);
        jLabel.setOpaque(true);
        JPanel jPanel2 = new JPanel();
        this.cancel = new GLIButton(Dictionary.get("General.Cancel"), Dictionary.get("General.Pure_Cancel_Tooltip"));
        this.ok = new GLIButton(Dictionary.get("General.OK"), Dictionary.get("General.OK_Tooltip"));
        this.cancel.addActionListener(this);
        this.ok.addActionListener(this);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        jPanel2.setLayout(new GridLayout(1, 2));
        jPanel2.add(this.ok);
        jPanel2.add(this.cancel);
        this.central_pane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.central_pane.setLayout(new BoxLayout(this.central_pane, 1));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jLabel, "North");
        JScrollPane jScrollPane = new JScrollPane(this.central_pane);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(16);
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.add((Component)jPanel2, "South");
        this.generateControls();
        Dimension dimension = Configuration.screen_size;
        this.setLocation((dimension.width - ArgumentConfiguration.SIZE.width) / 2, (dimension.height - ArgumentConfiguration.SIZE.height) / 2);
        dimension = null;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl = true;
        if (actionEvent.getSource() == this.ok) {
            for (int i = 0; i < this.central_pane.getComponentCount(); ++i) {
                Component component = this.central_pane.getComponent(i);
                if (!(component instanceof ArgumentControl)) continue;
                bl = bl && ((ArgumentControl)component).updateArgument();
            }
            if (bl) {
                this.success = true;
            }
        }
        if (bl) {
            this.dispose();
        }
    }

    public void addOKButtonActionListener(ActionListener actionListener) {
        this.ok.addActionListener(actionListener);
    }

    public void destroy() {
        this.cancel = null;
        this.central_pane = null;
        this.data = null;
        this.ok = null;
        this.self = null;
    }

    public boolean display() {
        this.setVisible(true);
        return this.success;
    }

    private void addHeader(String string, Color color) {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(color);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createRaisedBevelBorder()));
        jPanel2.setBackground(color);
        JLabel jLabel = new JLabel("<html><strong>" + string + "</strong></html>");
        jLabel.setBackground(Configuration.getColor("coloring.collection_heading_background", false));
        jLabel.setHorizontalAlignment(0);
        jLabel.setOpaque(true);
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)jLabel, "Center");
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jPanel2, "Center");
        this.central_pane.add(jPanel);
    }

    private void generateControls() {
        Color color = Configuration.getColor("coloring.collection_heading_background", false);
        Color color2 = Configuration.getColor("coloring.collection_tree_background", false);
        boolean bl = false;
        ArrayList arrayList = this.data.getArguments();
        int n = 250;
        String string = "";
        if (arrayList.size() > 0) {
            string = ((Argument)arrayList.get(0)).getOwner();
            this.addHeader(string, color2);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            Argument argument = (Argument)arrayList.get(i);
            String string2 = argument.getOwner();
            if (string != argument.getOwner()) {
                bl = !bl;
                string = argument.getOwner();
                this.addHeader(string, bl ? color : color2);
            }
            if (argument.isHiddenGLI()) continue;
            ArgumentControl argumentControl = new ArgumentControl(argument, false, null);
            n -= argumentControl.getPreferredSize().height;
            if (bl) {
                argumentControl.setBackground(color);
            } else {
                argumentControl.setBackground(color2);
            }
            this.central_pane.add(argumentControl);
        }
        if (n > 0) {
            JPanel jPanel = new JPanel();
            jPanel.setPreferredSize(new Dimension(100, n));
            jPanel.setSize(new Dimension(100, n));
            this.central_pane.add(jPanel);
        }
    }
}

