###########################################################################
#
# win32.mak -- Windows Makefile for sqlite3
#
# By Michael Dewsnip
#
# Copyright (C) 2008-2010  DL Consulting Ltd.
#
###########################################################################

AR = lib
CC = cl
CPPFLAGS =
DEFS = -D_CRT_SECURE_NO_DEPRECATE
INCLUDES = 

COMPILE = $(CC) -nologo -c $(CPPFLAGS) $(DEFS) $(INCLUDES)
LINK = $(CC) -nologo -Fe"$@" $(LDFLAGS)


.SUFFIXES:
.SUFFIXES: .c .obj
.c.obj:
	$(COMPILE) $<

HEADERS = \
  sqlite3.h

SOURCES = \
  shell.c \
  sqlite3.c

OBJECTS = \
  shell.obj \
  sqlite3.obj

LIBRARY = sqlite3.lib

EXECUTABLE_OBJECTS = \
  $(OBJECTS)

EXECUTABLE = sqlite3.exe

all: $(LIBRARY) $(EXECUTABLE)

sqlite3.lib: $(OBJECTS)
	if EXIST $(LIBRARY) del $(LIBRARY)
	$(AR) -nologo /out:$(LIBRARY) $(OBJECTS)

sqlite3.exe: $(EXECUTABLE_OBJECTS)
	$(LINK) $(EXECUTABLE_OBJECTS) $(LIBS)

clean:
	del $(OBJECTS)
	del $(LIBRARY)
	del $(EXECUTABLE)

install: $(LIBRARY)
        if NOT EXIST "..\include" mkdir "..\include"
	copy *.h "..\include"
        if NOT EXIST "..\lib" mkdir "..\lib"
	copy $(LIBRARY) "..\lib"
	copy $(EXECUTABLE) "$(GSDLHOME)\bin\windows"
