/**************************************************************************
 *
 * mgpp_passes_4jni.h -- modified mgpp_passes for use from jni
 * Copyright (C) 2004 New Zealand Digital Library, http://www.nzdl.org
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: mgpp_passes_4jni.h 16583 2008-07-29 10:20:36Z davidb $
 *
 **************************************************************************/
#ifndef H_MGPP_PASSES_4JNI
#define H_MGPP_PASSES_4JNI


/* clear all the settings from one mgpp_passes run to the next */
void clear_variables();

/* -S, -T1, -T2, -I1, -I2, args to mg_passes */
void add_pass (char pass_type, char pass_num);

/* -m arg to mg_passes */
void set_inversion_limit(int limit);

/* -J arg to mgpp_passes */
void set_document_tag(const char * tag_name);

/* -K arg to mgpp_passes */
void add_level_tag(const char * tag_name);

/* -L arg to mgpp_passes */
void set_index_level(const char * tag_name);

/* -f arg to mgpp_passes */
void set_filename(const char * filen);

/* The old driver method has been split into 3:
init_driver, process_document (called numdocs times), 
finalise_driver.
The above set vars methods should all be called before init_driver.
*/

void init_driver ();

void process_document(u_char *buffer, int len);

void finalise_driver();

int get_exit_value();

#endif
