/**********************************************************************
 *
 * IErrors.h
 * Copyright (C) 2003  UNESCO
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/


#ifndef __ISIS_ERROR_H__
#define __ISIS_ERROR_H__

enum IsisError { // Database error codes
  ISIS_NO_ERROR = 0,        // No errors reported
  ISIS_INVALID_CODE,
  ISIS_BAD_ALLOC,
  ISIS_XRF_OPEN_ERROR,      // Xrf open error
  ISIS_XRF_CREATE_ERROR,    // Xrf creation error
  ISIS_XRF_READ_ERROR,      // Xrf read error
  ISIS_XRF_WRITE_ERROR,     // Xrf write error
  ISIS_XRF_CORRUPT,         // Xrf corrupted
  ISIS_XRF_INVALID_BLOCK,   // Xrf invalid block
  ISIS_XRF_INVALID_STATUS,  // Xrf invalid status
  ISIS_MF_ALREADY_EXIST_ERROR, // Attempt to create an existing mf
  ISIS_MF_OPEN_ERROR,       // Mf open error
  ISIS_MF_CREATE_ERROR,     // Mf creation error
  ISIS_MF_READ_ERROR,       // Mf read error
  ISIS_MF_WRITE_ERROR,      // Mf write error 
  ISIS_ASSERT_ERROR,        // Assertion failed
  ISIS_BAD_CLASS_ID,        // Wrong object type
  ISIS_BAD_OBJECT_ADDRESS,  // Bad object address  ISIS_BAD_REFERENCE,       // Bad Reference
  ISIS_CACHE_FULL,          // Cache full
  ISIS_CHECKSUM_ERROR,      // Checksum Error
  ISIS_DIVIDEBY_ZERO,       // Divide By Zero Error
  ISIS_EOF_ERROR,           // Unexpected end of file
  ISIS_FILE_CLOSE_ERROR,    // Error closing file
  ISIS_FILE_CORRUPT,        // File corrupted
  ISIS_FILE_CREATION_ERROR, // Error creating file
  ISIS_FILE_EXISTS,         // File already exists
  ISIS_FILE_NOT_OPEN_ERROR, // Trying to use a closed file
  ISIS_FILE_NOT_READY,      // File not ready (failed or closed file)
  ISIS_FILE_NOT_WRITEABLE,  // Could not write to file 
  ISIS_FILE_OPEN_ERROR,     // Error opening file
  ISIS_FILE_POSITION_ERROR, // Cannot obtain the current file position
  ISIS_FILE_READ_ERROR,     // Error reading file  
  ISIS_FILE_SEEK_ERROR,     // Error seeking in file
  ISIS_FILE_WRITE_ERROR,    // Error writing to file
  ISIS_NO_DATABASE_OPEN,    // No database open
  ISIS_NO_FILE_EXISTS,      // No such file exists
  ISIS_NO_OBJECTS_EXIST,    // No objects exist
  ISIS_NULL_PTR,            // Accessing a null pointer 
  ISIS_OBJECT_EXISTS,       // Object already exists
  ISIS_OPEN_FILE_REFERENCE, // Another object is referencing this file
  ISIS_OVERFLOW,            // Math overflow
  ISIS_PARSE_ERROR,         // Parse error
  ISIS_PATH_ERROR,          // Invalid path
  ISIS_READ_ONLY_FILE,      // Trying to write to read-only file
  ISIS_STACK_EMPTY,         // Stack empty
  ISIS_STACK_FULL,          // Stack full
  ISIS_SYNC_ERROR,          // Synchronization Error
  ISIS_UNDERFLOW,           // Math under-flow
  ISIS_WRONG_FILE_TYPE,     // Wrong file type

  // Persistent lock error codes
  ISIS_INVALID_LOCK_TYPE,        // Invalid lock type specified
  ISIS_MFLOCK_ACCESS_ERROR,    // The file lock cannot be accessed
  ISIS_MFLOCK_ERROR,           // Error locking the file
  ISIS_RECORDLOCK_ACCESS_ERROR,  // The record lock cannot be accessed
  ISIS_RECORDLOCK_ERROR          // Error locking a record
};

// Standalone functions use to report database errors
const char *isisExceptionMessage(IsisError err);

#ifdef __CPP_EXCEPTIONS__
// Class declarations for exceptions representing program errors. 
// This implementation is provided for use C++'s built-in exception
// handling routines.

// A fatal file error condition has been reached. All database engine
// calls must catch this exception and evaluate it by testing the
// vbDatabase or vbDatabase64 internal error variable.
class CIsisException { };  

#endif // __CPP_EXCEPTIONS__

#endif // __ISIS_ERROR_H__
