/**
 *#########################################################################
 *
 * A component of the Gatherer application, part of the Greenstone digital
 * library suite from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * Author: Matthew Whyte, Greenstone Digital Library, University of Waikato
 *
 * Copyright (C) 1999 New Zealand Digital Library Project
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *########################################################################
 */

package org.greenstone.gatherer.cdm;

import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.DebugStream;
import javax.swing.event.*;
import java.awt.event.*;

/**
 * This handles events generated by changing design options.
 * The rebuildTypeRequired is updated if the rebuild type associated with this
 * listener requires more 'work' than what is currently set in the {@link CollectionDesignManager}.
 * @author Matthew Whyte
 */
public class DesignChangeListener implements ActionListener, DocumentListener {
    
    /** The rebuild type required associated with this listener */
    private final int rebuildType;
    
    /** Constructor. Sets the build type required. */
    public DesignChangeListener(int type) {
	rebuildType = type;
    }

    public void maybeSetRebuildRequired() {
	if (rebuildType > CollectionDesignManager.getRebuildTypeRequired()) {
	    CollectionDesignManager.setRebuildTypeRequired(rebuildType);
	}
    }
    
    /** Gives notification that an event has happened */
    public void actionPerformed(ActionEvent event) {
	//DebugStream.println("ActionEvent in Design from: " + event.getSource());
	maybeSetRebuildRequired();
    }

    /** Gives notification that an attribute or set of attributes changed. */
    public void changedUpdate(DocumentEvent e) {
	maybeSetRebuildRequired();
	//DebugStream.println("changedUpdate in Design.");
    }
    
    /** Gives notification that there was an insert into the document. */
    public void insertUpdate(DocumentEvent e) {
	maybeSetRebuildRequired();
	//DebugStream.println("insertUpdate in Design."); //debug
    }
    
    /** Gives notification that a portion of the document has been removed. */
    public void removeUpdate(DocumentEvent e) {
	maybeSetRebuildRequired();
	//DebugStream.println("removeUpdate in Design."); //debug
    }
    
}
