/**
 *#########################################################################
 *
 * A component of the Gatherer application, part of the Greenstone digital
 * library suite from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * Author: John Thompson and David Bainbridge, 
 *         Greenstone Digital Library, University of Waikato
 *
 * Copyright (C) 1999 New Zealand Digital Library Project
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *########################################################################
 */

package org.greenstone.gatherer;

import java.io.*;
import org.greenstone.gatherer.util.StaticStrings; 
import org.greenstone.gatherer.util.Utility;

public class FedoraInfo 
{
    public static final int minimumSupportedMajorVersion = 2;

    private boolean active = false;
    private String home = null;
    private String version = null;

    private String hostname = null;
    private String port     = null;
    private String username = null;
    private String password = null;
    private String protocol = null;

    public FedoraInfo() 
    {	
	this("localhost", "8080", "fedoraAdmin", "fedoraAdmin", "http");
    }

    public FedoraInfo(String hostname, String port, String username, String password, String protocol) 
    {
	this.hostname = hostname;
	this.port     = port;
	this.username = username;
	this.password = password;
	this.protocol = protocol;
    }

    // Called when we are attempting to run fedora
    public void setActive(boolean active) {
	this.active = active; 
    }

    // Called when an environment variable was wrongly set for running Fedora
    public void deactivate(String errorMessage) {
	this.active = false;
	// display an errormessage and exit cleanly
	System.err.println(errorMessage);
	Gatherer.exit();
    }

    public boolean isActive()
    {
	return active;
    }

    public void setHome(String home)
    {
	this.home = home;
    }


    public String getHome()
    {
	return home;
    }

    public void setVersion(String version)
    {
	String firstChar = version.substring(0, 1);
	if(!Character.isDigit(version.charAt(0))) { // version is illegal if it does not begin with a number
	    deactivate("Incorrect format for major version: " + version + ". The Fedora version must start with a number.");
	}
	else if(Integer.parseInt(firstChar) < minimumSupportedMajorVersion) { 
	    // major version number of Fedora must be more than this
	    deactivate("The major version number of Fedora must be at least " +  minimumSupportedMajorVersion + ".");
	}
	else { // acceptable
	    this.version = version;
	} 
    }


    public String getVersion()
    {
	return version;
    }

    public void setHostname(String hostname)
    {
	this.hostname = hostname;
    }

    public String getHostname()
    {
	return hostname;
    }


    public void setPort(String port)
    {
	this.port = port;
    }

    public String getPort()
    {
	return port;
    }


    public void setUsername(String username)
    {
	this.username = username;
    }

    public String getUsername()
    {
	return username;
    }


    public void setPassword(String password)
    {
	this.password = password;
    }

    public String getPassword()
    {
	return password;
    }


    public void setProtocol(String protocol)
    {
	this.protocol = protocol;
    }

    public String getProtocol()
    {
	return protocol;
    }

    public String getBaseURL() 
    {
	return this.protocol+"://"+this.hostname+":"+this.port+"/";
    }
    
    // The library preview address for Fedora
    public String getLibraryURL() 
    {
	return this.getBaseURL() + "fedora/search";
    }
}
