<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:java="http://xml.apache.org/xslt/java"
		xmlns:util="xalan://org.greenstone.gsdl3.util.XSLTUtil"
		xmlns:gslib="http://www.greenstone.org/skinning"
		extension-element-prefixes="java util"
		exclude-result-prefixes="java util">

  <!-- use the 'main' layout -->
  <xsl:include href="layouts/main.xsl"/>
<!--  <xsl:variable name="debug_property_file">default2</xsl:variable>-->
  <xsl:variable name="debug_property_file" select="concat('aux_', $interface_name)"/>
  <!-- set page title -->
  <xsl:template name="pageTitle">
    <gslib:collectionName/>
  </xsl:template>

  <!-- set page breadcrumbs -->
  <xsl:template name="breadcrumbs">
    <gslib:siteLink/>
    <gslib:rightArrow/>
  </xsl:template>

  <!-- the page content -->
  <xsl:template match="/page">
    
    <h2><xsl:value-of select="util:getInterfaceText($debug_property_file, /page/@lang, 'debuginfo.library')"/></h2>
    <p>
      <xsl:value-of select="util:getInterfaceText($debug_property_file, /page/@lang, 'debuginfo.intview_desc')"/>
    </p>
    <p>
      <xsl:value-of select="util:getInterfaceText($debug_property_file, /page/@lang, 'debuginfo.usage')"/>
    </p>

    <h3><u><xsl:value-of select="util:getInterfaceText($debug_property_file, /page/@lang, 'debuginfo.intermediateview')"/></u></h3>
    <dl>
      <dt>o=xml</dt>
      <dd>
	<xsl:value-of select="util:getInterfaceText($debug_property_file, /page/@lang, 'debuginfo.xml')"/>
      </dd>
      <dt>o=xsl</dt>
      <dd>
	<xsl:value-of select="util:getInterfaceText($debug_property_file, /page/@lang, 'debuginfo.xsl')"/>
	<dl>
	  <dt>o=xsl7</dt>
	  <dd><xsl:value-of select="util:getInterfaceText($debug_property_file, /page/@lang, 'debuginfo.xsl7')"/></dd>
	  <dt>o=xsl6</dt>
	  <dd><xsl:value-of select="util:getInterfaceText($debug_property_file, /page/@lang, 'debuginfo.xsl6')"/></dd>
	  <dt>o=xsl5</dt>
	  <dd><xsl:value-of select="util:getInterfaceText($debug_property_file, /page/@lang, 'debuginfo.xsl5')"/></dd>
	  <dt>o=xsl4</dt>
	  <dd><xsl:value-of select="util:getInterfaceText($debug_property_file, /page/@lang, 'debuginfo.xsl4')"/></dd>
	  <dt>o=xsl3</dt>
	  <dd><xsl:value-of select="util:getInterfaceText($debug_property_file, /page/@lang, 'debuginfo.xsl3')"/></dd>
	  <dt>o=xsl2</dt>
	  <dd><xsl:value-of select="util:getInterfaceText($debug_property_file, /page/@lang, 'debuginfo.xsl2')"/></dd>
	  <dt>o=xsl1</dt>
	  <dd><xsl:value-of select="util:getInterfaceText($debug_property_file, /page/@lang, 'debuginfo.xsl1')"/></dd>
	</dl>
      </dd>
      <dt>o=format</dt>
      <dd>
	<xsl:value-of select="util:getInterfaceText($debug_property_file, /page/@lang, 'debuginfo.format')"/>
	<dl>
	<dt>o=format1</dt>
	<dd><xsl:value-of select="util:getInterfaceText($debug_property_file, /page/@lang, 'debuginfo.format1')"/></dd>
	</dl>
      </dd>
      <dt>o=ilt</dt>
      <dd>
	<xsl:value-of select="util:getInterfaceText($debug_property_file, /page/@lang, 'debuginfo.ilt')"/>
      </dd>
      <dt>o=gslib</dt>
      <dd>
	<xsl:value-of select="util:getInterfaceText($debug_property_file, /page/@lang, 'debuginfo.gslib')"/>
	<dl>
	<dt>o=gslib1</dt>
	<dd><xsl:value-of select="util:getInterfaceText($debug_property_file, /page/@lang, 'debuginfo.gslib1')"/></dd>
	</dl>
      </dd>
      <dt>o=gslib-expander</dt>
      <dd>
	<xsl:value-of select="util:getInterfaceText($debug_property_file, /page/@lang, 'debuginfo.expandgslib')"/>
      </dd>

    </dl>


     <h3><u><xsl:value-of select="util:getInterfaceText($debug_property_file, /page/@lang, 'debuginfo.refreshconfig')"/></u></h3>
 
    <dl>
      <dt>
	<a href="{$library_name}?a=s&amp;sa=c">a=s&amp;sa=c</a>
      </dt>
      <dd>
	<xsl:value-of select="util:getInterfaceText($debug_property_file, /page/@lang, 'debuginfo.reconfigsite')"/>
      </dd>
      
      <dt>
	<a href="{$library_name}?a=s&amp;sa=c&amp;ss=collectionList">a=s&amp;sa=c&amp;ss=collectionList</a><br/>
	<a href="{$library_name}?a=s&amp;sa=c&amp;ss=serviceList">a=s&amp;sa=c&amp;ss=serviceList</a><br/>
 	<a href="{$library_name}?a=s&amp;sa=c&amp;ss=clusterList">a=s&amp;sa=c&amp;ss=clusterList</a><br/>
	<a href="{$library_name}?a=s&amp;sa=c&amp;ss=siteList">a=s&amp;sa=c&amp;ss=siteList</a><br/>      
      </dt>
      <dd>
	<xsl:value-of select="util:getInterfaceText($debug_property_file, /page/@lang, 'debuginfo.reconfigpart')"/>
      </dd>
      <dt>
	<a href="{$library_name}?a=s&amp;sa=a&amp;st=XX&amp;sn=XX">a=s&amp;sa=a&amp;st=moduletype&amp;sn=modulename</a>
      </dt>
      <dd>
	<xsl:value-of select="util:getInterfaceText($debug_property_file, /page/@lang, 'debuginfo.activatemodule')"/>
      </dd>
      <dt>
	<a href="{$library_name}?a=s&amp;sa=d&amp;st=XX&amp;sn=XX">a=s&amp;sa=d&amp;st=moduletype&amp;sn=modulename</a>
      </dt>
      <dd>
	<xsl:value-of select="util:getInterfaceText($debug_property_file, /page/@lang, 'debuginfo.deactivatemodule')"/>
      </dd>

    </dl>
     <h3><u><xsl:value-of select="util:getInterfaceText($debug_property_file, /page/@lang, 'debuginfo.refreshcollection')"/></u></h3>
     <dl>
      <dt>
	<a href="{$library_name}?a=s&amp;sa=c&amp;sc=XX">a=s&amp;sa=c&amp;sc=collname</a>
      </dt>
      <dd>
	<xsl:value-of select="util:getInterfaceText($debug_property_file, /page/@lang, 'debuginfo.reconfigcoll')"/>
      </dd>
      
      <dt>
	<a href="{$library_name}?a=s&amp;sa=c&amp;sc=XX&amp;ss=metadataList">a=s&amp;sa=c&amp;sc=collname&amp;ss=metadataList</a><br/>
	<a href="{$library_name}?a=s&amp;sa=c&amp;sc=XX&amp;ss=serviceList">a=s&amp;sa=c&amp;sc=collname&amp;ss=serviceList</a><br/>
      </dt>
      <dd>
	<xsl:value-of select="util:getInterfaceText($debug_property_file, /page/@lang, 'debuginfo.reconfigcollpart')"/>
      </dd>

      
     </dl>
    <h3><u><xsl:value-of select="util:getInterfaceText($debug_property_file, /page/@lang, 'debuginfo.misc_params')"/></u></h3>
    <dl>
      <dt>force=true</dt>
      <dd><xsl:value-of select="util:getInterfaceText($debug_property_file, /page/@lang, 'debuginfo.forcetandc')"/></dd>
	
      <dt>ilt=your-inline-template
      </dt>
      <dd>
	<xsl:value-of select="util:getInterfaceText($debug_property_file, /page/@lang, 'debuginfo.inlinetemplate')"/>
      </dd>
      <dt>dmd=
      </dt>
      <dd>
	<xsl:value-of select="util:getInterfaceText($debug_property_file, /page/@lang, 'debuginfo.displaymetadata')"/>
      </dd>
      <dt>formatedit=on</dt>
      <dd>
	<xsl:value-of select="util:getInterfaceText($debug_property_file, /page/@lang, 'debuginfo.formatedit')"/>
      </dd>
    </dl>
   
    <h3><u><xsl:value-of select="util:getInterfaceText($debug_property_file, /page/@lang, 'debuginfo.misc_links')"/></u></h3>
    <dl>
      <dt>
	<a href="{$library_name}?a=de&amp;c={/page/pageResponse/collection/@name}"><xsl:value-of select="util:getInterfaceText($interface_name, /page/@lang, 'depositor.title')"/> (a=de&amp;c=your-collection)</a>
      </dt>
      <dd>
	<xsl:value-of select="util:getInterfaceText($debug_property_file, /page/@lang, 'debuginfo.depositor')"/>
      </dd>

    </dl>
    
    <h2><xsl:value-of select="util:getInterfaceText($debug_property_file, /page/@lang, 'debuginfo.oaiserver')"/></h2>
    <dl>
      <!--
	  http://host:port/greenstone3/oaiserver?reset
	  http://host:port/greenstone3/oaiserver?activate=COLLNAME
	  http://host:port/greenstone3/oaiserver?deactivate=COLLNAME
      -->
      <dt>oaiserver?reset</dt>
      <dd>
	<xsl:value-of select="util:getInterfaceText($debug_property_file, /page/@lang, 'debuginfo.oaiserver_reset')"/>
      </dd>
      <dt>oaiserver?activate=COLLNAME</dt>
      <dd>
	<xsl:value-of select="util:getInterfaceText($debug_property_file, /page/@lang, 'debuginfo.oaiserver_activate_col')"/>
      </dd>
      <dt>oaiserver?deactivate=COLLNAME</dt>
      <dd>
	<xsl:value-of select="util:getInterfaceText($debug_property_file, /page/@lang, 'debuginfo.oaiserver_deactivate_col')"/>
      </dd>
    </dl>
    
  </xsl:template>
</xsl:stylesheet>  

