/*
 * Decompiled with CFR 0.152.
 */
package jdbm.recman;

import java.io.IOException;
import jdbm.recman.FreeLogicalRowIdPageManager;
import jdbm.recman.Location;
import jdbm.recman.PageManager;
import jdbm.recman.PhysicalRowId;
import jdbm.recman.RecordFile;
import jdbm.recman.TranslationPage;

final class LogicalRowIdManager {
    private RecordFile file;
    private PageManager pageman;
    private FreeLogicalRowIdPageManager freeman;

    LogicalRowIdManager(RecordFile recordFile, PageManager pageManager) throws IOException {
        this.file = recordFile;
        this.pageman = pageManager;
        this.freeman = new FreeLogicalRowIdPageManager(recordFile, pageManager);
    }

    Location insert(Location location) throws IOException {
        Location location2 = this.freeman.get();
        if (location2 == null) {
            long l = this.pageman.allocate((short)2);
            short s = 18;
            for (int i = 0; i < 817; ++i) {
                this.freeman.put(new Location(l, s));
                s = (short)(s + 10);
            }
            location2 = this.freeman.get();
            if (location2 == null) {
                throw new Error("couldn't obtain free translation");
            }
        }
        this.update(location2, location);
        return location2;
    }

    void delete(Location location) throws IOException {
        this.freeman.put(location);
    }

    void update(Location location, Location location2) throws IOException {
        TranslationPage translationPage = TranslationPage.getTranslationPageView(this.file.get(location.getBlock()));
        PhysicalRowId physicalRowId = translationPage.get(location.getOffset());
        physicalRowId.setBlock(location2.getBlock());
        physicalRowId.setOffset(location2.getOffset());
        this.file.release(location.getBlock(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Location fetch(Location location) throws IOException {
        TranslationPage translationPage = TranslationPage.getTranslationPageView(this.file.get(location.getBlock()));
        try {
            Location location2;
            Location location3 = location2 = new Location(translationPage.get(location.getOffset()));
            return location3;
        }
        finally {
            this.file.release(location.getBlock(), false);
        }
    }
}

