/*
 * Decompiled with CFR 0.152.
 */
package jdbm.btree;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Comparator;
import jdbm.RecordManager;
import jdbm.btree.BPage;
import jdbm.helper.Serializer;
import jdbm.helper.Tuple;
import jdbm.helper.TupleBrowser;

public class BTree
implements Externalizable {
    private static final boolean DEBUG = false;
    static final long serialVersionUID = 1L;
    public static final int DEFAULT_SIZE = 16;
    protected transient RecordManager _recman;
    private transient long _recid;
    protected Comparator _comparator;
    protected Serializer _keySerializer;
    protected Serializer _valueSerializer;
    private int _height;
    private transient long _root;
    protected int _pageSize;
    protected int _entries;
    private transient BPage _bpageSerializer;

    public static BTree createInstance(RecordManager recordManager, Comparator comparator) throws IOException {
        return BTree.createInstance(recordManager, comparator, null, null, 16);
    }

    public static BTree createInstance(RecordManager recordManager, Comparator comparator, Serializer serializer, Serializer serializer2) throws IOException {
        return BTree.createInstance(recordManager, comparator, serializer, serializer2, 16);
    }

    public static BTree createInstance(RecordManager recordManager, Comparator comparator, Serializer serializer, Serializer serializer2, int n) throws IOException {
        if (recordManager == null) {
            throw new IllegalArgumentException("Argument 'recman' is null");
        }
        if (comparator == null) {
            throw new IllegalArgumentException("Argument 'comparator' is null");
        }
        if (!(comparator instanceof Serializable)) {
            throw new IllegalArgumentException("Argument 'comparator' must be serializable");
        }
        if (serializer != null && !(serializer instanceof Serializable)) {
            throw new IllegalArgumentException("Argument 'keySerializer' must be serializable");
        }
        if (serializer2 != null && !(serializer2 instanceof Serializable)) {
            throw new IllegalArgumentException("Argument 'valueSerializer' must be serializable");
        }
        if ((n & 1) != 0) {
            throw new IllegalArgumentException("Argument 'pageSize' must be even");
        }
        BTree bTree = new BTree();
        bTree._recman = recordManager;
        bTree._comparator = comparator;
        bTree._keySerializer = serializer;
        bTree._valueSerializer = serializer2;
        bTree._pageSize = n;
        bTree._bpageSerializer = new BPage();
        bTree._bpageSerializer._btree = bTree;
        bTree._recid = recordManager.insert(bTree);
        return bTree;
    }

    public static BTree load(RecordManager recordManager, long l) throws IOException {
        BTree bTree = (BTree)recordManager.fetch(l);
        bTree._recid = l;
        bTree._recman = recordManager;
        bTree._bpageSerializer = new BPage();
        bTree._bpageSerializer._btree = bTree;
        return bTree;
    }

    public synchronized Object insert(Object object, Object object2, boolean bl) throws IOException {
        if (object == null) {
            throw new IllegalArgumentException("Argument 'key' is null");
        }
        if (object2 == null) {
            throw new IllegalArgumentException("Argument 'value' is null");
        }
        BPage bPage = this.getRoot();
        if (bPage == null) {
            bPage = new BPage(this, object, object2);
            this._root = bPage._recid;
            this._height = 1;
            this._entries = 1;
            this._recman.update(this._recid, this);
            return null;
        }
        BPage.InsertResult insertResult = bPage.insert(this._height, object, object2, bl);
        boolean bl2 = false;
        if (insertResult._overflow != null) {
            bPage = new BPage(this, bPage, insertResult._overflow);
            this._root = bPage._recid;
            ++this._height;
            bl2 = true;
        }
        if (insertResult._existing == null) {
            ++this._entries;
            bl2 = true;
        }
        if (bl2) {
            this._recman.update(this._recid, this);
        }
        return insertResult._existing;
    }

    public synchronized Object remove(Object object) throws IOException {
        if (object == null) {
            throw new IllegalArgumentException("Argument 'key' is null");
        }
        BPage bPage = this.getRoot();
        if (bPage == null) {
            return null;
        }
        boolean bl = false;
        BPage.RemoveResult removeResult = bPage.remove(this._height, object);
        if (removeResult._underflow && bPage.isEmpty()) {
            --this._height;
            bl = true;
            this._root = this._height == 0 ? 0L : bPage.childBPage((int)(this._pageSize - 1))._recid;
        }
        if (removeResult._value != null) {
            --this._entries;
            bl = true;
        }
        if (bl) {
            this._recman.update(this._recid, this);
        }
        return removeResult._value;
    }

    public synchronized Object find(Object object) throws IOException {
        if (object == null) {
            throw new IllegalArgumentException("Argument 'key' is null");
        }
        BPage bPage = this.getRoot();
        if (bPage == null) {
            return null;
        }
        Tuple tuple = new Tuple(null, null);
        TupleBrowser tupleBrowser = bPage.find(this._height, object);
        if (tupleBrowser.getNext(tuple)) {
            if (this._comparator.compare(object, tuple.getKey()) != 0) {
                return null;
            }
            return tuple.getValue();
        }
        return null;
    }

    public synchronized Tuple findGreaterOrEqual(Object object) throws IOException {
        if (object == null) {
            return null;
        }
        Tuple tuple = new Tuple(null, null);
        TupleBrowser tupleBrowser = this.browse(object);
        if (tupleBrowser.getNext(tuple)) {
            return tuple;
        }
        return null;
    }

    public synchronized TupleBrowser browse() throws IOException {
        BPage bPage = this.getRoot();
        if (bPage == null) {
            return EmptyBrowser.INSTANCE;
        }
        TupleBrowser tupleBrowser = bPage.findFirst();
        return tupleBrowser;
    }

    public synchronized TupleBrowser browse(Object object) throws IOException {
        BPage bPage = this.getRoot();
        if (bPage == null) {
            return EmptyBrowser.INSTANCE;
        }
        TupleBrowser tupleBrowser = bPage.find(this._height, object);
        return tupleBrowser;
    }

    public synchronized int size() {
        return this._entries;
    }

    public long getRecid() {
        return this._recid;
    }

    private BPage getRoot() throws IOException {
        if (this._root == 0L) {
            return null;
        }
        BPage bPage = (BPage)this._recman.fetch(this._root, this._bpageSerializer);
        bPage._recid = this._root;
        bPage._btree = this;
        return bPage;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this._comparator = (Comparator)objectInput.readObject();
        this._keySerializer = (Serializer)objectInput.readObject();
        this._valueSerializer = (Serializer)objectInput.readObject();
        this._height = objectInput.readInt();
        this._root = objectInput.readLong();
        this._pageSize = objectInput.readInt();
        this._entries = objectInput.readInt();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this._comparator);
        objectOutput.writeObject(this._keySerializer);
        objectOutput.writeObject(this._valueSerializer);
        objectOutput.writeInt(this._height);
        objectOutput.writeLong(this._root);
        objectOutput.writeInt(this._pageSize);
        objectOutput.writeInt(this._entries);
    }

    static class EmptyBrowser
    extends TupleBrowser {
        static TupleBrowser INSTANCE = new EmptyBrowser();

        EmptyBrowser() {
        }

        public boolean getNext(Tuple tuple) {
            return false;
        }

        public boolean getPrevious(Tuple tuple) {
            return false;
        }
    }
}

